# protoc-gen-deepcopy

`protoc-gen-deepcopy` is a plugin for protoc which generates
`DeepCopyInto()` and `DeepCopy()` functions for `.pb.go` types.
The implementations simply use `proto.Clone()` to copy the contents of the `in`
instance to the `out` instance.  This allows the use of Kubernetes
`deepcopy-gen` with the Kubernetes types generated by `kubetype-gen`.

## Usage

Add the executable to your system's PATH, for example:

`$ go install istio.io/tools/cmd/protoc-gen-deepcopy`

Add the `deepcopy_out` option to your `protoc` command line, for example:

`$ protoc --deepcopy_out=:output/path ...`

## Quirks

The generator is built off `protoc-gen-gogo`, which adds some imports that are
not used, along with copying over file comments from the source file.  See below
for an example of the generated code.

## Examples Of Generated Code

```go
// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: policy/v1beta1/cfg.proto

package v1beta1 // import "istio.io/api/policy/v1beta1"

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// DeepCopyInto supports using AttributeManifest within kubernetes types, where deepcopy-gen is used.
func (in *AttributeManifest) DeepCopyInto(out *AttributeManifest) {
    p := proto.Clone(in).(*AttributeManifest)
    *out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AttributeManifest. Required by controller-gen.
func (in *AttributeManifest) DeepCopy() *AttributeManifest {
    if in == nil {
        return nil
    }
    out := new(AttributeManifest)
    in.DeepCopyInto(out)
    return out
}

// DeepCopyInto supports using Rule within kubernetes types, where deepcopy-gen is used.
func (in *Rule) DeepCopyInto(out *Rule) {
    p := proto.Clone(in).(*Rule)
    *out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Rule. Required by controller-gen.
func (in *Rule) DeepCopy() *Rule {
    if in == nil {
        return nil
    }
    out := new(Rule)
    in.DeepCopyInto(out)
    return out
}

// DeepCopyInto supports using Instance within kubernetes types, where deepcopy-gen is used.
func (in *Instance) DeepCopyInto(out *Instance) {
    p := proto.Clone(in).(*Instance)
    *out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Instance. Required by controller-gen.
func (in *Instance) DeepCopy() *Instance {
    if in == nil {
        return nil
    }
    out := new(Instance)
    in.DeepCopyInto(out)
    return out
}

// DeepCopyInto supports using Handler within kubernetes types, where deepcopy-gen is used.
func (in *Handler) DeepCopyInto(out *Handler) {
    p := proto.Clone(in).(*Handler)
    *out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Handler. Required by controller-gen.
func (in *Handler) DeepCopy() *Handler {
    if in == nil {
        return nil
    }
    out := new(Handler)
    in.DeepCopyInto(out)
    return out
}
```
