/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.File;
import sandbox.java.io.FilePermissionCollection;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PermissionCollection;
import sandbox.java.security.PrivilegedAction;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int READLINK = 16;
    private static final int ALL = 31;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private static final long serialVersionUID = 7930732926638008763L;

    /*
     * Enabled aggressive block sorting
     */
    private void init(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if ((n & 0x1F) != n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid actions mask");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid actions mask");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getName:()Ljava/lang/String;");
        this.cpath = this.getName();
        RuntimeCostAccounter.recordJump();
        if (this.cpath == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("name can't be null");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.mask = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.cpath.equals("<<ALL FILES>>");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FilePermission$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission$1.<init>:(Ljava/io/FilePermission;)V");
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public String run() {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.access$000:(Ljava/io/FilePermission;)Ljava/lang/String;");
                    String string = FilePermission.this.cpath;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.access$000:(Ljava/io/FilePermission;)Ljava/lang/String;");
                    String string2 = FilePermission.this.cpath;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                    boolean bl = string2.endsWith("*");
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        int n = string.length() - 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                        String string3 = string.substring(0, n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(string3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append("-");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                        File file = new File(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                        string = file.getCanonicalPath();
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder4 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        int n2 = string.length() - 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                        String string4 = string.substring(0, n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(string4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append("*");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        return stringBuilder6.toString();
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                    File file = new File(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.access$000:(Ljava/io/FilePermission;)Ljava/lang/String;");
                    return FilePermission.this.cpath;
                }
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        this.cpath = (String)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n3 = this.cpath.length();
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            n2 = this.cpath.charAt(n3 - 1);
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        int n4 = n2;
        RuntimeCostAccounter.recordJump();
        if (n4 == 45) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = this.cpath.charAt(n3 - 2);
            RuntimeCostAccounter.recordJump();
            if (c == File.separatorChar) {
                this.directory = true;
                this.recursive = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                this.cpath = this.cpath.substring(0, --n3);
                RuntimeCostAccounter.recordJump();
                return;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n4 != 42) return;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = this.cpath.charAt(n3 - 2);
        RuntimeCostAccounter.recordJump();
        if (c != File.separatorChar) return;
        this.directory = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        this.cpath = this.cpath.substring(0, --n3);
    }

    public FilePermission(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/security/Permission.<init>:(Ljava/lang/String;)V");
        super(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getMask:(Ljava/lang/String;)I");
        int n = FilePermission.getMask(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.init:(I)V");
        this.init(n);
    }

    FilePermission(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/security/Permission.<init>:(Ljava/lang/String;)V");
        super(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.init:(I)V");
        this.init(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean implies(Permission permission) {
        boolean bl = permission instanceof FilePermission;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        int n = this.mask & filePermission.mask;
        int n2 = filePermission.mask;
        RuntimeCostAccounter.recordJump();
        if (n != n2) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.impliesIgnoreMask:(Ljava/io/FilePermission;)Z");
        boolean bl2 = this.impliesIgnoreMask(filePermission);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean impliesIgnoreMask(FilePermission filePermission) {
        RuntimeCostAccounter.recordJump();
        if (this.directory) {
            RuntimeCostAccounter.recordJump();
            if (this.recursive) {
                boolean bl = filePermission.directory;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    String string = filePermission.cpath;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n = string.length();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n2 = this.cpath.length();
                    RuntimeCostAccounter.recordJump();
                    if (n < n2) return false;
                    String string2 = filePermission.cpath;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                    boolean bl2 = string2.startsWith(this.cpath);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) return false;
                    boolean bl3 = true;
                    RuntimeCostAccounter.recordJump();
                    return bl3;
                }
                String string = filePermission.cpath;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n = string.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = this.cpath.length();
                RuntimeCostAccounter.recordJump();
                if (n <= n3) return false;
                String string3 = filePermission.cpath;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl4 = string3.startsWith(this.cpath);
                RuntimeCostAccounter.recordJump();
                if (!bl4) return false;
                boolean bl5 = true;
                RuntimeCostAccounter.recordJump();
                return bl5;
            }
            boolean bl = filePermission.directory;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                boolean bl6 = filePermission.recursive;
                RuntimeCostAccounter.recordJump();
                if (bl6) {
                    return false;
                }
                String string = filePermission.cpath;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                return this.cpath.equals(string);
            }
            String string = filePermission.cpath;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
            int n = string.lastIndexOf(File.separatorChar);
            RuntimeCostAccounter.recordJump();
            if (n == -1) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n4 = this.cpath.length();
            RuntimeCostAccounter.recordJump();
            if (n4 != n + 1) return false;
            String string4 = filePermission.cpath;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.regionMatches:(ILjava/lang/String;II)Z");
            boolean bl7 = this.cpath.regionMatches(0, string4, 0, n + 1);
            RuntimeCostAccounter.recordJump();
            if (!bl7) return false;
            boolean bl8 = true;
            RuntimeCostAccounter.recordJump();
            return bl8;
        }
        boolean bl = filePermission.directory;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        String string = filePermission.cpath;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        return this.cpath.equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof FilePermission;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        int n = filePermission.mask;
        RuntimeCostAccounter.recordJump();
        if (this.mask != n) return false;
        String string = filePermission.cpath;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.cpath.equals(string);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = filePermission.directory;
        RuntimeCostAccounter.recordJump();
        if (this.directory != bl3) return false;
        boolean bl4 = filePermission.recursive;
        RuntimeCostAccounter.recordJump();
        if (this.recursive != bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    public int hashCode() {
        return 0;
    }

    /*
     * Exception decompiling
     */
    private static int getMask(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        RuntimeCostAccounter.recordJump();
        if ((n & 4) == 4) {
            bl = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("read");
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 2) == 2) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(',');
                RuntimeCostAccounter.recordJump();
            } else {
                bl = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("write");
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 1) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(',');
                RuntimeCostAccounter.recordJump();
            } else {
                bl = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("execute");
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 8) == 8) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(',');
                RuntimeCostAccounter.recordJump();
            } else {
                bl = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("delete");
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 0x10) == 16) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(',');
                RuntimeCostAccounter.recordJump();
            } else {
                bl = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("readlink");
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public String getActions() {
        RuntimeCostAccounter.recordJump();
        if (this.actions == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getActions:(I)Ljava/lang/String;");
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        RuntimeCostAccounter.recordAllocation((String)"java/io/FilePermissionCollection");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermissionCollection.<init>:()V");
        return new FilePermissionCollection();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.actions == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getActions:()Ljava/lang/String;");
            this.getActions();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getMask:(Ljava/lang/String;)I");
        int n = FilePermission.getMask(this.actions);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.init:(I)V");
        this.init(n);
    }
}

