/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.ByteArrayInputStream;
import sandbox.java.io.EOFException;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.SequenceInputStream;
import sandbox.java.util.zip.CRC32;
import sandbox.java.util.zip.CheckedInputStream;
import sandbox.java.util.zip.Inflater;
import sandbox.java.util.zip.InflaterInputStream;
import sandbox.java.util.zip.ZipException;

public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc;
    protected boolean eos;
    private boolean closed;
    public static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private byte[] tmpbuf;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Inflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.<init>:(Z)V");
        Inflater inflater = new Inflater(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Inflater;I)V");
        super(inputStream, inflater, n);
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/CRC32");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.<init>:()V");
        this.crc = new CRC32();
        this.closed = false;
        RuntimeCostAccounter.recordArrayAllocation((int)128, (int)1);
        this.tmpbuf = new byte[128];
        this.usesDefaultInflater = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readHeader:(Ljava/io/InputStream;)I");
        this.readHeader(inputStream);
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.<init>:(Ljava/io/InputStream;I)V");
        this(inputStream, 512);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.eos) {
            return -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.read:([BII)I");
        int n3 = super.read(byArray, n, n2);
        RuntimeCostAccounter.recordJump();
        if (n3 != -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.update:([BII)V");
            this.crc.update(byArray, n, n3);
            return n3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readTrailer:()Z");
        boolean bl = this.readTrailer();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            this.eos = true;
            RuntimeCostAccounter.recordJump();
            return n3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.read:([BII)I");
        return this.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.closed) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.close:()V");
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }

    private int readHeader(InputStream inputStream) throws IOException {
        int n;
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/CheckedInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CheckedInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Checksum;)V");
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, this.crc);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.reset:()V");
        this.crc.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUShort:(Ljava/io/InputStream;)I");
        int n2 = this.readUShort(checkedInputStream);
        RuntimeCostAccounter.recordJump();
        if (n2 != 35615) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException("Not in GZIP format");
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
        int n3 = this.readUByte(checkedInputStream);
        RuntimeCostAccounter.recordJump();
        if (n3 != 8) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException("Unsupported compression method");
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
        int n4 = this.readUByte(checkedInputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.skipBytes:(Ljava/io/InputStream;I)V");
        this.skipBytes(checkedInputStream, 6);
        int n5 = 10;
        RuntimeCostAccounter.recordJump();
        if ((n4 & 4) == 4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUShort:(Ljava/io/InputStream;)I");
            n = this.readUShort(checkedInputStream);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.skipBytes:(Ljava/io/InputStream;I)V");
            this.skipBytes(checkedInputStream, n);
            n5 += n + 2;
        }
        RuntimeCostAccounter.recordJump();
        if ((n4 & 8) == 8) {
            int n6;
            do {
                ++n5;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
                n6 = this.readUByte(checkedInputStream);
                RuntimeCostAccounter.recordJump();
            } while (n6 != 0);
        }
        RuntimeCostAccounter.recordJump();
        if ((n4 & 0x10) == 16) {
            int n7;
            do {
                ++n5;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
                n7 = this.readUByte(checkedInputStream);
                RuntimeCostAccounter.recordJump();
            } while (n7 != 0);
        }
        RuntimeCostAccounter.recordJump();
        if ((n4 & 2) == 2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
            n = (int)this.crc.getValue() & 0xFFFF;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUShort:(Ljava/io/InputStream;)I");
            int n8 = this.readUShort(checkedInputStream);
            RuntimeCostAccounter.recordJump();
            if (n8 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                ZipException zipException = new ZipException("Corrupt GZIP header");
                RuntimeCostAccounter.recordThrow();
                throw zipException;
            }
            n5 += 2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.reset:()V");
        this.crc.reset();
        return n5;
    }

    private boolean readTrailer() throws IOException {
        block10: {
            int n;
            InputStream inputStream;
            block9: {
                block8: {
                    block7: {
                        inputStream = this.in;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getRemaining:()I");
                        n = this.inf.getRemaining();
                        RuntimeCostAccounter.recordJump();
                        if (n > 0) {
                            RuntimeCostAccounter.recordAllocation((String)"java/io/SequenceInputStream");
                            RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayInputStream");
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayInputStream.<init>:([BII)V");
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf, this.len - n, n);
                            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/GZIPInputStream$1");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream$1.<init>:(Ljava/util/zip/GZIPInputStream;Ljava/io/InputStream;)V");
                            FilterInputStream filterInputStream = new FilterInputStream(inputStream){
                                {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
                                    super(inputStream);
                                }

                                @Override
                                public void close() throws IOException {
                                }
                            };
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/SequenceInputStream.<init>:(Ljava/io/InputStream;Ljava/io/InputStream;)V");
                            inputStream = new SequenceInputStream(byteArrayInputStream, filterInputStream);
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUInt:(Ljava/io/InputStream;)J");
                        long l = this.readUInt(inputStream);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                        long l2 = l - this.crc.getValue();
                        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l3 != false) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUInt:(Ljava/io/InputStream;)J");
                        long l4 = this.readUInt(inputStream);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesWritten:()J");
                        long l5 = l4 - (this.inf.getBytesWritten() & 0xFFFFFFFFL);
                        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l6 == false) break block8;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException("Corrupt GZIP trailer");
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
                int n2 = this.in.available();
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) break block9;
                RuntimeCostAccounter.recordJump();
                if (n <= 26) break block10;
            }
            int n3 = 8;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readHeader:(Ljava/io/InputStream;)I");
                n3 += this.readHeader(inputStream);
            }
            catch (IOException iOException) {
                return true;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.reset:()V");
            this.inf.reset();
            RuntimeCostAccounter.recordJump();
            if (n > n3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.setInput:([BII)V");
                this.inf.setInput(this.buf, this.len - n + n3, n - n3);
            }
            return false;
        }
        return true;
    }

    private long readUInt(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUShort:(Ljava/io/InputStream;)I");
        long l = this.readUShort(inputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUShort:(Ljava/io/InputStream;)I");
        return (long)this.readUShort(inputStream) << 16 | l;
    }

    private int readUShort(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
        int n = this.readUByte(inputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPInputStream.readUByte:(Ljava/io/InputStream;)I");
        return this.readUByte(inputStream) << 8 | n;
    }

    private int readUByte(InputStream inputStream) throws IOException {
        int n;
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
                n = inputStream.read();
                RuntimeCostAccounter.recordJump();
                if (n == -1) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                    EOFException eOFException = new EOFException();
                    RuntimeCostAccounter.recordThrow();
                    throw eOFException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < -1) break block4;
                RuntimeCostAccounter.recordJump();
                if (n <= 255) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.in.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(".read() returned value out of range -1..255: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException(string2);
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        return n;
    }

    private void skipBytes(InputStream inputStream, int n) throws IOException {
        while (true) {
            int n2;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n3 = this.tmpbuf.length;
            RuntimeCostAccounter.recordJump();
            if (n < n3) {
                n2 = n;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = this.tmpbuf.length;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            int n4 = inputStream.read(this.tmpbuf, 0, n2);
            RuntimeCostAccounter.recordJump();
            if (n4 == -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            n -= n4;
            RuntimeCostAccounter.recordJump();
        }
    }
}

