/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.util.zip.Checksum;

public class CheckedOutputStream
extends FilterOutputStream {
    private Checksum cksum;

    public CheckedOutputStream(OutputStream outputStream, Checksum checksum) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        this.cksum = checksum;
    }

    @Override
    public void write(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        this.out.write(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Checksum.update:(I)V");
        this.cksum.update(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
        this.out.write(byArray, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Checksum.update:([BII)V");
        this.cksum.update(byArray, n, n2);
    }

    public Checksum getChecksum() {
        return this.cksum;
    }
}

