/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum cksum;

    public CheckedInputStream(InputStream inputStream, Checksum checksum) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
        super(inputStream);
        this.cksum = checksum;
    }

    @Override
    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
        int n = this.in.read();
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Checksum.update:(I)V");
            this.cksum.update(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
        n2 = this.in.read(byArray, n, n2);
        RuntimeCostAccounter.recordJump();
        if (n2 != -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Checksum.update:([BII)V");
            this.cksum.update(byArray, n, n2);
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)512, (int)1);
        byte[] byArray = new byte[512];
        long l2 = 0L;
        while (true) {
            int n;
            RuntimeCostAccounter.recordJump();
            if (l2 >= l) break;
            long l3 = l - l2;
            long l4 = l3 - (long)byArray.length;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 < 0) {
                n = (int)l3;
                RuntimeCostAccounter.recordJump();
            } else {
                n = byArray.length;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CheckedInputStream.read:([BII)I");
            l3 = this.read(byArray, 0, n);
            RuntimeCostAccounter.recordJump();
            if (l3 == -1L) {
                return l2;
            }
            l2 += l3;
            RuntimeCostAccounter.recordJump();
        }
        return l2;
    }

    public Checksum getChecksum() {
        return this.cksum;
    }
}

