/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.Comparator;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.Optional;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.function.ToDoubleFunction;
import sandbox.java.util.function.ToIntFunction;
import sandbox.java.util.function.ToLongFunction;
import sandbox.java.util.function.UnaryOperator;
import sandbox.java.util.stream.BaseStream;
import sandbox.java.util.stream.Collector;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.StreamSpliterators;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.stream.Streams;

public interface Stream<T>
extends BaseStream<T, Stream<T>> {
    public Stream<T> filter(Predicate<? super T> var1);

    public <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public IntStream mapToInt(ToIntFunction<? super T> var1);

    public LongStream mapToLong(ToLongFunction<? super T> var1);

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    public Stream<T> distinct();

    public Stream<T> sorted();

    public Stream<T> sorted(Comparator<? super T> var1);

    public Stream<T> peek(Consumer<? super T> var1);

    public Stream<T> limit(long var1);

    public Stream<T> skip(long var1);

    public void forEach(Consumer<? super T> var1);

    public void forEachOrdered(Consumer<? super T> var1);

    public Object[] toArray();

    public <A> A[] toArray(IntFunction<A[]> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public Optional<T> min(Comparator<? super T> var1);

    public Optional<T> max(Comparator<? super T> var1);

    public long count();

    public boolean anyMatch(Predicate<? super T> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Optional<T> findFirst();

    public Optional<T> findAny();

    public static <T> Builder<T> builder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$StreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$StreamBuilderImpl.<init>:()V");
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptySpliterator:()Ljava/util/Spliterator;");
        Spliterator spliterator = Spliterators.emptySpliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> of(T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$StreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$StreamBuilderImpl.<init>:(Ljava/lang/Object;)V");
        Streams.StreamBuilderImpl<T> streamBuilderImpl = new Streams.StreamBuilderImpl<T>(t);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(streamBuilderImpl, false);
    }

    @SafeVarargs
    public static <T> Stream<T> of(T ... TArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.stream:([Ljava/lang/Object;)Ljava/util/stream/Stream;");
        return Arrays.stream(TArray);
    }

    public static <T> Stream<T> iterate(final T t, final UnaryOperator<T> unaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(unaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Stream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream$1.<init>:(Ljava/lang/Object;Ljava/util/function/UnaryOperator;)V");
        Iterator iterator = new Iterator<T>(){
            T t;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.t = Streams.NONE;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                Object object;
                RuntimeCostAccounter.recordJump();
                if (this.t == Streams.NONE) {
                    object = t;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                    object = unaryOperator.apply(this.t);
                }
                this.t = object;
                return object;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliteratorUnknownSize:(Ljava/util/Iterator;I)Ljava/util/Spliterator;");
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 1040);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> generate(Supplier<T> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(supplier);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfRef.<init>:(JLjava/util/function/Supplier;)V");
        StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T> ofRef = new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, supplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(ofRef, false);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> Stream<T> concat(Stream<? extends T> var0, Stream<? extends T> var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var1_1);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$ConcatSpliterator$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.spliterator:()Ljava/util/Spliterator;");
        v0 = var0.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.spliterator:()Ljava/util/Spliterator;");
        v1 = var1_1.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$ConcatSpliterator$OfRef.<init>:(Ljava/util/Spliterator;Ljava/util/Spliterator;)V");
        var2_2 = new Streams.ConcatSpliterator.OfRef<T>(v0, v1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.isParallel:()Z");
        v2 = var0.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v2) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.isParallel:()Z");
        v3 = var1_1.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v3) lbl-1000:
        // 2 sources

        {
            v4 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v4 = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        var3_3 = StreamSupport.stream(var2_2, v4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams.composedClose:(Ljava/util/stream/BaseStream;Ljava/util/stream/BaseStream;)Ljava/lang/Runnable;");
        v5 = Streams.composedClose(var0, var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.onClose:(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;");
        return (Stream)var3_3.onClose(v5);
    }

    public static interface Builder<T>
    extends Consumer<T> {
        @Override
        public void accept(T var1);

        default public Builder<T> add(T t) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream$Builder.accept:(Ljava/lang/Object;)V");
            this.accept(t);
            return this;
        }

        public Stream<T> build();
    }
}

