/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.ArrayDeque;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Deque;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.concurrent.ForkJoinTask;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.function.LongFunction;
import sandbox.java.util.stream.AbstractTask;
import sandbox.java.util.stream.Node;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.SpinedBuffer;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamShape;

final class Nodes {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    static final String BAD_SIZE = "Stream size exceeds max array size";
    private static final Node EMPTY_NODE;
    private static final Node.OfInt EMPTY_INT_NODE;
    private static final Node.OfLong EMPTY_LONG_NODE;
    private static final Node.OfDouble EMPTY_DOUBLE_NODE;
    private static final int[] EMPTY_INT_ARRAY;
    private static final long[] EMPTY_LONG_ARRAY;
    private static final double[] EMPTY_DOUBLE_ARRAY;

    private Nodes() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
        Error error = new Error("no instances");
        RuntimeCostAccounter.recordThrow();
        throw error;
    }

    static <T> Node<T> emptyNode(StreamShape streamShape) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamShape.ordinal:()I");
        switch (1.$SwitchMap$java$util$stream$StreamShape[streamShape.ordinal()]) {
            case 1: {
                return EMPTY_NODE;
            }
            case 2: {
                return EMPTY_INT_NODE;
            }
            case 3: {
                return EMPTY_LONG_NODE;
            }
            case 4: {
                return EMPTY_DOUBLE_NODE;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unknown shape ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append((Object)streamShape);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
        IllegalStateException illegalStateException = new IllegalStateException(string);
        RuntimeCostAccounter.recordThrow();
        throw illegalStateException;
    }

    static <T> Node<T> conc(StreamShape streamShape, Node<T> node, Node<T> node2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamShape.ordinal:()I");
        switch (1.$SwitchMap$java$util$stream$StreamShape[streamShape.ordinal()]) {
            case 1: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ConcNode");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.<init>:(Ljava/util/stream/Node;Ljava/util/stream/Node;)V");
                return new ConcNode<T>(node, node2);
            }
            case 2: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ConcNode$OfInt");
                Node.OfInt ofInt = (Node.OfInt)node;
                Node.OfInt ofInt2 = (Node.OfInt)node2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfInt.<init>:(Ljava/util/stream/Node$OfInt;Ljava/util/stream/Node$OfInt;)V");
                return new ConcNode.OfInt(ofInt, ofInt2);
            }
            case 3: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ConcNode$OfLong");
                Node.OfLong ofLong = (Node.OfLong)node;
                Node.OfLong ofLong2 = (Node.OfLong)node2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfLong.<init>:(Ljava/util/stream/Node$OfLong;Ljava/util/stream/Node$OfLong;)V");
                return new ConcNode.OfLong(ofLong, ofLong2);
            }
            case 4: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ConcNode$OfDouble");
                Node.OfDouble ofDouble = (Node.OfDouble)node;
                Node.OfDouble ofDouble2 = (Node.OfDouble)node2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfDouble.<init>:(Ljava/util/stream/Node$OfDouble;Ljava/util/stream/Node$OfDouble;)V");
                return new ConcNode.OfDouble(ofDouble, ofDouble2);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unknown shape ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append((Object)streamShape);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
        IllegalStateException illegalStateException = new IllegalStateException(string);
        RuntimeCostAccounter.recordThrow();
        throw illegalStateException;
    }

    static <T> Node<T> node(T[] TArray) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ArrayNode");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ArrayNode.<init>:([Ljava/lang/Object;)V");
        return new ArrayNode<T>(TArray);
    }

    static <T> Node<T> node(Collection<T> collection) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectionNode");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectionNode.<init>:(Ljava/util/Collection;)V");
        return new CollectionNode<T>(collection);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <T> Node.Builder<T> builder(long l, IntFunction<T[]> intFunction) {
        FixedNodeBuilder fixedNodeBuilder;
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordJump();
            if (l < 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$FixedNodeBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$FixedNodeBuilder.<init>:(JLjava/util/function/IntFunction;)V");
                fixedNodeBuilder = new FixedNodeBuilder(l, intFunction);
                RuntimeCostAccounter.recordJump();
                return fixedNodeBuilder;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.builder:()Ljava/util/stream/Node$Builder;");
        fixedNodeBuilder = Nodes.builder();
        return fixedNodeBuilder;
    }

    static <T> Node.Builder<T> builder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SpinedNodeBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SpinedNodeBuilder.<init>:()V");
        return new SpinedNodeBuilder();
    }

    static Node.OfInt node(int[] nArray) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$IntArrayNode");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntArrayNode.<init>:([I)V");
        return new IntArrayNode(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Node.Builder.OfInt intBuilder(long l) {
        Node.Builder.OfInt ofInt;
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordJump();
            if (l < 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$IntFixedNodeBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntFixedNodeBuilder.<init>:(J)V");
                ofInt = new IntFixedNodeBuilder(l);
                RuntimeCostAccounter.recordJump();
                return ofInt;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.intBuilder:()Ljava/util/stream/Node$Builder$OfInt;");
        ofInt = Nodes.intBuilder();
        return ofInt;
    }

    static Node.Builder.OfInt intBuilder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$IntSpinedNodeBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntSpinedNodeBuilder.<init>:()V");
        return new IntSpinedNodeBuilder();
    }

    static Node.OfLong node(long[] lArray) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$LongArrayNode");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongArrayNode.<init>:([J)V");
        return new LongArrayNode(lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Node.Builder.OfLong longBuilder(long l) {
        Node.Builder.OfLong ofLong;
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordJump();
            if (l < 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$LongFixedNodeBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongFixedNodeBuilder.<init>:(J)V");
                ofLong = new LongFixedNodeBuilder(l);
                RuntimeCostAccounter.recordJump();
                return ofLong;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.longBuilder:()Ljava/util/stream/Node$Builder$OfLong;");
        ofLong = Nodes.longBuilder();
        return ofLong;
    }

    static Node.Builder.OfLong longBuilder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$LongSpinedNodeBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongSpinedNodeBuilder.<init>:()V");
        return new LongSpinedNodeBuilder();
    }

    static Node.OfDouble node(double[] dArray) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$DoubleArrayNode");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleArrayNode.<init>:([D)V");
        return new DoubleArrayNode(dArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Node.Builder.OfDouble doubleBuilder(long l) {
        Node.Builder.OfDouble ofDouble;
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordJump();
            if (l < 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$DoubleFixedNodeBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleFixedNodeBuilder.<init>:(J)V");
                ofDouble = new DoubleFixedNodeBuilder(l);
                RuntimeCostAccounter.recordJump();
                return ofDouble;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.doubleBuilder:()Ljava/util/stream/Node$Builder$OfDouble;");
        ofDouble = Nodes.doubleBuilder();
        return ofDouble;
    }

    static Node.Builder.OfDouble doubleBuilder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$DoubleSpinedNodeBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleSpinedNodeBuilder.<init>:()V");
        return new DoubleSpinedNodeBuilder();
    }

    public static <P_IN, P_OUT> Node<P_OUT> collect(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<P_OUT[]> intFunction) {
        Node node;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
            boolean bl2 = spliterator.hasCharacteristics(16384);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
                P_OUT[] P_OUTArray = intFunction.apply(n);
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfRef");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfRef.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;[Ljava/lang/Object;)V");
                SizedCollectorTask.OfRef<P_IN, P_OUT> ofRef = new SizedCollectorTask.OfRef<P_IN, P_OUT>(spliterator, pipelineHelper, P_OUTArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfRef.invoke:()Ljava/lang/Object;");
                ofRef.invoke();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([Ljava/lang/Object;)Ljava/util/stream/Node;");
                return Nodes.node(P_OUTArray);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectorTask$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfRef.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/function/IntFunction;Ljava/util/Spliterator;)V");
        CollectorTask.OfRef<P_IN, P_OUT> ofRef = new CollectorTask.OfRef<P_IN, P_OUT>(pipelineHelper, intFunction, spliterator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfRef.invoke:()Ljava/lang/Object;");
        Node node2 = (Node)ofRef.invoke();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.flatten:(Ljava/util/stream/Node;Ljava/util/function/IntFunction;)Ljava/util/stream/Node;");
            node = Nodes.flatten(node2, intFunction);
            RuntimeCostAccounter.recordJump();
        } else {
            node = node2;
        }
        return node;
    }

    public static <P_IN> Node.OfInt collectInt(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        Node.OfInt ofInt;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
            boolean bl2 = spliterator.hasCharacteristics(16384);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                int n = (int)l;
                RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
                int[] nArray = new int[n];
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfInt");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfInt.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;[I)V");
                SizedCollectorTask.OfInt<P_IN> ofInt2 = new SizedCollectorTask.OfInt<P_IN>(spliterator, pipelineHelper, nArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfInt.invoke:()Ljava/lang/Object;");
                ofInt2.invoke();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([I)Ljava/util/stream/Node$OfInt;");
                return Nodes.node(nArray);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectorTask$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfInt.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
        CollectorTask.OfInt<P_IN> ofInt3 = new CollectorTask.OfInt<P_IN>(pipelineHelper, spliterator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfInt.invoke:()Ljava/lang/Object;");
        Node.OfInt ofInt4 = (Node.OfInt)ofInt3.invoke();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.flattenInt:(Ljava/util/stream/Node$OfInt;)Ljava/util/stream/Node$OfInt;");
            ofInt = Nodes.flattenInt(ofInt4);
            RuntimeCostAccounter.recordJump();
        } else {
            ofInt = ofInt4;
        }
        return ofInt;
    }

    public static <P_IN> Node.OfLong collectLong(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        Node.OfLong ofLong;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
            boolean bl2 = spliterator.hasCharacteristics(16384);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                int n = (int)l;
                RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
                long[] lArray = new long[n];
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfLong");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfLong.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;[J)V");
                SizedCollectorTask.OfLong<P_IN> ofLong2 = new SizedCollectorTask.OfLong<P_IN>(spliterator, pipelineHelper, lArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfLong.invoke:()Ljava/lang/Object;");
                ofLong2.invoke();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([J)Ljava/util/stream/Node$OfLong;");
                return Nodes.node(lArray);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectorTask$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfLong.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
        CollectorTask.OfLong<P_IN> ofLong3 = new CollectorTask.OfLong<P_IN>(pipelineHelper, spliterator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfLong.invoke:()Ljava/lang/Object;");
        Node.OfLong ofLong4 = (Node.OfLong)ofLong3.invoke();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.flattenLong:(Ljava/util/stream/Node$OfLong;)Ljava/util/stream/Node$OfLong;");
            ofLong = Nodes.flattenLong(ofLong4);
            RuntimeCostAccounter.recordJump();
        } else {
            ofLong = ofLong4;
        }
        return ofLong;
    }

    public static <P_IN> Node.OfDouble collectDouble(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        Node.OfDouble ofDouble;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
            boolean bl2 = spliterator.hasCharacteristics(16384);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                int n = (int)l;
                RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
                double[] dArray = new double[n];
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfDouble");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfDouble.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;[D)V");
                SizedCollectorTask.OfDouble<P_IN> ofDouble2 = new SizedCollectorTask.OfDouble<P_IN>(spliterator, pipelineHelper, dArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfDouble.invoke:()Ljava/lang/Object;");
                ofDouble2.invoke();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([D)Ljava/util/stream/Node$OfDouble;");
                return Nodes.node(dArray);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectorTask$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfDouble.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
        CollectorTask.OfDouble<P_IN> ofDouble3 = new CollectorTask.OfDouble<P_IN>(pipelineHelper, spliterator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask$OfDouble.invoke:()Ljava/lang/Object;");
        Node.OfDouble ofDouble4 = (Node.OfDouble)ofDouble3.invoke();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.flattenDouble:(Ljava/util/stream/Node$OfDouble;)Ljava/util/stream/Node$OfDouble;");
            ofDouble = Nodes.flattenDouble(ofDouble4);
            RuntimeCostAccounter.recordJump();
        } else {
            ofDouble = ofDouble4;
        }
        return ofDouble;
    }

    public static <T> Node<T> flatten(Node<T> node, IntFunction<T[]> intFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
        int n = node.getChildCount();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
            long l = node.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n2 = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
            Object[] objectArray = intFunction.apply(n2);
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfRef");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfRef.<init>:(Ljava/util/stream/Node;[Ljava/lang/Object;ILjava/util/stream/Nodes$1;)V");
            ToArrayTask.OfRef ofRef = new ToArrayTask.OfRef(node, objectArray, 0, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfRef.invoke:()Ljava/lang/Object;");
            ofRef.invoke();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([Ljava/lang/Object;)Ljava/util/stream/Node;");
            return Nodes.node(objectArray);
        }
        return node;
    }

    public static Node.OfInt flattenInt(Node.OfInt ofInt) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfInt.getChildCount:()I");
        int n = ofInt.getChildCount();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfInt.count:()J");
            long l = ofInt.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n2 = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
            int[] nArray = new int[n2];
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfInt");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfInt.<init>:(Ljava/util/stream/Node$OfInt;[IILjava/util/stream/Nodes$1;)V");
            ToArrayTask.OfInt ofInt2 = new ToArrayTask.OfInt(ofInt, nArray, 0, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfInt.invoke:()Ljava/lang/Object;");
            ofInt2.invoke();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([I)Ljava/util/stream/Node$OfInt;");
            return Nodes.node(nArray);
        }
        return ofInt;
    }

    public static Node.OfLong flattenLong(Node.OfLong ofLong) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfLong.getChildCount:()I");
        int n = ofLong.getChildCount();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfLong.count:()J");
            long l = ofLong.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n2 = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            long[] lArray = new long[n2];
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfLong");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfLong.<init>:(Ljava/util/stream/Node$OfLong;[JILjava/util/stream/Nodes$1;)V");
            ToArrayTask.OfLong ofLong2 = new ToArrayTask.OfLong(ofLong, lArray, 0, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfLong.invoke:()Ljava/lang/Object;");
            ofLong2.invoke();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([J)Ljava/util/stream/Node$OfLong;");
            return Nodes.node(lArray);
        }
        return ofLong;
    }

    public static Node.OfDouble flattenDouble(Node.OfDouble ofDouble) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfDouble.getChildCount:()I");
        int n = ofDouble.getChildCount();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfDouble.count:()J");
            long l = ofDouble.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n2 = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            double[] dArray = new double[n2];
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfDouble");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfDouble.<init>:(Ljava/util/stream/Node$OfDouble;[DILjava/util/stream/Nodes$1;)V");
            ToArrayTask.OfDouble ofDouble2 = new ToArrayTask.OfDouble(ofDouble, dArray, 0, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfDouble.invoke:()Ljava/lang/Object;");
            ofDouble2.invoke();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([D)Ljava/util/stream/Node$OfDouble;");
            return Nodes.node(dArray);
        }
        return ofDouble;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$EmptyNode$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode$OfRef.<init>:(Ljava/util/stream/Nodes$1;)V");
        EMPTY_NODE = new EmptyNode.OfRef(null);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$EmptyNode$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode$OfInt.<init>:()V");
        EMPTY_INT_NODE = new EmptyNode.OfInt();
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$EmptyNode$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode$OfLong.<init>:()V");
        EMPTY_LONG_NODE = new EmptyNode.OfLong();
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$EmptyNode$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode$OfDouble.<init>:()V");
        EMPTY_DOUBLE_NODE = new EmptyNode.OfDouble();
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)4);
        EMPTY_INT_ARRAY = new int[0];
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_LONG_ARRAY = new long[0];
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_DOUBLE_ARRAY = new double[0];
    }

    private static class CollectorTask<P_IN, P_OUT, T_NODE extends Node<P_OUT>, T_BUILDER extends Node.Builder<P_OUT>>
    extends AbstractTask<P_IN, P_OUT, T_NODE, CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>> {
        protected final PipelineHelper<P_OUT> helper;
        protected final LongFunction<T_BUILDER> builderFactory;
        protected final BinaryOperator<T_NODE> concFactory;

        CollectorTask(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, LongFunction<T_BUILDER> longFunction, BinaryOperator<T_NODE> binaryOperator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
            super(pipelineHelper, spliterator);
            this.helper = pipelineHelper;
            this.builderFactory = longFunction;
            this.concFactory = binaryOperator;
        }

        CollectorTask(CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> collectorTask, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.<init>:(Ljava/util/stream/AbstractTask;Ljava/util/Spliterator;)V");
            super(collectorTask, spliterator);
            this.helper = collectorTask.helper;
            this.builderFactory = collectorTask.builderFactory;
            this.concFactory = collectorTask.concFactory;
        }

        @Override
        protected CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> makeChild(Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$CollectorTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.<init>:(Ljava/util/stream/Nodes$CollectorTask;Ljava/util/Spliterator;)V");
            return new CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>(this, spliterator);
        }

        @Override
        protected T_NODE doLeaf() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
            long l = this.helper.exactOutputSizeIfKnown(this.spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongFunction.apply:(J)Ljava/lang/Object;");
            Node.Builder builder = (Node.Builder)this.builderFactory.apply(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$Builder.build:()Ljava/util/stream/Node;");
            return (T_NODE)this.helper.wrapAndCopyInto(builder, this.spliterator).build();
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.isLeaf:()Z");
            boolean bl = this.isLeaf();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                CollectorTask collectorTask = (CollectorTask)this.leftChild;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.getLocalResult:()Ljava/lang/Object;");
                Object r = collectorTask.getLocalResult();
                CollectorTask collectorTask2 = (CollectorTask)this.rightChild;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.getLocalResult:()Ljava/lang/Object;");
                Object r2 = collectorTask2.getLocalResult();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                Object r3 = this.concFactory.apply(r, r2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.setLocalResult:(Ljava/lang/Object;)V");
                this.setLocalResult(r3);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.onCompletion:(Ljava/util/concurrent/CountedCompleter;)V");
            super.onCompletion(countedCompleter);
        }

        private static final class OfDouble<P_IN>
        extends CollectorTask<P_IN, Double, Node.OfDouble, Node.Builder.OfDouble> {
            OfDouble(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator) {
                LongFunction<Node.Builder.OfDouble> longFunction = Nodes::doubleBuilder;
                BinaryOperator binaryOperator = ConcNode.OfDouble::new;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/LongFunction;Ljava/util/function/BinaryOperator;)V");
                super(pipelineHelper, spliterator, longFunction, binaryOperator);
            }
        }

        private static final class OfLong<P_IN>
        extends CollectorTask<P_IN, Long, Node.OfLong, Node.Builder.OfLong> {
            OfLong(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator) {
                LongFunction<Node.Builder.OfLong> longFunction = Nodes::longBuilder;
                BinaryOperator binaryOperator = ConcNode.OfLong::new;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/LongFunction;Ljava/util/function/BinaryOperator;)V");
                super(pipelineHelper, spliterator, longFunction, binaryOperator);
            }
        }

        private static final class OfInt<P_IN>
        extends CollectorTask<P_IN, Integer, Node.OfInt, Node.Builder.OfInt> {
            OfInt(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator) {
                LongFunction<Node.Builder.OfInt> longFunction = Nodes::intBuilder;
                BinaryOperator binaryOperator = ConcNode.OfInt::new;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/LongFunction;Ljava/util/function/BinaryOperator;)V");
                super(pipelineHelper, spliterator, longFunction, binaryOperator);
            }
        }

        private static final class OfRef<P_IN, P_OUT>
        extends CollectorTask<P_IN, P_OUT, Node<P_OUT>, Node.Builder<P_OUT>> {
            OfRef(PipelineHelper<P_OUT> pipelineHelper, IntFunction<P_OUT[]> intFunction, Spliterator<P_IN> spliterator) {
                LongFunction<Node.Builder> longFunction = l -> {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.builder:(JLjava/util/function/IntFunction;)Ljava/util/stream/Node$Builder;");
                    return Nodes.builder(l, intFunction);
                };
                BinaryOperator binaryOperator = ConcNode::new;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$CollectorTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/LongFunction;Ljava/util/function/BinaryOperator;)V");
                super(pipelineHelper, spliterator, longFunction, binaryOperator);
            }
        }
    }

    private static abstract class ToArrayTask<T, T_NODE extends Node<T>, K extends ToArrayTask<T, T_NODE, K>>
    extends CountedCompleter<Void> {
        protected final T_NODE node;
        protected final int offset;

        ToArrayTask(T_NODE T_NODE, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:()V");
            this.node = T_NODE;
            this.offset = n;
        }

        ToArrayTask(K k, T_NODE T_NODE, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
            super((CountedCompleter<?>)k);
            this.node = T_NODE;
            this.offset = n;
        }

        abstract void copyNodeToArray();

        abstract K makeChild(int var1, int var2);

        @Override
        public void compute() {
            ToArrayTask<T, T_NODE, K> toArrayTask = this;
            while (true) {
                T_NODE T_NODE = toArrayTask.node;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                int n = T_NODE.getChildCount();
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.copyNodeToArray:()V");
                    toArrayTask.copyNodeToArray();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.propagateCompletion:()V");
                    toArrayTask.propagateCompletion();
                    return;
                }
                T_NODE T_NODE2 = toArrayTask.node;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                int n2 = T_NODE2.getChildCount() - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.setPendingCount:(I)V");
                toArrayTask.setPendingCount(n2);
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    T_NODE T_NODE3 = toArrayTask.node;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                    int n5 = T_NODE3.getChildCount() - 1;
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n5) break;
                    int n6 = toArrayTask.offset + n3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.makeChild:(II)Ljava/util/stream/Nodes$ToArrayTask;");
                    K k = toArrayTask.makeChild(n4, n6);
                    long l = n3;
                    T_NODE T_NODE4 = ((ToArrayTask)k).node;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
                    n3 = (int)(l + T_NODE4.count());
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                    ((ForkJoinTask)k).fork();
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
                int n7 = toArrayTask.offset + n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.makeChild:(II)Ljava/util/stream/Nodes$ToArrayTask;");
                toArrayTask = toArrayTask.makeChild(n4, n7);
                RuntimeCostAccounter.recordJump();
            }
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble> {
            private OfDouble(Node.OfDouble ofDouble, double[] dArray, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/lang/Object;ILjava/util/stream/Nodes$1;)V");
                super(ofDouble, dArray, n, null);
            }

            /* synthetic */ OfDouble(Node.OfDouble ofDouble, double[] dArray, int n, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfDouble.<init>:(Ljava/util/stream/Node$OfDouble;[DI)V");
                this(ofDouble, dArray, n);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong> {
            private OfLong(Node.OfLong ofLong, long[] lArray, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/lang/Object;ILjava/util/stream/Nodes$1;)V");
                super(ofLong, lArray, n, null);
            }

            /* synthetic */ OfLong(Node.OfLong ofLong, long[] lArray, int n, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfLong.<init>:(Ljava/util/stream/Node$OfLong;[JI)V");
                this(ofLong, lArray, n);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt> {
            private OfInt(Node.OfInt ofInt, int[] nArray, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/lang/Object;ILjava/util/stream/Nodes$1;)V");
                super(ofInt, nArray, n, null);
            }

            /* synthetic */ OfInt(Node.OfInt ofInt, int[] nArray, int n, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfInt.<init>:(Ljava/util/stream/Node$OfInt;[II)V");
                this(ofInt, nArray, n);
            }
        }

        private static class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends ToArrayTask<T, T_NODE, OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>> {
            private final T_ARR array;

            private OfPrimitive(T_NODE T_NODE, T_ARR T_ARR, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.<init>:(Ljava/util/stream/Node;I)V");
                super(T_NODE, n);
                this.array = T_ARR;
            }

            private OfPrimitive(OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> ofPrimitive, T_NODE T_NODE, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.<init>:(Ljava/util/stream/Nodes$ToArrayTask;Ljava/util/stream/Node;I)V");
                super(ofPrimitive, T_NODE, n);
                this.array = ofPrimitive.array;
            }

            @Override
            OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> makeChild(int n, int n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive");
                Node.OfPrimitive ofPrimitive = (Node.OfPrimitive)this.node;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.getChild:(I)Ljava/util/stream/Node$OfPrimitive;");
                Node node = ofPrimitive.getChild(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive.<init>:(Ljava/util/stream/Nodes$ToArrayTask$OfPrimitive;Ljava/util/stream/Node$OfPrimitive;I)V");
                return new OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, Node>(this, node, n2);
            }

            @Override
            void copyNodeToArray() {
                Node.OfPrimitive ofPrimitive = (Node.OfPrimitive)this.node;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.copyInto:(Ljava/lang/Object;I)V");
                ofPrimitive.copyInto(this.array, this.offset);
            }

            /* synthetic */ OfPrimitive(Node.OfPrimitive ofPrimitive, Object object, int n, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/lang/Object;I)V");
                this(ofPrimitive, object, n);
            }
        }

        private static final class OfRef<T>
        extends ToArrayTask<T, Node<T>, OfRef<T>> {
            private final T[] array;

            private OfRef(Node<T> node, T[] TArray, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.<init>:(Ljava/util/stream/Node;I)V");
                super(node, n);
                this.array = TArray;
            }

            private OfRef(OfRef<T> ofRef, Node<T> node, int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask.<init>:(Ljava/util/stream/Nodes$ToArrayTask;Ljava/util/stream/Node;I)V");
                super(ofRef, node, n);
                this.array = ofRef.array;
            }

            @Override
            OfRef<T> makeChild(int n, int n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$ToArrayTask$OfRef");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
                Node node = this.node.getChild(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfRef.<init>:(Ljava/util/stream/Nodes$ToArrayTask$OfRef;Ljava/util/stream/Node;I)V");
                return new OfRef(this, node, n2);
            }

            @Override
            void copyNodeToArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.copyInto:([Ljava/lang/Object;I)V");
                this.node.copyInto(this.array, this.offset);
            }

            /* synthetic */ OfRef(Node node, Object[] objectArray, int n, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ToArrayTask$OfRef.<init>:(Ljava/util/stream/Node;[Ljava/lang/Object;I)V");
                this(node, objectArray, n);
            }
        }
    }

    private static abstract class SizedCollectorTask<P_IN, P_OUT, T_SINK extends Sink<P_OUT>, K extends SizedCollectorTask<P_IN, P_OUT, T_SINK, K>>
    extends CountedCompleter<Void>
    implements Sink<P_OUT> {
        protected final Spliterator<P_IN> spliterator;
        protected final PipelineHelper<P_OUT> helper;
        protected final long targetSize;
        protected long offset;
        protected long length;
        protected int index;
        protected int fence;
        static final /* synthetic */ boolean $assertionsDisabled;

        SizedCollectorTask(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> pipelineHelper, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
                boolean bl = spliterator.hasCharacteristics(16384);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.spliterator = spliterator;
            this.helper = pipelineHelper;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
            long l = spliterator.estimateSize();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.suggestTargetSize:(J)J");
            this.targetSize = AbstractTask.suggestTargetSize(l);
            this.offset = 0L;
            this.length = n;
        }

        SizedCollectorTask(K k, Spliterator<P_IN> spliterator, long l, long l2, int n) {
            block6: {
                block5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
                    super((CountedCompleter<?>)k);
                    RuntimeCostAccounter.recordJump();
                    if (!$assertionsDisabled) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
                        boolean bl = spliterator.hasCharacteristics(16384);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                            AssertionError assertionError = new AssertionError();
                            RuntimeCostAccounter.recordThrow();
                            throw assertionError;
                        }
                    }
                    this.spliterator = spliterator;
                    this.helper = ((SizedCollectorTask)k).helper;
                    this.targetSize = ((SizedCollectorTask)k).targetSize;
                    this.offset = l;
                    this.length = l2;
                    RuntimeCostAccounter.recordJump();
                    if (l < 0L) break block5;
                    RuntimeCostAccounter.recordJump();
                    if (l2 < 0L) break block5;
                    long l3 = l + l2 - 1L - (long)n;
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l4 < 0) break block6;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
                Object[] objectArray = new Object[4];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[0] = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[1] = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[2] = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[3] = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("offset and length interval [%d, %d + %d) is not within array size interval [0, %d)", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }

        @Override
        public void compute() {
            SizedCollectorTask<P_IN, P_OUT, T_SINK, K> sizedCollectorTask = this;
            Spliterator<P_IN> spliterator = this.spliterator;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                long l = spliterator.estimateSize() - sizedCollectorTask.targetSize;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                Spliterator<P_IN> spliterator2 = spliterator.trySplit();
                RuntimeCostAccounter.recordJump();
                if (spliterator2 == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.setPendingCount:(I)V");
                sizedCollectorTask.setPendingCount(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                long l3 = spliterator2.estimateSize();
                long l4 = sizedCollectorTask.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.makeChild:(Ljava/util/Spliterator;JJ)Ljava/util/stream/Nodes$SizedCollectorTask;");
                K k = sizedCollectorTask.makeChild(spliterator2, l4, l3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                ((ForkJoinTask)k).fork();
                long l5 = sizedCollectorTask.offset + l3;
                long l6 = sizedCollectorTask.length - l3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.makeChild:(Ljava/util/Spliterator;JJ)Ljava/util/stream/Nodes$SizedCollectorTask;");
                sizedCollectorTask = sizedCollectorTask.makeChild(spliterator, l5, l6);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                long l = sizedCollectorTask.offset + sizedCollectorTask.length - 0x7FFFFFF7L;
                long l7 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l7 >= 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            SizedCollectorTask sizedCollectorTask2 = sizedCollectorTask;
            PipelineHelper<P_OUT> pipelineHelper = sizedCollectorTask.helper;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            pipelineHelper.wrapAndCopyInto(sizedCollectorTask2, spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.propagateCompletion:()V");
            sizedCollectorTask.propagateCompletion();
        }

        abstract K makeChild(Spliterator<P_IN> var1, long var2, long var4);

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (l > this.length) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException("size passed to Sink.begin exceeds array length");
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.index = (int)this.offset;
            this.fence = this.index + (int)this.length;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }

        static final class OfDouble<P_IN>
        extends SizedCollectorTask<P_IN, Double, Sink.OfDouble, OfDouble<P_IN>>
        implements Sink.OfDouble {
            private final double[] array;

            OfDouble(Spliterator<P_IN> spliterator, PipelineHelper<Double> pipelineHelper, double[] dArray) {
                int n = dArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;I)V");
                super(spliterator, pipelineHelper, n);
                this.array = dArray;
            }

            OfDouble(OfDouble<P_IN> ofDouble, Spliterator<P_IN> spliterator, long l, long l2) {
                int n = ofDouble.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask;Ljava/util/Spliterator;JJI)V");
                super(ofDouble, spliterator, l, l2, n);
                this.array = ofDouble.array;
            }

            @Override
            OfDouble<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfDouble");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfDouble.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask$OfDouble;Ljava/util/Spliterator;JJ)V");
                return new OfDouble<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(double d) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= this.fence) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                    String string = Integer.toString(this.index);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                this.array[this.index++] = d;
            }
        }

        static final class OfLong<P_IN>
        extends SizedCollectorTask<P_IN, Long, Sink.OfLong, OfLong<P_IN>>
        implements Sink.OfLong {
            private final long[] array;

            OfLong(Spliterator<P_IN> spliterator, PipelineHelper<Long> pipelineHelper, long[] lArray) {
                int n = lArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;I)V");
                super(spliterator, pipelineHelper, n);
                this.array = lArray;
            }

            OfLong(OfLong<P_IN> ofLong, Spliterator<P_IN> spliterator, long l, long l2) {
                int n = ofLong.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask;Ljava/util/Spliterator;JJI)V");
                super(ofLong, spliterator, l, l2, n);
                this.array = ofLong.array;
            }

            @Override
            OfLong<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfLong");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfLong.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask$OfLong;Ljava/util/Spliterator;JJ)V");
                return new OfLong<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(long l) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= this.fence) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                    String string = Integer.toString(this.index);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                this.array[this.index++] = l;
            }
        }

        static final class OfInt<P_IN>
        extends SizedCollectorTask<P_IN, Integer, Sink.OfInt, OfInt<P_IN>>
        implements Sink.OfInt {
            private final int[] array;

            OfInt(Spliterator<P_IN> spliterator, PipelineHelper<Integer> pipelineHelper, int[] nArray) {
                int n = nArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;I)V");
                super(spliterator, pipelineHelper, n);
                this.array = nArray;
            }

            OfInt(OfInt<P_IN> ofInt, Spliterator<P_IN> spliterator, long l, long l2) {
                int n = ofInt.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask;Ljava/util/Spliterator;JJI)V");
                super(ofInt, spliterator, l, l2, n);
                this.array = ofInt.array;
            }

            @Override
            OfInt<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfInt");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfInt.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask$OfInt;Ljava/util/Spliterator;JJ)V");
                return new OfInt<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(int n) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= this.fence) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                    String string = Integer.toString(this.index);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                this.array[this.index++] = n;
            }
        }

        static final class OfRef<P_IN, P_OUT>
        extends SizedCollectorTask<P_IN, P_OUT, Sink<P_OUT>, OfRef<P_IN, P_OUT>>
        implements Sink<P_OUT> {
            private final P_OUT[] array;

            OfRef(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> pipelineHelper, P_OUT[] P_OUTArray) {
                int n = P_OUTArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/Spliterator;Ljava/util/stream/PipelineHelper;I)V");
                super(spliterator, pipelineHelper, n);
                this.array = P_OUTArray;
            }

            OfRef(OfRef<P_IN, P_OUT> ofRef, Spliterator<P_IN> spliterator, long l, long l2) {
                int n = ofRef.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask;Ljava/util/Spliterator;JJI)V");
                super(ofRef, spliterator, l, l2, n);
                this.array = ofRef.array;
            }

            @Override
            OfRef<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$SizedCollectorTask$OfRef");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SizedCollectorTask$OfRef.<init>:(Ljava/util/stream/Nodes$SizedCollectorTask$OfRef;Ljava/util/Spliterator;JJ)V");
                return new OfRef<P_IN, P_OUT>(this, spliterator, l, l2);
            }

            @Override
            public void accept(P_OUT P_OUT) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= this.fence) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                    String string = Integer.toString(this.index);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                this.array[this.index++] = P_OUT;
            }
        }
    }

    private static final class DoubleSpinedNodeBuilder
    extends SpinedBuffer.OfDouble
    implements Node.OfDouble,
    Node.Builder.OfDouble {
        private boolean building;
        static final /* synthetic */ boolean $assertionsDisabled;

        DoubleSpinedNodeBuilder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.<init>:()V");
            this.building = false;
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.spliterator:()Ljava/util/Spliterator$OfDouble;");
            return super.spliterator();
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.forEach:(Ljava/lang/Object;)V");
            super.forEach(doubleConsumer);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was already building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleSpinedNodeBuilder.clear:()V");
            this.clear();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleSpinedNodeBuilder.ensureCapacity:(J)V");
            this.ensureCapacity(l);
        }

        @Override
        public void accept(double d) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.accept:(D)V");
            super.accept(d);
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = false;
        }

        @Override
        public void copyInto(double[] dArray, int n) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.copyInto:(Ljava/lang/Object;I)V");
            super.copyInto(dArray, n);
        }

        @Override
        public double[] asPrimitiveArray() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.asPrimitiveArray:()Ljava/lang/Object;");
            return (double[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfDouble build() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            return this;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class LongSpinedNodeBuilder
    extends SpinedBuffer.OfLong
    implements Node.OfLong,
    Node.Builder.OfLong {
        private boolean building;
        static final /* synthetic */ boolean $assertionsDisabled;

        LongSpinedNodeBuilder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.<init>:()V");
            this.building = false;
        }

        @Override
        public Spliterator.OfLong spliterator() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.spliterator:()Ljava/util/Spliterator$OfLong;");
            return super.spliterator();
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.forEach:(Ljava/lang/Object;)V");
            super.forEach(longConsumer);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was already building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongSpinedNodeBuilder.clear:()V");
            this.clear();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongSpinedNodeBuilder.ensureCapacity:(J)V");
            this.ensureCapacity(l);
        }

        @Override
        public void accept(long l) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.accept:(J)V");
            super.accept(l);
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = false;
        }

        @Override
        public void copyInto(long[] lArray, int n) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.copyInto:(Ljava/lang/Object;I)V");
            super.copyInto(lArray, n);
        }

        @Override
        public long[] asPrimitiveArray() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.asPrimitiveArray:()Ljava/lang/Object;");
            return (long[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfLong build() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            return this;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class IntSpinedNodeBuilder
    extends SpinedBuffer.OfInt
    implements Node.OfInt,
    Node.Builder.OfInt {
        private boolean building;
        static final /* synthetic */ boolean $assertionsDisabled;

        IntSpinedNodeBuilder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.<init>:()V");
            this.building = false;
        }

        @Override
        public Spliterator.OfInt spliterator() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.spliterator:()Ljava/util/Spliterator$OfInt;");
            return super.spliterator();
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.forEach:(Ljava/lang/Object;)V");
            super.forEach(intConsumer);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was already building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntSpinedNodeBuilder.clear:()V");
            this.clear();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntSpinedNodeBuilder.ensureCapacity:(J)V");
            this.ensureCapacity(l);
        }

        @Override
        public void accept(int n) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.accept:(I)V");
            super.accept(n);
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = false;
        }

        @Override
        public void copyInto(int[] nArray, int n) throws IndexOutOfBoundsException {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.copyInto:(Ljava/lang/Object;I)V");
            super.copyInto(nArray, n);
        }

        @Override
        public int[] asPrimitiveArray() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.asPrimitiveArray:()Ljava/lang/Object;");
            return (int[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfInt build() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            return this;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class DoubleFixedNodeBuilder
    extends DoubleArrayNode
    implements Node.Builder.OfDouble {
        static final /* synthetic */ boolean $assertionsDisabled;

        DoubleFixedNodeBuilder(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$DoubleArrayNode.<init>:(J)V");
            super(l);
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
        }

        @Override
        public Node.OfDouble build() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Current size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            return this;
        }

        @Override
        public void begin(long l) {
            long l2 = l - (long)this.array.length;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[0] = l;
                int n = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Begin size %d is not equal to fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.curSize = 0;
        }

        @Override
        public void accept(double d) {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize >= n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[1];
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Accept exceeded fixed size of %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.array[this.curSize++] = d;
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void end() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("End size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([D)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("DoubleFixedNodeBuilder[%d][%s]", objectArray);
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class LongFixedNodeBuilder
    extends LongArrayNode
    implements Node.Builder.OfLong {
        static final /* synthetic */ boolean $assertionsDisabled;

        LongFixedNodeBuilder(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$LongArrayNode.<init>:(J)V");
            super(l);
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
        }

        @Override
        public Node.OfLong build() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Current size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            return this;
        }

        @Override
        public void begin(long l) {
            long l2 = l - (long)this.array.length;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[0] = l;
                int n = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Begin size %d is not equal to fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.curSize = 0;
        }

        @Override
        public void accept(long l) {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize >= n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[1];
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Accept exceeded fixed size of %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.array[this.curSize++] = l;
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void end() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("End size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([J)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("LongFixedNodeBuilder[%d][%s]", objectArray);
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class IntFixedNodeBuilder
    extends IntArrayNode
    implements Node.Builder.OfInt {
        static final /* synthetic */ boolean $assertionsDisabled;

        IntFixedNodeBuilder(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$IntArrayNode.<init>:(J)V");
            super(l);
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
        }

        @Override
        public Node.OfInt build() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Current size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            return this;
        }

        @Override
        public void begin(long l) {
            long l2 = l - (long)this.array.length;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[0] = l;
                int n = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Begin size %d is not equal to fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.curSize = 0;
        }

        @Override
        public void accept(int n) {
            int n2 = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize >= n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[1];
                int n3 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Accept exceeded fixed size of %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.array[this.curSize++] = n;
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void end() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("End size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([I)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("IntFixedNodeBuilder[%d][%s]", objectArray);
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static class DoubleArrayNode
    implements Node.OfDouble {
        final double[] array;
        int curSize;

        DoubleArrayNode(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.array = new double[n];
            this.curSize = 0;
        }

        DoubleArrayNode(double[] dArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = dArray;
            this.curSize = dArray.length;
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([DII)Ljava/util/Spliterator$OfDouble;");
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public double[] asPrimitiveArray() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (n == this.curSize) {
                return this.array;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([DI)[D");
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(double[] dArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.array, 0, dArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.curSize) break;
                double d = this.array[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }

        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([D)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("DoubleArrayNode[%d][%s]", objectArray);
        }
    }

    private static class LongArrayNode
    implements Node.OfLong {
        final long[] array;
        int curSize;

        LongArrayNode(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.array = new long[n];
            this.curSize = 0;
        }

        LongArrayNode(long[] lArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = lArray;
            this.curSize = lArray.length;
        }

        @Override
        public Spliterator.OfLong spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([JII)Ljava/util/Spliterator$OfLong;");
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public long[] asPrimitiveArray() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (n == this.curSize) {
                return this.array;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(long[] lArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.array, 0, lArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.curSize) break;
                long l = this.array[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }

        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([J)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("LongArrayNode[%d][%s]", objectArray);
        }
    }

    private static class IntArrayNode
    implements Node.OfInt {
        final int[] array;
        int curSize;

        IntArrayNode(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
            this.array = new int[n];
            this.curSize = 0;
        }

        IntArrayNode(int[] nArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = nArray;
            this.curSize = nArray.length;
        }

        @Override
        public Spliterator.OfInt spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([III)Ljava/util/Spliterator$OfInt;");
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public int[] asPrimitiveArray() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (n == this.curSize) {
                return this.array;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(int[] nArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.array, 0, nArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.curSize) break;
                int n2 = this.array[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n2);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }

        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([I)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("IntArrayNode[%d][%s]", objectArray);
        }
    }

    private static final class SpinedNodeBuilder<T>
    extends SpinedBuffer<T>
    implements Node<T>,
    Node.Builder<T> {
        private boolean building;
        static final /* synthetic */ boolean $assertionsDisabled;

        SpinedNodeBuilder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.<init>:()V");
            this.building = false;
        }

        @Override
        public Spliterator<T> spliterator() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.spliterator:()Ljava/util/Spliterator;");
            return super.spliterator();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.forEach:(Ljava/util/function/Consumer;)V");
            super.forEach(consumer);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was already building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SpinedNodeBuilder.clear:()V");
            this.clear();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$SpinedNodeBuilder.ensureCapacity:(J)V");
            this.ensureCapacity(l);
        }

        @Override
        public void accept(T t) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.accept:(Ljava/lang/Object;)V");
            super.accept(t);
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (!this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"was not building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.building = false;
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.copyInto:([Ljava/lang/Object;I)V");
            super.copyInto(TArray, n);
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.asArray:(Ljava/util/function/IntFunction;)[Ljava/lang/Object;");
            return super.asArray(intFunction);
        }

        @Override
        public Node<T> build() {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (this.building) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                    AssertionError assertionError = new AssertionError((Object)"during building");
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            return this;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static final class FixedNodeBuilder<T>
    extends ArrayNode<T>
    implements Node.Builder<T> {
        static final /* synthetic */ boolean $assertionsDisabled;

        FixedNodeBuilder(long l, IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ArrayNode.<init>:(JLjava/util/function/IntFunction;)V");
            super(l, intFunction);
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
        }

        @Override
        public Node<T> build() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Current size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            return this;
        }

        @Override
        public void begin(long l) {
            long l2 = l - (long)this.array.length;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[0] = l;
                int n = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Begin size %d is not equal to fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.curSize = 0;
        }

        @Override
        public void accept(T t) {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize >= n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[1];
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("Accept exceeded fixed size of %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.array[this.curSize++] = t;
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void end() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.curSize < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[0] = this.curSize;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                String string = String.format("End size %d is less than fixed size %d", objectArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([Ljava/lang/Object;)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("FixedNodeBuilder[%d][%s]", objectArray);
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Nodes.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static abstract class InternalNodeSpliterator<T, S extends Spliterator<T>, N extends Node<T>>
    implements Spliterator<T> {
        N curNode;
        int curChildIndex;
        S lastNodeSpliterator;
        S tryAdvanceSpliterator;
        Deque<N> tryAdvanceStack;

        InternalNodeSpliterator(N n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.curNode = n;
        }

        protected final Deque<N> initStack() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.<init>:(I)V");
            ArrayDeque arrayDeque = new ArrayDeque(8);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
            int n = this.curNode.getChildCount() - 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n < this.curChildIndex) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
                Node node = this.curNode.getChild(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.addFirst:(Ljava/lang/Object;)V");
                arrayDeque.addFirst(node);
                --n;
                RuntimeCostAccounter.recordJump();
            }
            return arrayDeque;
        }

        protected final N findNextLeafNode(Deque<N> deque) {
            Node node = null;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.pollFirst:()Ljava/lang/Object;");
                node = (Node)deque.pollFirst();
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                int n = node.getChildCount();
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
                    long l = node.count() - 0L;
                    long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l2 <= 0) continue;
                    return (N)node;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                int n2 = node.getChildCount() - 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
                    Node node2 = node.getChild(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.addFirst:(Ljava/lang/Object;)V");
                    deque.addFirst(node2);
                    --n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            }
            return null;
        }

        protected final boolean initTryAdvance() {
            RuntimeCostAccounter.recordJump();
            if (this.curNode == null) {
                return false;
            }
            RuntimeCostAccounter.recordJump();
            if (this.tryAdvanceSpliterator == null) {
                RuntimeCostAccounter.recordJump();
                if (this.lastNodeSpliterator == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator.initStack:()Ljava/util/Deque;");
                    this.tryAdvanceStack = this.initStack();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator.findNextLeafNode:(Ljava/util/Deque;)Ljava/util/stream/Node;");
                    N n = this.findNextLeafNode(this.tryAdvanceStack);
                    RuntimeCostAccounter.recordJump();
                    if (n == null) {
                        this.curNode = null;
                        return false;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
                    this.tryAdvanceSpliterator = n.spliterator();
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.tryAdvanceSpliterator = this.lastNodeSpliterator;
                }
            }
            return true;
        }

        public final S trySplit() {
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (this.curNode == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (this.tryAdvanceSpliterator == null) break block7;
                }
                return null;
            }
            RuntimeCostAccounter.recordJump();
            if (this.lastNodeSpliterator != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                return (S)this.lastNodeSpliterator.trySplit();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
            int n = this.curNode.getChildCount() - 1;
            RuntimeCostAccounter.recordJump();
            if (this.curChildIndex < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
                Node node = this.curNode.getChild(this.curChildIndex++);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
                return (S)node.spliterator();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
            this.curNode = this.curNode.getChild(this.curChildIndex);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
            int n2 = this.curNode.getChildCount();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
                this.lastNodeSpliterator = this.curNode.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                return (S)this.lastNodeSpliterator.trySplit();
            }
            this.curChildIndex = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
            Node node = this.curNode.getChild(this.curChildIndex++);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
            return (S)node.spliterator();
        }

        @Override
        public final long estimateSize() {
            RuntimeCostAccounter.recordJump();
            if (this.curNode == null) {
                return 0L;
            }
            RuntimeCostAccounter.recordJump();
            if (this.lastNodeSpliterator != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                return this.lastNodeSpliterator.estimateSize();
            }
            long l = 0L;
            int n = this.curChildIndex;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChildCount:()I");
                int n2 = this.curNode.getChildCount();
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.getChild:(I)Ljava/util/stream/Node;");
                Node node = this.curNode.getChild(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
                l += node.count();
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            return l;
        }

        @Override
        public final int characteristics() {
            return 64;
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Node.OfDouble ofDouble) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofDouble);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Spliterator.OfLong {
            OfLong(Node.OfLong ofLong) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofLong);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Spliterator.OfInt {
            OfInt(Node.OfInt ofInt) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofInt);
            }
        }

        private static abstract class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, N extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, N>>
        extends InternalNodeSpliterator<T, T_SPLITR, N>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(N n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator.<init>:(Ljava/util/stream/Node;)V");
                super(n);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.initTryAdvance:()Z");
                boolean bl = this.initTryAdvance();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Spliterator.OfPrimitive ofPrimitive = (Spliterator.OfPrimitive)this.tryAdvanceSpliterator;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfPrimitive.tryAdvance:(Ljava/lang/Object;)Z");
                boolean bl2 = ofPrimitive.tryAdvance(T_CONS);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastNodeSpliterator == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.findNextLeafNode:(Ljava/util/Deque;)Ljava/util/stream/Node;");
                        Node.OfPrimitive ofPrimitive2 = (Node.OfPrimitive)this.findNextLeafNode(this.tryAdvanceStack);
                        RuntimeCostAccounter.recordJump();
                        if (ofPrimitive2 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.spliterator:()Ljava/util/Spliterator$OfPrimitive;");
                            this.tryAdvanceSpliterator = ofPrimitive2.spliterator();
                            Spliterator.OfPrimitive ofPrimitive3 = (Spliterator.OfPrimitive)this.tryAdvanceSpliterator;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfPrimitive.tryAdvance:(Ljava/lang/Object;)Z");
                            return ofPrimitive3.tryAdvance(T_CONS);
                        }
                    }
                    this.curNode = null;
                }
                return bl2;
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                RuntimeCostAccounter.recordJump();
                if (this.curNode == null) {
                    return;
                }
                RuntimeCostAccounter.recordJump();
                if (this.tryAdvanceSpliterator == null) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastNodeSpliterator == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.initStack:()Ljava/util/Deque;");
                        Deque deque = this.initStack();
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.findNextLeafNode:(Ljava/util/Deque;)Ljava/util/stream/Node;");
                            Node.OfPrimitive ofPrimitive = (Node.OfPrimitive)this.findNextLeafNode(deque);
                            RuntimeCostAccounter.recordJump();
                            if (ofPrimitive == null) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.forEach:(Ljava/lang/Object;)V");
                            ofPrimitive.forEach(T_CONS);
                            RuntimeCostAccounter.recordJump();
                        }
                        this.curNode = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        Spliterator.OfPrimitive ofPrimitive = (Spliterator.OfPrimitive)this.lastNodeSpliterator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfPrimitive.forEachRemaining:(Ljava/lang/Object;)V");
                        ofPrimitive.forEachRemaining(T_CONS);
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfPrimitive.tryAdvance:(Ljava/lang/Object;)Z");
                        boolean bl = this.tryAdvance(T_CONS);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }

        private static final class OfRef<T>
        extends InternalNodeSpliterator<T, Spliterator<T>, Node<T>> {
            OfRef(Node<T> node) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator.<init>:(Ljava/util/stream/Node;)V");
                super(node);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.initTryAdvance:()Z");
                boolean bl = this.initTryAdvance();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                boolean bl2 = this.tryAdvanceSpliterator.tryAdvance(consumer);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastNodeSpliterator == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.findNextLeafNode:(Ljava/util/Deque;)Ljava/util/stream/Node;");
                        Object n = this.findNextLeafNode(this.tryAdvanceStack);
                        RuntimeCostAccounter.recordJump();
                        if (n != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
                            this.tryAdvanceSpliterator = n.spliterator();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                            return this.tryAdvanceSpliterator.tryAdvance(consumer);
                        }
                    }
                    this.curNode = null;
                }
                return bl2;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                RuntimeCostAccounter.recordJump();
                if (this.curNode == null) {
                    return;
                }
                RuntimeCostAccounter.recordJump();
                if (this.tryAdvanceSpliterator == null) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastNodeSpliterator == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.initStack:()Ljava/util/Deque;");
                        Deque deque = this.initStack();
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.findNextLeafNode:(Ljava/util/Deque;)Ljava/util/stream/Node;");
                            Object n = this.findNextLeafNode(deque);
                            RuntimeCostAccounter.recordJump();
                            if (n == null) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.forEach:(Ljava/util/function/Consumer;)V");
                            n.forEach(consumer);
                            RuntimeCostAccounter.recordJump();
                        }
                        this.curNode = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
                        this.lastNodeSpliterator.forEachRemaining(consumer);
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.tryAdvance:(Ljava/util/function/Consumer;)Z");
                        boolean bl = this.tryAdvance(consumer);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
    }

    static final class ConcNode<T>
    extends AbstractConcNode<T, Node<T>>
    implements Node<T> {
        ConcNode(Node<T> node, Node<T> node2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$AbstractConcNode.<init>:(Ljava/util/stream/Node;Ljava/util/stream/Node;)V");
            super(node, node2);
        }

        @Override
        public Spliterator<T> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfRef.<init>:(Ljava/util/stream/Node;)V");
            return new InternalNodeSpliterator.OfRef(this);
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(TArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.copyInto:([Ljava/lang/Object;I)V");
            this.left.copyInto(TArray, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
            int n2 = n + (int)this.left.count();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.copyInto:([Ljava/lang/Object;I)V");
            this.right.copyInto(TArray, n2);
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.count:()J");
            long l = this.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
            T[] TArray = intFunction.apply(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.copyInto:([Ljava/lang/Object;I)V");
            this.copyInto(TArray, 0);
            return TArray;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.forEach:(Ljava/util/function/Consumer;)V");
            this.left.forEach(consumer);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.forEach:(Ljava/util/function/Consumer;)V");
            this.right.forEach(consumer);
        }

        @Override
        public Node<T> truncate(long l, long l2, IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordJump();
            if (l == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.count:()J");
                long l3 = l2 - this.count();
                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l4 == false) {
                    return this;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
            long l5 = this.left.count();
            RuntimeCostAccounter.recordJump();
            if (l >= l5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.truncate:(JJLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                return this.right.truncate(l - l5, l2 - l5, intFunction);
            }
            RuntimeCostAccounter.recordJump();
            if (l2 <= l5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.truncate:(JJLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                return this.left.truncate(l, l2, intFunction);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.getShape:()Ljava/util/stream/StreamShape;");
            StreamShape streamShape = this.getShape();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.truncate:(JJLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node node = this.left.truncate(l, l5, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.truncate:(JJLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node node2 = this.right.truncate(0L, l2 - l5, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.conc:(Ljava/util/stream/StreamShape;Ljava/util/stream/Node;Ljava/util/stream/Node;)Ljava/util/stream/Node;");
            return Nodes.conc(streamShape, node, node2);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.count:()J");
            long l = this.count() - 32L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 < 0) {
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[]{this.left, this.right};
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                return String.format("ConcNode[%s.%s]", objectArray);
            }
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode.count:()J");
            long l3 = this.count();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            objectArray[0] = l3;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("ConcNode[size=%d]", objectArray);
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Node.OfDouble {
            OfDouble(Node.OfDouble ofDouble, Node.OfDouble ofDouble2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofDouble, ofDouble2);
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfDouble");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfDouble.<init>:(Ljava/util/stream/Node$OfDouble;)V");
                return new InternalNodeSpliterator.OfDouble(this);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Node.OfLong {
            OfLong(Node.OfLong ofLong, Node.OfLong ofLong2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofLong, ofLong2);
            }

            @Override
            public Spliterator.OfLong spliterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfLong");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfLong.<init>:(Ljava/util/stream/Node$OfLong;)V");
                return new InternalNodeSpliterator.OfLong(this);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Node.OfInt {
            OfInt(Node.OfInt ofInt, Node.OfInt ofInt2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.<init>:(Ljava/util/stream/Node$OfPrimitive;Ljava/util/stream/Node$OfPrimitive;)V");
                super(ofInt, ofInt2);
            }

            @Override
            public Spliterator.OfInt spliterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfInt");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$InternalNodeSpliterator$OfInt.<init>:(Ljava/util/stream/Node$OfInt;)V");
                return new InternalNodeSpliterator.OfInt(this);
            }
        }

        private static abstract class OfPrimitive<E, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<E, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends AbstractConcNode<E, T_NODE>
        implements Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE> {
            OfPrimitive(T_NODE T_NODE, T_NODE T_NODE2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$AbstractConcNode.<init>:(Ljava/util/stream/Node;Ljava/util/stream/Node;)V");
                super(T_NODE, T_NODE2);
            }

            @Override
            public void forEach(T_CONS T_CONS) {
                Node.OfPrimitive ofPrimitive = (Node.OfPrimitive)this.left;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.forEach:(Ljava/lang/Object;)V");
                ofPrimitive.forEach(T_CONS);
                Node.OfPrimitive ofPrimitive2 = (Node.OfPrimitive)this.right;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.forEach:(Ljava/lang/Object;)V");
                ofPrimitive2.forEach(T_CONS);
            }

            @Override
            public void copyInto(T_ARR T_ARR, int n) {
                Node.OfPrimitive ofPrimitive = (Node.OfPrimitive)this.left;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.copyInto:(Ljava/lang/Object;I)V");
                ofPrimitive.copyInto(T_ARR, n);
                Node.OfPrimitive ofPrimitive2 = (Node.OfPrimitive)this.right;
                Node.OfPrimitive ofPrimitive3 = (Node.OfPrimitive)this.left;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.count:()J");
                int n2 = n + (int)ofPrimitive3.count();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfPrimitive.copyInto:(Ljava/lang/Object;I)V");
                ofPrimitive2.copyInto(T_ARR, n2);
            }

            @Override
            public T_ARR asPrimitiveArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.count:()J");
                long l = this.count();
                RuntimeCostAccounter.recordJump();
                if (l >= 0x7FFFFFF7L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.newArray:(I)Ljava/lang/Object;");
                Object T_ARR = this.newArray(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.copyInto:(Ljava/lang/Object;I)V");
                this.copyInto(T_ARR, 0);
                return T_ARR;
            }

            public String toString() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.count:()J");
                long l = this.count() - 32L;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 < 0) {
                    RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
                    Object[] objectArray = new Object[3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                    objectArray[0] = clazz.getName();
                    objectArray[1] = this.left;
                    objectArray[2] = this.right;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                    return String.format("%s[%s.%s]", objectArray);
                }
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                Object[] objectArray = new Object[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                objectArray[0] = clazz.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$ConcNode$OfPrimitive.count:()J");
                long l3 = this.count();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                objectArray[1] = l3;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                return String.format("%s[size=%d]", objectArray);
            }
        }
    }

    private static abstract class AbstractConcNode<T, T_NODE extends Node<T>>
    implements Node<T> {
        protected final T_NODE left;
        protected final T_NODE right;
        private final long size;

        AbstractConcNode(T_NODE T_NODE, T_NODE T_NODE2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.left = T_NODE;
            this.right = T_NODE2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
            long l = T_NODE.count();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.count:()J");
            this.size = l + T_NODE2.count();
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        public T_NODE getChild(int n) {
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                return this.left;
            }
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                return this.right;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }

        @Override
        public long count() {
            return this.size;
        }
    }

    private static final class CollectionNode<T>
    implements Node<T> {
        private final Collection<T> c;

        CollectionNode(Collection<T> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.c = collection;
        }

        @Override
        public Spliterator<T> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.stream:()Ljava/util/stream/Stream;");
            Stream<T> stream = this.c.stream();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.spliterator:()Ljava/util/Spliterator;");
            return stream.spliterator();
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<T> iterator = this.c.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                T t = iterator.next();
                TArray[n++] = t;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            int n = this.c.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.c.toArray(intFunction.apply(n));
        }

        @Override
        public long count() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            return this.c.size();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.forEach:(Ljava/util/function/Consumer;)V");
            this.c.forEach(consumer);
        }

        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            int n = this.c.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            objectArray[1] = this.c;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("CollectionNode[%d][%s]", objectArray);
        }
    }

    private static class ArrayNode<T>
    implements Node<T> {
        final T[] array;
        int curSize;

        ArrayNode(long l, IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Nodes.BAD_SIZE);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
            this.array = intFunction.apply(n);
            this.curSize = 0;
        }

        ArrayNode(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = TArray;
            this.curSize = TArray.length;
        }

        @Override
        public Spliterator<T> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([Ljava/lang/Object;II)Ljava/util/Spliterator;");
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.array, 0, TArray, n, this.curSize);
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (n == this.curSize) {
                return this.array;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.curSize) break;
                T t = this.array[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(t);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }

        public String toString() {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            Object[] objectArray = new Object[2];
            int n = this.array.length - this.curSize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([Ljava/lang/Object;)Ljava/lang/String;");
            objectArray[1] = Arrays.toString(this.array);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("ArrayNode[%d][%s]", objectArray);
        }
    }

    private static abstract class EmptyNode<T, T_ARR, T_CONS>
    implements Node<T> {
        EmptyNode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
            return intFunction.apply(0);
        }

        public void copyInto(T_ARR T_ARR, int n) {
        }

        @Override
        public long count() {
            return 0L;
        }

        public void forEach(T_CONS T_CONS) {
        }

        private static final class OfDouble
        extends EmptyNode<Double, double[], DoubleConsumer>
        implements Node.OfDouble {
            OfDouble() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode.<init>:()V");
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyDoubleSpliterator:()Ljava/util/Spliterator$OfDouble;");
                return Spliterators.emptyDoubleSpliterator();
            }

            @Override
            public double[] asPrimitiveArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.access$700:()[D");
                return EMPTY_DOUBLE_ARRAY;
            }
        }

        private static final class OfLong
        extends EmptyNode<Long, long[], LongConsumer>
        implements Node.OfLong {
            OfLong() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode.<init>:()V");
            }

            @Override
            public Spliterator.OfLong spliterator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyLongSpliterator:()Ljava/util/Spliterator$OfLong;");
                return Spliterators.emptyLongSpliterator();
            }

            @Override
            public long[] asPrimitiveArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.access$600:()[J");
                return EMPTY_LONG_ARRAY;
            }
        }

        private static final class OfInt
        extends EmptyNode<Integer, int[], IntConsumer>
        implements Node.OfInt {
            OfInt() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode.<init>:()V");
            }

            @Override
            public Spliterator.OfInt spliterator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyIntSpliterator:()Ljava/util/Spliterator$OfInt;");
                return Spliterators.emptyIntSpliterator();
            }

            @Override
            public int[] asPrimitiveArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.access$500:()[I");
                return EMPTY_INT_ARRAY;
            }
        }

        private static class OfRef<T>
        extends EmptyNode<T, T[], Consumer<? super T>> {
            private OfRef() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode.<init>:()V");
            }

            @Override
            public Spliterator<T> spliterator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptySpliterator:()Ljava/util/Spliterator;");
                return Spliterators.emptySpliterator();
            }

            /* synthetic */ OfRef(1 var1_1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes$EmptyNode$OfRef.<init>:()V");
                this();
            }
        }
    }
}

