/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.PriorityQueue;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.Delayed;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;

public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock;
    private final PriorityQueue<E> q;
    private Thread leader;
    private final Condition available;

    public DelayQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.lock = new ReentrantLock();
        RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:()V");
        this.q = new PriorityQueue();
        this.leader = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.available = this.lock.newCondition();
    }

    public DelayQueue(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.lock = new ReentrantLock();
        RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:()V");
        this.q = new PriorityQueue();
        this.leader = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.available = this.lock.newCondition();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.addAll:(Ljava/util/Collection;)Z");
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.offer:(Ljava/util/concurrent/Delayed;)Z");
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.offer:(Ljava/lang/Object;)Z");
            this.q.offer(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
            E e2 = this.q.peek();
            RuntimeCostAccounter.recordJump();
            if (e2 == e) {
                this.leader = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.available.signal();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    @Override
    public void put(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.offer:(Ljava/util/concurrent/Delayed;)Z");
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.offer:(Ljava/util/concurrent/Delayed;)Z");
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock;
        block4: {
            E e;
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                Delayed delayed = (Delayed)this.q.peek();
                RuntimeCostAccounter.recordJump();
                if (delayed != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                    long l = delayed.getDelay(TimeUnit.NANOSECONDS) - 0L;
                    long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l2 <= 0) break block4;
                }
                e = null;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return e;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.poll:()Ljava/lang/Object;");
        Delayed delayed = (Delayed)this.q.poll();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E take() throws InterruptedException {
        var1_1 = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        var1_1.lockInterruptibly();
        while (true) {
            block15: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                var2_2 = (Delayed)this.q.peek();
                RuntimeCostAccounter.recordJump();
                if (var2_2 != null) break block15;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.available.await();
                RuntimeCostAccounter.recordJump();
                ** GOTO lbl71
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
            var3_3 = var2_2.getDelay(TimeUnit.NANOSECONDS);
            RuntimeCostAccounter.recordJump();
            if (var3_3 > 0L) break block14;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.poll:()Ljava/lang/Object;");
            var5_4 = (Delayed)this.q.poll();
            break;
        }
        catch (Throwable var7_6) {
            RuntimeCostAccounter.recordJump();
            if (this.leader == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                v0 = this.q.peek();
                RuntimeCostAccounter.recordJump();
                if (v0 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.available.signal();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            var1_1.unlock();
            RuntimeCostAccounter.recordThrow();
            throw var7_6;
        }
        {
            block16: {
                block14: {
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                        v1 = this.q.peek();
                        RuntimeCostAccounter.recordJump();
                        if (v1 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                            this.available.signal();
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    var1_1.unlock();
                    return (E)var5_4;
                }
                var2_2 = null;
                RuntimeCostAccounter.recordJump();
                if (this.leader != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                    this.available.await();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    this.leader = var5_4 = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                    this.available.awaitNanos(var3_3);
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == var5_4) {
                        this.leader = null;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                break block16;
                catch (Throwable var6_5) {
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == var5_4) {
                        this.leader = null;
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw var6_5;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        var6_4.lockInterruptibly();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
            var7_5 = (Delayed)this.q.peek();
            RuntimeCostAccounter.recordJump();
            if (var7_5 != null) ** GOTO lbl45
            RuntimeCostAccounter.recordJump();
            if (var4_3 > 0L) break block20;
            var8_9 = null;
            break;
        }
        catch (Throwable var15_11) {
            RuntimeCostAccounter.recordJump();
            if (this.leader == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                v0 = this.q.peek();
                RuntimeCostAccounter.recordJump();
                if (v0 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.available.signal();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            var6_4.unlock();
            RuntimeCostAccounter.recordThrow();
            throw var15_11;
        }
        {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            RuntimeCostAccounter.recordJump();
                            if (this.leader == null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                                v1 = this.q.peek();
                                RuntimeCostAccounter.recordJump();
                                if (v1 != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                    this.available.signal();
                                }
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                            var6_4.unlock();
                            return var8_9;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                        var4_3 = this.available.awaitNanos(var4_3);
                        RuntimeCostAccounter.recordJump();
                        ** GOTO lbl106
lbl45:
                        // 1 sources

                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                        var9_6 = var7_5.getDelay(TimeUnit.NANOSECONDS);
                        RuntimeCostAccounter.recordJump();
                        if (var9_6 > 0L) break block21;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.poll:()Ljava/lang/Object;");
                        var11_7 = (Delayed)this.q.poll();
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                            v2 = this.q.peek();
                            RuntimeCostAccounter.recordJump();
                            if (v2 != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                this.available.signal();
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                        var6_4.unlock();
                        return (E)var11_7;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var4_3 > 0L) break block22;
                    var11_7 = null;
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
                        v3 = this.q.peek();
                        RuntimeCostAccounter.recordJump();
                        if (v3 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                            this.available.signal();
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    var6_4.unlock();
                    return (E)var11_7;
                }
                var7_5 = null;
                RuntimeCostAccounter.recordJump();
                if (var4_3 < var9_6) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (this.leader != null) lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                    var4_3 = this.available.awaitNanos(var4_3);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    this.leader = var11_7 = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                    var12_8 = this.available.awaitNanos(var9_6);
                    var4_3 -= var9_6 - var12_8;
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == var11_7) {
                        this.leader = null;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                break block23;
                catch (Throwable var14_10) {
                    RuntimeCostAccounter.recordJump();
                    if (this.leader == var11_7) {
                        this.leader = null;
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw var14_10;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    @Override
    public E peek() {
        Delayed delayed;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
            delayed = (Delayed)this.q.peek();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return (E)delayed;
    }

    @Override
    public int size() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.size:()I");
            n = this.q.size();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private E peekExpired() {
        Delayed delayed;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.peek:()Ljava/lang/Object;");
        Delayed delayed2 = (Delayed)this.q.peek();
        RuntimeCostAccounter.recordJump();
        if (delayed2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
            long l = delayed2.getDelay(TimeUnit.NANOSECONDS) - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 <= 0) {
                delayed = delayed2;
                return (E)delayed;
            }
        }
        delayed = null;
        RuntimeCostAccounter.recordJump();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        int n;
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.peekExpired:()Ljava/util/concurrent/Delayed;");
                E e = this.peekExpired();
                RuntimeCostAccounter.recordJump();
                if (e == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.poll:()Ljava/lang/Object;");
                this.q.poll();
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            n = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.peekExpired:()Ljava/util/concurrent/Delayed;");
                E e = this.peekExpired();
                RuntimeCostAccounter.recordJump();
                if (e == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.poll:()Ljava/lang/Object;");
                this.q.poll();
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            n2 = n3;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n2;
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.clear:()V");
            this.q.clear();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.toArray:()[Ljava/lang/Object;");
            objectArray = this.q.toArray();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            TArray2 = this.q.toArray(TArray);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return TArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.remove:(Ljava/lang/Object;)Z");
            bl = this.q.remove(object);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEQ(Object object) {
        ReentrantLock reentrantLock;
        block3: {
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                E e;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.iterator:()Ljava/util/Iterator;");
                Iterator<E> iterator = this.q.iterator();
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    e = iterator.next();
                    RuntimeCostAccounter.recordJump();
                } while (object != e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                iterator.remove();
                RuntimeCostAccounter.recordJump();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/DelayQueue$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.toArray:()[Ljava/lang/Object;");
        Object[] objectArray = this.toArray();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue$Itr.<init>:(Ljava/util/concurrent/DelayQueue;[Ljava/lang/Object;)V");
        return new Itr(objectArray);
    }

    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet;

        Itr(Object[] objectArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.lastRet = -1;
            this.array = objectArray;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.cursor < n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.cursor >= n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            Object object = this.array[this.lastRet];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/DelayQueue.removeEQ:(Ljava/lang/Object;)V");
            DelayQueue.this.removeEQ(object);
            this.lastRet = -1;
        }
    }
}

