/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;

public final class Spliterators {
    private static final Spliterator<Object> EMPTY_SPLITERATOR;
    private static final Spliterator.OfInt EMPTY_INT_SPLITERATOR;
    private static final Spliterator.OfLong EMPTY_LONG_SPLITERATOR;
    private static final Spliterator.OfDouble EMPTY_DOUBLE_SPLITERATOR;

    private Spliterators() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <T> Spliterator<T> emptySpliterator() {
        return EMPTY_SPLITERATOR;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return EMPTY_INT_SPLITERATOR;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return EMPTY_LONG_SPLITERATOR;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return EMPTY_DOUBLE_SPLITERATOR;
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$ArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;I)V");
        return new ArraySpliterator(Objects.requireNonNull(objectArray), n);
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        int n4 = Objects.requireNonNull(objectArray).length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.checkFromToBounds:(III)V");
        Spliterators.checkFromToBounds(n4, n, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$ArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;III)V");
        return new ArraySpliterator(objectArray, n, n2, n3);
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([II)V");
        return new IntArraySpliterator(Objects.requireNonNull(nArray), n);
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        int n4 = Objects.requireNonNull(nArray).length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.checkFromToBounds:(III)V");
        Spliterators.checkFromToBounds(n4, n, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([IIII)V");
        return new IntArraySpliterator(nArray, n, n2, n3);
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JI)V");
        return new LongArraySpliterator(Objects.requireNonNull(lArray), n);
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        int n4 = Objects.requireNonNull(lArray).length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.checkFromToBounds:(III)V");
        Spliterators.checkFromToBounds(n4, n, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JIII)V");
        return new LongArraySpliterator(lArray, n, n2, n3);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DI)V");
        return new DoubleArraySpliterator(Objects.requireNonNull(dArray), n);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        int n4 = Objects.requireNonNull(dArray).length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.checkFromToBounds:(III)V");
        Spliterators.checkFromToBounds(n4, n, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleArraySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DIII)V");
        return new DoubleArraySpliterator(dArray, n, n2, n3);
    }

    private static void checkFromToBounds(int n, int n2, int n3) {
        RuntimeCostAccounter.recordJump();
        if (n2 > n3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("origin(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(") > fence(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder6.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:(I)V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(n2);
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 > n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:(I)V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(n3);
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> collection, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IteratorSpliterator.<init>:(Ljava/util/Collection;I)V");
        return new IteratorSpliterator<T>(Objects.requireNonNull(collection), n);
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> iterator, long l, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IteratorSpliterator.<init>:(Ljava/util/Iterator;JI)V");
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), l, n);
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> iterator, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IteratorSpliterator.<init>:(Ljava/util/Iterator;I)V");
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), n);
    }

    public static Spliterator.OfInt spliterator(PrimitiveIterator.OfInt ofInt, long l, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfInt;JI)V");
        return new IntIteratorSpliterator(Objects.requireNonNull(ofInt), l, n);
    }

    public static Spliterator.OfInt spliteratorUnknownSize(PrimitiveIterator.OfInt ofInt, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfInt;I)V");
        return new IntIteratorSpliterator(Objects.requireNonNull(ofInt), n);
    }

    public static Spliterator.OfLong spliterator(PrimitiveIterator.OfLong ofLong, long l, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfLong;JI)V");
        return new LongIteratorSpliterator(Objects.requireNonNull(ofLong), l, n);
    }

    public static Spliterator.OfLong spliteratorUnknownSize(PrimitiveIterator.OfLong ofLong, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfLong;I)V");
        return new LongIteratorSpliterator(Objects.requireNonNull(ofLong), n);
    }

    public static Spliterator.OfDouble spliterator(PrimitiveIterator.OfDouble ofDouble, long l, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfDouble;JI)V");
        return new DoubleIteratorSpliterator(Objects.requireNonNull(ofDouble), l, n);
    }

    public static Spliterator.OfDouble spliteratorUnknownSize(PrimitiveIterator.OfDouble ofDouble, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleIteratorSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleIteratorSpliterator.<init>:(Ljava/util/PrimitiveIterator$OfDouble;I)V");
        return new DoubleIteratorSpliterator(Objects.requireNonNull(ofDouble), n);
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(spliterator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$1Adapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$1Adapter.<init>:(Ljava/util/Spliterator;)V");
        class Adapter
        implements Iterator<T>,
        Consumer<T> {
            boolean valueReady;
            T nextElement;
            final /* synthetic */ Spliterator val$spliterator;

            Adapter(Spliterator spliterator) {
                this.val$spliterator = spliterator;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.valueReady = false;
            }

            @Override
            public void accept(T t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public T next() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$1Adapter.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator.OfInt iterator(Spliterator.OfInt ofInt) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(ofInt);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$2Adapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$2Adapter.<init>:(Ljava/util/Spliterator$OfInt;)V");
        class Adapter
        implements PrimitiveIterator.OfInt,
        IntConsumer {
            boolean valueReady;
            int nextElement;
            final /* synthetic */ Spliterator.OfInt val$spliterator;

            Adapter(Spliterator.OfInt ofInt) {
                this.val$spliterator = ofInt;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.valueReady = false;
            }

            @Override
            public void accept(int n) {
                this.valueReady = true;
                this.nextElement = n;
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfInt.tryAdvance:(Ljava/util/function/IntConsumer;)Z");
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public int nextInt() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$2Adapter.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofInt);
    }

    public static PrimitiveIterator.OfLong iterator(Spliterator.OfLong ofLong) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(ofLong);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$3Adapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$3Adapter.<init>:(Ljava/util/Spliterator$OfLong;)V");
        class Adapter
        implements PrimitiveIterator.OfLong,
        LongConsumer {
            boolean valueReady;
            long nextElement;
            final /* synthetic */ Spliterator.OfLong val$spliterator;

            Adapter(Spliterator.OfLong ofLong) {
                this.val$spliterator = ofLong;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.valueReady = false;
            }

            @Override
            public void accept(long l) {
                this.valueReady = true;
                this.nextElement = l;
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfLong.tryAdvance:(Ljava/util/function/LongConsumer;)Z");
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public long nextLong() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$3Adapter.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofLong);
    }

    public static PrimitiveIterator.OfDouble iterator(Spliterator.OfDouble ofDouble) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(ofDouble);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$4Adapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$4Adapter.<init>:(Ljava/util/Spliterator$OfDouble;)V");
        class Adapter
        implements PrimitiveIterator.OfDouble,
        DoubleConsumer {
            boolean valueReady;
            double nextElement;
            final /* synthetic */ Spliterator.OfDouble val$spliterator;

            Adapter(Spliterator.OfDouble ofDouble) {
                this.val$spliterator = ofDouble;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.valueReady = false;
            }

            @Override
            public void accept(double d) {
                this.valueReady = true;
                this.nextElement = d;
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfDouble.tryAdvance:(Ljava/util/function/DoubleConsumer;)Z");
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public double nextDouble() {
                RuntimeCostAccounter.recordJump();
                if (!this.valueReady) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$4Adapter.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofDouble);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$EmptySpliterator$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator$OfRef.<init>:()V");
        EMPTY_SPLITERATOR = new EmptySpliterator.OfRef<Object>();
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$EmptySpliterator$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator$OfInt.<init>:()V");
        EMPTY_INT_SPLITERATOR = new EmptySpliterator.OfInt();
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$EmptySpliterator$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator$OfLong.<init>:()V");
        EMPTY_LONG_SPLITERATOR = new EmptySpliterator.OfLong();
        RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$EmptySpliterator$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator$OfDouble.<init>:()V");
        EMPTY_DOUBLE_SPLITERATOR = new EmptySpliterator.OfDouble();
    }

    static final class DoubleIteratorSpliterator
    implements Spliterator.OfDouble {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfDouble it;
        private final int characteristics;
        private long est;
        private int batch;

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble ofDouble, long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofDouble;
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x1000) == 0) {
                n2 = n | 0x40 | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble ofDouble, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofDouble;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            PrimitiveIterator.OfDouble ofDouble = this.it;
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.hasNext:()Z");
                boolean bl = ofDouble.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    double[] dArray = new double[n2];
                    int n3 = 0;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.nextDouble:()D");
                        dArray[n3] = ofDouble.nextDouble();
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.hasNext:()Z");
                        bl2 = ofDouble.hasNext();
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DIII)V");
                    return new DoubleArraySpliterator(dArray, 0, n3, this.characteristics);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.forEachRemaining:(Ljava/util/function/DoubleConsumer;)V");
            this.it.forEachRemaining(doubleConsumer);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.hasNext:()Z");
            boolean bl = this.it.hasNext();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.nextDouble:()D");
                double d = this.it.nextDouble();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleIteratorSpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static final class LongIteratorSpliterator
    implements Spliterator.OfLong {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfLong it;
        private final int characteristics;
        private long est;
        private int batch;

        public LongIteratorSpliterator(PrimitiveIterator.OfLong ofLong, long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofLong;
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x1000) == 0) {
                n2 = n | 0x40 | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        public LongIteratorSpliterator(PrimitiveIterator.OfLong ofLong, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofLong;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            PrimitiveIterator.OfLong ofLong = this.it;
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.hasNext:()Z");
                boolean bl = ofLong.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    long[] lArray = new long[n2];
                    int n3 = 0;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.nextLong:()J");
                        lArray[n3] = ofLong.nextLong();
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.hasNext:()Z");
                        bl2 = ofLong.hasNext();
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JIII)V");
                    return new LongArraySpliterator(lArray, 0, n3, this.characteristics);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.forEachRemaining:(Ljava/util/function/LongConsumer;)V");
            this.it.forEachRemaining(longConsumer);
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.hasNext:()Z");
            boolean bl = this.it.hasNext();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.nextLong:()J");
                long l = this.it.nextLong();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongIteratorSpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static final class IntIteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfInt it;
        private final int characteristics;
        private long est;
        private int batch;

        public IntIteratorSpliterator(PrimitiveIterator.OfInt ofInt, long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofInt;
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x1000) == 0) {
                n2 = n | 0x40 | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        public IntIteratorSpliterator(PrimitiveIterator.OfInt ofInt, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.it = ofInt;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            PrimitiveIterator.OfInt ofInt = this.it;
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.hasNext:()Z");
                boolean bl = ofInt.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
                    int[] nArray = new int[n2];
                    int n3 = 0;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.nextInt:()I");
                        nArray[n3] = ofInt.nextInt();
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.hasNext:()Z");
                        bl2 = ofInt.hasNext();
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([IIII)V");
                    return new IntArraySpliterator(nArray, 0, n3, this.characteristics);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.forEachRemaining:(Ljava/util/function/IntConsumer;)V");
            this.it.forEachRemaining(intConsumer);
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.hasNext:()Z");
            boolean bl = this.it.hasNext();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.nextInt:()I");
                int n = this.it.nextInt();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntIteratorSpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long est;
        private int batch;

        public IteratorSpliterator(Collection<? extends T> collection, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.collection = collection;
            this.it = null;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x1000) == 0) {
                n2 = n | 0x40 | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.collection = null;
            this.it = iterator;
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x1000) == 0) {
                n2 = n | 0x40 | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator<T> trySplit() {
            long l;
            Iterator<Object> iterator = this.it;
            RuntimeCostAccounter.recordJump();
            if (iterator == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                this.it = this.collection.iterator();
                iterator = this.it;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                l = this.est = (long)this.collection.size();
                RuntimeCostAccounter.recordJump();
            } else {
                l = this.est;
            }
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    Object[] objectArray = new Object[n2];
                    int n3 = 0;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        objectArray[n3] = iterator.next();
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        bl2 = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$ArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;III)V");
                    return new ArraySpliterator(objectArray, 0, n3, this.characteristics);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Iterator<T> iterator = this.it;
            RuntimeCostAccounter.recordJump();
            if (iterator == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                this.it = this.collection.iterator();
                iterator = this.it;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                this.est = this.collection.size();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
            iterator.forEachRemaining(consumer);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.it == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                this.it = this.collection.iterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                this.est = this.collection.size();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = this.it.hasNext();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                T t = this.it.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(t);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordJump();
            if (this.it == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                this.it = this.collection.iterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                this.est = this.collection.size();
                return this.est;
            }
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IteratorSpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    public static abstract class AbstractDoubleSpliterator
    implements Spliterator.OfDouble {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractDoubleSpliterator(long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x40) != 0) {
                n2 = n | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$AbstractDoubleSpliterator$HoldingDoubleConsumer");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractDoubleSpliterator$HoldingDoubleConsumer.<init>:()V");
            HoldingDoubleConsumer holdingDoubleConsumer = new HoldingDoubleConsumer();
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractDoubleSpliterator.tryAdvance:(Ljava/util/function/DoubleConsumer;)Z");
                boolean bl = this.tryAdvance(holdingDoubleConsumer);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    double[] dArray = new double[n2];
                    int n3 = 0;
                    do {
                        dArray[n3] = holdingDoubleConsumer.value;
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractDoubleSpliterator.tryAdvance:(Ljava/util/function/DoubleConsumer;)Z");
                        bl2 = this.tryAdvance(holdingDoubleConsumer);
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractDoubleSpliterator.characteristics:()I");
                    int n4 = this.characteristics();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DIII)V");
                    return new DoubleArraySpliterator(dArray, 0, n3, n4);
                }
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingDoubleConsumer
        implements DoubleConsumer {
            double value;

            HoldingDoubleConsumer() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void accept(double d) {
                this.value = d;
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    implements Spliterator.OfLong {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractLongSpliterator(long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x40) != 0) {
                n2 = n | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$AbstractLongSpliterator$HoldingLongConsumer");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractLongSpliterator$HoldingLongConsumer.<init>:()V");
            HoldingLongConsumer holdingLongConsumer = new HoldingLongConsumer();
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractLongSpliterator.tryAdvance:(Ljava/util/function/LongConsumer;)Z");
                boolean bl = this.tryAdvance(holdingLongConsumer);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    long[] lArray = new long[n2];
                    int n3 = 0;
                    do {
                        lArray[n3] = holdingLongConsumer.value;
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractLongSpliterator.tryAdvance:(Ljava/util/function/LongConsumer;)Z");
                        bl2 = this.tryAdvance(holdingLongConsumer);
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractLongSpliterator.characteristics:()I");
                    int n4 = this.characteristics();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JIII)V");
                    return new LongArraySpliterator(lArray, 0, n3, n4);
                }
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingLongConsumer
        implements LongConsumer {
            long value;

            HoldingLongConsumer() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void accept(long l) {
                this.value = l;
            }
        }
    }

    public static abstract class AbstractIntSpliterator
    implements Spliterator.OfInt {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractIntSpliterator(long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x40) != 0) {
                n2 = n | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$AbstractIntSpliterator$HoldingIntConsumer");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractIntSpliterator$HoldingIntConsumer.<init>:()V");
            HoldingIntConsumer holdingIntConsumer = new HoldingIntConsumer();
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractIntSpliterator.tryAdvance:(Ljava/util/function/IntConsumer;)Z");
                boolean bl = this.tryAdvance(holdingIntConsumer);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
                    int[] nArray = new int[n2];
                    int n3 = 0;
                    do {
                        nArray[n3] = holdingIntConsumer.value;
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractIntSpliterator.tryAdvance:(Ljava/util/function/IntConsumer;)Z");
                        bl2 = this.tryAdvance(holdingIntConsumer);
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractIntSpliterator.characteristics:()I");
                    int n4 = this.characteristics();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([IIII)V");
                    return new IntArraySpliterator(nArray, 0, n3, n4);
                }
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingIntConsumer
        implements IntConsumer {
            int value;

            HoldingIntConsumer() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void accept(int n) {
                this.value = n;
            }
        }
    }

    public static abstract class AbstractSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractSpliterator(long l, int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.est = l;
            RuntimeCostAccounter.recordJump();
            if ((n & 0x40) != 0) {
                n2 = n | 0x4000;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n;
            }
            this.characteristics = n2;
        }

        @Override
        public Spliterator<T> trySplit() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$AbstractSpliterator$HoldingConsumer");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractSpliterator$HoldingConsumer.<init>:()V");
            HoldingConsumer holdingConsumer = new HoldingConsumer();
            long l = this.est;
            RuntimeCostAccounter.recordJump();
            if (l > 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractSpliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                boolean bl = this.tryAdvance(holdingConsumer);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    int n = this.batch + 1024;
                    long l2 = (long)n - l;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 > 0) {
                        n = (int)l;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n > 0x2000000) {
                        n = 0x2000000;
                    }
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    Object[] objectArray = new Object[n2];
                    int n3 = 0;
                    do {
                        objectArray[n3] = holdingConsumer.value;
                        RuntimeCostAccounter.recordJump();
                        if (++n3 >= n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractSpliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                        bl2 = this.tryAdvance(holdingConsumer);
                        RuntimeCostAccounter.recordJump();
                    } while (bl2);
                    this.batch = n3;
                    RuntimeCostAccounter.recordJump();
                    if (this.est != Long.MAX_VALUE) {
                        this.est -= (long)n3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$ArraySpliterator");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$AbstractSpliterator.characteristics:()I");
                    int n4 = this.characteristics();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;III)V");
                    return new ArraySpliterator(objectArray, 0, n3, n4);
                }
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingConsumer<T>
        implements Consumer<T> {
            Object value;

            HoldingConsumer() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void accept(T t) {
                this.value = t;
            }
        }
    }

    static final class DoubleArraySpliterator
    implements Spliterator.OfDouble {
        private final double[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public DoubleArraySpliterator(double[] dArray, int n) {
            int n2 = dArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DIII)V");
            this(dArray, 0, n2, n);
        }

        public DoubleArraySpliterator(double[] dArray, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = dArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            DoubleArraySpliterator doubleArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                doubleArraySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$DoubleArraySpliterator");
                this.index = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.<init>:([DIII)V");
                DoubleArraySpliterator doubleArraySpliterator2 = new DoubleArraySpliterator(this.array, n, this.index, this.characteristics);
                doubleArraySpliterator = doubleArraySpliterator2;
            }
            return doubleArraySpliterator;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            double[] dArray = this.array;
            int n = this.array.length;
            int n2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                int n3 = this.index;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    this.index = n2;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < this.index) {
                        do {
                            double d = dArray[n3];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                            doubleConsumer.accept(d);
                            RuntimeCostAccounter.recordJump();
                        } while (++n3 < n2);
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.index >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.index < this.fence) {
                    double d = this.array[this.index++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                    doubleConsumer.accept(d);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$DoubleArraySpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static final class LongArraySpliterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public LongArraySpliterator(long[] lArray, int n) {
            int n2 = lArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JIII)V");
            this(lArray, 0, n2, n);
        }

        public LongArraySpliterator(long[] lArray, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = lArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongArraySpliterator longArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                longArraySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$LongArraySpliterator");
                this.index = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.<init>:([JIII)V");
                LongArraySpliterator longArraySpliterator2 = new LongArraySpliterator(this.array, n, this.index, this.characteristics);
                longArraySpliterator = longArraySpliterator2;
            }
            return longArraySpliterator;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long[] lArray = this.array;
            int n = this.array.length;
            int n2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                int n3 = this.index;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    this.index = n2;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < this.index) {
                        do {
                            long l = lArray[n3];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                            longConsumer.accept(l);
                            RuntimeCostAccounter.recordJump();
                        } while (++n3 < n2);
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.index >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.index < this.fence) {
                    long l = this.array[this.index++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                    longConsumer.accept(l);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$LongArraySpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static final class IntArraySpliterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public IntArraySpliterator(int[] nArray, int n) {
            int n2 = nArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([IIII)V");
            this(nArray, 0, n2, n);
        }

        public IntArraySpliterator(int[] nArray, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = nArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntArraySpliterator intArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                intArraySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$IntArraySpliterator");
                this.index = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.<init>:([IIII)V");
                IntArraySpliterator intArraySpliterator2 = new IntArraySpliterator(this.array, n, this.index, this.characteristics);
                intArraySpliterator = intArraySpliterator2;
            }
            return intArraySpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            int[] nArray = this.array;
            int n = this.array.length;
            int n2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                int n3 = this.index;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    this.index = n2;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < this.index) {
                        do {
                            int n4 = nArray[n3];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                            intConsumer.accept(n4);
                            RuntimeCostAccounter.recordJump();
                        } while (++n3 < n2);
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.index >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.index < this.fence) {
                    int n = this.array[this.index++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                    intConsumer.accept(n);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$IntArraySpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    static final class ArraySpliterator<T>
    implements Spliterator<T> {
        private final Object[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySpliterator(Object[] objectArray, int n) {
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;III)V");
            this(objectArray, 0, n2, n);
        }

        public ArraySpliterator(Object[] objectArray, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.array = objectArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator<T> trySplit() {
            ArraySpliterator<T> arraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                arraySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Spliterators$ArraySpliterator");
                this.index = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.<init>:([Ljava/lang/Object;III)V");
                ArraySpliterator<T> arraySpliterator2 = new ArraySpliterator<T>(this.array, n, this.index, this.characteristics);
                arraySpliterator = arraySpliterator2;
            }
            return arraySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Object[] objectArray = this.array;
            int n = this.array.length;
            int n2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                int n3 = this.index;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    this.index = n2;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < this.index) {
                        do {
                            Object object = objectArray[n3];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object);
                            RuntimeCostAccounter.recordJump();
                        } while (++n3 < n2);
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.index >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.index < this.fence) {
                    Object object = this.array[this.index++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(object);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$ArraySpliterator.hasCharacteristics:(I)Z");
            boolean bl = this.hasCharacteristics(4);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C> {
        EmptySpliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        public S trySplit() {
            return null;
        }

        public boolean tryAdvance(C c) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(c);
            return false;
        }

        public void forEachRemaining(C c) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(c);
        }

        public long estimateSize() {
            return 0L;
        }

        public int characteristics() {
            return 16448;
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator.<init>:()V");
            }
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator.<init>:()V");
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator.<init>:()V");
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators$EmptySpliterator.<init>:()V");
            }
        }
    }
}

