/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.Serializable;
import sandbox.java.nio.ByteBuffer;
import sandbox.java.nio.ByteOrder;
import sandbox.java.nio.LongBuffer;
import sandbox.java.util.Arrays;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.StreamSupport;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private static final ObjectStreamField[] serialPersistentFields;
    private long[] words;
    private transient int wordsInUse;
    private transient boolean sizeIsSticky;
    private static final long serialVersionUID = 7997698588986878753L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int wordIndex(int n) {
        return n >> 6;
    }

    private void checkInvariants() {
        block9: {
            block10: {
                RuntimeCostAccounter.recordJump();
                if (!$assertionsDisabled) {
                    RuntimeCostAccounter.recordJump();
                    if (this.wordsInUse != 0) {
                        long l = this.words[this.wordsInUse - 1] - 0L;
                        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l2 == false) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                            AssertionError assertionError = new AssertionError();
                            RuntimeCostAccounter.recordThrow();
                            throw assertionError;
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
                if ($assertionsDisabled) break block9;
                RuntimeCostAccounter.recordJump();
                if (this.wordsInUse < 0) break block10;
                int n = this.words.length;
                RuntimeCostAccounter.recordJump();
                if (this.wordsInUse <= n) break block9;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
            AssertionError assertionError = new AssertionError();
            RuntimeCostAccounter.recordThrow();
            throw assertionError;
        }
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            int n = this.words.length;
            RuntimeCostAccounter.recordJump();
            if (this.wordsInUse != n) {
                long l = this.words[this.wordsInUse] - 0L;
                long l3 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 != false) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
        }
    }

    private void recalculateWordsInUse() {
        int n = this.wordsInUse - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            long l = this.words[n] - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            --n;
            RuntimeCostAccounter.recordJump();
        }
        this.wordsInUse = n + 1;
    }

    public BitSet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.initWords:(I)V");
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public BitSet(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NegativeArraySizeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("nbits < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NegativeArraySizeException.<init>:(Ljava/lang/String;)V");
            NegativeArraySizeException negativeArraySizeException = new NegativeArraySizeException(string);
            RuntimeCostAccounter.recordThrow();
            throw negativeArraySizeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.initWords:(I)V");
        this.initWords(n);
        this.sizeIsSticky = true;
    }

    private void initWords(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n - 1) + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.words = new long[n2];
    }

    private BitSet(long[] lArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.wordsInUse = 0;
        this.sizeIsSticky = false;
        this.words = lArray;
        this.wordsInUse = lArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public static BitSet valueOf(long[] lArray) {
        int n = lArray.length;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            long l = lArray[n - 1] - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) break;
            --n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
        long[] lArray2 = Arrays.copyOf(lArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:([J)V");
        return new BitSet(lArray2);
    }

    public static BitSet valueOf(LongBuffer longBuffer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/LongBuffer.slice:()Ljava/nio/LongBuffer;");
        longBuffer = longBuffer.slice();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/LongBuffer.remaining:()I");
        int n = longBuffer.remaining();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/LongBuffer.get:(I)J");
            long l = longBuffer.get(n - 1) - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) break;
            --n;
            RuntimeCostAccounter.recordJump();
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        long[] lArray = new long[n2];
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/LongBuffer.get:([J)Ljava/nio/LongBuffer;");
        longBuffer.get(lArray);
        RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:([J)V");
        return new BitSet(lArray);
    }

    public static BitSet valueOf(byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([B)Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.valueOf:(Ljava/nio/ByteBuffer;)Ljava/util/BitSet;");
        return BitSet.valueOf(byteBuffer);
    }

    public static BitSet valueOf(ByteBuffer byteBuffer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.slice:()Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.order:(Ljava/nio/ByteOrder;)Ljava/nio/ByteBuffer;");
        byteBuffer = byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
        int n = byteBuffer.remaining();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.get:(I)B");
            byte by = byteBuffer.get(n - 1);
            RuntimeCostAccounter.recordJump();
            if (by != 0) break;
            --n;
            RuntimeCostAccounter.recordJump();
        }
        int n2 = (n + 7) / 8;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        long[] lArray = new long[n2];
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.limit:(I)Ljava/nio/Buffer;");
        byteBuffer.limit(n);
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
            int n4 = byteBuffer.remaining();
            RuntimeCostAccounter.recordJump();
            if (n4 < 8) break;
            int n5 = n3++;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.getLong:()J");
            lArray[n5] = byteBuffer.getLong();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
        int n6 = byteBuffer.remaining();
        int n7 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 >= n6) break;
            int n8 = n3;
            long l = lArray[n8];
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.get:()B");
            lArray[n8] = l | ((long)byteBuffer.get() & 0xFFL) << 8 * n7;
            ++n7;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:([J)V");
        return new BitSet(lArray);
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)1);
            return new byte[0];
        }
        int n2 = 8 * (n - 1);
        long l = this.words[n - 1];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l == 0L) break;
            ++n2;
            l >>>= 8;
            RuntimeCostAccounter.recordJump();
        }
        int n3 = n2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
        byte[] byArray = new byte[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([B)Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.order:(Ljava/nio/ByteOrder;)Ljava/nio/ByteBuffer;");
        ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n - 1) break;
            long l2 = this.words[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.putLong:(J)Ljava/nio/ByteBuffer;");
            byteBuffer2.putLong(l2);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        long l3 = this.words[n - 1];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l3 == 0L) break;
            byte by = (byte)(l3 & 0xFFL);
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.put:(B)Ljava/nio/ByteBuffer;");
            byteBuffer2.put(by);
            l3 >>>= 8;
            RuntimeCostAccounter.recordJump();
        }
        return byArray;
    }

    public long[] toLongArray() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
        return Arrays.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int n) {
        int n2 = this.words.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            int n3 = 2 * this.words.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
            int n4 = Math.max(n3, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
            this.words = Arrays.copyOf(this.words, n4);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n) {
        int n2 = n + 1;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse < n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.ensureCapacity:(I)V");
            this.ensureCapacity(n2);
            this.wordsInUse = n2;
        }
    }

    private static void checkRange(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("toIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append("fromIndex: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(" > toIndex: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder9.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    public void flip(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("bitIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.expandTo:(I)V");
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] ^ 1L << n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void flip(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkRange:(II)V");
        BitSet.checkRange(n, n2);
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n3 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n4 = BitSet.wordIndex(n2 - 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.expandTo:(I)V");
        this.expandTo(n4);
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        RuntimeCostAccounter.recordJump();
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] ^ l & l2;
            RuntimeCostAccounter.recordJump();
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] ^ l;
            int n7 = n3 + 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n4) break;
                int n8 = n7++;
                this.words[n8] = this.words[n8] ^ 0xFFFFFFFFFFFFFFFFL;
                RuntimeCostAccounter.recordJump();
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] ^ l2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void set(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("bitIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.expandTo:(I)V");
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] | 1L << n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void set(int n, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.set:(I)V");
            this.set(n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.clear:(I)V");
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkRange:(II)V");
        BitSet.checkRange(n, n2);
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n3 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n4 = BitSet.wordIndex(n2 - 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.expandTo:(I)V");
        this.expandTo(n4);
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        RuntimeCostAccounter.recordJump();
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] | l & l2;
            RuntimeCostAccounter.recordJump();
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] | l;
            int n7 = n3 + 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n4) break;
                this.words[n7] = -1L;
                ++n7;
                RuntimeCostAccounter.recordJump();
            }
            int n8 = n4;
            this.words[n8] = this.words[n8] | l2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void set(int n, int n2, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.set:(II)V");
            this.set(n, n2);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.clear:(II)V");
            this.clear(n, n2);
        }
    }

    public void clear(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("bitIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) {
            return;
        }
        int n3 = n2;
        this.words[n3] = this.words[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void clear(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkRange:(II)V");
        BitSet.checkRange(n, n2);
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n3 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n3 >= this.wordsInUse) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n4 = BitSet.wordIndex(n2 - 1);
        RuntimeCostAccounter.recordJump();
        if (n4 >= this.wordsInUse) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.length:()I");
            n2 = this.length();
            n4 = this.wordsInUse - 1;
        }
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        RuntimeCostAccounter.recordJump();
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] & (l & l2 ^ 0xFFFFFFFFFFFFFFFFL);
            RuntimeCostAccounter.recordJump();
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            int n7 = n3 + 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n4) break;
                this.words[n7] = 0L;
                ++n7;
                RuntimeCostAccounter.recordJump();
            }
            int n8 = n4;
            this.words[n8] = this.words[n8] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void clear() {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.wordsInUse <= 0) break;
            this.words[--this.wordsInUse] = 0L;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean get(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("bitIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) return false;
        long l = (this.words[n2] & 1L << n) - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 == false) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public BitSet get(int n, int n2) {
        long l;
        boolean bl;
        int n3;
        block12: {
            block11: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkRange:(II)V");
                BitSet.checkRange(n, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
                this.checkInvariants();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.length:()I");
                n3 = this.length();
                RuntimeCostAccounter.recordJump();
                if (n3 <= n) break block11;
                RuntimeCostAccounter.recordJump();
                if (n != n2) break block12;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:(I)V");
            return new BitSet(0);
        }
        RuntimeCostAccounter.recordJump();
        if (n2 > n3) {
            n2 = n3;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:(I)V");
        BitSet bitSet = new BitSet(n2 - n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n4 = BitSet.wordIndex(n2 - n - 1) + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n5 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if ((n & 0x3F) == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        int n6 = 0;
        while (true) {
            long l2;
            RuntimeCostAccounter.recordJump();
            if (n6 >= n4 - 1) break;
            long[] lArray = bitSet.words;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                l2 = this.words[n5];
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = this.words[n5] >>> n | this.words[n5 + 1] << -n;
            }
            lArray[n6] = l2;
            ++n6;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        long l3 = -1L >>> -n2;
        long[] lArray = bitSet.words;
        RuntimeCostAccounter.recordJump();
        if ((n2 - 1 & 0x3F) < (n & 0x3F)) {
            l = this.words[n5] >>> n | (this.words[n5 + 1] & l3) << -n;
            RuntimeCostAccounter.recordJump();
        } else {
            l = (this.words[n5] & l3) >>> n;
        }
        lArray[n4 - 1] = l;
        bitSet.wordsInUse = n4;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        bitSet.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        bitSet.checkInvariants();
        return bitSet;
    }

    public int nextSetBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) {
            return -1;
        }
        long l = this.words[n2] & -1L << n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfTrailingZeros:(J)I");
                return n2 * 64 + Long.numberOfTrailingZeros(l);
            }
            RuntimeCostAccounter.recordJump();
            if (++n2 == this.wordsInUse) {
                return -1;
            }
            l = this.words[n2];
            RuntimeCostAccounter.recordJump();
        }
    }

    public int nextClearBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex < 0: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) {
            return n;
        }
        long l = (this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfTrailingZeros:(J)I");
                return n2 * 64 + Long.numberOfTrailingZeros(l);
            }
            RuntimeCostAccounter.recordJump();
            if (++n2 == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            l = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
        }
    }

    public int previousSetBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordJump();
            if (n == -1) {
                return -1;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex < -1: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.length:()I");
            return this.length() - 1;
        }
        long l = this.words[n2] & -1L >>> -(n + 1);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfLeadingZeros:(J)I");
                return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
            }
            int n3 = n2--;
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                return -1;
            }
            l = this.words[n2];
            RuntimeCostAccounter.recordJump();
        }
    }

    public int previousClearBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordJump();
            if (n == -1) {
                return -1;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex < -1: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.wordIndex:(I)I");
        int n2 = BitSet.wordIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.wordsInUse) {
            return n;
        }
        long l = (this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(n + 1);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfLeadingZeros:(J)I");
                return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
            }
            int n3 = n2--;
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                return -1;
            }
            l = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
        }
    }

    public int length() {
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse == 0) {
            return 0;
        }
        long l = this.words[this.wordsInUse - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfLeadingZeros:(J)I");
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(l));
    }

    public boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean intersects(BitSet bitSet) {
        int n = bitSet.wordsInUse;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n2 = Math.min(this.wordsInUse, n) - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            long l = (this.words[n2] & bitSet.words[n2]) - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) {
                return true;
            }
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.wordsInUse) break;
            long l = this.words[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.bitCount:(J)I");
            n += Long.bitCount(l);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    public void and(BitSet bitSet) {
        RuntimeCostAccounter.recordJump();
        if (this == bitSet) {
            return;
        }
        while (true) {
            int n = bitSet.wordsInUse;
            RuntimeCostAccounter.recordJump();
            if (this.wordsInUse <= n) break;
            this.words[--this.wordsInUse] = 0L;
            RuntimeCostAccounter.recordJump();
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.wordsInUse) break;
            int n2 = n;
            this.words[n2] = this.words[n2] & bitSet.words[n];
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void or(BitSet bitSet) {
        RuntimeCostAccounter.recordJump();
        if (this == bitSet) {
            return;
        }
        int n = bitSet.wordsInUse;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n2 = Math.min(this.wordsInUse, n);
        int n3 = bitSet.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse < n3) {
            int n4 = bitSet.wordsInUse;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.ensureCapacity:(I)V");
            this.ensureCapacity(n4);
            this.wordsInUse = bitSet.wordsInUse;
        }
        int n5 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n2) break;
            int n6 = n5;
            this.words[n6] = this.words[n6] | bitSet.words[n5];
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n7 = bitSet.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (n2 < n7) {
            long[] lArray = bitSet.words;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(lArray, n2, this.words, n2, this.wordsInUse - n2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void xor(BitSet bitSet) {
        int n = bitSet.wordsInUse;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n2 = Math.min(this.wordsInUse, n);
        int n3 = bitSet.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse < n3) {
            int n4 = bitSet.wordsInUse;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.ensureCapacity:(I)V");
            this.ensureCapacity(n4);
            this.wordsInUse = bitSet.wordsInUse;
        }
        int n5 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n2) break;
            int n6 = n5;
            this.words[n6] = this.words[n6] ^ bitSet.words[n5];
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n7 = bitSet.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (n2 < n7) {
            long[] lArray = bitSet.words;
            int n8 = bitSet.wordsInUse - n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(lArray, n2, this.words, n2, n8);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public void andNot(BitSet bitSet) {
        int n = bitSet.wordsInUse;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n2 = Math.min(this.wordsInUse, n) - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            int n3 = n2;
            this.words[n3] = this.words[n3] & (bitSet.words[n2] ^ 0xFFFFFFFFFFFFFFFFL);
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.wordsInUse;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (--n < 0) break;
            l ^= this.words[n] * (long)(n + 1);
            RuntimeCostAccounter.recordJump();
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof BitSet;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        bitSet.checkInvariants();
        int n = bitSet.wordsInUse;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse != n) {
            return false;
        }
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.wordsInUse) break;
            long l = this.words[n2] - bitSet.words[n2];
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) {
                return false;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    public Object clone() {
        RuntimeCostAccounter.recordJump();
        if (!this.sizeIsSticky) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.trimToSize:()V");
            this.trimToSize();
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            BitSet bitSet = (BitSet)super.clone();
            RuntimeCostAccounter.recordMethodCall((String)"[J.clone:()Ljava/lang/Object;");
            bitSet.words = (long[])this.words.clone();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
            bitSet.checkInvariants();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    private void trimToSize() {
        int n = this.words.length;
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse != n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordJump();
        if (!this.sizeIsSticky) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.trimToSize:()V");
            this.trimToSize();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.putFields:()Ljava/io/ObjectOutputStream$PutField;");
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;Ljava/lang/Object;)V");
        putField.put("bits", this.words);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFields:()V");
        objectOutputStream.writeFields();
    }

    /*
     * Unable to fully structure code
     */
    private void readObject(ObjectInputStream var1_1) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
        var2_2 = var1_1.readFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        this.words = (long[])var2_2.get("bits", null);
        this.wordsInUse = this.words.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.recalculateWordsInUse:()V");
        this.recalculateWordsInUse();
        v0 = this.words.length;
        RuntimeCostAccounter.recordJump();
        if (v0 <= 0) ** GOTO lbl-1000
        cfr_temp_0 = this.words[this.words.length - 1] - 0L;
        v1 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (v1 == false) {
            v2 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        this.sizeIsSticky = v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
    }

    public String toString() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.checkInvariants:()V");
        this.checkInvariants();
        RuntimeCostAccounter.recordJump();
        if (this.wordsInUse > 128) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.cardinality:()I");
            n = this.cardinality();
            RuntimeCostAccounter.recordJump();
        } else {
            n = this.wordsInUse * 64;
        }
        int n2 = n;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(6 * n2 + 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('{');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextSetBit:(I)I");
        int n3 = this.nextSetBit(0);
        RuntimeCostAccounter.recordJump();
        if (n3 != -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder.append(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextSetBit:(I)I");
            n3 = this.nextSetBit(n3 + 1);
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextClearBit:(I)I");
                int n4 = this.nextClearBit(n3);
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append(", ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    stringBuilder2.append(n3);
                    RuntimeCostAccounter.recordJump();
                } while (++n3 < n4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextSetBit:(I)I");
                n3 = this.nextSetBit(n3 + 1);
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('}');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public IntStream stream() {
        Supplier<Spliterator.OfInt> supplier = () -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet$1BitSetIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet$1BitSetIterator.<init>:(Ljava/util/BitSet;)V");
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextSetBit:(I)I");
                    this.next = BitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    boolean bl;
                    RuntimeCostAccounter.recordJump();
                    if (this.next != -1) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                @Override
                public int nextInt() {
                    RuntimeCostAccounter.recordJump();
                    if (this.next != -1) {
                        int n = this.next;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextSetBit:(I)I");
                        this.next = BitSet.this.nextSetBit(this.next + 1);
                        return n;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
            }
            BitSetIterator bitSetIterator = new BitSetIterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.cardinality:()I");
            long l = this.cardinality();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:(Ljava/util/PrimitiveIterator$OfInt;JI)Ljava/util/Spliterator$OfInt;");
            return Spliterators.spliterator(bitSetIterator, l, 21);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/function/Supplier;IZ)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(supplier, 16469, false);
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = BitSet.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[1];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[0] = new ObjectStreamField("bits", long[].class);
        serialPersistentFields = objectStreamFieldArray;
    }
}

