/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractList;
import sandbox.java.util.Arrays;
import sandbox.java.util.BitSet;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.ListIterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.RandomAccess;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.UnaryOperator;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA;
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            this.elementData = new Object[n2];
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                this.elementData = EMPTY_ELEMENTDATA;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Illegal Capacity: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
    }

    public ArrayList() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        RuntimeCostAccounter.recordJump();
        if (this.size != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.elementData.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz != Object[].class) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        RuntimeCostAccounter.recordJump();
        if (this.size < n) {
            Object[] objectArray;
            RuntimeCostAccounter.recordJump();
            if (this.size == 0) {
                objectArray = EMPTY_ELEMENTDATA;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                objectArray = Arrays.copyOf(this.elementData, this.size);
            }
            this.elementData = objectArray;
        }
    }

    public void ensureCapacity(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 10;
        }
        int n3 = n2;
        RuntimeCostAccounter.recordJump();
        if (n > n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureExplicitCapacity:(I)V");
            this.ensureExplicitCapacity(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
            n = Math.max(10, n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureExplicitCapacity:(I)V");
        this.ensureExplicitCapacity(n);
    }

    private void ensureExplicitCapacity(int n) {
        ++this.modCount;
        int n2 = n - this.elementData.length;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.grow:(I)V");
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        RuntimeCostAccounter.recordJump();
        if (n3 - n < 0) {
            n3 = n;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 - 0x7FFFFFF7 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.hugeCapacity:(I)I");
            n3 = ArrayList.hugeCapacity(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:()V");
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError();
            RuntimeCostAccounter.recordThrow();
            throw outOfMemoryError;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0x7FFFFFF7) {
            n2 = Integer.MAX_VALUE;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0x7FFFFFF7;
        }
        return n2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.size == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.indexOf:(Ljava/lang/Object;)I");
        int n = this.indexOf(object);
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int indexOf(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object2 = this.elementData[n];
                RuntimeCostAccounter.recordJump();
                if (object2 == null) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object3 = this.elementData[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            int n = this.size - 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break;
                Object object2 = this.elementData[n];
                RuntimeCostAccounter.recordJump();
                if (object2 == null) {
                    return n;
                }
                --n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            int n = this.size - 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break;
                Object object3 = this.elementData[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                --n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            ArrayList arrayList = (ArrayList)super.clone();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    @Override
    public Object[] toArray() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n < this.size) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = TArray.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
            return Arrays.copyOf(this.elementData, this.size, clazz);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        int n2 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    public E get(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.rangeCheck:(I)V");
        this.rangeCheck(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.elementData:(I)Ljava/lang/Object;");
        return this.elementData(n);
    }

    @Override
    public E set(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.rangeCheck:(I)V");
        this.rangeCheck(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.elementData:(I)Ljava/lang/Object;");
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureCapacityInternal:(I)V");
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.rangeCheckForAdd:(I)V");
        this.rangeCheckForAdd(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureCapacityInternal:(I)V");
        this.ensureCapacityInternal(this.size + 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.rangeCheck:(I)V");
        this.rangeCheck(n);
        ++this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.elementData:(I)Ljava/lang/Object;");
        E e = this.elementData(n);
        int n2 = this.size - n - 1;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return e;
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object2 = this.elementData[n];
                RuntimeCostAccounter.recordJump();
                if (object2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.fastRemove:(I)V");
                    this.fastRemove(n);
                    return true;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object3 = this.elementData[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.fastRemove:(I)V");
                    this.fastRemove(n);
                    return true;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.size) break;
            this.elementData[n] = null;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureCapacityInternal:(I)V");
        this.ensureCapacityInternal(this.size + n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(objectArray, 0, this.elementData, this.size, n);
        this.size += n;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.rangeCheckForAdd:(I)V");
        this.rangeCheckForAdd(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureCapacityInternal:(I)V");
        this.ensureCapacityInternal(this.size + n2);
        int n3 = this.size - n;
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.size += n2;
        RuntimeCostAccounter.recordJump();
        if (n2 != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3;
        ++this.modCount;
        int n4 = this.size - n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.elementData, n2, this.elementData, n, n4);
        int n5 = n3 = this.size - (n2 - n);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= this.size) break;
            this.elementData[n5] = null;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        this.size = n3;
    }

    private void rangeCheck(int n) {
        RuntimeCostAccounter.recordJump();
        if (n >= this.size) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.outOfBoundsMsg:(I)Ljava/lang/String;");
            String string = this.outOfBoundsMsg(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    private void rangeCheckForAdd(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n > this.size) break block2;
                RuntimeCostAccounter.recordJump();
                if (n >= 0) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.outOfBoundsMsg:(I)Ljava/lang/String;");
            String string = this.outOfBoundsMsg(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    private String outOfBoundsMsg(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(", Size: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.size);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(collection);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.batchRemove:(Ljava/util/Collection;Z)Z");
        return this.batchRemove(collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(collection);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.batchRemove:(Ljava/util/Collection;Z)Z");
        return this.batchRemove(collection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        Object[] objectArray = this.elementData;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        try {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object = objectArray[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
                boolean bl3 = collection.contains(object);
                RuntimeCostAccounter.recordJump();
                if (bl3 == bl) {
                    objectArray[n2++] = objectArray[n];
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (n != this.size) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
                n2 += this.size - n;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 != this.size) {
                int n3 = n2;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= this.size) break;
                    objectArray[n3] = null;
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
                this.modCount += this.size - n2;
                this.size = n2;
                bl2 = true;
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (n != this.size) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
            n2 += this.size - n;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 != this.size) {
            int n4 = n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 >= this.size) break;
                objectArray[n4] = null;
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
            this.modCount += this.size - n2;
            this.size = n2;
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(this.size);
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.size) break;
            Object object = this.elementData[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(object);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.modCount != n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.elementData = EMPTY_ELEMENTDATA;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        objectInputStream.readInt();
        RuntimeCostAccounter.recordJump();
        if (this.size > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.ensureCapacityInternal:(I)V");
            this.ensureCapacityInternal(this.size);
            Object[] objectArray = this.elementData;
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
                objectArray[n] = objectInputStream.readObject();
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= this.size) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$ListItr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ListItr.<init>:(Ljava/util/ArrayList;I)V");
        return new ListItr(n);
    }

    @Override
    public ListIterator<E> listIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$ListItr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ListItr.<init>:(Ljava/util/ArrayList;I)V");
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.<init>:(Ljava/util/ArrayList;Ljava/util/ArrayList$1;)V");
        return new Itr(this, null);
    }

    @Override
    public List<E> subList(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.subListRangeCheck:(III)V");
        ArrayList.subListRangeCheck(n, n2, this.size);
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$SubList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.<init>:(Ljava/util/ArrayList;Ljava/util/AbstractList;III)V");
        return new SubList(this, 0, n, n2);
    }

    static void subListRangeCheck(int n, int n2, int n3) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("fromIndex = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 > n3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("toIndex = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append("fromIndex(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(") > toIndex(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder10.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(consumer);
        int n = this.modCount;
        Object[] objectArray = this.elementData;
        int n2 = this.size;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.modCount != n) break;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            Object object = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(object);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.modCount != n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$ArrayListSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.<init>:(Ljava/util/ArrayList;III)V");
        return new ArrayListSpliterator(this, 0, -1, 0);
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(predicate);
        int n2 = 0;
        RuntimeCostAccounter.recordAllocation((String)"java/util/BitSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.<init>:(I)V");
        BitSet bitSet = new BitSet(this.size);
        int n3 = this.modCount;
        int n4 = this.size;
        int n5 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.modCount != n3) break;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n4) break;
            Object object = this.elementData[n5];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Predicate.test:(Ljava/lang/Object;)Z");
            boolean bl = predicate.test(object);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.set:(I)V");
                bitSet.set(n5);
                ++n2;
            }
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.modCount != n3) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        n5 = n;
        RuntimeCostAccounter.recordJump();
        if (n5 != 0) {
            int n6 = n4 - n2;
            int n7 = 0;
            int n8 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (n8 >= n6) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/BitSet.nextClearBit:(I)I");
                n7 = bitSet.nextClearBit(n7);
                this.elementData[n8] = this.elementData[n7];
                ++n7;
                ++n8;
                RuntimeCostAccounter.recordJump();
            }
            n7 = n6;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n4) break;
                this.elementData[n7] = null;
                ++n7;
                RuntimeCostAccounter.recordJump();
            }
            this.size = n6;
            RuntimeCostAccounter.recordJump();
            if (this.modCount != n3) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            ++this.modCount;
        }
        return n5 != 0;
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(unaryOperator);
        int n = this.modCount;
        int n2 = this.size;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.modCount != n) break;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            Object object = this.elementData[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.elementData[n3] = unaryOperator.apply(object);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.modCount != n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([Ljava/lang/Object;IILjava/util/Comparator;)V");
        Arrays.sort(this.elementData, 0, this.size, comparator);
        RuntimeCostAccounter.recordJump();
        if (this.modCount != n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
        ++this.modCount;
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_ELEMENTDATA = new Object[0];
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    }

    static final class ArrayListSpliterator<E>
    implements Spliterator<E> {
        private final ArrayList<E> list;
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(ArrayList<E> arrayList, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.list = arrayList;
            this.index = n;
            this.fence = n2;
            this.expectedModCount = n3;
        }

        private int getFence() {
            int n = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                ArrayList<E> arrayList = this.list;
                RuntimeCostAccounter.recordJump();
                if (arrayList == null) {
                    this.fence = 0;
                    n = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.expectedModCount = arrayList.modCount;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.access$100:(Ljava/util/ArrayList;)I");
                    n = this.fence = ((ArrayList)arrayList).size;
                }
            }
            return n;
        }

        @Override
        public ArrayListSpliterator<E> trySplit() {
            ArrayListSpliterator<E> arrayListSpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                arrayListSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$ArrayListSpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.<init>:(Ljava/util/ArrayList;III)V");
                ArrayListSpliterator<E> arrayListSpliterator2 = new ArrayListSpliterator<E>(this.list, n2, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                this.index = n2 + 1;
                Object object = this.list.elementData[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(object);
                int n3 = this.list.modCount;
                RuntimeCostAccounter.recordJump();
                if (n3 != this.expectedModCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            ArrayList<E> arrayList = this.list;
            RuntimeCostAccounter.recordJump();
            if (arrayList != null) {
                Object[] objectArray = arrayList.elementData;
                RuntimeCostAccounter.recordJump();
                if (arrayList.elementData != null) {
                    int n;
                    int n2 = this.fence;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) {
                        n = arrayList.modCount;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.access$100:(Ljava/util/ArrayList;)I");
                        n2 = ((ArrayList)arrayList).size;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.expectedModCount;
                    }
                    int n3 = this.index;
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 0) {
                        this.index = n2;
                        int n4 = objectArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (this.index <= n4) {
                            while (true) {
                                RuntimeCostAccounter.recordJump();
                                if (n3 >= n2) break;
                                Object object = objectArray[n3];
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                                consumer.accept(object);
                                ++n3;
                                RuntimeCostAccounter.recordJump();
                            }
                            int n5 = arrayList.modCount;
                            RuntimeCostAccounter.recordJump();
                            if (n5 == n) {
                                return;
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.getFence:()I");
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class SubList
    extends AbstractList<E>
    implements RandomAccess {
        private final AbstractList<E> parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(AbstractList<E> abstractList, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
            this.parent = abstractList;
            this.parentOffset = n2;
            this.offset = n + n2;
            this.size = n3 - n2;
            this.modCount = ArrayList.this.modCount;
        }

        @Override
        public E set(int n, E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheck:(I)V");
            this.rangeCheck(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.elementData:(I)Ljava/lang/Object;");
            Object e2 = ArrayList.this.elementData(this.offset + n);
            ArrayList.this.elementData[this.offset + n] = e;
            return e2;
        }

        @Override
        public E get(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheck:(I)V");
            this.rangeCheck(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.elementData:(I)Ljava/lang/Object;");
            return ArrayList.this.elementData(this.offset + n);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int n, E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheckForAdd:(I)V");
            this.rangeCheckForAdd(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.add:(ILjava/lang/Object;)V");
            this.parent.add(this.parentOffset + n, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public E remove(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheck:(I)V");
            this.rangeCheck(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.remove:(I)Ljava/lang/Object;");
            Object e = this.parent.remove(this.parentOffset + n);
            this.modCount = this.parent.modCount;
            --this.size;
            return e;
        }

        @Override
        protected void removeRange(int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.removeRange:(II)V");
            this.parent.removeRange(this.parentOffset + n, this.parentOffset + n2);
            this.modCount = this.parent.modCount;
            this.size -= n2 - n;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.addAll:(ILjava/util/Collection;)Z");
            return this.addAll(this.size, collection);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheckForAdd:(I)V");
            this.rangeCheckForAdd(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            int n2 = collection.size();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.addAll:(ILjava/util/Collection;)Z");
            this.parent.addAll(this.parentOffset + n, collection);
            this.modCount = this.parent.modCount;
            this.size += n2;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.listIterator:()Ljava/util/ListIterator;");
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.rangeCheckForAdd:(I)V");
            this.rangeCheckForAdd(n);
            final int n2 = this.offset;
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$SubList$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.<init>:(Ljava/util/ArrayList$SubList;II)V");
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    this.cursor = n;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayList.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    boolean bl;
                    int n3 = SubList.this.size;
                    RuntimeCostAccounter.recordJump();
                    if (this.cursor != n3) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                @Override
                public E next() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                    int n4 = this.cursor;
                    int n22 = SubList.this.size;
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n22) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    int n3 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 + n4 >= n3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    this.cursor = n4 + 1;
                    this.lastRet = n4;
                    return objectArray[n2 + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    boolean bl;
                    RuntimeCostAccounter.recordJump();
                    if (this.cursor != 0) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                @Override
                public E previous() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                    int n3 = this.cursor - 1;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    int n22 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 + n3 >= n22) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    this.cursor = n3;
                    this.lastRet = n3;
                    return objectArray[n2 + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Objects.requireNonNull(consumer);
                    int n5 = SubList.this.size;
                    int n22 = this.cursor;
                    RuntimeCostAccounter.recordJump();
                    if (n22 >= n5) {
                        return;
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    int n3 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 + n22 >= n3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n22 == n5) break;
                        int n4 = SubList.this.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (n4 != this.expectedModCount) break;
                        Object object = objectArray[n2 + n22++];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(object);
                        RuntimeCostAccounter.recordJump();
                    }
                    this.lastRet = this.cursor = n22;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastRet < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                        IllegalStateException illegalStateException = new IllegalStateException();
                        RuntimeCostAccounter.recordThrow();
                        throw illegalStateException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.remove:(I)Ljava/lang/Object;");
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    RuntimeCostAccounter.recordJump();
                }

                @Override
                public void set(E e) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastRet < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                        IllegalStateException illegalStateException = new IllegalStateException();
                        RuntimeCostAccounter.recordThrow();
                        throw illegalStateException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                    try {
                        ArrayList arrayList = ArrayList.this;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                        arrayList.set(n2 + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    RuntimeCostAccounter.recordJump();
                }

                @Override
                public void add(E e) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList$1.checkForComodification:()V");
                    this.checkForComodification();
                    try {
                        int n3 = this.cursor;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.add:(ILjava/lang/Object;)V");
                        SubList.this.add(n3, e);
                        this.cursor = n3 + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    RuntimeCostAccounter.recordJump();
                }

                final void checkForComodification() {
                    int n3 = ArrayList.this.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (this.expectedModCount != n3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.subListRangeCheck:(III)V");
            ArrayList.subListRangeCheck(n, n2, this.size);
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$SubList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.<init>:(Ljava/util/ArrayList;Ljava/util/AbstractList;III)V");
            return new SubList(this, this.offset, n, n2);
        }

        private void rangeCheck(int n) {
            block3: {
                block2: {
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (n < this.size) break block3;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.outOfBoundsMsg:(I)Ljava/lang/String;");
                String string = this.outOfBoundsMsg(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
        }

        private void rangeCheckForAdd(int n) {
            block3: {
                block2: {
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (n <= this.size) break block3;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.outOfBoundsMsg:(I)Ljava/lang/String;");
                String string = this.outOfBoundsMsg(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
        }

        private String outOfBoundsMsg(int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", Size: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.size);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }

        private void checkForComodification() {
            int n = ArrayList.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.modCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$SubList.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList$ArrayListSpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ArrayListSpliterator.<init>:(Ljava/util/ArrayList;III)V");
            return new ArrayListSpliterator(ArrayList.this, this.offset, this.offset + this.size, this.modCount);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.<init>:(Ljava/util/ArrayList;Ljava/util/ArrayList$1;)V");
            super(ArrayList.this, null);
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.cursor != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            int n = this.cursor - 1;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            Object[] objectArray = ArrayList.this.elementData;
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            this.cursor = n;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void set(E e) {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void add(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            try {
                int n = this.cursor;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(ILjava/lang/Object;)V");
                ArrayList.this.add(n, e);
                this.cursor = n + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet;
        int expectedModCount;
        final /* synthetic */ ArrayList this$0;

        private Itr(ArrayList arrayList) {
            this.this$0 = arrayList;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.lastRet = -1;
            this.expectedModCount = this.this$0.modCount;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.access$100:(Ljava/util/ArrayList;)I");
            int n = this.this$0.size;
            RuntimeCostAccounter.recordJump();
            if (this.cursor != n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.checkForComodification:()V");
            this.checkForComodification();
            int n = this.cursor;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.access$100:(Ljava/util/ArrayList;)I");
            int n2 = this.this$0.size;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            Object[] objectArray = this.this$0.elementData;
            int n3 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n3) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            this.cursor = n + 1;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.checkForComodification:()V");
            this.checkForComodification();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.remove:(I)Ljava/lang/Object;");
                this.this$0.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = this.this$0.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.access$100:(Ljava/util/ArrayList;)I");
            int n = this.this$0.size;
            int n2 = this.cursor;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) {
                return;
            }
            Object[] objectArray = this.this$0.elementData;
            int n3 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 == n) break;
                int n4 = this.this$0.modCount;
                RuntimeCostAccounter.recordJump();
                if (n4 != this.expectedModCount) break;
                Object object = objectArray[n2++];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(object);
                RuntimeCostAccounter.recordJump();
            }
            this.cursor = n2;
            this.lastRet = n2 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.checkForComodification:()V");
            this.checkForComodification();
        }

        final void checkForComodification() {
            int n = this.this$0.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        /* synthetic */ Itr(ArrayList arrayList, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList$Itr.<init>:(Ljava/util/ArrayList;)V");
            this(arrayList);
        }
    }
}

