/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.Collection;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.ListIterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.RandomAccess;
import sandbox.java.util.RandomAccessSubList;
import sandbox.java.util.SubList;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        this.modCount = 0;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.add:(ILjava/lang/Object;)V");
        this.add(n, e);
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int n, E e) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    @Override
    public void add(int n, E e) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    @Override
    public E remove(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int indexOf(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.listIterator:()Ljava/util/ListIterator;");
        ListIterator<E> listIterator = this.listIterator();
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            E e;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
                boolean bl2 = listIterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl2) return -1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                e = listIterator.next();
                RuntimeCostAccounter.recordJump();
            } while (e != null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previousIndex:()I");
            return listIterator.previousIndex();
        }
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
            boolean bl3 = listIterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl3) return -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            E e = listIterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(e);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previousIndex:()I");
        return listIterator.previousIndex();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lastIndexOf(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.listIterator:(I)Ljava/util/ListIterator;");
        ListIterator<E> listIterator = this.listIterator(n);
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            E e;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasPrevious:()Z");
                boolean bl2 = listIterator.hasPrevious();
                RuntimeCostAccounter.recordJump();
                if (!bl2) return -1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                e = listIterator.previous();
                RuntimeCostAccounter.recordJump();
            } while (e != null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.nextIndex:()I");
            return listIterator.nextIndex();
        }
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasPrevious:()Z");
            boolean bl3 = listIterator.hasPrevious();
            RuntimeCostAccounter.recordJump();
            if (!bl3) return -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
            E e = listIterator.previous();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(e);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.nextIndex:()I");
        return listIterator.nextIndex();
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.removeRange:(II)V");
        this.removeRange(0, n);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.rangeCheckForAdd:(I)V");
        this.rangeCheckForAdd(n);
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = collection.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            int n2 = n++;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.add:(ILjava/lang/Object;)V");
            this.add(n2, e);
            bl = true;
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractList$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.<init>:(Ljava/util/AbstractList;Ljava/util/AbstractList$1;)V");
        return new Itr(this, null);
    }

    @Override
    public ListIterator<E> listIterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.listIterator:(I)Ljava/util/ListIterator;");
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.rangeCheckForAdd:(I)V");
        this.rangeCheckForAdd(n);
        RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractList$ListItr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$ListItr.<init>:(Ljava/util/AbstractList;I)V");
        return new ListItr(n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        SubList subList;
        boolean bl = this instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/RandomAccessSubList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/RandomAccessSubList.<init>:(Ljava/util/AbstractList;II)V");
            subList = new RandomAccessSubList(this, n, n2);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/SubList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SubList.<init>:(Ljava/util/AbstractList;II)V");
            subList = new SubList(this, n, n2);
        }
        return subList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof List;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.listIterator:()Ljava/util/ListIterator;");
        ListIterator<E> listIterator = this.listIterator();
        List list = (List)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator listIterator2 = list.listIterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
            boolean bl2 = listIterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
            boolean bl3 = listIterator2.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl3) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            E e = listIterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            Object e2 = listIterator2.next();
            RuntimeCostAccounter.recordJump();
            if (e == null) {
                RuntimeCostAccounter.recordJump();
                if (e2 != null) return false;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl4 = e.equals(e2);
                RuntimeCostAccounter.recordJump();
                if (!bl4) {
                    return false;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
        boolean bl5 = listIterator.hasNext();
        RuntimeCostAccounter.recordJump();
        if (bl5) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
        boolean bl6 = listIterator2.hasNext();
        RuntimeCostAccounter.recordJump();
        if (bl6) return false;
        boolean bl7 = true;
        RuntimeCostAccounter.recordJump();
        return bl7;
    }

    @Override
    public int hashCode() {
        int n = 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        while (true) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordJump();
            if (e == null) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
                n2 = e.hashCode();
            }
            n = 31 * n + n2;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    protected void removeRange(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.listIterator:(I)Ljava/util/ListIterator;");
        ListIterator<E> listIterator = this.listIterator(n);
        int n3 = 0;
        int n4 = n2 - n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            listIterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.remove:()V");
            listIterator.remove();
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void rangeCheckForAdd(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
                int n2 = this.size();
                RuntimeCostAccounter.recordJump();
                if (n <= n2) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.outOfBoundsMsg:(I)Ljava/lang/String;");
            String string = this.outOfBoundsMsg(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    private String outOfBoundsMsg(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(", Size: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
        int n2 = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.<init>:(Ljava/util/AbstractList;Ljava/util/AbstractList$1;)V");
            super(AbstractList.this, null);
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.cursor != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E previous() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            try {
                int n = this.cursor - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.get:(I)Ljava/lang/Object;");
                Object e = AbstractList.this.get(n);
                this.lastRet = this.cursor = n;
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$ListItr.checkForComodification:()V");
                this.checkForComodification();
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                AbstractList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public void add(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            try {
                int n = this.cursor;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.add:(ILjava/lang/Object;)V");
                AbstractList.this.add(n, e);
                this.lastRet = -1;
                this.cursor = n + 1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet;
        int expectedModCount;
        final /* synthetic */ AbstractList this$0;

        private Itr(AbstractList abstractList) {
            this.this$0 = abstractList;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.cursor = 0;
            this.lastRet = -1;
            this.expectedModCount = this.this$0.modCount;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.size:()I");
            int n = this.this$0.size();
            RuntimeCostAccounter.recordJump();
            if (this.cursor != n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.checkForComodification:()V");
            this.checkForComodification();
            try {
                int n = this.cursor;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.get:(I)Ljava/lang/Object;");
                Object e = this.this$0.get(n);
                this.lastRet = n;
                this.cursor = n + 1;
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.checkForComodification:()V");
                this.checkForComodification();
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.checkForComodification:()V");
            this.checkForComodification();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.remove:(I)Ljava/lang/Object;");
                this.this$0.remove(this.lastRet);
                RuntimeCostAccounter.recordJump();
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = this.this$0.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
        }

        final void checkForComodification() {
            int n = this.this$0.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        /* synthetic */ Itr(AbstractList abstractList, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList$Itr.<init>:(Ljava/util/AbstractList;)V");
            this(abstractList);
        }
    }
}

