/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.Externalizable;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidClassException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.zone.ZoneOffsetTransition;
import sandbox.java.time.zone.ZoneOffsetTransitionRule;
import sandbox.java.time.zone.ZoneRules;

final class Ser
implements Externalizable {
    private static final long serialVersionUID = -8885321777449118786L;
    static final byte ZRULES = 1;
    static final byte ZOT = 2;
    static final byte ZOTRULE = 3;
    private byte type;
    private Object object;

    public Ser() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    Ser(byte by, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.type = by;
        this.object = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeInternal:(BLjava/lang/Object;Ljava/io/DataOutput;)V");
        Ser.writeInternal(this.type, this.object, objectOutput);
    }

    static void write(Object object, DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeInternal:(BLjava/lang/Object;Ljava/io/DataOutput;)V");
        Ser.writeInternal((byte)1, object, dataOutput);
    }

    private static void writeInternal(byte by, Object object, DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(by);
        switch (by) {
            case 1: {
                ZoneRules zoneRules = (ZoneRules)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.writeExternal:(Ljava/io/DataOutput;)V");
                zoneRules.writeExternal(dataOutput);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 2: {
                ZoneOffsetTransition zoneOffsetTransition = (ZoneOffsetTransition)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.writeExternal:(Ljava/io/DataOutput;)V");
                zoneOffsetTransition.writeExternal(dataOutput);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 3: {
                ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.writeExternal:(Ljava/io/DataOutput;)V");
                zoneOffsetTransitionRule.writeExternal(dataOutput);
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidClassException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidClassException.<init>:(Ljava/lang/String;)V");
                InvalidClassException invalidClassException = new InvalidClassException("Unknown serialized type");
                RuntimeCostAccounter.recordThrow();
                throw invalidClassException;
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readByte:()B");
        this.type = objectInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readInternal:(BLjava/io/DataInput;)Ljava/lang/Object;");
        this.object = Ser.readInternal(this.type, objectInput);
    }

    static Object read(DataInput dataInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readInternal:(BLjava/io/DataInput;)Ljava/lang/Object;");
        return Ser.readInternal(by, dataInput);
    }

    private static Object readInternal(byte by, DataInput dataInput) throws IOException, ClassNotFoundException {
        switch (by) {
            case 1: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.readExternal:(Ljava/io/DataInput;)Ljava/time/zone/ZoneRules;");
                return ZoneRules.readExternal(dataInput);
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.readExternal:(Ljava/io/DataInput;)Ljava/time/zone/ZoneOffsetTransition;");
                return ZoneOffsetTransition.readExternal(dataInput);
            }
            case 3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.readExternal:(Ljava/io/DataInput;)Ljava/time/zone/ZoneOffsetTransitionRule;");
                return ZoneOffsetTransitionRule.readExternal(dataInput);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
        StreamCorruptedException streamCorruptedException = new StreamCorruptedException("Unknown serialized type");
        RuntimeCostAccounter.recordThrow();
        throw streamCorruptedException;
    }

    private Object readResolve() {
        return this.object;
    }

    static void writeOffset(ZoneOffset zoneOffset, DataOutput dataOutput) throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordJump();
        if (n2 % 900 == 0) {
            n = n2 / 900;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 127;
        }
        int n3 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n3);
        RuntimeCostAccounter.recordJump();
        if (n3 == 127) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            dataOutput.writeInt(n2);
        }
    }

    static ZoneOffset readOffset(DataInput dataInput) throws IOException {
        ZoneOffset zoneOffset;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordJump();
        if (by == 127) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            int n = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(by * 900);
        }
        return zoneOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void writeEpochSec(long l, DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l >= -4575744000L) {
            RuntimeCostAccounter.recordJump();
            if (l < 10413792000L) {
                RuntimeCostAccounter.recordJump();
                if (l % 900L == 0L) {
                    int n = (int)((l + 4575744000L) / 900L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(n >>> 16 & 0xFF);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(n >>> 8 & 0xFF);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(n & 0xFF);
                    RuntimeCostAccounter.recordJump();
                    return;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(255);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeLong:(J)V");
        dataOutput.writeLong(l);
    }

    static long readEpochSec(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        int n = dataInput.readByte() & 0xFF;
        RuntimeCostAccounter.recordJump();
        if (n == 255) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readLong:()J");
            return dataInput.readLong();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        int n2 = dataInput.readByte() & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        int n3 = dataInput.readByte() & 0xFF;
        long l = (n << 16) + (n2 << 8) + n3;
        return l * 900L - 4575744000L;
    }
}

