/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTimeImpl;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.util.Comparator;
import sandbox.java.util.Objects;

public interface ChronoLocalDateTime<D extends ChronoLocalDate>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDateTime<?>> {
    public static Comparator<ChronoLocalDateTime<?>> timeLineOrder() {
        return AbstractChronology.DATE_TIME_ORDER;
    }

    public static ChronoLocalDateTime<?> from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof ChronoLocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (ChronoLocalDateTime)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoLocalDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        return chronology.localDateTime(temporalAccessor);
    }

    default public Chronology getChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        return d.getChronology();
    }

    public D toLocalDate();

    public LocalTime toLocalTime();

    @Override
    public boolean isSupported(TemporalField var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalUnit == ChronoUnit.FOREVER) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl3 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    default public ChronoLocalDateTime<D> with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.with(temporalAdjuster);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    public ChronoLocalDateTime<D> with(TemporalField var1, long var2);

    @Override
    default public ChronoLocalDateTime<D> plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.plus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    public ChronoLocalDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    default public ChronoLocalDateTime<D> minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public ChronoLocalDateTime<D> minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(l, temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public <R> R query(TemporalQuery<R> temporalQuery) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery2 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery3) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery4 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery4) break block7;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery5 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            return (R)this.toLocalTime();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery6 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
            return (R)this.getChronology();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery7 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return (R)ChronoUnit.NANOS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        Temporal temporal2 = temporal.with(ChronoField.EPOCH_DAY, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l2 = localTime.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal2.with(ChronoField.NANO_OF_DAY, l2);
    }

    default public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public ChronoZonedDateTime<D> atZone(ZoneId var1);

    default public Instant toInstant(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
        long l = this.toEpochSecond(zoneOffset);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        long l2 = localTime.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        return Instant.ofEpochSecond(l, l2);
    }

    default public long toEpochSecond(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
        long l2 = l * 86400L + (long)localTime.toSecondOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        return l2 -= (long)zoneOffset.getTotalSeconds();
    }

    @Override
    default public int compareTo(ChronoLocalDateTime<?> chronoLocalDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object obj = chronoLocalDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.compareTo:(Ljava/time/chrono/ChronoLocalDate;)I");
        int n = d.compareTo((ChronoLocalDate)obj);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoLocalDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
            n = localTime.compareTo(localTime2);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
                Chronology chronology = this.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getChronology:()Ljava/time/chrono/Chronology;");
                Chronology chronology2 = chronoLocalDateTime.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.compareTo:(Ljava/time/chrono/Chronology;)I");
                n = chronology.compareTo(chronology2);
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isAfter(ChronoLocalDateTime<?> chronoLocalDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object obj = chronoLocalDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = obj.toEpochDay();
        RuntimeCostAccounter.recordJump();
        if (l <= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l3 = localTime.toNanoOfDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoLocalDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l4 = l3 - localTime2.toNanoOfDay();
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 <= 0) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isBefore(ChronoLocalDateTime<?> chronoLocalDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object obj = chronoLocalDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = obj.toEpochDay();
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l3 = localTime.toNanoOfDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoLocalDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l4 = l3 - localTime2.toNanoOfDay();
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 >= 0) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isEqual(ChronoLocalDateTime<?> chronoLocalDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l = localTime.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime2 = chronoLocalDateTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l2 = l - localTime2.toNanoOfDay();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 != false) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l4 = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object obj = chronoLocalDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l5 = l4 - obj.toEpochDay();
        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l6 != false) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

