/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.Month;
import sandbox.java.time.MonthDay;
import sandbox.java.time.Ser;
import sandbox.java.time.YearMonth;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.format.SignStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

public final class Year
implements Temporal,
TemporalAdjuster,
Comparable<Year>,
Serializable {
    public static final int MIN_VALUE = -999999999;
    public static final int MAX_VALUE = 999999999;
    private static final long serialVersionUID = -23038383694477807L;
    private static final DateTimeFormatter PARSER;
    private final int year;

    public static Year now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.now:(Ljava/time/Clock;)Ljava/time/Year;");
        return Year.now(clock);
    }

    public static Year now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.now:(Ljava/time/Clock;)Ljava/time/Year;");
        return Year.now(clock);
    }

    public static Year now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        int n = localDate.getYear();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
        return Year.of(n);
    }

    public static Year of(int n) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordAllocation((String)"java/time/Year");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.<init>:(I)V");
        return new Year(n);
    }

    public static Year from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof Year;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (Year)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
            Chronology chronology = Chronology.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = IsoChronology.INSTANCE.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n = temporalAccessor.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
            return Year.of(n);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain Year from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static Year parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/Year;");
        return Year.parse(charSequence, PARSER);
    }

    public static Year parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<Year> temporalQuery = Year::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLeap(long l) {
        RuntimeCostAccounter.recordJump();
        if ((l & 3L) != 0L) return false;
        RuntimeCostAccounter.recordJump();
        if (l % 100L == 0L) {
            RuntimeCostAccounter.recordJump();
            if (l % 400L != 0L) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    private Year(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.year = n;
    }

    public int getValue() {
        return this.year;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField != ChronoField.YEAR) {
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.YEAR_OF_ERA) {
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.ERA) return false;
                }
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl3 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalUnit != ChronoUnit.YEARS) {
                RuntimeCostAccounter.recordJump();
                if (temporalUnit != ChronoUnit.DECADES) {
                    RuntimeCostAccounter.recordJump();
                    if (temporalUnit != ChronoUnit.CENTURIES) {
                        RuntimeCostAccounter.recordJump();
                        if (temporalUnit != ChronoUnit.MILLENNIA) {
                            RuntimeCostAccounter.recordJump();
                            if (temporalUnit != ChronoUnit.ERAS) return false;
                        }
                    }
                }
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl3 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.YEAR_OF_ERA) {
            ValueRange valueRange;
            RuntimeCostAccounter.recordJump();
            if (this.year <= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                valueRange = ValueRange.of(1L, 1000000000L);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                valueRange = ValueRange.of(1L, 999999999L);
            }
            return valueRange;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        n = 1 - this.year;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.year;
                    }
                    return n;
                }
                case 2: {
                    return this.year;
                }
                case 3: {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        n = 0;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 1;
                    }
                    return n;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    public boolean isLeap() {
        long l = this.year;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.isLeap:(J)Z");
        return Year.isLeap(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidMonthDay(MonthDay monthDay) {
        RuntimeCostAccounter.recordJump();
        if (monthDay == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.isValidYear:(I)Z");
        boolean bl = monthDay.isValidYear(this.year);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int length() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.isLeap:()Z");
        boolean bl = this.isLeap();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 366;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 365;
        }
        return n;
    }

    @Override
    public Year with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Year)temporalAdjuster.adjustInto(this);
    }

    @Override
    public Year with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
            chronoField.checkValidValue(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    long l2;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        l2 = 1L - l;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l2 = l;
                    }
                    int n = (int)l2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
                    return Year.of(n);
                }
                case 2: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
                    return Year.of(n);
                }
                case 3: {
                    Year year;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l3 = this.getLong(ChronoField.ERA) - l;
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l4 == false) {
                        year = this;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
                        year = Year.of(1 - this.year);
                    }
                    return year;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    @Override
    public Year plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Year)temporalAmount.addTo(this);
    }

    @Override
    public Year plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
                    return this.plusYears(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l2 = Math.multiplyExact(l, 10L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
                    return this.plusYears(l2);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l3 = Math.multiplyExact(l, 100L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
                    return this.plusYears(l3);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l4 = Math.multiplyExact(l, 1000L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
                    return this.plusYears(l4);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l5 = this.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                    long l6 = Math.addExact(l5, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/Year;");
                    return this.with(ChronoField.ERA, l6);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public Year plusYears(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.YEAR.checkValidIntValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
        return Year.of(n);
    }

    @Override
    public Year minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Year)temporalAmount.subtractFrom(this);
    }

    @Override
    public Year minus(long l, TemporalUnit temporalUnit) {
        Year year;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Year;");
            Year year2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Year;");
            year = year2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Year;");
            year = this.plus(l2, temporalUnit);
        }
        return year;
    }

    public Year minusYears(long l) {
        Year year;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
            Year year2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
            year = year2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.plusYears:(J)Ljava/time/Year;");
            year = this.plusYears(l2);
        }
        return year;
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery2 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            return (R)IsoChronology.INSTANCE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery3 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery3) {
            return (R)ChronoUnit.YEARS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
        Chronology chronology = Chronology.from(temporal);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl = chronology.equals(IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Adjustment only supported on ISO date-time");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        long l = this.year;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.YEAR, l);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/Year;");
        Year year = Year.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            long l = (long)year.year - (long)this.year;
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    return l;
                }
                case 2: {
                    return l / 10L;
                }
                case 3: {
                    return l / 100L;
                }
                case 4: {
                    return l / 1000L;
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l2 = year.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.getLong:(Ljava/time/temporal/TemporalField;)J");
                    return l2 - this.getLong(ChronoField.ERA);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, year);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public LocalDate atDay(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        return LocalDate.ofYearDay(this.year, n);
    }

    public YearMonth atMonth(Month month) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(ILjava/time/Month;)Ljava/time/YearMonth;");
        return YearMonth.of(this.year, month);
    }

    public YearMonth atMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(II)Ljava/time/YearMonth;");
        return YearMonth.of(this.year, n);
    }

    public LocalDate atMonthDay(MonthDay monthDay) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.atYear:(I)Ljava/time/LocalDate;");
        return monthDay.atYear(this.year);
    }

    @Override
    public int compareTo(Year year) {
        return this.year - year.year;
    }

    public boolean isAfter(Year year) {
        boolean bl;
        int n = year.year;
        RuntimeCostAccounter.recordJump();
        if (this.year > n) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(Year year) {
        boolean bl;
        int n = year.year;
        RuntimeCostAccounter.recordJump();
        if (this.year < n) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof Year;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            int n = ((Year)object).year;
            RuntimeCostAccounter.recordJump();
            if (this.year == n) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
        return Integer.toString(this.year);
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(11, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.year);
    }

    static Year readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.of:(I)Ljava/time/Year;");
        return Year.of(n);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:()Ljava/time/format/DateTimeFormatter;");
        PARSER = dateTimeFormatterBuilder2.toFormatter();
    }
}

