/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.Ser;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeParseException;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Objects;
import sandbox.java.util.regex.Matcher;
import sandbox.java.util.regex.Pattern;

public final class Period
implements ChronoPeriod,
Serializable {
    public static final Period ZERO;
    private static final long serialVersionUID = -3587258372562876L;
    private static final Pattern PATTERN;
    private static final List<TemporalUnit> SUPPORTED_UNITS;
    private final int years;
    private final int months;
    private final int days;

    public static Period ofYears(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n, 0, 0);
    }

    public static Period ofMonths(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(0, n, 0);
    }

    public static Period ofWeeks(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n2 = Math.multiplyExact(n, 7);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(0, 0, n2);
    }

    public static Period ofDays(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(0, 0, n);
    }

    public static Period of(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n, n2, n3);
    }

    public static Period from(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (Period)temporalAmount;
        }
        boolean bl2 = temporalAmount instanceof ChronoPeriod;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            ChronoPeriod chronoPeriod = (ChronoPeriod)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriod.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology = chronoPeriod.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.equals:(Ljava/lang/Object;)Z");
            boolean bl3 = IsoChronology.INSTANCE.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Period requires ISO chronology: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(temporalAmount);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amount");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.getUnits:()Ljava/util/List;");
        List<TemporalUnit> list = temporalAmount.getUnits();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
        Iterator<TemporalUnit> iterator = list.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl4 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            TemporalUnit temporalUnit = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.get:(Ljava/time/temporal/TemporalUnit;)J");
            long l = temporalAmount.get(temporalUnit);
            RuntimeCostAccounter.recordJump();
            if (temporalUnit == ChronoUnit.YEARS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                n = Math.toIntExact(l);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (temporalUnit == ChronoUnit.MONTHS) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                    n2 = Math.toIntExact(l);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (temporalUnit == ChronoUnit.DAYS) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                        n3 = Math.toIntExact(l);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Unit must be Years, Months or Days, but was ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(temporalUnit);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder5.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n, n2, n3);
    }

    public static Period parse(CharSequence charSequence) {
        block7: {
            String string;
            String string2;
            String string3;
            String string4;
            int n;
            block8: {
                int n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(charSequence, "text");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.matcher:(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
                Matcher matcher = PATTERN.matcher(charSequence);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.matches:()Z");
                boolean bl = matcher.matches();
                RuntimeCostAccounter.recordJump();
                if (!bl) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string5 = matcher.group(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = "-".equals(string5);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    n2 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n2 = 1;
                }
                n = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string4 = matcher.group(2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string3 = matcher.group(3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string2 = matcher.group(4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string = matcher.group(5);
                RuntimeCostAccounter.recordJump();
                if (string4 != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string3 != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string2 == null) break block7;
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;I)I");
                int n3 = Period.parseNumber(charSequence, string4, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;I)I");
                int n4 = Period.parseNumber(charSequence, string3, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;I)I");
                int n5 = Period.parseNumber(charSequence, string2, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;I)I");
                int n6 = Period.parseNumber(charSequence, string, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
                int n7 = Math.multiplyExact(n5, 7);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
                n6 = Math.addExact(n6, n7);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
                return Period.create(n3, n4, n6);
            }
            catch (NumberFormatException numberFormatException) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;ILjava/lang/Throwable;)V");
                DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0, numberFormatException);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeParseException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
        DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0);
        RuntimeCostAccounter.recordThrow();
        throw dateTimeParseException;
    }

    private static int parseNumber(CharSequence charSequence, String string, int n) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
        int n2 = Integer.parseInt(string);
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
            return Math.multiplyExact(n2, n);
        }
        catch (ArithmeticException arithmeticException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;ILjava/lang/Throwable;)V");
            DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0, arithmeticException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
    }

    public static Period between(LocalDate localDate, LocalDate localDate2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.until:(Ljava/time/chrono/ChronoLocalDate;)Ljava/time/Period;");
        return localDate.until(localDate2);
    }

    private static Period create(int n, int n2, int n3) {
        RuntimeCostAccounter.recordJump();
        if ((n | n2 | n3) == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/Period");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.<init>:(III)V");
        return new Period(n, n2, n3);
    }

    private Period(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.YEARS) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getYears:()I");
            return this.getYears();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.MONTHS) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getMonths:()I");
            return this.getMonths();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.DAYS) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getDays:()I");
            return this.getDays();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
        UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
        RuntimeCostAccounter.recordThrow();
        throw unsupportedTemporalTypeException;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public IsoChronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    public boolean isZero() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this == ZERO) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNegative() {
        RuntimeCostAccounter.recordJump();
        if (this.years >= 0) {
            RuntimeCostAccounter.recordJump();
            if (this.months >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.days >= 0) return false;
            }
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Period withYears(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == this.years) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n, this.months, this.days);
    }

    public Period withMonths(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == this.months) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(this.years, n, this.days);
    }

    public Period withDays(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == this.days) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(this.years, this.months, n);
    }

    @Override
    public Period plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.from:(Ljava/time/temporal/TemporalAmount;)Ljava/time/Period;");
        Period period = Period.from(temporalAmount);
        int n = period.years;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n2 = Math.addExact(this.years, n);
        int n3 = period.months;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n4 = Math.addExact(this.months, n3);
        int n5 = period.days;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n6 = Math.addExact(this.days, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n2, n4, n6);
    }

    public Period plusYears(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = this.years;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(l2, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        int n = Math.toIntExact(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n, this.months, this.days);
    }

    public Period plusMonths(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = this.months;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(l2, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        int n = Math.toIntExact(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(this.years, n, this.days);
    }

    public Period plusDays(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = this.days;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(l2, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        int n = Math.toIntExact(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(this.years, this.months, n);
    }

    @Override
    public Period minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.from:(Ljava/time/temporal/TemporalAmount;)Ljava/time/Period;");
        Period period = Period.from(temporalAmount);
        int n = period.years;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n2 = Math.subtractExact(this.years, n);
        int n3 = period.months;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n4 = Math.subtractExact(this.months, n3);
        int n5 = period.days;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n6 = Math.subtractExact(this.days, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n2, n4, n6);
    }

    public Period minusYears(long l) {
        Period period;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusYears:(J)Ljava/time/Period;");
            Period period2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusYears:(J)Ljava/time/Period;");
            period = period2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusYears:(J)Ljava/time/Period;");
            period = this.plusYears(l2);
        }
        return period;
    }

    public Period minusMonths(long l) {
        Period period;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusMonths:(J)Ljava/time/Period;");
            Period period2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusMonths:(J)Ljava/time/Period;");
            period = period2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusMonths:(J)Ljava/time/Period;");
            period = this.plusMonths(l2);
        }
        return period;
    }

    public Period minusDays(long l) {
        Period period;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusDays:(J)Ljava/time/Period;");
            Period period2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusDays:(J)Ljava/time/Period;");
            period = period2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.plusDays:(J)Ljava/time/Period;");
            period = this.plusDays(l2);
        }
        return period;
    }

    @Override
    public Period multipliedBy(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (this == ZERO) break block2;
                RuntimeCostAccounter.recordJump();
                if (n != 1) break block3;
            }
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n2 = Math.multiplyExact(this.years, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n3 = Math.multiplyExact(this.months, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n4 = Math.multiplyExact(this.days, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n2, n3, n4);
    }

    @Override
    public Period negated() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.multipliedBy:(I)Ljava/time/Period;");
        return this.multipliedBy(-1);
    }

    @Override
    public Period normalized() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.toTotalMonths:()J");
        long l = this.toTotalMonths();
        long l2 = l / 12L;
        int n = (int)(l % 12L);
        long l3 = l2 - (long)this.years;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 == false) {
            RuntimeCostAccounter.recordJump();
            if (n == this.months) {
                return this;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        int n2 = Math.toIntExact(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.create:(III)Ljava/time/Period;");
        return Period.create(n2, n, this.days);
    }

    public long toTotalMonths() {
        return (long)this.years * 12L + (long)this.months;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.validateChrono:(Ljava/time/temporal/TemporalAccessor;)V");
        this.validateChrono(temporal);
        RuntimeCostAccounter.recordJump();
        if (this.months == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.years != 0) {
                long l = this.years;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.plus(l, ChronoUnit.YEARS);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.toTotalMonths:()J");
            long l = this.toTotalMonths();
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.plus(l, ChronoUnit.MONTHS);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            long l = this.days;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.plus(l, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.validateChrono:(Ljava/time/temporal/TemporalAccessor;)V");
        this.validateChrono(temporal);
        RuntimeCostAccounter.recordJump();
        if (this.months == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.years != 0) {
                long l = this.years;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.minus(l, ChronoUnit.YEARS);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.toTotalMonths:()J");
            long l = this.toTotalMonths();
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.minus(l, ChronoUnit.MONTHS);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            long l = this.days;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.minus(l, ChronoUnit.DAYS);
        }
        return temporal;
    }

    private void validateChrono(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.equals:(Ljava/lang/Object;)Z");
            boolean bl = IsoChronology.INSTANCE.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Chronology mismatch, expected: ISO, actual: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                String string = chronology.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string2);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        Period period = (Period)object;
        int n = period.years;
        RuntimeCostAccounter.recordJump();
        if (this.years != n) return false;
        int n2 = period.months;
        RuntimeCostAccounter.recordJump();
        if (this.months != n2) return false;
        int n3 = period.days;
        RuntimeCostAccounter.recordJump();
        if (this.days != n3) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        int n = this.years + Integer.rotateLeft(this.months, 8);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        return n + Integer.rotateLeft(this.days, 16);
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordJump();
        if (this == ZERO) {
            return "P0D";
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('P');
        RuntimeCostAccounter.recordJump();
        if (this.years != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(this.years);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder2.append('Y');
        }
        RuntimeCostAccounter.recordJump();
        if (this.months != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(this.months);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append('M');
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append(this.days);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder4.append('D');
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(14, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.years);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.months);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.days);
    }

    static Period readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n2 = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n3 = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.of:(III)Ljava/time/Period;");
        return Period.of(n, n2, n3);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Period");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.<init>:(III)V");
        ZERO = new Period(0, 0, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;I)Ljava/util/regex/Pattern;");
        PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?", 2);
        RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
        TemporalUnit[] temporalUnitArray = new TemporalUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        List<TemporalUnit> list = Arrays.asList(temporalUnitArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
        SUPPORTED_UNITS = Collections.unmodifiableList(list);
    }
}

