/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.Writer;

public class StringWriter
extends Writer {
    private StringBuffer buf;

    public StringWriter() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        this.buf = new StringBuffer();
        this.lock = this.buf;
    }

    public StringWriter(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative buffer size");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(I)V");
        this.buf = new StringBuffer(n);
        this.lock = this.buf;
    }

    @Override
    public void write(int n) {
        char c = (char)n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
        this.buf.append(c);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                int n3 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n > n3) break block4;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block4;
                int n4 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n + n2 > n4) break block4;
                RuntimeCostAccounter.recordJump();
                if (n + n2 >= 0) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
        this.buf.append(cArray, n, n2);
    }

    @Override
    public void write(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        this.buf.append(string);
    }

    @Override
    public void write(String string, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        String string2 = string.substring(n, n + n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        this.buf.append(string2);
    }

    @Override
    public StringWriter append(CharSequence charSequence) {
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StringWriter.write:(Ljava/lang/String;)V");
            this.write("null");
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            String string = charSequence.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StringWriter.write:(Ljava/lang/String;)V");
            this.write(string);
        }
        return this;
    }

    @Override
    public StringWriter append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2;
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            charSequence2 = "null";
            RuntimeCostAccounter.recordJump();
        } else {
            charSequence2 = charSequence;
        }
        CharSequence charSequence3 = charSequence2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence4 = charSequence3.subSequence(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        String string = charSequence4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StringWriter.write:(Ljava/lang/String;)V");
        this.write(string);
        return this;
    }

    @Override
    public StringWriter append(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StringWriter.write:(I)V");
        this.write(c);
        return this;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return this.buf.toString();
    }

    public StringBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

