/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.IOException;
import sandbox.java.nio.CharBuffer;

public abstract class Reader
implements Readable,
Closeable {
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer;

    protected Reader() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.skipBuffer = null;
        this.lock = this;
    }

    protected Reader(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.skipBuffer = null;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.lock = object;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.remaining:()I");
        int n2 = n = charBuffer.remaining();
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        char[] cArray = new char[n2];
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
        int n3 = this.read(cArray, 0, n);
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.put:([CII)Ljava/nio/CharBuffer;");
            charBuffer.put(cArray, 0, n3);
        }
        return n3;
    }

    public int read() throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)2);
        char[] cArray = new char[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
        int n = this.read(cArray, 0, 1);
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        int n = cArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
        return this.read(cArray, 0, n);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("skip value is negative");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        int n = (int)Math.min(l, 8192L);
        Object object = this.lock;
        try {
            block9: {
                block8: {
                    RuntimeCostAccounter.recordJump();
                    if (this.skipBuffer == null) break block8;
                    int n2 = this.skipBuffer.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break block9;
                }
                int n3 = n;
                RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)2);
                this.skipBuffer = new char[n3];
            }
            long l2 = l;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) break;
                long l3 = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
                int n4 = (int)Math.min(l2, l3);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
                int n5 = this.read(this.skipBuffer, 0, n4);
                RuntimeCostAccounter.recordJump();
                if (n5 == -1) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                l2 -= (long)n5;
                RuntimeCostAccounter.recordJump();
            }
            return l - l2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark() not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    public void reset() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("reset() not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    @Override
    public abstract void close() throws IOException;
}

