/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Label;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.common.reflection.ASMUtil;
import co.paralleluniverse.common.util.ExtendedStackTraceClassContext;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.ExtendedStackTraceHotSpot;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class ExtendedStackTrace
implements Iterable<ExtendedStackTraceElement> {
    protected final Throwable t;
    private ExtendedStackTraceElement[] est;

    public static ExtendedStackTrace of(Throwable t) {
        try {
            return new ExtendedStackTraceHotSpot(t);
        }
        catch (Throwable e) {
            return new ExtendedStackTrace(t);
        }
    }

    public static ExtendedStackTrace here() {
        try {
            return new ExtendedStackTraceHotSpot(new Throwable());
        }
        catch (Throwable e) {
            return new ExtendedStackTraceClassContext();
        }
    }

    protected ExtendedStackTrace(Throwable t) {
        this.t = t;
    }

    @Override
    public Iterator<ExtendedStackTraceElement> iterator() {
        return Arrays.asList(this.get()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedStackTraceElement[] get() {
        ExtendedStackTrace extendedStackTrace = this;
        synchronized (extendedStackTrace) {
            StackTraceElement[] st;
            if (this.est == null && (st = this.t.getStackTrace()) != null) {
                this.est = new ExtendedStackTraceElement[st.length];
                for (int i = 0; i < st.length; ++i) {
                    this.est[i] = new BasicExtendedStackTraceElement(st[i]);
                }
            }
            return this.est;
        }
    }

    protected Member getMethod(final ExtendedStackTraceElement este) {
        Member method;
        block7: {
            if (este.getDeclaringClass() == null) {
                return null;
            }
            Member[] ms = this.getMethods(este.getDeclaringClass());
            method = null;
            for (Member m : ms) {
                if (!este.getMethodName().equals(m.getName())) continue;
                if (method == null) {
                    method = m;
                    continue;
                }
                method = null;
                break;
            }
            if (method == null && este.getLineNumber() >= 0) {
                try {
                    final AtomicReference descriptor = new AtomicReference();
                    ASMUtil.accept(este.getDeclaringClass(), 4, new ClassVisitor(327680){

                        @Override
                        public MethodVisitor visitMethod(int access, String name, final String desc, String signature, String[] exceptions) {
                            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                            if (descriptor.get() == null && este.getMethodName().equals(name)) {
                                mv = new MethodVisitor(this.api, mv){
                                    int minLine;
                                    int maxLine;
                                    {
                                        super(x0, x1);
                                        this.minLine = Integer.MAX_VALUE;
                                        this.maxLine = Integer.MIN_VALUE;
                                    }

                                    @Override
                                    public void visitLineNumber(int line, Label start) {
                                        if (line < this.minLine) {
                                            this.minLine = line;
                                        }
                                        if (line > this.maxLine) {
                                            this.maxLine = line;
                                        }
                                    }

                                    @Override
                                    public void visitEnd() {
                                        if (this.minLine <= este.getLineNumber() && this.maxLine >= este.getLineNumber()) {
                                            descriptor.set(desc);
                                        }
                                        super.visitEnd();
                                    }
                                };
                            }
                            return mv;
                        }
                    });
                    if (descriptor.get() == null) break block7;
                    String desc = (String)descriptor.get();
                    for (Member m : ms) {
                        if (!este.getMethodName().equals(ExtendedStackTrace.getName(m)) || !desc.equals(ExtendedStackTrace.getDescriptor(m))) continue;
                        method = m;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return method;
    }

    protected static final String getName(Member m) {
        if (m instanceof Constructor) {
            return "<init>";
        }
        return ((Method)m).getName();
    }

    protected static final String getDescriptor(Member m) {
        if (m instanceof Constructor) {
            return Type.getConstructorDescriptor((Constructor)m);
        }
        return Type.getMethodDescriptor((Method)m);
    }

    protected final Member[] getMethods(Class<?> clazz) {
        Method[] ms = clazz.getDeclaredMethods();
        Constructor<?>[] cs = clazz.getDeclaredConstructors();
        Member[] es = new Member[ms.length + cs.length];
        System.arraycopy(cs, 0, es, 0, cs.length);
        System.arraycopy(ms, 0, es, cs.length, ms.length);
        return es;
    }

    protected class BasicExtendedStackTraceElement
    extends ExtendedStackTraceElement {
        protected BasicExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz, Method method, int bci) {
            super(ste, clazz, method, bci);
        }

        protected BasicExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz) {
            super(ste, clazz, null, -1);
        }

        protected BasicExtendedStackTraceElement(StackTraceElement ste) {
            super(ste, null, null, -1);
        }

        @Override
        public Member getMethod() {
            if (this.method == null) {
                this.method = ExtendedStackTrace.this.getMethod(this);
                if (this.method != null && !this.getMethodName().equals(ExtendedStackTrace.getName(this.method))) {
                    throw new IllegalStateException("Method name mismatch: " + this.getMethodName() + ", " + this.method.getName());
                }
            }
            return this.method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (this.clazz == null) {
                try {
                    this.clazz = Class.forName(this.getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.clazz;
        }
    }
}

