/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class SimpleMBean {
    protected final String name;
    private volatile boolean registered = false;

    public SimpleMBean(String product, String name, String monitor, String kind) {
        this.name = "co.paralleluniverse:" + (product != null ? "type=" + product + "," : "") + "name=" + name + (monitor != null ? ",monitor=" + monitor : "") + (kind != null ? ",kind=" + kind : "");
    }

    protected void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.name);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void unregisterMBean() {
        try {
            if (this.registered) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.name));
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

