/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Handle;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.common.reflection.ClassLoaderUtil;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SimpleSuspendableClassifier;
import com.google.common.base.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SuspendablesScanner
extends Task {
    private static final int ASMAPI = 327680;
    private final Map<String, MethodNode> methods = new HashMap<String, MethodNode>();
    private final Map<String, ClassNode> classes = new HashMap<String, ClassNode>();
    private final Set<MethodNode> knownSuspendablesOrSupers = new HashSet<MethodNode>();
    private final boolean ant;
    private URLClassLoader cl;
    private final ArrayList<FileSet> filesets = new ArrayList();
    private final Path projectDir;
    private URL[] urls;
    private SimpleSuspendableClassifier ssc;
    private boolean auto = true;
    private boolean append = false;
    private String supersFile;
    private String suspendablesFile;

    public SuspendablesScanner() {
        this.ant = ((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader;
        this.projectDir = null;
    }

    public SuspendablesScanner(Path projectDir) {
        this.ant = ((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader;
        this.projectDir = projectDir;
        assert (!this.ant);
    }

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setSuspendablesFile(String outputFile) {
        this.suspendablesFile = outputFile;
    }

    public void setSupersFile(String outputFile) {
        this.supersFile = outputFile;
    }

    public void setAuto(boolean value) {
        this.auto = value;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    void setURLs(List<URL> urls) {
        this.urls = SuspendablesScanner.unique(urls).toArray(new URL[0]);
        this.cl = new URLClassLoader(this.urls);
        this.ssc = new SimpleSuspendableClassifier(this.cl);
    }

    private static <T> List<T> unique(List<T> list) {
        return new ArrayList<T>(new LinkedHashSet<T>(list));
    }

    public void execute() throws BuildException {
        try {
            this.run();
            this.log("OUTPUT: " + this.supersFile, 2);
            this.log("OUTPUT: " + this.suspendablesFile, 2);
            ArrayList<String> suspendables = this.suspendablesFile != null ? new ArrayList<String>() : null;
            ArrayList<String> suspendableSupers = this.supersFile != null ? new ArrayList<String>() : null;
            this.putSuspendablesAndSupers(suspendables, suspendableSupers);
            if (this.suspendablesFile != null) {
                Collections.sort(suspendables);
                SuspendablesScanner.outputResults(this.suspendablesFile, this.append, suspendables);
            }
            if (this.supersFile != null) {
                Collections.sort(suspendableSupers);
                SuspendablesScanner.outputResults(this.supersFile, this.append, suspendableSupers);
            }
        }
        catch (Exception e) {
            this.log(e, 0);
            throw new BuildException((Throwable)e);
        }
    }

    public void run() {
        try {
            ArrayList<URL> us = new ArrayList<URL>();
            if (this.ant) {
                AntClassLoader acl = (AntClassLoader)((Object)((Object)this)).getClass().getClassLoader();
                SuspendablesScanner.classpathToUrls(acl.getClasspath().split(System.getProperty("path.separator")), us);
                for (FileSet fs : this.filesets) {
                    us.add(fs.getDir().toURI().toURL());
                }
            } else {
                URLClassLoader ucl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
                us.addAll(Arrays.asList(ucl.getURLs()));
            }
            this.setURLs(us);
            this.log("Classpath URLs: " + Arrays.toString(this.urls), 2);
            ArrayList<URL> pus = new ArrayList<URL>();
            if (this.ant) {
                for (FileSet fs : this.filesets) {
                    pus.add(fs.getDir().toURI().toURL());
                }
            } else {
                pus.add(this.projectDir.toUri().toURL());
            }
            this.log("Project URLs: " + pus, 2);
            long tStart = System.nanoTime();
            this.scanExternalSuspendables();
            long tScanExternal = System.nanoTime();
            if (this.auto) {
                this.log("Scanned external suspendables in " + (tScanExternal - tStart) / 1000000L + " ms", 2);
            }
            Function<InputStream, Void> fileVisitor = new Function<InputStream, Void>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Void apply(InputStream is1) {
                    try (InputStream is = is1;){
                        SuspendablesScanner.this.createGraph(is);
                        Void void_ = null;
                        return void_;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            if (this.ant) {
                this.visitAntProject(fileVisitor);
            } else {
                this.visitProjectDir(fileVisitor);
            }
            this.scanSuspendablesFile(fileVisitor);
            long tBuildGraph = System.nanoTime();
            this.log("Built method graph in " + (tBuildGraph - tScanExternal) / 1000000L + " ms", 2);
            this.walkGraph();
            long tWalkGraph = System.nanoTime();
            this.log("Walked method graph in " + (tWalkGraph - tBuildGraph) / 1000000L + " ms", 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanExternalSuspendables() throws IOException {
        ClassLoaderUtil.accept(this.cl, new ClassLoaderUtil.Visitor(){

            @Override
            public void visit(String resource, URL url, ClassLoader cl) throws IOException {
                if (resource.startsWith("java/util") || resource.startsWith("java/lang") || resource.startsWith("co/paralleluniverse/asm")) {
                    return;
                }
                if (ClassLoaderUtil.isClassFile(url.getFile())) {
                    try (InputStream is = cl.getResourceAsStream(resource);){
                        new ClassReader(is).accept(new SuspendableClassifier(false, 327680, null), 3);
                    }
                    catch (Exception e) {
                        System.err.println("Exception thrown during processing of " + resource + " at " + url);
                        throw e;
                    }
                }
            }
        });
    }

    private void visitAntProject(Function<InputStream, Void> classFileVisitor) throws IOException {
        for (FileSet fs : this.filesets) {
            try {
                String[] includedFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String filename : includedFiles = ds.getIncludedFiles()) {
                    if (!ClassLoaderUtil.isClassFile(filename)) continue;
                    try {
                        File file = new File(fs.getDir(), filename);
                        if (file.isFile()) {
                            classFileVisitor.apply((Object)new FileInputStream(file));
                            continue;
                        }
                        this.log("File not found: " + filename);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while processing " + filename, e);
                    }
                }
            }
            catch (BuildException ex) {
                this.log(ex.getMessage(), ex, 1);
            }
        }
    }

    private void visitProjectDir(final Function<InputStream, Void> classFileVisitor) throws IOException {
        Files.walkFileTree(this.projectDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if (ClassLoaderUtil.isClassFile(file.getFileName().toString())) {
                        classFileVisitor.apply((Object)Files.newInputStream(file, new OpenOption[0]));
                    }
                    return FileVisitResult.CONTINUE;
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing " + file, e);
                }
            }
        });
    }

    private void scanSuspendablesFile(Function<InputStream, Void> classFileVisitor) {
        if (this.suspendablesFile != null) {
            SimpleSuspendableClassifier tssc = new SimpleSuspendableClassifier(this.suspendablesFile);
            HashSet<String> cs = new HashSet<String>();
            cs.addAll(tssc.getSuspendableClasses());
            for (String susMethod : tssc.getSuspendables()) {
                cs.add(susMethod.substring(0, susMethod.indexOf(46)));
            }
            for (String className : cs) {
                try {
                    this.log("Scanning suspendable class:" + className, 3);
                    classFileVisitor.apply((Object)this.cl.getResourceAsStream(ClassLoaderUtil.classToResource(className)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing " + className, e);
                }
            }
        }
    }

    private void createGraph(InputStream classStream) throws IOException {
        ClassReader cr = new ClassReader(classStream);
        ClassVisitor cv = null;
        cv = new SuspendableClassifier(true, 327680, cv);
        cv = new ClassNodeVisitor(true, 327680, cv);
        if (this.auto) {
            cv = new CallGraphVisitor(true, 327680, cv);
        }
        cr.accept(cv, 2 | (this.auto ? 0 : 1));
    }

    private void walkGraph() {
        ArrayDeque<MethodNode> q = new ArrayDeque<MethodNode>();
        q.addAll(this.knownSuspendablesOrSupers);
        while (!q.isEmpty()) {
            MethodNode m = (MethodNode)q.poll();
            if (m.inProject) {
                this.followBridges(q, this.getClassNode(m), m);
                this.followSupers(q, this.getClassNode(m), m);
            }
            this.followNonOverriddenSubs(q, this.getClassNode(m), m);
            this.followCallers(q, m);
        }
    }

    private void followBridges(Queue<MethodNode> q, ClassNode cls, MethodNode method) {
        this.log("followBridges " + method + " " + cls, 4);
        if (cls == null) {
            return;
        }
        if (method.suspendType == MethodDatabase.SuspendableType.NON_SUSPENDABLE) {
            return;
        }
        List<String> bridges = cls.getMethodWithDifferentReturn(method.name);
        for (String m1 : bridges) {
            if (method.name.equals(m1)) continue;
            MethodNode m = this.getOrCreateMethodNode(cls.name + '.' + m1);
            if (m.suspendType == MethodDatabase.SuspendableType.SUSPENDABLE || m.suspendType == MethodDatabase.SuspendableType.SUSPENDABLE_SUPER) continue;
            m.setSuspendType(MethodDatabase.SuspendableType.SUSPENDABLE_SUPER);
            m.inProject = method.inProject;
            q.add(m);
        }
    }

    private boolean followSupers(Queue<MethodNode> q, ClassNode cls, MethodNode method) {
        this.log("followSupers " + method + " " + cls, 4);
        if (cls == null) {
            return false;
        }
        if (method.suspendType == MethodDatabase.SuspendableType.NON_SUSPENDABLE || method.setBySuper) {
            return false;
        }
        boolean foundMethod = false;
        if (cls.hasMethod(method.name) && method.classNode != cls) {
            MethodNode m1 = this.methods.get((cls.name + '.' + method.name).intern());
            if (m1 != null && m1.suspendType == MethodDatabase.SuspendableType.NON_SUSPENDABLE) {
                return false;
            }
            if (m1 == null || m1.suspendType == null) {
                this.log("Found parent of suspendable method: " + method.owner + '.' + method.name + " in " + cls.name + (cls.inProject ? "" : " NOT IN PROJECT"), cls.inProject ? 3 : 1);
                MethodNode m = this.getOrCreateMethodNode(cls.name + '.' + method.name);
                m.setSuspendType(MethodDatabase.SuspendableType.SUSPENDABLE_SUPER);
                q.add(m);
                foundMethod = true;
            }
        }
        boolean methodInParent = false;
        for (ClassNode s : cls.supers) {
            methodInParent |= this.followSupers(q, this.fill(s), method);
        }
        if (!foundMethod && methodInParent) {
            this.log("Found parent of suspendable method in a parent of: " + method.owner + '.' + method.name + " in " + cls.name + (cls.inProject ? "" : " NOT IN PROJECT"), cls.inProject ? 3 : 1);
        }
        return foundMethod || methodInParent;
    }

    private void followNonOverriddenSubs(Queue<MethodNode> q, ClassNode cls, MethodNode method) {
        this.log("followNonOverriddenSubs " + method + " " + cls, 4);
        if (cls == null) {
            return;
        }
        if (method.suspendType == MethodDatabase.SuspendableType.NON_SUSPENDABLE) {
            return;
        }
        if (cls.subs != null) {
            for (ClassNode s : cls.subs) {
                if (s == null || s.hasMethod(method.name) || !s.inProject) continue;
                MethodNode sm = this.getOrCreateMethodNode(s.name + '.' + method.name);
                sm.inProject = true;
                sm.refersToSuper = true;
                if (!sm.inProject || sm.suspendType != null) continue;
                sm.setSuspendType(method.suspendType);
                sm.setBySuper = true;
                q.add(sm);
                this.followNonOverriddenSubs(q, s, sm);
            }
        }
    }

    private void followCallers(Queue<MethodNode> q, MethodNode method) {
        for (MethodNode caller : method.getCallers()) {
            if (caller.suspendType != null) continue;
            q.add(caller);
            this.log("Marking " + caller + " suspendable because it calls " + method, 3);
            caller.setSuspendType(MethodDatabase.SuspendableType.SUSPENDABLE);
        }
    }

    public void putSuspendablesAndSupers(Collection<String> suspendables, Collection<String> suspendableSupers) {
        for (MethodNode method : this.methods.values()) {
            if (method.known) continue;
            if (method.suspendType == MethodDatabase.SuspendableType.SUSPENDABLE && !method.refersToSuper && suspendables != null) {
                suspendables.add(SuspendablesScanner.output(method));
                continue;
            }
            if (method.suspendType != MethodDatabase.SuspendableType.SUSPENDABLE_SUPER || method.refersToSuper || suspendableSupers == null) continue;
            suspendableSupers.add(SuspendablesScanner.output(method));
        }
    }

    private static String output(MethodNode method) {
        return method.owner.replace('/', '.') + '.' + method.name;
    }

    private static void outputResults(String outputFile, boolean append, Collection<String> results) throws Exception {
        try (PrintStream out = SuspendablesScanner.getOutputStream(outputFile, append);){
            for (String s : results) {
                out.println(s);
            }
        }
    }

    private MethodNode getOrCreateMethodNode(String methodName) {
        MethodNode entry = this.methods.get(methodName = methodName.intern());
        if (entry == null) {
            entry = new MethodNode(SuspendablesScanner.getClassName(methodName), SuspendablesScanner.getMethodWithDesc(methodName));
            this.methods.put(methodName, entry);
        }
        return entry;
    }

    private ClassNode getOrCreateClassNode(String className) {
        ClassNode node = this.classes.get(className = className.intern());
        if (node == null) {
            node = new ClassNode(className);
            this.classes.put(className, node);
        }
        return node;
    }

    private ClassNode getOrLoadClassNode(String className) {
        return this.fill(this.getOrCreateClassNode(className.intern()));
    }

    private ClassNode fill(ClassNode node) {
        try {
            if (node.supers == null) {
                try (InputStream is = this.cl.getResourceAsStream(ClassLoaderUtil.classToResource(node.name));){
                    ClassReader cr = new ClassReader(is);
                    cr.accept(new ClassNodeVisitor(false, 327680, null), 3);
                    assert (node.supers != null);
                }
            }
            return node;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassNode getClassNode(MethodNode m) {
        ClassNode c = m.classNode;
        if (c == null) {
            m.classNode = c = this.getOrLoadClassNode(m.owner);
        }
        return c;
    }

    private static String getClassName(String fullMethodWithDesc) {
        return fullMethodWithDesc.substring(0, fullMethodWithDesc.lastIndexOf(46));
    }

    private static String getMethodWithDesc(String fullMethodWithDesc) {
        return fullMethodWithDesc.substring(fullMethodWithDesc.lastIndexOf(46) + 1);
    }

    private static String getMethodWithoutReturn(String fullMethodWithDesc) {
        String m = SuspendablesScanner.getMethodWithDesc(fullMethodWithDesc);
        return m.substring(0, m.lastIndexOf(41) + 1);
    }

    private static boolean isReflectInvocation(String className, String methodName) {
        return className.equals("java/lang/reflect/Method") && methodName.equals("invoke");
    }

    private static boolean isInvocationHandlerInvocation(String className, String methodName) {
        return className.equals("java/lang/reflect/InvocationHandler") && methodName.equals("invoke");
    }

    private static boolean isMethodHandleInvocation(String className, String methodName) {
        return className.equals("java/lang/invoke/MethodHandle") && methodName.startsWith("invoke");
    }

    private static void classpathToUrls(String[] classPath, List<URL> urls) throws RuntimeException {
        try {
            for (String cp : classPath) {
                urls.add(new File(cp).toURI().toURL());
            }
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static PrintStream getOutputStream(String outputFile, boolean append) throws Exception {
        if (outputFile != null && (outputFile = outputFile.trim()).isEmpty()) {
            outputFile = null;
        }
        if (outputFile != null) {
            File file = new File(outputFile);
            if (file.getParent() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            return new PrintStream(new FileOutputStream(file, append));
        }
        return System.out;
    }

    private static class MethodNode {
        String owner;
        ClassNode classNode;
        final String name;
        boolean inProject;
        boolean known;
        MethodDatabase.SuspendableType suspendType;
        boolean refersToSuper;
        boolean setBySuper;
        private MethodNode[] callers;
        private int numCallers;

        public MethodNode(String owner, String nameAndDesc) {
            this.owner = owner.intern();
            this.name = nameAndDesc.intern();
        }

        public void addCaller(MethodNode caller) {
            if (this.callers == null) {
                this.callers = new MethodNode[4];
            }
            if (this.numCallers + 1 >= this.callers.length) {
                this.callers = Arrays.copyOf(this.callers, this.callers.length * 2);
            }
            this.callers[this.numCallers] = caller;
            ++this.numCallers;
        }

        public Collection<MethodNode> getCallers() {
            if (this.callers == null) {
                return Collections.emptyList();
            }
            return new AbstractCollection<MethodNode>(){

                @Override
                public int size() {
                    return numCallers;
                }

                @Override
                public Iterator<MethodNode> iterator() {
                    return new Iterator<MethodNode>(){
                        private int i;

                        @Override
                        public boolean hasNext() {
                            return this.i < numCallers;
                        }

                        @Override
                        public MethodNode next() {
                            return callers[this.i++];
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }

        public String toString() {
            return "MethodNode{" + this.owner + '.' + this.name + " inProject: " + this.inProject + " suspendType: " + (Object)((Object)this.suspendType) + '}';
        }

        public void setSuspendType(MethodDatabase.SuspendableType suspendType) {
            this.suspendType = suspendType;
            this.setBySuper = false;
        }
    }

    private class ClassNode {
        boolean inProject;
        final String name;
        ClassNode[] supers;
        private ClassNode[] subs;
        private int numSubs;
        private String[] methods;

        public ClassNode(String name) {
            this.name = name;
        }

        void setSupers(String superName, String[] interfaces) {
            this.supers = new ClassNode[(superName != null ? 1 : 0) + (interfaces != null ? interfaces.length : 0)];
            int i = 0;
            if (superName != null) {
                this.supers[i] = SuspendablesScanner.this.getOrCreateClassNode(superName);
                this.supers[i].addSub(this);
                ++i;
            }
            if (interfaces != null) {
                for (String iface : interfaces) {
                    this.supers[i] = SuspendablesScanner.this.getOrCreateClassNode(iface);
                    this.supers[i].addSub(this);
                    ++i;
                }
            }
        }

        void setMethods(Collection<String> ms) {
            this.methods = ms.toArray(new String[ms.size()]);
            for (int i = 0; i < this.methods.length; ++i) {
                this.methods[i] = this.methods[i].intern();
            }
        }

        boolean hasMethod(String method) {
            for (String m : this.methods) {
                if (!method.equals(m)) continue;
                return true;
            }
            return false;
        }

        List<String> getMethodWithDifferentReturn(String method) {
            method = SuspendablesScanner.getMethodWithoutReturn(method);
            ArrayList<String> ms = new ArrayList<String>();
            for (String m : this.methods) {
                if (!m.startsWith(method)) continue;
                ms.add(m);
            }
            return ms;
        }

        public String toString() {
            return "ClassNode{" + this.name + " inProject: " + this.inProject + '}';
        }

        private void addSub(ClassNode cn) {
            if (this.subs == null) {
                this.subs = new ClassNode[4];
            }
            if (this.numSubs + 1 >= this.subs.length) {
                this.subs = Arrays.copyOf(this.subs, this.subs.length * 2);
            }
            this.subs[this.numSubs] = cn;
            ++this.numSubs;
        }
    }

    private class CallGraphVisitor
    extends ClassVisitor {
        private final boolean inProject;
        private String className;

        public CallGraphVisitor(boolean inProject, int api, ClassVisitor cv) {
            super(api, cv);
            this.inProject = inProject;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        @Override
        public MethodVisitor visitMethod(int access, final String methodname, final String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, methodname, desc, signature, exceptions);
            final MethodNode caller = SuspendablesScanner.this.getOrCreateMethodNode(this.className + '.' + methodname + desc);
            caller.inProject |= this.inProject;
            return new MethodVisitor(this.api, mv){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc2, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc2, itf);
                    if (SuspendablesScanner.isReflectInvocation(owner, name)) {
                        SuspendablesScanner.this.log("NOTE: Reflective invocation in " + this.methodToString(), 1);
                    } else if (SuspendablesScanner.isInvocationHandlerInvocation(owner, name)) {
                        SuspendablesScanner.this.log("NOTE: Invocation handler invocation in " + this.methodToString(), 1);
                    } else if (SuspendablesScanner.isMethodHandleInvocation(owner, name)) {
                        SuspendablesScanner.this.log("NOTE: Method handle invocation in " + this.methodToString(), 1);
                    } else {
                        MethodNode callee = SuspendablesScanner.this.getOrCreateMethodNode(owner + '.' + name + desc2);
                        SuspendablesScanner.this.log("Adding caller " + caller + " to " + callee, 4);
                        callee.addCaller(caller);
                    }
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String desc2, Handle bsm, Object ... bsmArgs) {
                    super.visitInvokeDynamicInsn(name, desc2, bsm, bsmArgs);
                    SuspendablesScanner.this.log("NOTE: InvokeDynamic invocation in " + this.methodToString(), 1);
                }

                private String methodToString() {
                    return CallGraphVisitor.this.className + '.' + methodname + "(" + Arrays.toString(Type.getArgumentTypes(desc)) + ") - " + CallGraphVisitor.this.className + '.' + methodname + desc;
                }
            };
        }
    }

    private class ClassNodeVisitor
    extends ClassVisitor {
        private final boolean inProject;
        private String className;
        private final List<String> methods;
        private ClassNode cn;

        public ClassNodeVisitor(boolean inProject, int api, ClassVisitor cv) {
            super(api, cv);
            this.methods = new ArrayList<String>();
            this.inProject = inProject;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            SuspendablesScanner.this.log("Loading and analyzing class " + this.className, 4);
            this.cn = SuspendablesScanner.this.getOrCreateClassNode(this.className);
            this.cn.inProject |= this.inProject;
            this.cn.setSupers(superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String methodname, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, methodname, desc, signature, exceptions);
            this.methods.add((methodname + desc).intern());
            return mv;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.cn.setMethods(this.methods);
        }
    }

    private class SuspendableClassifier
    extends ClassVisitor {
        private final boolean inProject;
        private String className;
        private boolean suspendableClass;

        public SuspendableClassifier(boolean inProject, int api, ClassVisitor cv) {
            super(api, cv);
            this.inProject = inProject;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name.intern();
            SuspendablesScanner.this.log("Searching suspendables in " + this.className, 4);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(adesc, visible);
            if (adesc.equals(Classes.SUSPENDABLE_DESC)) {
                this.suspendableClass = true;
            }
            return av;
        }

        @Override
        public MethodVisitor visitMethod(int access, final String methodname, final String desc, String signature, String[] exceptions) {
            boolean noImpl;
            MethodVisitor mv = super.visitMethod(access, methodname, desc, signature, exceptions);
            MethodDatabase.SuspendableType suspendable = MethodDatabase.SuspendableType.NON_SUSPENDABLE;
            boolean bl = noImpl = (access & 0x500) != 0;
            if (this.suspendableClass) {
                MethodDatabase.SuspendableType suspendableType = suspendable = noImpl ? MethodDatabase.SuspendableType.SUSPENDABLE_SUPER : MethodDatabase.SuspendableType.SUSPENDABLE;
            }
            if (suspendable != MethodDatabase.SuspendableType.SUSPENDABLE && this.checkExceptions(exceptions)) {
                MethodDatabase.SuspendableType suspendableType = suspendable = noImpl ? MethodDatabase.SuspendableType.SUSPENDABLE_SUPER : MethodDatabase.SuspendableType.SUSPENDABLE;
            }
            if (suspendable != MethodDatabase.SuspendableType.SUSPENDABLE && SuspendablesScanner.this.ssc.isSuperSuspendable(this.className, methodname, desc)) {
                suspendable = this.max(suspendable, MethodDatabase.SuspendableType.SUSPENDABLE_SUPER);
            }
            if (suspendable != MethodDatabase.SuspendableType.SUSPENDABLE && SuspendablesScanner.this.ssc.isSuspendable(this.className, methodname, desc)) {
                suspendable = this.max(suspendable, MethodDatabase.SuspendableType.SUSPENDABLE);
            }
            final MethodDatabase.SuspendableType suspendable1 = suspendable;
            return new MethodVisitor(this.api, mv){
                private MethodDatabase.SuspendableType susp;
                {
                    super(x0, x1);
                    this.susp = suspendable1 != MethodDatabase.SuspendableType.NON_SUSPENDABLE ? suspendable1 : null;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(desc, visible);
                    if (Classes.SUSPENDABLE_DESC.equals(adesc)) {
                        this.susp = noImpl ? MethodDatabase.SuspendableType.SUSPENDABLE_SUPER : MethodDatabase.SuspendableType.SUSPENDABLE;
                    } else if (Classes.DONT_INSTRUMENT_DESC.equals(adesc)) {
                        this.susp = MethodDatabase.SuspendableType.NON_SUSPENDABLE;
                    }
                    return av;
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    if (this.susp != null) {
                        SuspendableClassifier.this.markKnownSuspendable(methodname, desc, this.susp);
                    }
                }
            };
        }

        private void markKnownSuspendable(String methodname, String desc, MethodDatabase.SuspendableType sus) {
            MethodNode method = SuspendablesScanner.this.getOrCreateMethodNode(this.className + '.' + methodname + desc);
            method.owner = this.className;
            method.inProject |= this.inProject;
            method.setSuspendType(this.max(method.suspendType, sus));
            method.known = true;
            if (SuspendablesScanner.this.auto || this.inProject) {
                SuspendablesScanner.this.knownSuspendablesOrSupers.add(method);
            }
            SuspendablesScanner.this.log("Known suspendable " + this.className + '.' + methodname + desc, 3);
        }

        private boolean checkExceptions(String[] exceptions) {
            if (exceptions != null) {
                for (String ex : exceptions) {
                    if (!ex.equals(Classes.SUSPEND_EXECUTION_NAME)) continue;
                    return true;
                }
            }
            return false;
        }

        private MethodDatabase.SuspendableType max(MethodDatabase.SuspendableType a, MethodDatabase.SuspendableType b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return b.compareTo(a) > 0 ? b : a;
        }
    }
}

