/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.StandardCharsets;
import sandbox.java.nio.file.attribute.FileTime;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.HashSet;
import sandbox.java.util.Iterator;
import sandbox.java.util.Vector;
import sandbox.java.util.zip.CRC32;
import sandbox.java.util.zip.Deflater;
import sandbox.java.util.zip.DeflaterOutputStream;
import sandbox.java.util.zip.ZipCoder;
import sandbox.java.util.zip.ZipConstants;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipException;
import sandbox.java.util.zip.ZipUtils;
import sandbox.sun.security.action.GetPropertyAction;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private static final boolean inhibitZip64;
    private XEntry current;
    private Vector<XEntry> xentries;
    private HashSet<String> names;
    private CRC32 crc;
    private long written;
    private long locoff;
    private byte[] comment;
    private int method;
    private boolean finished;
    private boolean closed;
    private final ZipCoder zc;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static int version(ZipEntry zipEntry) throws ZipException {
        switch (zipEntry.method) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
        ZipException zipException = new ZipException("unsupported compression method");
        RuntimeCostAccounter.recordThrow();
        throw zipException;
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public ZipOutputStream(OutputStream outputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.<init>:(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)V");
        this(outputStream, StandardCharsets.UTF_8);
    }

    public ZipOutputStream(OutputStream outputStream, Charset charset) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Deflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.<init>:(IZ)V");
        Deflater deflater = new Deflater(-1, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterOutputStream.<init>:(Ljava/io/OutputStream;Ljava/util/zip/Deflater;)V");
        super(outputStream, deflater);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Vector");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.<init>:()V");
        this.xentries = new Vector();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:()V");
        this.names = new HashSet();
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/CRC32");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.<init>:()V");
        this.crc = new CRC32();
        this.written = 0L;
        this.locoff = 0L;
        this.method = 8;
        this.closed = false;
        RuntimeCostAccounter.recordJump();
        if (charset == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("charset is null");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.get:(Ljava/nio/charset/Charset;)Ljava/util/zip/ZipCoder;");
        this.zc = ZipCoder.get(charset);
        this.usesDefaultDeflater = true;
    }

    public void setComment(String string) {
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
            this.comment = this.zc.getBytes(string);
            int n = this.comment.length;
            RuntimeCostAccounter.recordJump();
            if (n > 65535) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("ZIP file comment too long.");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
    }

    public void setMethod(int n) {
        RuntimeCostAccounter.recordJump();
        if (n != 8) {
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid compression method");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        this.method = n;
    }

    public void setLevel(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.setLevel:(I)V");
        this.def.setLevel(n);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        long l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.current != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.closeEntry:()V");
            this.closeEntry();
        }
        long l2 = (l = zipEntry.time - -1L) == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 == false) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
            long l3 = System.currentTimeMillis();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.setTime:(J)V");
            zipEntry.setTime(l3);
        }
        int n = zipEntry.method;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            zipEntry.method = this.method;
        }
        zipEntry.flag = 0;
        switch (zipEntry.method) {
            case 8: {
                long l4 = zipEntry.size - -1L;
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l5 != false) {
                    long l6 = zipEntry.csize - -1L;
                    long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l7 != false) {
                        long l8 = zipEntry.crc - -1L;
                        long l9 = l8 == 0L ? 0 : (l8 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l9 != false) break;
                    }
                }
                zipEntry.flag = 8;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 0: {
                long l10;
                long l11 = zipEntry.size - -1L;
                long l12 = l11 == 0L ? 0 : (l11 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l12 == false) {
                    zipEntry.size = zipEntry.csize;
                    RuntimeCostAccounter.recordJump();
                } else {
                    long l13 = zipEntry.csize - -1L;
                    long l14 = l13 == 0L ? 0 : (l13 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l14 == false) {
                        zipEntry.csize = zipEntry.size;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        long l15 = zipEntry.size - zipEntry.csize;
                        long l16 = l15 == 0L ? 0 : (l15 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l16 != false) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                            ZipException zipException = new ZipException("STORED entry where compressed != uncompressed size");
                            RuntimeCostAccounter.recordThrow();
                            throw zipException;
                        }
                    }
                }
                long l17 = (l10 = zipEntry.size - -1L) == 0L ? 0 : (l10 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l17 != false) {
                    long l18 = zipEntry.crc - -1L;
                    long l19 = l18 == 0L ? 0 : (l18 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l19 != false) break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                ZipException zipException = new ZipException("STORED entry missing size, compressed size, or crc-32");
                RuntimeCostAccounter.recordThrow();
                throw zipException;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                ZipException zipException = new ZipException("unsupported compression method");
                RuntimeCostAccounter.recordThrow();
                throw zipException;
            }
        }
        String string = zipEntry.name;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.add:(Ljava/lang/Object;)Z");
        boolean bl = this.names.add(string);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("duplicate entry: ");
            String string2 = zipEntry.name;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException(string3);
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.isUTF8:()Z");
        boolean bl2 = this.zc.isUTF8();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            zipEntry.flag |= 0x800;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipOutputStream$XEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream$XEntry.<init>:(Ljava/util/zip/ZipEntry;J)V");
        this.current = new XEntry(zipEntry, this.written);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.add:(Ljava/lang/Object;)Z");
        this.xentries.add(this.current);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLOC:(Ljava/util/zip/ZipOutputStream$XEntry;)V");
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.current != null) {
            ZipEntry zipEntry = this.current.entry;
            switch (zipEntry.method) {
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finish:()V");
                    this.def.finish();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
                        boolean bl = this.def.finished();
                        RuntimeCostAccounter.recordJump();
                        if (bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.deflate:()V");
                        this.deflate();
                        RuntimeCostAccounter.recordJump();
                    }
                    int n = zipEntry.flag & 8;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) {
                        long l = zipEntry.size;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesRead:()J");
                        long l2 = l - this.def.getBytesRead();
                        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l3 != false) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder2 = stringBuilder.append("invalid entry size (expected ");
                            long l4 = zipEntry.size;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder3 = stringBuilder2.append(l4);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder4 = stringBuilder3.append(" but got ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesRead:()J");
                            long l5 = this.def.getBytesRead();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder5 = stringBuilder4.append(l5);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder6 = stringBuilder5.append(" bytes)");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string = stringBuilder6.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                            ZipException zipException = new ZipException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw zipException;
                        }
                        long l6 = zipEntry.csize;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesWritten:()J");
                        long l7 = l6 - this.def.getBytesWritten();
                        long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l8 != false) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder7 = stringBuilder.append("invalid entry compressed size (expected ");
                            long l9 = zipEntry.csize;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder8 = stringBuilder7.append(l9);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder9 = stringBuilder8.append(" but got ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesWritten:()J");
                            long l10 = this.def.getBytesWritten();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder10 = stringBuilder9.append(l10);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder11 = stringBuilder10.append(" bytes)");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string = stringBuilder11.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                            ZipException zipException = new ZipException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw zipException;
                        }
                        long l11 = zipEntry.crc;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                        long l12 = l11 - this.crc.getValue();
                        long l13 = l12 == 0L ? 0 : (l12 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l13 != false) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder12 = stringBuilder.append("invalid entry CRC-32 (expected 0x");
                            long l14 = zipEntry.crc;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                            String string = Long.toHexString(l14);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder13 = stringBuilder12.append(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder14 = stringBuilder13.append(" but got 0x");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                            long l15 = this.crc.getValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                            String string2 = Long.toHexString(l15);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder15 = stringBuilder14.append(string2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder16 = stringBuilder15.append(")");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string3 = stringBuilder16.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                            ZipException zipException = new ZipException(string3);
                            RuntimeCostAccounter.recordThrow();
                            throw zipException;
                        }
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesRead:()J");
                        zipEntry.size = this.def.getBytesRead();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesWritten:()J");
                        zipEntry.csize = this.def.getBytesWritten();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                        zipEntry.crc = this.crc.getValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeEXT:(Ljava/util/zip/ZipEntry;)V");
                        this.writeEXT(zipEntry);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.reset:()V");
                    this.def.reset();
                    this.written += zipEntry.csize;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 0: {
                    long l = zipEntry.size - (this.written - this.locoff);
                    long l16 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l16 != false) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder17 = stringBuilder.append("invalid entry size (expected ");
                        long l17 = zipEntry.size;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder18 = stringBuilder17.append(l17);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder19 = stringBuilder18.append(" but got ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder20 = stringBuilder19.append(this.written - this.locoff);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder21 = stringBuilder20.append(" bytes)");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder21.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                        ZipException zipException = new ZipException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw zipException;
                    }
                    long l18 = zipEntry.crc;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                    long l19 = l18 - this.crc.getValue();
                    long l20 = l19 == 0L ? 0 : (l19 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l20 == false) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder22 = stringBuilder.append("invalid entry crc-32 (expected 0x");
                    long l21 = zipEntry.crc;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                    String string = Long.toHexString(l21);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder23 = stringBuilder22.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder24 = stringBuilder23.append(" but got 0x");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                    long l22 = this.crc.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                    String string4 = Long.toHexString(l22);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder25 = stringBuilder24.append(string4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder26 = stringBuilder25.append(")");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string5 = stringBuilder26.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException(string5);
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
                default: {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException("invalid compression method");
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.reset:()V");
            this.crc.reset();
            this.current = null;
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        block11: {
            block10: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block10;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block10;
                int n3 = byArray.length - n2;
                RuntimeCostAccounter.recordJump();
                if (n <= n3) break block11;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (this.current == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException("no current ZIP entry");
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
        ZipEntry zipEntry = this.current.entry;
        switch (zipEntry.method) {
            case 8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterOutputStream.write:([BII)V");
                super.write(byArray, n, n2);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 0: {
                this.written += (long)n2;
                long l = this.written - this.locoff - zipEntry.size;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 > 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException("attempt to write past end of STORED entry");
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                this.out.write(byArray, n, n2);
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                ZipException zipException = new ZipException("invalid compression method");
                RuntimeCostAccounter.recordThrow();
                throw zipException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.update:([BII)V");
        this.crc.update(byArray, n, n2);
    }

    @Override
    public void finish() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.finished) {
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (this.current != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.closeEntry:()V");
            this.closeEntry();
        }
        long l = this.written;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.iterator:()Ljava/util/Iterator;");
        Iterator<XEntry> iterator = this.xentries.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            XEntry xEntry = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeCEN:(Ljava/util/zip/ZipOutputStream$XEntry;)V");
            this.writeCEN(xEntry);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeEND:(JJ)V");
        this.writeEND(l, this.written - l);
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.closed) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterOutputStream.close:()V");
            super.close();
            this.closed = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeLOC(XEntry var1_1) throws IOException {
        block14: {
            block13: {
                var2_2 = var1_1.entry;
                var3_3 = var2_2.flag;
                var4_4 = false;
                v0 = var2_2.extra;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.getExtraLen:([B)I");
                var5_5 = this.getExtraLen(v0);
                v1 = var2_2.time;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.javaToDosTime:(J)J");
                var1_1.dostime = ZipUtils.javaToDosTime(v1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(67324752L);
                RuntimeCostAccounter.recordJump();
                if ((var3_3 & 8) != 8) break block13;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.version:(Ljava/util/zip/ZipEntry;)I");
                v2 = ZipOutputStream.version(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(v2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(var3_3);
                v3 = var2_2.method;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(v3);
                v4 = var1_1.dostime;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(0L);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(0L);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(0L);
                RuntimeCostAccounter.recordJump();
                break block14;
            }
            cfr_temp_0 = var2_2.csize - 0xFFFFFFFFL;
            v5 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v5 >= 0) ** GOTO lbl-1000
            cfr_temp_1 = var2_2.size - 0xFFFFFFFFL;
            v6 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v6 >= 0) lbl-1000:
            // 2 sources

            {
                var4_4 = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(45);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.version:(Ljava/util/zip/ZipEntry;)I");
                v7 = ZipOutputStream.version(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(v7);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(var3_3);
            v8 = var2_2.method;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(v8);
            v9 = var1_1.dostime;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(v9);
            v10 = var2_2.crc;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(v10);
            RuntimeCostAccounter.recordJump();
            if (var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(0xFFFFFFFFL);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(0xFFFFFFFFL);
                var5_5 += 20;
                RuntimeCostAccounter.recordJump();
            } else {
                v11 = var2_2.csize;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v11);
                v12 = var2_2.size;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v12);
            }
        }
        v13 = var2_2.name;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
        var6_6 = this.zc.getBytes(v13);
        v14 = var6_6.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(v14);
        var7_7 = 0;
        var8_8 = 0;
        v15 = var2_2.mtime;
        RuntimeCostAccounter.recordJump();
        if (v15 != null) {
            var7_7 += 4;
            var8_8 |= 1;
        }
        v16 = var2_2.atime;
        RuntimeCostAccounter.recordJump();
        if (v16 != null) {
            var7_7 += 4;
            var8_8 |= 2;
        }
        v17 = var2_2.ctime;
        RuntimeCostAccounter.recordJump();
        if (v17 != null) {
            var7_7 += 4;
            var8_8 |= 4;
        }
        RuntimeCostAccounter.recordJump();
        if (var8_8 != 0) {
            var5_5 += var7_7 + 5;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(var5_5);
        v18 = var6_6.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
        this.writeBytes(var6_6, 0, v18);
        RuntimeCostAccounter.recordJump();
        if (var4_4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(16);
            v19 = var2_2.size;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(v19);
            v20 = var2_2.csize;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(v20);
        }
        RuntimeCostAccounter.recordJump();
        if (var8_8 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(21589);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(var7_7 + 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeByte:(I)V");
            this.writeByte(var8_8);
            v21 = var2_2.mtime;
            RuntimeCostAccounter.recordJump();
            if (v21 != null) {
                v22 = var2_2.mtime;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.fileTimeToUnixTime:(Ljava/nio/file/attribute/FileTime;)J");
                v23 = ZipUtils.fileTimeToUnixTime(v22);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v23);
            }
            v24 = var2_2.atime;
            RuntimeCostAccounter.recordJump();
            if (v24 != null) {
                v25 = var2_2.atime;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.fileTimeToUnixTime:(Ljava/nio/file/attribute/FileTime;)J");
                v26 = ZipUtils.fileTimeToUnixTime(v25);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v26);
            }
            v27 = var2_2.ctime;
            RuntimeCostAccounter.recordJump();
            if (v27 != null) {
                v28 = var2_2.ctime;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.fileTimeToUnixTime:(Ljava/nio/file/attribute/FileTime;)J");
                v29 = ZipUtils.fileTimeToUnixTime(v28);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(v29);
            }
        }
        v30 = var2_2.extra;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeExtra:([B)V");
        this.writeExtra(v30);
        this.locoff = this.written;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeEXT(ZipEntry zipEntry) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(134695760L);
        long l = zipEntry.crc;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l);
        long l2 = zipEntry.csize - 0xFFFFFFFFL;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) {
            long l4 = zipEntry.size - 0xFFFFFFFFL;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 < 0) {
                long l6 = zipEntry.csize;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(l6);
                long l7 = zipEntry.size;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(l7);
                return;
            }
        }
        long l8 = zipEntry.csize;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
        this.writeLong(l8);
        long l9 = zipEntry.size;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
        this.writeLong(l9);
        RuntimeCostAccounter.recordJump();
    }

    private void writeCEN(XEntry xEntry) throws IOException {
        byte[] byArray;
        long l;
        long l2;
        ZipEntry zipEntry = xEntry.entry;
        int n = zipEntry.flag;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.version:(Ljava/util/zip/ZipEntry;)I");
        int n2 = ZipOutputStream.version(zipEntry);
        long l3 = zipEntry.csize;
        long l4 = zipEntry.size;
        long l5 = xEntry.offset;
        int n3 = 0;
        boolean bl = false;
        long l6 = zipEntry.csize - 0xFFFFFFFFL;
        long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l7 >= 0) {
            l3 = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        long l8 = (l2 = zipEntry.size - 0xFFFFFFFFL) == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l8 >= 0) {
            l4 = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        long l9 = (l = xEntry.offset - 0xFFFFFFFFL) == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l9 >= 0) {
            l5 = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(33639248L);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(45);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(45);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(n2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n);
        int n4 = zipEntry.method;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n4);
        long l10 = xEntry.dostime;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l10);
        long l11 = zipEntry.crc;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l11);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l4);
        String string = zipEntry.name;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
        byte[] byArray2 = this.zc.getBytes(string);
        int n5 = byArray2.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n5);
        byte[] byArray3 = zipEntry.extra;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.getExtraLen:([B)I");
        int n6 = this.getExtraLen(byArray3);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n6 += n3 + 4;
        }
        int n7 = 0;
        FileTime fileTime = zipEntry.mtime;
        RuntimeCostAccounter.recordJump();
        if (fileTime != null) {
            n6 += 4;
            n7 |= 1;
        }
        FileTime fileTime2 = zipEntry.atime;
        RuntimeCostAccounter.recordJump();
        if (fileTime2 != null) {
            n7 |= 2;
        }
        FileTime fileTime3 = zipEntry.ctime;
        RuntimeCostAccounter.recordJump();
        if (fileTime3 != null) {
            n7 |= 4;
        }
        RuntimeCostAccounter.recordJump();
        if (n7 != 0) {
            n6 += 5;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n6);
        String string2 = zipEntry.comment;
        RuntimeCostAccounter.recordJump();
        if (string2 != null) {
            String string3 = zipEntry.comment;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
            byArray = this.zc.getBytes(string3);
            int n8 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n9 = Math.min(n8, 65535);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(n9);
            RuntimeCostAccounter.recordJump();
        } else {
            byArray = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(0);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l5);
        int n10 = byArray2.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
        this.writeBytes(byArray2, 0, n10);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(n3);
            RuntimeCostAccounter.recordJump();
            if (l4 == 0xFFFFFFFFL) {
                long l12 = zipEntry.size;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
                this.writeLong(l12);
            }
            RuntimeCostAccounter.recordJump();
            if (l3 == 0xFFFFFFFFL) {
                long l13 = zipEntry.csize;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
                this.writeLong(l13);
            }
            RuntimeCostAccounter.recordJump();
            if (l5 == 0xFFFFFFFFL) {
                long l14 = xEntry.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
                this.writeLong(l14);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n7 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(21589);
            FileTime fileTime4 = zipEntry.mtime;
            RuntimeCostAccounter.recordJump();
            if (fileTime4 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeByte:(I)V");
                this.writeByte(n7);
                FileTime fileTime5 = zipEntry.mtime;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.fileTimeToUnixTime:(Ljava/nio/file/attribute/FileTime;)J");
                long l15 = ZipUtils.fileTimeToUnixTime(fileTime5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
                this.writeInt(l15);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
                this.writeShort(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeByte:(I)V");
                this.writeByte(n7);
            }
        }
        byte[] byArray4 = zipEntry.extra;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeExtra:([B)V");
        this.writeExtra(byArray4);
        RuntimeCostAccounter.recordJump();
        if (byArray != null) {
            int n11 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n12 = Math.min(n11, 65535);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
            this.writeBytes(byArray, 0, n12);
        }
    }

    private void writeEND(long l, long l2) throws IOException {
        boolean bl = false;
        long l3 = l2;
        long l4 = l;
        RuntimeCostAccounter.recordJump();
        if (l3 >= 0xFFFFFFFFL) {
            l3 = 0xFFFFFFFFL;
            bl = true;
        }
        RuntimeCostAccounter.recordJump();
        if (l4 >= 0xFFFFFFFFL) {
            l4 = 0xFFFFFFFFL;
            bl = true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.size:()I");
        int n = this.xentries.size();
        RuntimeCostAccounter.recordJump();
        if (n >= 65535) {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (!inhibitZip64) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            RuntimeCostAccounter.recordJump();
            if (bl |= bl2) {
                n = 65535;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            long l5 = this.written;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(101075792L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(44L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(45);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(45);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(0L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(0L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.size:()I");
            long l6 = this.xentries.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(l6);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.size:()I");
            long l7 = this.xentries.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(l7);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(117853008L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(0L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeLong:(J)V");
            this.writeLong(l5);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
            this.writeInt(1L);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(101010256L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
        this.writeShort(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeInt:(J)V");
        this.writeInt(l4);
        RuntimeCostAccounter.recordJump();
        if (this.comment != null) {
            int n2 = this.comment.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(n2);
            int n3 = this.comment.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
            this.writeBytes(this.comment, 0, n3);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeShort:(I)V");
            this.writeShort(0);
        }
    }

    private int getExtraLen(byte[] byArray) {
        RuntimeCostAccounter.recordJump();
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (true) {
            int n4;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (n3 + 4 > n2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                    int n5 = ZipUtils.get16(byArray, n3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                    n4 = ZipUtils.get16(byArray, n3 + 2);
                    RuntimeCostAccounter.recordJump();
                    if (n4 < 0) break;
                    RuntimeCostAccounter.recordJump();
                    if (n3 + 4 + n4 > n2) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n5 == 21589) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (n5 != 1) break block7;
                }
                n += n4 + 4;
            }
            n3 += n4 + 4;
            RuntimeCostAccounter.recordJump();
        }
        return n2 - n;
    }

    private void writeExtra(byte[] byArray) throws IOException {
        block7: {
            RuntimeCostAccounter.recordJump();
            if (byArray == null) break block7;
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                int n3;
                int n4;
                block9: {
                    block8: {
                        RuntimeCostAccounter.recordJump();
                        if (n2 + 4 > n) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                        n4 = ZipUtils.get16(byArray, n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                        n3 = ZipUtils.get16(byArray, n2 + 2);
                        RuntimeCostAccounter.recordJump();
                        if (n3 < 0) break block8;
                        RuntimeCostAccounter.recordJump();
                        if (n2 + 4 + n3 <= n) break block9;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
                    this.writeBytes(byArray, n2, n - n2);
                    return;
                }
                RuntimeCostAccounter.recordJump();
                if (n4 != 21589) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 != 1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
                        this.writeBytes(byArray, n2, n3 + 4);
                    }
                }
                n2 += n3 + 4;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.writeBytes:([BII)V");
                this.writeBytes(byArray, n2, n - n2);
            }
        }
    }

    private void writeByte(int n) throws IOException {
        OutputStream outputStream = this.out;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n & 0xFF);
        ++this.written;
    }

    private void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n >>> 0 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long l) throws IOException {
        OutputStream outputStream = this.out;
        int n = (int)(l >>> 0 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n);
        int n2 = (int)(l >>> 8 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n2);
        int n3 = (int)(l >>> 16 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n3);
        int n4 = (int)(l >>> 24 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n4);
        this.written += 4L;
    }

    private void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        int n = (int)(l >>> 0 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n);
        int n2 = (int)(l >>> 8 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n2);
        int n3 = (int)(l >>> 16 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n3);
        int n4 = (int)(l >>> 24 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n4);
        int n5 = (int)(l >>> 32 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n5);
        int n6 = (int)(l >>> 40 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n6);
        int n7 = (int)(l >>> 48 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n7);
        int n8 = (int)(l >>> 56 & 0xFFL);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
        outputStream.write(n8);
        this.written += 8L;
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
        this.out.write(byArray, n, n2);
        this.written += (long)n2;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("jdk.util.zip.inhibitZip64", "false");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.parseBoolean:(Ljava/lang/String;)Z");
        inhibitZip64 = Boolean.parseBoolean(string);
    }

    private static class XEntry {
        final ZipEntry entry;
        final long offset;
        long dostime;

        public XEntry(ZipEntry zipEntry, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.entry = zipEntry;
            this.offset = l;
        }
    }
}

