/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.Locale;
import sandbox.java.util.MissingResourceException;
import sandbox.java.util.ResourceBundle;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.java.util.logging.Level;
import sandbox.sun.misc.JavaLangAccess;
import sandbox.sun.misc.SharedSecrets;

public class LogRecord
implements Serializable {
    private static final AtomicLong globalSequenceNumber;
    private static final int MIN_SEQUENTIAL_THREAD_ID = 0x3FFFFFFF;
    private static final AtomicInteger nextThreadId;
    private static final ThreadLocal<Integer> threadIds;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;
    private static final long serialVersionUID = 5372048053134512534L;

    private int defaultThreadID() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getId:()J");
        long l = thread.getId();
        RuntimeCostAccounter.recordJump();
        if (l < 0x3FFFFFFFL) {
            return (int)l;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.get:()Ljava/lang/Object;");
        Integer n = threadIds.get();
        RuntimeCostAccounter.recordJump();
        if (n == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
            int n2 = nextThreadId.getAndIncrement();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            n = n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.set:(Ljava/lang/Object;)V");
            threadIds.set(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
        return n;
    }

    public LogRecord(Level level, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        level.getClass();
        this.level = level;
        this.message = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndIncrement:()J");
        this.sequenceNumber = globalSequenceNumber.getAndIncrement();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.defaultThreadID:()I");
        this.threadID = this.defaultThreadID();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        this.millis = System.currentTimeMillis();
        this.needToInferCaller = true;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        RuntimeCostAccounter.recordJump();
        if (level == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.level = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getSourceClassName() {
        RuntimeCostAccounter.recordJump();
        if (this.needToInferCaller) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.inferCaller:()V");
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
        this.needToInferCaller = false;
    }

    public String getSourceMethodName() {
        RuntimeCostAccounter.recordJump();
        if (this.needToInferCaller) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.inferCaller:()V");
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
        this.needToInferCaller = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeByte:(I)V");
        objectOutputStream.writeByte(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeByte:(I)V");
        objectOutputStream.writeByte(0);
        RuntimeCostAccounter.recordJump();
        if (this.parameters == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
            objectOutputStream.writeInt(-1);
            return;
        }
        int n = this.parameters.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (true) {
            int n3 = this.parameters.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            Object object = this.parameters[n2];
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(null);
                RuntimeCostAccounter.recordJump();
            } else {
                Object object2 = this.parameters[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                String string = object2.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(string);
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readByte:()B");
        byte by = objectInputStream.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readByte:()B");
        byte by2 = objectInputStream.readByte();
        RuntimeCostAccounter.recordJump();
        if (by != 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("LogRecord: bad version: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(by);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(".");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(by2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException(string);
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n = objectInputStream.readInt();
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            this.parameters = null;
            RuntimeCostAccounter.recordJump();
        } else {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            this.parameters = new Object[n2];
            int n3 = 0;
            while (true) {
                int n4 = this.parameters.length;
                RuntimeCostAccounter.recordJump();
                if (n3 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
                this.parameters[n3] = objectInputStream.readObject();
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle resourceBundle;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                Locale locale = Locale.getDefault();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBundle:(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;)Ljava/util/ResourceBundle;");
                this.resourceBundle = resourceBundle = ResourceBundle.getBundle(this.resourceBundleName, locale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
            RuntimeCostAccounter.recordJump();
        }
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        this.needToInferCaller = false;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.getJavaLangAccess:()Lsun/misc/JavaLangAccess;");
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Throwable");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.<init>:()V");
        Throwable throwable = new Throwable();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/JavaLangAccess.getStackTraceDepth:(Ljava/lang/Throwable;)I");
        int n = javaLangAccess.getStackTraceDepth(throwable);
        boolean bl = true;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/JavaLangAccess.getStackTraceElement:(Ljava/lang/Throwable;I)Ljava/lang/StackTraceElement;");
            StackTraceElement stackTraceElement = javaLangAccess.getStackTraceElement(throwable, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StackTraceElement.getClassName:()Ljava/lang/String;");
            String string = stackTraceElement.getClassName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.isLoggerImplFrame:(Ljava/lang/String;)Z");
            boolean bl2 = this.isLoggerImplFrame(string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    bl = false;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                    boolean bl3 = string.startsWith("java.lang.reflect.");
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                        boolean bl4 = string.startsWith("sun.reflect.");
                        RuntimeCostAccounter.recordJump();
                        if (!bl4) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
                            this.setSourceClassName(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StackTraceElement.getMethodName:()Ljava/lang/String;");
                            String string2 = stackTraceElement.getMethodName();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
                            this.setSourceMethodName(string2);
                            return;
                        }
                    }
                }
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLoggerImplFrame(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = string.equals("java.util.logging.Logger");
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string.startsWith("java.util.logging.LoggingProxyImpl");
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl3 = string.startsWith("sun.util.logging.");
                RuntimeCostAccounter.recordJump();
                if (!bl3) return false;
            }
        }
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
        globalSequenceNumber = new AtomicLong(0L);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:(I)V");
        nextThreadId = new AtomicInteger(0x3FFFFFFF);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ThreadLocal");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.<init>:()V");
        threadIds = new ThreadLocal();
    }
}

