/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.sun.misc.Unsafe;

public class AtomicStampedReference<V> {
    private volatile Pair<V> pair;
    private static final Unsafe UNSAFE;
    private static final long pairOffset;

    public AtomicStampedReference(V v, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair.of:(Ljava/lang/Object;I)Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;");
        this.pair = Pair.of(v, n);
    }

    public V getReference() {
        return (V)this.pair.reference;
    }

    public int getStamp() {
        return this.pair.stamp;
    }

    public V get(int[] nArray) {
        Pair<V> pair = this.pair;
        nArray[0] = pair.stamp;
        return (V)pair.reference;
    }

    public boolean weakCompareAndSet(V v, V v2, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;II)Z");
        return this.compareAndSet(v, v2, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compareAndSet(V v, V v2, int n, int n2) {
        block3: {
            Pair<V> pair;
            block2: {
                pair = this.pair;
                Object t = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v != t) return false;
                int n3 = pair.stamp;
                RuntimeCostAccounter.recordJump();
                if (n != n3) return false;
                Object t2 = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v2 != t2) break block2;
                int n4 = pair.stamp;
                RuntimeCostAccounter.recordJump();
                if (n2 == n4) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair.of:(Ljava/lang/Object;I)Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;");
            Pair<V> pair2 = Pair.of(v2, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference.casPair:(Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;)Z");
            boolean bl = this.casPair(pair, pair2);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public void set(V v, int n) {
        block3: {
            block2: {
                Pair<V> pair = this.pair;
                Object t = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v != t) break block2;
                int n2 = pair.stamp;
                RuntimeCostAccounter.recordJump();
                if (n == n2) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair.of:(Ljava/lang/Object;I)Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;");
            this.pair = Pair.of(v, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attemptStamp(V v, int n) {
        Pair<V> pair = this.pair;
        Object t = pair.reference;
        RuntimeCostAccounter.recordJump();
        if (v != t) return false;
        int n2 = pair.stamp;
        RuntimeCostAccounter.recordJump();
        if (n != n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair.of:(Ljava/lang/Object;I)Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;");
            Pair<V> pair2 = Pair.of(v, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference.casPair:(Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;Ljava/util/concurrent/atomic/AtomicStampedReference$Pair;)Z");
            boolean bl = this.casPair(pair, pair2);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    private boolean casPair(Pair<V> pair, Pair<V> pair2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return UNSAFE.compareAndSwapObject((Object)this, pairOffset, pair, pair2);
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField(string);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            return unsafe.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NoSuchFieldError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.<init>:(Ljava/lang/String;)V");
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            noSuchFieldError.initCause(noSuchFieldException);
            RuntimeCostAccounter.recordThrow();
            throw noSuchFieldError;
        }
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        UNSAFE = Unsafe.getUnsafe();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference.objectFieldOffset:(Lsun/misc/Unsafe;Ljava/lang/String;Ljava/lang/Class;)J");
        pairOffset = AtomicStampedReference.objectFieldOffset(UNSAFE, "pair", AtomicStampedReference.class);
    }

    private static class Pair<T> {
        final T reference;
        final int stamp;

        private Pair(T t, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.reference = t;
            this.stamp = n;
        }

        static <T> Pair<T> of(T t, int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicStampedReference$Pair.<init>:(Ljava/lang/Object;I)V");
            return new Pair<T>(t, n);
        }
    }
}

