/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.ForkJoinPool;
import sandbox.java.util.concurrent.ForkJoinTask;
import sandbox.java.util.concurrent.ForkJoinWorkerThread;
import sandbox.sun.misc.Unsafe;

public abstract class CountedCompleter<T>
extends ForkJoinTask<T> {
    private static final long serialVersionUID = 5232453752276485070L;
    final CountedCompleter<?> completer;
    volatile int pending;
    private static final Unsafe U;
    private static final long PENDING;

    protected CountedCompleter(CountedCompleter<?> countedCompleter, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
        this.completer = countedCompleter;
        this.pending = n;
    }

    protected CountedCompleter(CountedCompleter<?> countedCompleter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
        this.completer = countedCompleter;
    }

    protected CountedCompleter() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter<?> countedCompleter) {
    }

    public boolean onExceptionalCompletion(Throwable throwable, CountedCompleter<?> countedCompleter) {
        return true;
    }

    public final CountedCompleter<?> getCompleter() {
        return this.completer;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int n) {
        this.pending = n;
    }

    public final void addToPendingCount(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        U.getAndAddInt((Object)this, PENDING, n);
    }

    public final boolean compareAndSetPendingCount(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        return U.compareAndSwapInt((Object)this, PENDING, n, n2);
    }

    public final int decrementPendingCountUnlessZero() {
        int n;
        boolean bl;
        do {
            n = this.pending;
            RuntimeCostAccounter.recordJump();
            if (n == 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            bl = U.compareAndSwapInt((Object)this, PENDING, n, n - 1);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return n;
    }

    public final CountedCompleter<?> getRoot() {
        CountedCompleter<?> countedCompleter = this;
        while (true) {
            CountedCompleter<?> countedCompleter2 = countedCompleter.completer;
            RuntimeCostAccounter.recordJump();
            if (countedCompleter2 == null) break;
            countedCompleter = countedCompleter2;
            RuntimeCostAccounter.recordJump();
        }
        return countedCompleter;
    }

    public final void tryComplete() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            int n = countedCompleter.pending;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.onCompletion:(Ljava/util/concurrent/CountedCompleter;)V");
                countedCompleter.onCompletion(countedCompleter2);
                countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                RuntimeCostAccounter.recordJump();
                if (countedCompleter != null) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.quietlyComplete:()V");
                countedCompleter2.quietlyComplete();
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            boolean bl = U.compareAndSwapInt((Object)countedCompleter, PENDING, n, n - 1);
            RuntimeCostAccounter.recordJump();
            if (bl) break;
        }
    }

    public final void propagateCompletion() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            int n = countedCompleter.pending;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                RuntimeCostAccounter.recordJump();
                if (countedCompleter != null) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.quietlyComplete:()V");
                countedCompleter2.quietlyComplete();
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            boolean bl = U.compareAndSwapInt(countedCompleter, PENDING, n, n - 1);
            RuntimeCostAccounter.recordJump();
            if (bl) break;
        }
    }

    @Override
    public void complete(T t) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.setRawResult:(Ljava/lang/Object;)V");
        this.setRawResult(t);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.onCompletion:(Ljava/util/concurrent/CountedCompleter;)V");
        this.onCompletion(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.quietlyComplete:()V");
        this.quietlyComplete();
        CountedCompleter<?> countedCompleter = this.completer;
        RuntimeCostAccounter.recordJump();
        if (countedCompleter != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.tryComplete:()V");
            countedCompleter.tryComplete();
        }
    }

    public final CountedCompleter<?> firstComplete() {
        boolean bl;
        do {
            int n = this.pending;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                return this;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            bl = U.compareAndSwapInt((Object)this, PENDING, n, n - 1);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return null;
    }

    public final CountedCompleter<?> nextComplete() {
        CountedCompleter<?> countedCompleter = this.completer;
        RuntimeCostAccounter.recordJump();
        if (countedCompleter != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.firstComplete:()Ljava/util/concurrent/CountedCompleter;");
            return countedCompleter.firstComplete();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.quietlyComplete:()V");
        this.quietlyComplete();
        return null;
    }

    public final void quietlyCompleteRoot() {
        CountedCompleter<?> countedCompleter = this;
        while (true) {
            CountedCompleter<?> countedCompleter2 = countedCompleter.completer;
            RuntimeCostAccounter.recordJump();
            if (countedCompleter2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.quietlyComplete:()V");
                countedCompleter.quietlyComplete();
                return;
            }
            countedCompleter = countedCompleter2;
            RuntimeCostAccounter.recordJump();
        }
    }

    public final void helpComplete(int n) {
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordJump();
            if (this.status >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                boolean bl = thread instanceof ForkJoinWorkerThread;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                    ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
                    ForkJoinPool.WorkQueue workQueue = forkJoinWorkerThread.workQueue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpComplete:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/CountedCompleter;I)I");
                    forkJoinPool.helpComplete(workQueue, this, n);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalHelpComplete:(Ljava/util/concurrent/CountedCompleter;I)I");
                    ForkJoinPool.common.externalHelpComplete(this, n);
                }
            }
        }
    }

    @Override
    void internalPropagateException(Throwable throwable) {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.onExceptionalCompletion:(Ljava/lang/Throwable;Ljava/util/concurrent/CountedCompleter;)Z");
            boolean bl = countedCompleter.onExceptionalCompletion(throwable, countedCompleter2);
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            countedCompleter2 = countedCompleter;
            countedCompleter = countedCompleter2.completer;
            RuntimeCostAccounter.recordJump();
            if (countedCompleter == null) break;
            int n = countedCompleter.status;
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.recordExceptionalCompletion:(Ljava/lang/Throwable;)I");
            int n2 = countedCompleter.recordExceptionalCompletion(throwable);
            RuntimeCostAccounter.recordJump();
            if (n2 != Integer.MIN_VALUE) break;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    protected final boolean exec() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.compute:()V");
        this.compute();
        return false;
    }

    @Override
    public T getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(T t) {
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            U = Unsafe.getUnsafe();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = CountedCompleter.class.getDeclaredField("pending");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PENDING = U.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

