/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.net.NetworkInterface;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.SecureRandom;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.StreamSupport;
import sandbox.sun.security.action.GetPropertyAction;

public final class SplittableRandom {
    private static final long GOLDEN_GAMMA = -7046029254386353131L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private long seed;
    private final long gamma;
    private static final AtomicLong defaultGen;
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";

    private SplittableRandom(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.seed = l;
        this.gamma = l2;
    }

    private static long mix64(long l) {
        l = (l ^ l >>> 30) * -4658895280553007687L;
        l = (l ^ l >>> 27) * -7723592293110705685L;
        return l ^ l >>> 31;
    }

    private static int mix32(long l) {
        l = (l ^ l >>> 33) * 7109453100751455733L;
        return (int)((l ^ l >>> 28) * -3808689974395783757L >>> 32);
    }

    private static long mixGamma(long l) {
        long l2;
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        l = l ^ l >>> 33 | 1L;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.bitCount:(J)I");
        int n = Long.bitCount(l ^ l >>> 1);
        RuntimeCostAccounter.recordJump();
        if (n < 24) {
            l2 = l ^ 0xAAAAAAAAAAAAAAAAL;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = l;
        }
        return l2;
    }

    private long nextSeed() {
        return this.seed += this.gamma;
    }

    private static long initialSeed() {
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.util.secureRandomSeed");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            boolean bl = string.equalsIgnoreCase("true");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.getSeed:(I)[B");
                byte[] byArray = SecureRandom.getSeed((int)8);
                long l = (long)byArray[0] & 0xFFL;
                int n = 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= 8) break;
                    l = l << 8 | (long)byArray[n] & 0xFFL;
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return l;
            }
        }
        long l = 0L;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.getNetworkInterfaces:()Ljava/util/Enumeration;");
            Enumeration enumeration = NetworkInterface.getNetworkInterfaces();
            boolean bl = false;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl2 = enumeration.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                NetworkInterface networkInterface = (NetworkInterface)enumeration.nextElement();
                RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.isVirtual:()Z");
                boolean bl3 = networkInterface.isVirtual();
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.getHardwareAddress:()[B");
                    byte[] byArray = networkInterface.getHardwareAddress();
                    RuntimeCostAccounter.recordJump();
                    if (byArray != null) {
                        int n = byArray.length;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                        int n2 = Math.min(n >>> 1, 4);
                        int n3 = 0;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= n2) break;
                            l = l << 16 ^ (long)(byArray[n3] << 8) ^ (long)byArray[n - 1 - n3];
                            ++n3;
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 4) {
                            l = l << 8 ^ (long)byArray[n - 1 - n2];
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
                        l = SplittableRandom.mix64(l);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    bl = true;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        long l2 = System.currentTimeMillis();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        long l3 = l ^ SplittableRandom.mix64(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l4 = System.nanoTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        return l3 ^ SplittableRandom.mix64(l4);
    }

    final long internalNextLong(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l3 = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        long l4 = SplittableRandom.mix64(l3);
        RuntimeCostAccounter.recordJump();
        if (l < l2) {
            long l5 = l2 - l;
            long l6 = l5 - 1L;
            RuntimeCostAccounter.recordJump();
            if ((l5 & l6) == 0L) {
                l4 = (l4 & l6) + l;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (l5 > 0L) {
                    long l7 = l4 >>> 1;
                    while (true) {
                        l4 = l7 % l5;
                        RuntimeCostAccounter.recordJump();
                        if (l7 + l6 - l4 >= 0L) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                        long l8 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
                        l7 = SplittableRandom.mix64(l8) >>> 1;
                        RuntimeCostAccounter.recordJump();
                    }
                    l4 += l;
                    RuntimeCostAccounter.recordJump();
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (l4 >= l) {
                            RuntimeCostAccounter.recordJump();
                            if (l4 < l2) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                        long l9 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
                        l4 = SplittableRandom.mix64(l9);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return l4;
    }

    final int internalNextInt(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
        int n3 = SplittableRandom.mix32(l);
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            int n4 = n2 - n;
            int n5 = n4 - 1;
            RuntimeCostAccounter.recordJump();
            if ((n4 & n5) == 0) {
                n3 = (n3 & n5) + n;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    int n6 = n3 >>> 1;
                    while (true) {
                        n3 = n6 % n4;
                        RuntimeCostAccounter.recordJump();
                        if (n6 + n5 - n3 >= 0) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                        long l2 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
                        n6 = SplittableRandom.mix32(l2) >>> 1;
                        RuntimeCostAccounter.recordJump();
                    }
                    n3 += n;
                    RuntimeCostAccounter.recordJump();
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n3 >= n) {
                            RuntimeCostAccounter.recordJump();
                            if (n3 < n2) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                        long l3 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
                        n3 = SplittableRandom.mix32(l3);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return n3;
    }

    final double internalNextDouble(double d, double d2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextLong:()J");
        double d3 = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        RuntimeCostAccounter.recordJump();
        if (d < d2) {
            d3 = d3 * (d2 - d) + d;
            RuntimeCostAccounter.recordJump();
            if (d3 >= d2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
                long l = Double.doubleToLongBits(d2) - 1L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                d3 = Double.longBitsToDouble(l);
            }
        }
        return d3;
    }

    public SplittableRandom(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.<init>:(JJ)V");
        this(l, -7046029254386353131L);
    }

    public SplittableRandom() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndAdd:(J)J");
        long l = defaultGen.getAndAdd(4354685564936845354L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        this.seed = SplittableRandom.mix64(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mixGamma:(J)J");
        this.gamma = SplittableRandom.mixGamma(l + -7046029254386353131L);
    }

    public SplittableRandom split() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextLong:()J");
        long l = this.nextLong();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l2 = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mixGamma:(J)J");
        long l3 = SplittableRandom.mixGamma(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.<init>:(JJ)V");
        return new SplittableRandom(l, l3);
    }

    public int nextInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
        return SplittableRandom.mix32(l);
    }

    public int nextInt(int n) {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
        int n2 = SplittableRandom.mix32(l);
        int n3 = n - 1;
        RuntimeCostAccounter.recordJump();
        if ((n & n3) == 0) {
            n2 &= n3;
            RuntimeCostAccounter.recordJump();
        } else {
            int n4 = n2 >>> 1;
            while (true) {
                n2 = n4 % n;
                RuntimeCostAccounter.recordJump();
                if (n4 + n3 - n2 >= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                long l2 = this.nextSeed();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
                n4 = SplittableRandom.mix32(l2) >>> 1;
                RuntimeCostAccounter.recordJump();
            }
        }
        return n2;
    }

    public int nextInt(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextInt:(II)I");
        return this.internalNextInt(n, n2);
    }

    public long nextLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        return SplittableRandom.mix64(l);
    }

    public long nextLong(long l) {
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l2 = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        long l3 = SplittableRandom.mix64(l2);
        long l4 = l - 1L;
        RuntimeCostAccounter.recordJump();
        if ((l & l4) == 0L) {
            l3 &= l4;
            RuntimeCostAccounter.recordJump();
        } else {
            long l5 = l3 >>> 1;
            while (true) {
                l3 = l5 % l;
                RuntimeCostAccounter.recordJump();
                if (l5 + l4 - l3 >= 0L) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
                long l6 = this.nextSeed();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
                l5 = SplittableRandom.mix64(l6) >>> 1;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l3;
    }

    public long nextLong(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextLong:(JJ)J");
        return this.internalNextLong(l, l2);
    }

    public double nextDouble() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        return (double)(SplittableRandom.mix64(l) >>> 11) * (double)1.110223E-16f;
    }

    public double nextDouble(double d) {
        double d2;
        RuntimeCostAccounter.recordJump();
        if (!(d > 0.0)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix64:(J)J");
        double d3 = (double)(SplittableRandom.mix64(l) >>> 11) * (double)1.110223E-16f * d;
        RuntimeCostAccounter.recordJump();
        if (d3 < d) {
            d2 = d3;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
            long l2 = Double.doubleToLongBits(d) - 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
            d2 = Double.longBitsToDouble(l2);
        }
        return d2;
    }

    public double nextDouble(double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextDouble:(DD)D");
        return this.internalNextDouble(d, d2);
    }

    public boolean nextBoolean() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.mix32:(J)I");
        int n = SplittableRandom.mix32(l);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public IntStream ints(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomIntsSpliterator.<init>:(Ljava/util/SplittableRandom;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, l, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomIntsSpliterator.<init>:(Ljava/util/SplittableRandom;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints(long l, int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomIntsSpliterator.<init>:(Ljava/util/SplittableRandom;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, l, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomIntsSpliterator.<init>:(Ljava/util/SplittableRandom;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public LongStream longs(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomLongsSpliterator.<init>:(Ljava/util/SplittableRandom;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, l, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomLongsSpliterator.<init>:(Ljava/util/SplittableRandom;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs(long l, long l2, long l3) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >= l3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomLongsSpliterator.<init>:(Ljava/util/SplittableRandom;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, l, l2, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomLongsSpliterator.<init>:(Ljava/util/SplittableRandom;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, l, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public DoubleStream doubles(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomDoublesSpliterator.<init>:(Ljava/util/SplittableRandom;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, l, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomDoublesSpliterator.<init>:(Ljava/util/SplittableRandom;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles(long l, double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomDoublesSpliterator.<init>:(Ljava/util/SplittableRandom;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, l, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles(double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomDoublesSpliterator.<init>:(Ljava/util/SplittableRandom;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.initialSeed:()J");
        long l = SplittableRandom.initialSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
        defaultGen = new AtomicLong(l);
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        final SplittableRandom rng;
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(SplittableRandom splittableRandom, long l, long l2, double d, double d2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomDoublesSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomDoublesSpliterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.split:()Ljava/util/SplittableRandom;");
                SplittableRandom splittableRandom = this.rng.split();
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomDoublesSpliterator.<init>:(Ljava/util/SplittableRandom;JJDD)V");
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(splittableRandom, l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextDouble:(DD)D");
                double d = this.rng.internalNextDouble(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                double d = this.origin;
                double d2 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextDouble:(DD)D");
                    double d3 = splittableRandom.internalNextDouble(d, d2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                    doubleConsumer.accept(d3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        final SplittableRandom rng;
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(SplittableRandom splittableRandom, long l, long l2, long l3, long l4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomLongsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomLongsSpliterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.split:()Ljava/util/SplittableRandom;");
                SplittableRandom splittableRandom = this.rng.split();
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomLongsSpliterator.<init>:(Ljava/util/SplittableRandom;JJJJ)V");
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(splittableRandom, l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextLong:(JJ)J");
                long l3 = this.rng.internalNextLong(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l3);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                long l3 = this.origin;
                long l4 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextLong:(JJ)J");
                    long l5 = splittableRandom.internalNextLong(l3, l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                    longConsumer.accept(l5);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        final SplittableRandom rng;
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(SplittableRandom splittableRandom, long l, long l2, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomIntsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/SplittableRandom$RandomIntsSpliterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.split:()Ljava/util/SplittableRandom;");
                SplittableRandom splittableRandom = this.rng.split();
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom$RandomIntsSpliterator.<init>:(Ljava/util/SplittableRandom;JJII)V");
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(splittableRandom, l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextInt:(II)I");
                int n = this.rng.internalNextInt(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                int n = this.origin;
                int n2 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/SplittableRandom.internalNextInt:(II)I");
                    int n3 = splittableRandom.internalNextInt(n, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                    intConsumer.accept(n3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }
}

