/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.text;

import java.lang.ref.SoftReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.text.CharacterIterator;
import sandbox.java.text.StringCharacterIterator;
import sandbox.java.text.spi.BreakIteratorProvider;
import sandbox.java.util.Locale;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference<BreakIteratorCache>[] iterCache;

    protected BreakIterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public Object clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.following:(I)I");
        int n2 = this.following(n);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < n) break;
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.previous:()I");
            n2 = this.previous();
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    public boolean isBoundary(int n) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.following:(I)I");
        int n2 = this.following(n - 1);
        RuntimeCostAccounter.recordJump();
        if (n2 == -1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/text/StringCharacterIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/StringCharacterIterator.<init>:(Ljava/lang/String;)V");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.setText:(Ljava/text/CharacterIterator;)V");
        this.setText(stringCharacterIterator);
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getWordInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
        return BreakIterator.getWordInstance(locale);
    }

    public static BreakIterator getWordInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getBreakInstance:(Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        return BreakIterator.getBreakInstance(locale, 1);
    }

    public static BreakIterator getLineInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getLineInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
        return BreakIterator.getLineInstance(locale);
    }

    public static BreakIterator getLineInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getBreakInstance:(Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        return BreakIterator.getBreakInstance(locale, 2);
    }

    public static BreakIterator getCharacterInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getCharacterInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
        return BreakIterator.getCharacterInstance(locale);
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getBreakInstance:(Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        return BreakIterator.getBreakInstance(locale, 0);
    }

    public static BreakIterator getSentenceInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getSentenceInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
        return BreakIterator.getSentenceInstance(locale);
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.getBreakInstance:(Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        return BreakIterator.getBreakInstance(locale, 3);
    }

    private static BreakIterator getBreakInstance(Locale locale, int n) {
        Object object;
        SoftReference<BreakIteratorCache> softReference = iterCache[n];
        RuntimeCostAccounter.recordJump();
        if (softReference != null) {
            SoftReference<BreakIteratorCache> softReference2 = iterCache[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
            object = softReference2.get();
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator$BreakIteratorCache.getLocale:()Ljava/util/Locale;");
                Locale locale2 = ((BreakIteratorCache)object).getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
                boolean bl = locale2.equals(locale);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator$BreakIteratorCache.createBreakInstance:()Ljava/text/BreakIterator;");
                    return ((BreakIteratorCache)object).createBreakInstance();
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.createBreakInstance:(Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        object = BreakIterator.createBreakInstance(locale, n);
        RuntimeCostAccounter.recordAllocation((String)"java/text/BreakIterator$BreakIteratorCache");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator$BreakIteratorCache.<init>:(Ljava/util/Locale;Ljava/text/BreakIterator;)V");
        BreakIteratorCache breakIteratorCache = new BreakIteratorCache(locale, (BreakIterator)object);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/SoftReference");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.<init>:(Ljava/lang/Object;)V");
        BreakIterator.iterCache[n] = new SoftReference<BreakIteratorCache>(breakIteratorCache);
        return object;
    }

    private static BreakIterator createBreakInstance(Locale locale, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getAdapter:(Ljava/lang/Class;Ljava/util/Locale;)Lsun/util/locale/provider/LocaleProviderAdapter;");
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(BreakIteratorProvider.class, (Locale)locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.createBreakInstance:(Lsun/util/locale/provider/LocaleProviderAdapter;Ljava/util/Locale;I)Ljava/text/BreakIterator;");
        BreakIterator breakIterator = BreakIterator.createBreakInstance(localeProviderAdapter, locale, n);
        RuntimeCostAccounter.recordJump();
        if (breakIterator == null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.forJRE:()Lsun/util/locale/provider/LocaleProviderAdapter;");
            LocaleProviderAdapter localeProviderAdapter2 = LocaleProviderAdapter.forJRE();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.createBreakInstance:(Lsun/util/locale/provider/LocaleProviderAdapter;Ljava/util/Locale;I)Ljava/text/BreakIterator;");
            breakIterator = BreakIterator.createBreakInstance(localeProviderAdapter2, locale, n);
        }
        return breakIterator;
    }

    private static BreakIterator createBreakInstance(LocaleProviderAdapter localeProviderAdapter, Locale locale, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getBreakIteratorProvider:()Ljava/text/spi/BreakIteratorProvider;");
        BreakIteratorProvider breakIteratorProvider = localeProviderAdapter.getBreakIteratorProvider();
        BreakIterator breakIterator = null;
        switch (n) {
            case 0: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/BreakIteratorProvider.getCharacterInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
                breakIterator = breakIteratorProvider.getCharacterInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 1: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/BreakIteratorProvider.getWordInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
                breakIterator = breakIteratorProvider.getWordInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/BreakIteratorProvider.getLineInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
                breakIterator = breakIteratorProvider.getLineInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/BreakIteratorProvider.getSentenceInstance:(Ljava/util/Locale;)Ljava/text/BreakIterator;");
                breakIterator = breakIteratorProvider.getSentenceInstance(locale);
            }
        }
        return breakIterator;
    }

    public static synchronized Locale[] getAvailableLocales() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getPool:(Ljava/lang/Class;)Lsun/util/locale/provider/LocaleServiceProviderPool;");
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getAvailableLocales:()[Ljava/util/Locale;");
        return localeServiceProviderPool.getAvailableLocales();
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
        iterCache = new SoftReference[4];
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale locale;

        BreakIteratorCache(Locale locale, BreakIterator breakIterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.locale = locale;
            RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.clone:()Ljava/lang/Object;");
            this.iter = (BreakIterator)breakIterator.clone();
        }

        Locale getLocale() {
            return this.locale;
        }

        BreakIterator createBreakInstance() {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/BreakIterator.clone:()Ljava/lang/Object;");
            return (BreakIterator)this.iter.clone();
        }
    }
}

