import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import io.appwrite.Client
import io.appwrite.services.Storage

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        val client = Client(applicationContext)
            .setEndpoint("https://[HOSTNAME_OR_IP]/v1") // Your API Endpoint
            .setProject("5df5acd0d48c2") // Your project ID

        val storage = Storage(client)

        GlobalScope.launch {
            val response = storage.createFile(
                bucketId = "[BUCKET_ID]",
                fileId = "[FILE_ID]",
                file = File("./path-to-files/image.jpg"),
            )
            val json = response.body?.string()        
        }
    }
}