<?php

use Utopia\Auth\Hashes\Argon2;
use Utopia\Database\Database;
use Utopia\Database\Helpers\ID;

return [
    'cache' => [
        '$collection' => Database::METADATA,
        '$id' => 'cache',
        'name' => 'Cache',
        'attributes' => [
            [
                '$id' => 'resource',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'resourceType',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('mimeType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'accessedAt',
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => 'signature',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => '_key_resource',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resource'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'users' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('users'),
        'name' => 'Users',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('email'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 320,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('phone'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16, // leading '+' and 15 digitts maximum by E.164 format
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('labels'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('passwordHistory'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('password'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'hash', // Hashing algorithm used to hash the password
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => (new Argon2())->getName(),
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('hashOptions'), // Configuration of hashing algorithm
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => (new Argon2())->getOptions(),
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('passwordUpdate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('prefs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => new \stdClass(),
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('registration'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('emailVerification'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('phoneVerification'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('reset'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('mfa'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('mfaRecoveryCodes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('authenticators'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryAuthenticators'],
            ],
            [
                '$id' => ID::custom('sessions'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQuerySessions'],
            ],
            [
                '$id' => ID::custom('tokens'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryTokens'],
            ],
            [
                '$id' => ID::custom('challenges'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryChallenges'],
            ],
            [
                '$id' => ID::custom('memberships'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryMemberships'],
            ],
            [
                '$id' => ID::custom('targets'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryTargets'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['userSearch'],
            ],
            [
                '$id' => ID::custom('accessedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('emailCanonical'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 320,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('emailIsFree'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('emailIsDisposable'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('emailIsCorporate'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('emailIsCanonical'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_email'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['email'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_phone'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['phone'],
                'lengths' => [16],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_status'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['status'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_passwordUpdate'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['passwordUpdate'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_registration'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['registration'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_emailVerification'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['emailVerification'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_phoneVerification'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['phoneVerification'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'tokens' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('tokens'),
        'name' => 'Tokens',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('userAgent'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('ip'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 45, // https://stackoverflow.com/a/166157/2299554
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'authenticators' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('authenticators'),
        'name' => 'Authenticators',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('verified'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => false,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('data'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_userInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'challenges' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('challenges'),
        'name' => 'Challenges',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('token'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ], [
                '$id' => ID::custom('code'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ], [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'sessions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('sessions'),
        'name' => 'Sessions',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('provider'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerUid'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerAccessToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('providerAccessTokenExpiry'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('providerRefreshToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('userAgent'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('ip'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 45, // https://stackoverflow.com/a/166157/2299554
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('countryCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientEngine'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientEngineVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceBrand'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceModel'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('factors'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('mfaUpdatedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_provider_providerUid'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['provider', 'providerUid'],
                'lengths' => [128, 128],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'identities' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('identities'),
        'name' => 'Identities',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('provider'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerUid'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048, // Decrease to 128 as in index length?
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerEmail'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 320,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerAccessToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('providerAccessTokenExpiry'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('providerRefreshToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                // Used to store data from provider that may or may not be sensitive
                '$id' => ID::custom('secrets'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('scopes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'required' => false,
                'signed' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_userInternalId_provider_providerUid'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['userInternalId', 'provider', 'providerUid'],
                'lengths' => [11, 128, 128], // providerUid is length 2000!
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_provider_providerUid'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['provider', 'providerUid'],
                'lengths' => [128, 128], // providerUid is length 2000!
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_userId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_userInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_provider'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['provider'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerUid'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerUid'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerEmail'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerEmail'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerAccessTokenExpiry'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerAccessTokenExpiry'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'teams' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('teams'),
        'name' => 'Teams',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('total'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('prefs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => new \stdClass(),
                'array' => false,
                'filters' => ['json'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_total'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['total'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'memberships' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('memberships'),
        'name' => 'Memberships',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('roles'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('invited'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('joined'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('confirm'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_unique'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['teamInternalId', 'userInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_team'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_userId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_teamId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_invited'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['invited'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_joined'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['joined'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_confirm'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['confirm'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'buckets' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('buckets'),
        'name' => 'Buckets',
        'attributes' => [
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 128,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('fileSecurity'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 1,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('maximumFileSize'),
                'type' => Database::VAR_INTEGER,
                'signed' => false,
                'size' => 8,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('allowedFileExtensions'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 64,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => true,
            ],
            [
                '$id' => 'compression',
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 10,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('encryption'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('antivirus'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('transformations'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
                'default' => true,
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_name'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_fileSecurity'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['fileSecurity'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_maximumFileSize'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['maximumFileSize'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_encryption'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['encryption'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_antivirus'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['antivirus'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ]
    ],

    'stats' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('stats'),
        'name' => 'Stats',
        'attributes' => [
            [
                '$id' => ID::custom('metric'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('value'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('time'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('period'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_time'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['time'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
            [
                '$id' => ID::custom('_key_period_time'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['period', 'time'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_metric_period_time'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['metric', 'period', 'time'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ],
    ],

    'providers' => [
        '$collection' => ID::custom(DATABASE::METADATA),
        '$id' => ID::custom('providers'),
        'name' => 'Providers',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('provider'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('credentials'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('options'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => ['providerSearch'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_provider'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['provider'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_type'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['type'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled_type'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled', 'type'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ]
        ],
    ],

    'messages' => [
        '$collection' => ID::custom(DATABASE::METADATA),
        '$id' => ID::custom('messages'),
        'name' => 'Messages',
        'attributes' => [
            [
                '$id' => ID::custom('providerType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => 'processing',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('data'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('topics'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 21845,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('users'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 21845,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('targets'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 21845,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduledAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('scheduleInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduleId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deliveredAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('deliveryErrors'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deliveredTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => ['messageSearch'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'topics' => [
        '$collection' => ID::custom(DATABASE::METADATA),
        '$id' => ID::custom('topics'),
        'name' => 'Topics',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('subscribe'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('emailTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('smsTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('pushTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('targets'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryTopicTargets'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => ['topicSearch'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'subscribers' => [
        '$collection' => ID::custom(DATABASE::METADATA),
        '$id' => ID::custom('subscribers'),
        'name' => 'Subscribers',
        'attributes' => [
            [
                '$id' => ID::custom('targetId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('targetInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('topicId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('topicInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_targetId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['targetId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_targetInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['targetInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_userId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_userInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_topicId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['topicId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_topicInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['topicInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_unique_target_topic'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['targetInternalId', 'topicInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'targets' => [
        '$collection' => ID::custom(DATABASE::METADATA),
        '$id' => ID::custom('targets'),
        'name' => 'Targets',
        'attributes' => [
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sessionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sessionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('identifier'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('expired'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => false,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_userId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_userInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_providerInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_identifier'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['identifier'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_expired'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['expired'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_session_internal_id'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['sessionInternalId'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    // note that this is not required for console & projects.
    'files' => [
        '$collection' => ID::custom('buckets'),
        '$id' => ID::custom('files'),
        '$name' => 'Files',
        'attributes' => [
            [
                'array' => false,
                '$id' => ID::custom('bucketId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('bucketInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('path'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('signature'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('mimeType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('metadata'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 75000, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('sizeOriginal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sizeActual'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('algorithm'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('comment'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLCipher'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLTag'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLIV'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksUploaded'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'transformedAt',
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_bucket'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['bucketId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_signature'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['signature'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_mimeType'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['mimeType'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_sizeOriginal'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['sizeOriginal'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_chunksTotal'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['chunksTotal'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_chunksUploaded'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['chunksUploaded'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_transformedAt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['transformedAt'],
                'lengths' => [],
                'orders' => [],
            ]
        ]
    ],
];
