/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.EOFException;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.PushbackInputStream;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.StandardCharsets;
import sandbox.java.util.zip.CRC32;
import sandbox.java.util.zip.Inflater;
import sandbox.java.util.zip.InflaterInputStream;
import sandbox.java.util.zip.ZipCoder;
import sandbox.java.util.zip.ZipConstants;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipException;
import sandbox.java.util.zip.ZipUtils;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private int flag;
    private CRC32 crc;
    private long remaining;
    private byte[] tmpbuf;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed;
    private boolean entryEOF;
    private ZipCoder zc;
    private byte[] b;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public ZipInputStream(InputStream inputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.<init>:(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V");
        this(inputStream, StandardCharsets.UTF_8);
    }

    public ZipInputStream(InputStream inputStream, Charset charset) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/PushbackInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.<init>:(Ljava/io/InputStream;I)V");
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 512);
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Inflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.<init>:(Z)V");
        Inflater inflater = new Inflater(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Inflater;I)V");
        super(pushbackInputStream, inflater, 512);
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/CRC32");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.<init>:()V");
        this.crc = new CRC32();
        RuntimeCostAccounter.recordArrayAllocation((int)512, (int)1);
        this.tmpbuf = new byte[512];
        this.closed = false;
        this.entryEOF = false;
        RuntimeCostAccounter.recordArrayAllocation((int)256, (int)1);
        this.b = new byte[256];
        this.usesDefaultInflater = true;
        RuntimeCostAccounter.recordJump();
        if (inputStream == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("in is null");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (charset == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("charset is null");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.get:(Ljava/nio/charset/Charset;)Ljava/util/zip/ZipCoder;");
        this.zc = ZipCoder.get(charset);
    }

    public ZipEntry getNextEntry() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.entry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.closeEntry:()V");
            this.closeEntry();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.reset:()V");
        this.crc.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.reset:()V");
        this.inf.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readLOC:()Ljava/util/zip/ZipEntry;");
        this.entry = this.readLOC();
        RuntimeCostAccounter.recordJump();
        if (this.entry == null) {
            return null;
        }
        int n = this.entry.method;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            this.remaining = this.entry.size;
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.ensureOpen:()V");
        this.ensureOpen();
        while (true) {
            int n = this.tmpbuf.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.read:([BII)I");
            int n2 = this.read(this.tmpbuf, 0, n);
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) break;
            RuntimeCostAccounter.recordJump();
        }
        this.entryEOF = true;
    }

    @Override
    public int available() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        block17: {
            block16: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block16;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block16;
                int n3 = byArray.length - n2;
                RuntimeCostAccounter.recordJump();
                if (n <= n3) break block17;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordJump();
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.method) {
            case 8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.read:([BII)I");
                n2 = super.read(byArray, n, n2);
                RuntimeCostAccounter.recordJump();
                if (n2 == -1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readEnd:(Ljava/util/zip/ZipEntry;)V");
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.update:([BII)V");
                    this.crc.update(byArray, n, n2);
                }
                return n2;
            }
            case 0: {
                RuntimeCostAccounter.recordJump();
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                long l = (long)n2 - this.remaining;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 > 0) {
                    n2 = (int)this.remaining;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                n2 = this.in.read(byArray, n, n2);
                RuntimeCostAccounter.recordJump();
                if (n2 == -1) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException("unexpected EOF");
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.update:([BII)V");
                this.crc.update(byArray, n, n2);
                this.remaining -= (long)n2;
                RuntimeCostAccounter.recordJump();
                if (this.remaining == 0L) {
                    long l3 = this.entry.crc;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                    long l4 = l3 - this.crc.getValue();
                    long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l5 != false) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("invalid entry CRC (expected 0x");
                        long l6 = this.entry.crc;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                        String string = Long.toHexString(l6);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append(" but got 0x");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
                        long l7 = this.crc.getValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
                        String string2 = Long.toHexString(l7);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append(")");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string3 = stringBuilder6.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                        ZipException zipException = new ZipException(string3);
                        RuntimeCostAccounter.recordThrow();
                        throw zipException;
                    }
                }
                return n2;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
        ZipException zipException = new ZipException("invalid compression method");
        RuntimeCostAccounter.recordThrow();
        throw zipException;
    }

    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("negative skip length");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        int n = (int)Math.min(l, Integer.MAX_VALUE);
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            int n3 = n - n2;
            int n4 = this.tmpbuf.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n4) {
                n3 = this.tmpbuf.length;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.read:([BII)I");
            n3 = this.read(this.tmpbuf, 0, n3);
            RuntimeCostAccounter.recordJump();
            if (n3 == -1) {
                this.entryEOF = true;
                RuntimeCostAccounter.recordJump();
                break;
            }
            n2 += n3;
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.closed) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.close:()V");
            super.close();
            this.closed = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private ZipEntry readLOC() throws IOException {
        block13: {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readFully:([BII)V");
                this.readFully(this.tmpbuf, 0, 30);
            }
            catch (EOFException var1_1) {
                return null;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
            cfr_temp_0 = ZipUtils.get32(this.tmpbuf, 0) - 67324752L;
            v0 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v0 != false) {
                return null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
            this.flag = ZipUtils.get16(this.tmpbuf, 6);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
            var1_2 = ZipUtils.get16(this.tmpbuf, 26);
            var2_3 = this.b.length;
            RuntimeCostAccounter.recordJump();
            if (var1_2 > var2_3) {
                do {
                    RuntimeCostAccounter.recordJump();
                } while (var1_2 > (var2_3 *= 2));
                v1 = var2_3;
                RuntimeCostAccounter.recordArrayAllocation((int)v1, (int)1);
                this.b = new byte[v1];
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readFully:([BII)V");
            this.readFully(this.b, 0, var1_2);
            RuntimeCostAccounter.recordJump();
            if ((this.flag & 2048) != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toStringUTF8:([BI)Ljava/lang/String;");
                v2 = this.zc.toStringUTF8(this.b, var1_2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
                v2 = this.zc.toString(this.b, var1_2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.createZipEntry:(Ljava/lang/String;)Ljava/util/zip/ZipEntry;");
            var3_4 = this.createZipEntry(v2);
            RuntimeCostAccounter.recordJump();
            if ((this.flag & 1) == 1) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                v3 = new ZipException("encrypted ZIP entry not supported");
                RuntimeCostAccounter.recordThrow();
                throw v3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
            var3_4.method = ZipUtils.get16(this.tmpbuf, 8);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
            v4 = ZipUtils.get32(this.tmpbuf, 10);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.dosToJavaTime:(J)J");
            var3_4.time = ZipUtils.dosToJavaTime(v4);
            RuntimeCostAccounter.recordJump();
            if ((this.flag & 8) == 8) {
                v5 = var3_4.method;
                RuntimeCostAccounter.recordJump();
                if (v5 != 8) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    v6 = new ZipException("only DEFLATED entries can have EXT descriptor");
                    RuntimeCostAccounter.recordThrow();
                    throw v6;
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                var3_4.crc = ZipUtils.get32(this.tmpbuf, 14);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                var3_4.csize = ZipUtils.get32(this.tmpbuf, 18);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                var3_4.size = ZipUtils.get32(this.tmpbuf, 22);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
            var1_2 = ZipUtils.get16(this.tmpbuf, 28);
            RuntimeCostAccounter.recordJump();
            if (var1_2 <= 0) break block13;
            v7 = var1_2;
            RuntimeCostAccounter.recordArrayAllocation((int)v7, (int)1);
            var4_5 = new byte[v7];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readFully:([BII)V");
            this.readFully(var4_5, 0, var1_2);
            cfr_temp_1 = var3_4.csize - 0xFFFFFFFFL;
            v8 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v8 == false) ** GOTO lbl-1000
            cfr_temp_2 = var3_4.size - 0xFFFFFFFFL;
            v9 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v9 == false) lbl-1000:
            // 2 sources

            {
                v10 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                v10 = false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.setExtra0:([BZ)V");
            var3_4.setExtra0(var4_5, v10);
        }
        return var3_4;
    }

    protected ZipEntry createZipEntry(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.<init>:(Ljava/lang/String;)V");
        return new ZipEntry(string);
    }

    /*
     * Unable to fully structure code
     */
    private void readEnd(ZipEntry var1_1) throws IOException {
        block10: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getRemaining:()I");
            var2_2 = this.inf.getRemaining();
            RuntimeCostAccounter.recordJump();
            if (var2_2 > 0) {
                v0 = (PushbackInputStream)this.in;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.unread:([BII)V");
                v0.unread(this.buf, this.len - var2_2, var2_2);
            }
            RuntimeCostAccounter.recordJump();
            if ((this.flag & 8) != 8) break block10;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesWritten:()J");
            cfr_temp_0 = this.inf.getBytesWritten() - 0xFFFFFFFFL;
            v1 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v1 > 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesRead:()J");
            cfr_temp_1 = this.inf.getBytesRead() - 0xFFFFFFFFL;
            v2 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (v2 > 0) lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readFully:([BII)V");
                this.readFully(this.tmpbuf, 0, 24);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                var3_3 = ZipUtils.get32(this.tmpbuf, 0);
                RuntimeCostAccounter.recordJump();
                if (var3_3 != 134695760L) {
                    var1_1.crc = var3_3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                    var1_1.csize = ZipUtils.get64(this.tmpbuf, 4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                    var1_1.size = ZipUtils.get64(this.tmpbuf, 12);
                    v3 = (PushbackInputStream)this.in;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.unread:([BII)V");
                    v3.unread(this.tmpbuf, 19, 4);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.crc = ZipUtils.get32(this.tmpbuf, 4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                    var1_1.csize = ZipUtils.get64(this.tmpbuf, 8);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                    var1_1.size = ZipUtils.get64(this.tmpbuf, 16);
                }
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.readFully:([BII)V");
                this.readFully(this.tmpbuf, 0, 16);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                var3_4 = ZipUtils.get32(this.tmpbuf, 0);
                RuntimeCostAccounter.recordJump();
                if (var3_4 != 134695760L) {
                    var1_1.crc = var3_4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.csize = ZipUtils.get32(this.tmpbuf, 4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.size = ZipUtils.get32(this.tmpbuf, 8);
                    v4 = (PushbackInputStream)this.in;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.unread:([BII)V");
                    v4.unread(this.tmpbuf, 11, 4);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.crc = ZipUtils.get32(this.tmpbuf, 4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.csize = ZipUtils.get32(this.tmpbuf, 8);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                    var1_1.size = ZipUtils.get32(this.tmpbuf, 12);
                }
            }
        }
        v5 = var1_1.size;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesWritten:()J");
        cfr_temp_2 = v5 - this.inf.getBytesWritten();
        v6 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (v6 != false) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            v7 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v8 = v7.append("invalid entry size (expected ");
            v9 = var1_1.size;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            v10 = v8.append(v9);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v11 = v10.append(" but got ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesWritten:()J");
            v12 = this.inf.getBytesWritten();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            v13 = v11.append(v12);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v14 = v13.append(" bytes)");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            v15 = v14.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            v16 = new ZipException(v15);
            RuntimeCostAccounter.recordThrow();
            throw v16;
        }
        v17 = var1_1.csize;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesRead:()J");
        cfr_temp_3 = v17 - this.inf.getBytesRead();
        v18 = cfr_temp_3 == 0L ? 0 : (cfr_temp_3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (v18 != false) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            v19 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v20 = v19.append("invalid entry compressed size (expected ");
            v21 = var1_1.csize;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            v22 = v20.append(v21);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v23 = v22.append(" but got ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesRead:()J");
            v24 = this.inf.getBytesRead();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            v25 = v23.append(v24);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v26 = v25.append(" bytes)");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            v27 = v26.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            v28 = new ZipException(v27);
            RuntimeCostAccounter.recordThrow();
            throw v28;
        }
        v29 = var1_1.crc;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
        cfr_temp_4 = v29 - this.crc.getValue();
        v30 = cfr_temp_4 == 0L ? 0 : (cfr_temp_4 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (v30 != false) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            v31 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v32 = v31.append("invalid entry CRC (expected 0x");
            v33 = var1_1.crc;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
            v34 = Long.toHexString(v33);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v35 = v32.append(v34);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v36 = v35.append(" but got 0x");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
            v37 = this.crc.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
            v38 = Long.toHexString(v37);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v39 = v36.append(v38);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v40 = v39.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            v41 = v40.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            v42 = new ZipException(v41);
            RuntimeCostAccounter.recordThrow();
            throw v42;
        }
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            int n3 = this.in.read(byArray, n, n2);
            RuntimeCostAccounter.recordJump();
            if (n3 == -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            n += n3;
            n2 -= n3;
            RuntimeCostAccounter.recordJump();
        }
    }
}

