/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.EOFException;
import sandbox.java.io.File;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.StandardCharsets;
import sandbox.java.util.ArrayDeque;
import sandbox.java.util.Deque;
import sandbox.java.util.Enumeration;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Set;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.WeakHashMap;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.zip.Inflater;
import sandbox.java.util.zip.InflaterInputStream;
import sandbox.java.util.zip.ZipCoder;
import sandbox.java.util.zip.ZipConstants;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipError;
import sandbox.java.util.zip.ZipException;
import sandbox.java.util.zip.ZipUtils;
import sandbox.sun.misc.JavaUtilZipFileAccess;
import sandbox.sun.misc.PerfCounter;
import sandbox.sun.misc.SharedSecrets;
import sandbox.sun.misc.VM;

public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private final String name;
    private final int total;
    private final boolean locsig;
    private volatile boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams;
    private Deque<Inflater> inflaterCache;
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;I)V");
        this(file, 1);
    }

    public ZipFile(File file, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;ILjava/nio/charset/Charset;)V");
        this(file, n, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;I)V");
        this(file, 1);
    }

    public ZipFile(File file, int n, Charset charset) throws IOException {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.closeRequested = false;
                RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.<init>:()V");
                this.streams = new WeakHashMap<InputStream, Inflater>();
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.<init>:()V");
                this.inflaterCache = new ArrayDeque<Inflater>();
                RuntimeCostAccounter.recordJump();
                if ((n & 1) == 0) break block6;
                RuntimeCostAccounter.recordJump();
                if ((n & 0xFFFFFFFA) == 0) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Illegal mode: 0x");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toHexString:(I)Ljava/lang/String;");
            String string = Integer.toHexString(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string = file.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(string);
            RuntimeCostAccounter.recordJump();
            if ((n & 4) != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkDelete:(Ljava/lang/String;)V");
                securityManager.checkDelete(string);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (charset == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("charset is null");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.get:(Ljava/nio/charset/Charset;)Ljava/util/zip/ZipCoder;");
        this.zc = ZipCoder.get(charset);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l = System.nanoTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
        long l2 = file.lastModified();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.open:(Ljava/lang/String;IJZ)J");
        this.jzfile = ZipFile.open(string, n, l2, usemmap);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/PerfCounter.getZipFileOpenTime:()Lsun/misc/PerfCounter;");
        PerfCounter perfCounter = PerfCounter.getZipFileOpenTime();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/PerfCounter.addElapsedTimeFrom:(J)V");
        perfCounter.addElapsedTimeFrom(l);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/PerfCounter.getZipFileCount:()Lsun/misc/PerfCounter;");
        PerfCounter perfCounter2 = PerfCounter.getZipFileCount();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/PerfCounter.increment:()V");
        perfCounter2.increment();
        this.name = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getTotal:(J)I");
        this.total = ZipFile.getTotal(this.jzfile);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.startsWithLOC:(J)Z");
        this.locsig = ZipFile.startsWithLOC(this.jzfile);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;ILjava/nio/charset/Charset;)V");
        this(file, 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;ILjava/nio/charset/Charset;)V");
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getCommentBytes:(J)[B");
            byte[] byArray = ZipFile.getCommentBytes(this.jzfile);
            RuntimeCostAccounter.recordJump();
            if (byArray == null) {
                return null;
            }
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
            return this.zc.toString(byArray, n);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("name");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        long l = 0L;
        ZipFile zipFile = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
            byte[] byArray = this.zc.getBytes(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntry:(J[BZ)J");
            l = ZipFile.getEntry(this.jzfile, byArray, true);
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getZipEntry:(Ljava/lang/String;J)Ljava/util/zip/ZipEntry;");
                ZipEntry zipEntry = this.getZipEntry(string, l);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.freeEntry:(JJ)V");
                ZipFile.freeEntry(this.jzfile, l);
                return zipEntry;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public InputStream getInputStream(ZipEntry var1_1) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (var1_1 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            v0 = new NullPointerException("entry");
            RuntimeCostAccounter.recordThrow();
            throw v0;
        }
        var2_2 = 0L;
        var4_3 = null;
        var5_4 = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.isUTF8:()Z");
            v1 = this.zc.isUTF8();
            RuntimeCostAccounter.recordJump();
            if (v1) ** GOTO lbl-1000
            v2 = var1_1.flag & 2048;
            RuntimeCostAccounter.recordJump();
            if (v2 != 0) {
                v3 = var1_1.name;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytesUTF8:(Ljava/lang/String;)[B");
                v4 = this.zc.getBytesUTF8(v3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntry:(J[BZ)J");
                var2_2 = ZipFile.getEntry(this.jzfile, v4, false);
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                v5 = var1_1.name;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.getBytes:(Ljava/lang/String;)[B");
                v6 = this.zc.getBytes(v5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntry:(J[BZ)J");
                var2_2 = ZipFile.getEntry(this.jzfile, v6, false);
            }
            RuntimeCostAccounter.recordJump();
            if (var2_2 == 0L) {
                return null;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipFile$ZipFileInputStream");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.<init>:(Ljava/util/zip/ZipFile;J)V");
            var4_3 = new ZipFileInputStream(var2_2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryMethod:(J)I");
            switch (ZipFile.getEntryMethod(var2_2)) {
                case 0: {
                    var6_5 = this.streams;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.streams.put(var4_3, null);
                    }
                    catch (Throwable var7_6) {
                        RuntimeCostAccounter.recordThrow();
                        throw var7_6;
                    }
                    RuntimeCostAccounter.recordJump();
                    return var4_3;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntrySize:(J)J");
                    var8_7 = ZipFile.getEntrySize(var2_2) + 2L;
                    RuntimeCostAccounter.recordJump();
                    if (var8_7 > 65536L) {
                        var8_7 = 8192L;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var8_7 <= 0L) {
                        var8_7 = 4096L;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInflater:()Ljava/util/zip/Inflater;");
                    var10_8 = this.getInflater();
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipFile$ZipFileInflaterInputStream");
                    v7 = (int)var8_7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInflaterInputStream.<init>:(Ljava/util/zip/ZipFile;Ljava/util/zip/ZipFile$ZipFileInputStream;Ljava/util/zip/Inflater;I)V");
                    var11_9 = new ZipFileInflaterInputStream(var4_3, var10_8, v7);
                    var12_10 = this.streams;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.streams.put(var11_9, var10_8);
                    }
                    catch (Throwable var13_11) {
                        RuntimeCostAccounter.recordThrow();
                        throw var13_11;
                    }
                    RuntimeCostAccounter.recordJump();
                    return var11_9;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            v8 = new ZipException("invalid compression method");
            RuntimeCostAccounter.recordThrow();
            throw v8;
        }
        catch (Throwable var14_12) {
            RuntimeCostAccounter.recordThrow();
            throw var14_12;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Inflater getInflater() {
        block3: {
            Deque<Inflater> deque = this.inflaterCache;
            try {
                Inflater inflater;
                boolean bl;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.poll:()Ljava/lang/Object;");
                    inflater = this.inflaterCache.poll();
                    RuntimeCostAccounter.recordJump();
                    if (null == inflater) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.ended:()Z");
                    bl = inflater.ended();
                    RuntimeCostAccounter.recordJump();
                } while (bl);
                return inflater;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Inflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.<init>:(Z)V");
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.ended:()Z");
        boolean bl = inflater.ended();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.reset:()V");
            inflater.reset();
            Deque<Inflater> deque = this.inflaterCache;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.add:(Ljava/lang/Object;)Z");
                this.inflaterCache.add(inflater);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipFile$ZipEntryIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipEntryIterator.<init>:(Ljava/util/zip/ZipFile;)V");
        return new ZipEntryIterator();
    }

    public Stream<? extends ZipEntry> stream() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipFile$ZipEntryIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipEntryIterator.<init>:(Ljava/util/zip/ZipFile;)V");
        ZipEntryIterator zipEntryIterator = new ZipEntryIterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.size:()I");
        long l = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:(Ljava/util/Iterator;JI)Ljava/util/Spliterator;");
        Spliterator<ZipEntry> spliterator = Spliterators.spliterator(zipEntryIterator, l, 1297);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(spliterator, false);
    }

    /*
     * Unable to fully structure code
     */
    private ZipEntry getZipEntry(String var1_1, long var2_2) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipEntry");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.<init>:()V");
                        var4_3 = new ZipEntry();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryFlag:(J)I");
                        var4_3.flag = ZipFile.getEntryFlag(var2_2);
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 == null) break block4;
                        var4_3.name = var1_1;
                        RuntimeCostAccounter.recordJump();
                        break block5;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryBytes:(JI)[B");
                    var5_4 = ZipFile.getEntryBytes(var2_2, 0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.isUTF8:()Z");
                    v0 = this.zc.isUTF8();
                    RuntimeCostAccounter.recordJump();
                    if (v0) ** GOTO lbl-1000
                    v1 = var4_3.flag & 2048;
                    RuntimeCostAccounter.recordJump();
                    if (v1 != 0) {
                        v2 = var5_4.length;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toStringUTF8:([BI)Ljava/lang/String;");
                        var4_3.name = this.zc.toStringUTF8(var5_4, v2);
                        RuntimeCostAccounter.recordJump();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = var5_4.length;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
                        var4_3.name = this.zc.toString(var5_4, v3);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryTime:(J)J");
                v4 = ZipFile.getEntryTime(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.dosToJavaTime:(J)J");
                var4_3.time = ZipUtils.dosToJavaTime(v4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryCrc:(J)J");
                var4_3.crc = ZipFile.getEntryCrc(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntrySize:(J)J");
                var4_3.size = ZipFile.getEntrySize(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryCSize:(J)J");
                var4_3.csize = ZipFile.getEntryCSize(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryMethod:(J)I");
                var4_3.method = ZipFile.getEntryMethod(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryBytes:(JI)[B");
                v5 = ZipFile.getEntryBytes(var2_2, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.setExtra0:([BZ)V");
                var4_3.setExtra0(v5, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryBytes:(JI)[B");
                var5_4 = ZipFile.getEntryBytes(var2_2, 2);
                RuntimeCostAccounter.recordJump();
                if (var5_4 != null) break block6;
                var4_3.comment = null;
                RuntimeCostAccounter.recordJump();
                break block7;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.isUTF8:()Z");
            v6 = this.zc.isUTF8();
            RuntimeCostAccounter.recordJump();
            if (v6) ** GOTO lbl-1000
            v7 = var4_3.flag & 2048;
            RuntimeCostAccounter.recordJump();
            if (v7 != 0) {
                v8 = var5_4.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toStringUTF8:([BI)Ljava/lang/String;");
                var4_3.comment = this.zc.toStringUTF8(var5_4, v8);
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                v9 = var5_4.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipCoder.toString:([BI)Ljava/lang/String;");
                var4_3.comment = this.zc.toString(var5_4, v9);
            }
        }
        return var4_3;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpen:()V");
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        try {
            Object object;
            Object object2 = this.streams;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                boolean bl = this.streams.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(Ljava/util/Map;)V");
                    object = new HashMap<InputStream, Inflater>(this.streams);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
                    this.streams.clear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                    Set set = object.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator iterator = set.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl2 = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        Map.Entry entry = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        InputStream inputStream = (InputStream)entry.getKey();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                        inputStream.close();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                        Inflater inflater = (Inflater)entry.getValue();
                        RuntimeCostAccounter.recordJump();
                        if (inflater != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.end:()V");
                            inflater.end();
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            object = this.inflaterCache;
            try {
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.poll:()Ljava/lang/Object;");
                    object2 = this.inflaterCache.poll();
                    RuntimeCostAccounter.recordJump();
                    if (null == object2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.end:()V");
                    ((Inflater)object2).end();
                    RuntimeCostAccounter.recordJump();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (this.jzfile != 0L) {
                long l = this.jzfile;
                this.jzfile = 0L;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.close:(J)V");
                ZipFile.close(l);
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    protected void finalize() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.close:()V");
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        RuntimeCostAccounter.recordJump();
        if (this.closeRequested) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("zip file closed");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.jzfile == 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("The object is not initialized.");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closeRequested) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException("ZipFile closed");
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
    }

    private boolean startsWithLocHeader() {
        return this.locsig;
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native boolean startsWithLOC(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static /* synthetic */ void access$100(ZipFile zipFile, Inflater inflater) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.releaseInflater:(Ljava/util/zip/Inflater;)V");
        zipFile.releaseInflater(inflater);
    }

    static /* synthetic */ void access$200(ZipFile zipFile) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpen:()V");
        zipFile.ensureOpen();
    }

    static /* synthetic */ long access$500(long l, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getNextEntry:(JI)J");
        return ZipFile.getNextEntry(l, n);
    }

    static /* synthetic */ String access$700(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getZipMessage:(J)Ljava/lang/String;");
        return ZipFile.getZipMessage(l);
    }

    static /* synthetic */ ZipEntry access$900(ZipFile zipFile, String string, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getZipEntry:(Ljava/lang/String;J)Ljava/util/zip/ZipEntry;");
        return zipFile.getZipEntry(string, l);
    }

    static /* synthetic */ void access$1000(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.freeEntry:(JJ)V");
        ZipFile.freeEntry(l, l2);
    }

    static /* synthetic */ long access$1100(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntryCSize:(J)J");
        return ZipFile.getEntryCSize(l);
    }

    static /* synthetic */ long access$1200(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntrySize:(J)J");
        return ZipFile.getEntrySize(l);
    }

    static /* synthetic */ void access$1300(ZipFile zipFile) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.ensureOpenOrZipException:()V");
        zipFile.ensureOpenOrZipException();
    }

    static /* synthetic */ int access$1400(long l, long l2, long l3, byte[] byArray, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.read:(JJJ[BII)I");
        return ZipFile.read(l, l2, l3, byArray, n, n2);
    }

    static /* synthetic */ boolean access$1500(ZipFile zipFile) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.startsWithLocHeader:()Z");
        return zipFile.startsWithLocHeader();
    }

    /*
     * Unable to fully structure code
     */
    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.initIDs:()V");
        ZipFile.initIDs();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/VM.getSavedProperty:(Ljava/lang/String;)Ljava/lang/String;");
        var0 = VM.getSavedProperty((String)"sun.zip.disableMemoryMapping");
        RuntimeCostAccounter.recordJump();
        if (var0 == null) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        v0 = var0.length();
        RuntimeCostAccounter.recordJump();
        if (v0 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            v1 = var0.equalsIgnoreCase("true");
            RuntimeCostAccounter.recordJump();
            ** if (v1) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = true;
            RuntimeCostAccounter.recordJump();
            ** GOTO lbl20
        }
lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
lbl20:
        // 2 sources

        ZipFile.usemmap = v2;
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipFile$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$1.<init>:()V");
        v3 = new JavaUtilZipFileAccess(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public boolean startsWithLocHeader(ZipFile zipFile) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1500:(Ljava/util/zip/ZipFile;)Z");
                return ZipFile.access$1500(zipFile);
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.setJavaUtilZipFileAccess:(Lsun/misc/JavaUtilZipFileAccess;)V");
        SharedSecrets.setJavaUtilZipFileAccess((JavaUtilZipFileAccess)v3);
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        protected long jzentry;
        private long pos;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
            this.closeRequested = false;
            this.pos = 0L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1100:(J)J");
            this.rem = ZipFile.access$1100(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1200:(J)J");
            this.size = ZipFile.access$1200(l);
            this.jzentry = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            ZipFile zipFile = ZipFile.this;
            try {
                long l = this.rem;
                long l2 = this.pos;
                RuntimeCostAccounter.recordJump();
                if (l == 0L) {
                    return -1;
                }
                RuntimeCostAccounter.recordJump();
                if (n2 <= 0) {
                    return 0;
                }
                long l3 = (long)n2 - l;
                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l4 > 0) {
                    n2 = (int)l;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1300:(Ljava/util/zip/ZipFile;)V");
                ZipFile.access$1300(ZipFile.this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                long l5 = ZipFile.this.jzfile;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1400:(JJJ[BII)I");
                n2 = ZipFile.access$1400(l5, this.jzentry, l2, byArray, n, n2);
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) {
                    this.pos = l2 + (long)n2;
                    this.rem = l - (long)n2;
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (this.rem == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.close:()V");
                this.close();
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
            byte[] byArray = new byte[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.read:([BII)I");
            int n = this.read(byArray, 0, 1);
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long l) {
            RuntimeCostAccounter.recordJump();
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            RuntimeCostAccounter.recordJump();
            if (this.rem == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.close:()V");
                this.close();
            }
            return l;
        }

        @Override
        public int available() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.rem > Integer.MAX_VALUE) {
                n = Integer.MAX_VALUE;
                RuntimeCostAccounter.recordJump();
            } else {
                n = (int)this.rem;
            }
            return n;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object;
            block6: {
                RuntimeCostAccounter.recordJump();
                if (this.closeRequested) {
                    return;
                }
                this.closeRequested = true;
                this.rem = 0L;
                object = ZipFile.this;
                try {
                    RuntimeCostAccounter.recordJump();
                    if (this.jzentry == 0L) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                    long l = ZipFile.this.jzfile - 0L;
                    long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l2 != false) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                        long l3 = ZipFile.this.jzfile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1000:(JJ)V");
                        ZipFile.access$1000(l3, this.jzentry);
                        this.jzentry = 0L;
                    }
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$000:(Ljava/util/zip/ZipFile;)Ljava/util/Map;");
            object = ZipFile.this.streams;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$000:(Ljava/util/zip/ZipFile;)Ljava/util/Map;");
                Map map = ZipFile.this.streams;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                map.remove(this);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        protected void finalize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.close:()V");
            this.close();
        }
    }

    private class ZipEntryIterator
    implements Enumeration<ZipEntry>,
    Iterator<ZipEntry> {
        private int i;

        public ZipEntryIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.i = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$200:(Ljava/util/zip/ZipFile;)V");
            ZipFile.access$200(ZipFile.this);
        }

        @Override
        public boolean hasMoreElements() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipEntryIterator.hasNext:()Z");
            return this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ZipFile zipFile = ZipFile.this;
            try {
                boolean bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$200:(Ljava/util/zip/ZipFile;)V");
                ZipFile.access$200(ZipFile.this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$300:(Ljava/util/zip/ZipFile;)I");
                int n = ZipFile.this.total;
                RuntimeCostAccounter.recordJump();
                if (this.i < n) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        @Override
        public ZipEntry nextElement() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipEntryIterator.next:()Ljava/util/zip/ZipEntry;");
            return this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZipEntry next() {
            ZipFile zipFile = ZipFile.this;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$200:(Ljava/util/zip/ZipFile;)V");
                ZipFile.access$200(ZipFile.this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$300:(Ljava/util/zip/ZipFile;)I");
                int n = ZipFile.this.total;
                RuntimeCostAccounter.recordJump();
                if (this.i >= n) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                long l = ZipFile.this.jzfile;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$500:(JI)J");
                long l2 = ZipFile.access$500(l, this.i++);
                RuntimeCostAccounter.recordJump();
                if (l2 == 0L) {
                    String string;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$600:(Ljava/util/zip/ZipFile;)Z");
                    boolean bl = ZipFile.this.closeRequested;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        string = "ZipFile concurrently closed";
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                        long l3 = ZipFile.this.jzfile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$700:(J)Ljava/lang/String;");
                        string = ZipFile.access$700(l3);
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipError");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("jzentry == 0,\n jzfile = ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                    long l4 = ZipFile.this.jzfile;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(",\n total = ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$300:(Ljava/util/zip/ZipFile;)I");
                    int n2 = ZipFile.this.total;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append(",\n name = ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$800:(Ljava/util/zip/ZipFile;)Ljava/lang/String;");
                    String string2 = ZipFile.this.name;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder7.append(",\n i = ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder8.append(this.i);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder10 = stringBuilder9.append(",\n message = ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder11 = stringBuilder10.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string3 = stringBuilder11.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipError.<init>:(Ljava/lang/String;)V");
                    ZipError zipError = new ZipError(string3);
                    RuntimeCostAccounter.recordThrow();
                    throw zipError;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$900:(Ljava/util/zip/ZipFile;Ljava/lang/String;J)Ljava/util/zip/ZipEntry;");
                ZipEntry zipEntry = ZipFile.access$900(ZipFile.this, null, l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$400:(Ljava/util/zip/ZipFile;)J");
                long l5 = ZipFile.this.jzfile;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$1000:(JJ)V");
                ZipFile.access$1000(l5, l2);
                return zipEntry;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final ZipFileInputStream zfin;

        ZipFileInflaterInputStream(ZipFileInputStream zipFileInputStream, Inflater inflater, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Inflater;I)V");
            super(zipFileInputStream, inflater, n);
            this.closeRequested = false;
            this.eof = false;
            this.zfin = zipFileInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Inflater inflater;
            RuntimeCostAccounter.recordJump();
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.close:()V");
            super.close();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$000:(Ljava/util/zip/ZipFile;)Ljava/util/Map;");
            Map map = ZipFile.this.streams;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$000:(Ljava/util/zip/ZipFile;)Ljava/util/Map;");
                Map map2 = ZipFile.this.streams;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                inflater = (Inflater)map2.remove(this);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (inflater != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.access$100:(Ljava/util/zip/ZipFile;Ljava/util/zip/Inflater;)V");
                ZipFile.access$100(ZipFile.this, inflater);
            }
        }

        @Override
        protected void fill() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.eof) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:(Ljava/lang/String;)V");
                EOFException eOFException = new EOFException("Unexpected end of ZLIB input stream");
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            int n = this.buf.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            this.len = this.in.read(this.buf, 0, n);
            RuntimeCostAccounter.recordJump();
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.setInput:([BII)V");
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.closeRequested) {
                return 0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInputStream.size:()J");
            long l = this.zfin.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.getBytesWritten:()J");
            long l2 = l - this.inf.getBytesWritten();
            RuntimeCostAccounter.recordJump();
            if (l2 > Integer.MAX_VALUE) {
                n = Integer.MAX_VALUE;
                RuntimeCostAccounter.recordJump();
            } else {
                n = (int)l2;
            }
            return n;
        }

        protected void finalize() throws Throwable {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile$ZipFileInflaterInputStream.close:()V");
            this.close();
        }
    }
}

