/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.util.zip.DataFormatException;
import sandbox.java.util.zip.Inflater;
import sandbox.java.util.zip.ZipException;

public class InflaterOutputStream
extends FilterOutputStream {
    protected final Inflater inf;
    protected final byte[] buf;
    private final byte[] wbuf;
    private boolean usesDefaultInflater;
    private boolean closed;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public InflaterOutputStream(OutputStream outputStream) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Inflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.<init>:()V");
        Inflater inflater = new Inflater();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.<init>:(Ljava/io/OutputStream;Ljava/util/zip/Inflater;)V");
        this(outputStream, inflater);
        this.usesDefaultInflater = true;
    }

    public InflaterOutputStream(OutputStream outputStream, Inflater inflater) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.<init>:(Ljava/io/OutputStream;Ljava/util/zip/Inflater;I)V");
        this(outputStream, inflater, 512);
    }

    public InflaterOutputStream(OutputStream outputStream, Inflater inflater, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
        this.wbuf = new byte[1];
        this.usesDefaultInflater = false;
        this.closed = false;
        RuntimeCostAccounter.recordJump();
        if (outputStream == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("Null output");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (inflater == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("Null inflater");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size < 1");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.inf = inflater;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.closed) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.finish:()V");
                this.finish();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
                this.out.close();
                this.closed = true;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
            this.out.close();
            this.closed = true;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void flush() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.finished:()Z");
        boolean bl = this.inf.finished();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            try {
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.finished:()Z");
                    boolean bl2 = this.inf.finished();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.needsInput:()Z");
                    boolean bl3 = this.inf.needsInput();
                    RuntimeCostAccounter.recordJump();
                    if (bl3) break;
                    int n = this.buf.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.inflate:([BII)I");
                    int n2 = this.inf.inflate(this.buf, 0, n);
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 1) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                    this.out.write(this.buf, 0, n2);
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.flush:()V");
                super.flush();
            }
            catch (DataFormatException dataFormatException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DataFormatException.getMessage:()Ljava/lang/String;");
                String string = dataFormatException.getMessage();
                RuntimeCostAccounter.recordJump();
                if (string == null) {
                    string = "Invalid ZLIB data format";
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                ZipException zipException = new ZipException(string);
                RuntimeCostAccounter.recordThrow();
                throw zipException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public void finish() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.flush:()V");
        this.flush();
        RuntimeCostAccounter.recordJump();
        if (this.usesDefaultInflater) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.end:()V");
            this.inf.end();
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.wbuf[0] = (byte)n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.write:([BII)V");
        this.write(this.wbuf, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        block20: {
            block19: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterOutputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
                    NullPointerException nullPointerException = new NullPointerException("Null buffer for read");
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block19;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block19;
                int n3 = byArray.length - n;
                RuntimeCostAccounter.recordJump();
                if (n2 <= n3) break block20;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        try {
            while (true) {
                int n4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.needsInput:()Z");
                boolean bl = this.inf.needsInput();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    int n5;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 1) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 512) {
                        n5 = n2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n5 = 512;
                    }
                    int n6 = n5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.setInput:([BII)V");
                    this.inf.setInput(byArray, n, n6);
                    n += n6;
                    n2 -= n6;
                }
                do {
                    int n7 = this.buf.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.inflate:([BII)I");
                    n4 = this.inf.inflate(this.buf, 0, n7);
                    RuntimeCostAccounter.recordJump();
                    if (n4 > 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                        this.out.write(this.buf, 0, n4);
                    }
                    RuntimeCostAccounter.recordJump();
                } while (n4 > 0);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.finished:()Z");
                boolean bl2 = this.inf.finished();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.needsDictionary:()Z");
                boolean bl3 = this.inf.needsDictionary();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
                    ZipException zipException = new ZipException("ZLIB dictionary missing");
                    RuntimeCostAccounter.recordThrow();
                    throw zipException;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (DataFormatException dataFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DataFormatException.getMessage:()Ljava/lang/String;");
            String string = dataFormatException.getMessage();
            RuntimeCostAccounter.recordJump();
            if (string == null) {
                string = "Invalid ZLIB data format";
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException(string);
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
        RuntimeCostAccounter.recordJump();
    }
}

