/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.regex;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.regex.ASCII;
import sandbox.java.util.regex.MatchResult;
import sandbox.java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode;
    int first;
    int last;
    int oldLast;
    int lastAppendPosition;
    int[] locals;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds;
    boolean anchoringBounds;

    Matcher() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.acceptMode = 0;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        this.lastAppendPosition = 0;
        this.transparentBounds = false;
        this.anchoringBounds = true;
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.acceptMode = 0;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        this.lastAppendPosition = 0;
        this.transparentBounds = false;
        this.anchoringBounds = true;
        this.parentPattern = pattern;
        this.text = charSequence;
        int n = pattern.capturingGroupCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n2 = Math.max(n, 10);
        int n3 = n2 * 2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        this.groups = new int[n3];
        int n4 = pattern.localCount;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        this.locals = new int[n4];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/regex/Matcher");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        String string = this.text.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.<init>:(Ljava/util/regex/Pattern;Ljava/lang/CharSequence;)V");
        Matcher matcher = new Matcher(this.parentPattern, string);
        matcher.first = this.first;
        matcher.last = this.last;
        RuntimeCostAccounter.recordMethodCall((String)"[I.clone:()Ljava/lang/Object;");
        matcher.groups = (int[])this.groups.clone();
        return matcher;
    }

    public Matcher usePattern(Pattern pattern) {
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Pattern cannot be null");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.parentPattern = pattern;
        int n = pattern.capturingGroupCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n2 = Math.max(n, 10);
        int n3 = n2 * 2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        this.groups = new int[n3];
        int n4 = pattern.localCount;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        this.locals = new int[n4];
        int n5 = 0;
        while (true) {
            int n6 = this.groups.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            this.groups[n5] = -1;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        n5 = 0;
        while (true) {
            int n7 = this.locals.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n7) break;
            this.locals[n5] = -1;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        return this;
    }

    public Matcher reset() {
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        int n = 0;
        while (true) {
            int n2 = this.groups.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            this.groups[n] = -1;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        n = 0;
        while (true) {
            int n3 = this.locals.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n3) break;
            this.locals[n] = -1;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getTextLength:()I");
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        return this.reset();
    }

    @Override
    public int start() {
        RuntimeCostAccounter.recordJump();
        if (this.first < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("No match available");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        return this.first;
    }

    @Override
    public int start(int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (this.first < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("No match available");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.groupCount:()I");
                int n2 = this.groupCount();
                RuntimeCostAccounter.recordJump();
                if (n <= n2) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("No group ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        return this.groups[n * 2];
    }

    public int start(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getMatchedGroupIndex:(Ljava/lang/String;)I");
        return this.groups[this.getMatchedGroupIndex(string) * 2];
    }

    @Override
    public int end() {
        RuntimeCostAccounter.recordJump();
        if (this.first < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("No match available");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        return this.last;
    }

    @Override
    public int end(int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (this.first < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("No match available");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.groupCount:()I");
                int n2 = this.groupCount();
                RuntimeCostAccounter.recordJump();
                if (n <= n2) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("No group ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        return this.groups[n * 2 + 1];
    }

    public int end(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getMatchedGroupIndex:(Ljava/lang/String;)I");
        return this.groups[this.getMatchedGroupIndex(string) * 2 + 1];
    }

    @Override
    public String group() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
        return this.group(0);
    }

    @Override
    public String group(int n) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        RuntimeCostAccounter.recordJump();
                        if (this.first < 0) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                            IllegalStateException illegalStateException = new IllegalStateException("No match found");
                            RuntimeCostAccounter.recordThrow();
                            throw illegalStateException;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.groupCount:()I");
                        int n2 = this.groupCount();
                        RuntimeCostAccounter.recordJump();
                        if (n <= n2) break block8;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("No group ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                int n3 = this.groups[n * 2];
                RuntimeCostAccounter.recordJump();
                if (n3 == -1) break block9;
                int n4 = this.groups[n * 2 + 1];
                RuntimeCostAccounter.recordJump();
                if (n4 != -1) break block10;
            }
            return null;
        }
        int n5 = this.groups[n * 2];
        int n6 = this.groups[n * 2 + 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getSubSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence = this.getSubSequence(n5, n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        return charSequence.toString();
    }

    public String group(String string) {
        int n;
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getMatchedGroupIndex:(Ljava/lang/String;)I");
                n = this.getMatchedGroupIndex(string);
                int n2 = this.groups[n * 2];
                RuntimeCostAccounter.recordJump();
                if (n2 == -1) break block2;
                int n3 = this.groups[n * 2 + 1];
                RuntimeCostAccounter.recordJump();
                if (n3 != -1) break block3;
            }
            return null;
        }
        int n4 = this.groups[n * 2];
        int n5 = this.groups[n * 2 + 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getSubSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence = this.getSubSequence(n4, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        return charSequence.toString();
    }

    @Override
    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.match:(II)Z");
        return this.match(this.from, 1);
    }

    public boolean find() {
        int n = this.last;
        RuntimeCostAccounter.recordJump();
        if (n == this.first) {
            ++n;
        }
        RuntimeCostAccounter.recordJump();
        if (n < this.from) {
            n = this.from;
        }
        RuntimeCostAccounter.recordJump();
        if (n > this.to) {
            int n2 = 0;
            while (true) {
                int n3 = this.groups.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                this.groups[n2] = -1;
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.search:(I)Z");
        return this.search(n);
    }

    public boolean find(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getTextLength:()I");
                int n2 = this.getTextLength();
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= n2) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("Illegal start index");
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        this.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.search:(I)Z");
        return this.search(n);
    }

    public boolean lookingAt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.match:(II)Z");
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
        int n = string.indexOf(92);
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
            int n2 = string.indexOf(36);
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) {
                return string;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            char c;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n4 = string.length();
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n4) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                    c = string.charAt(n3);
                    RuntimeCostAccounter.recordJump();
                    if (c == '\\') break block6;
                    RuntimeCostAccounter.recordJump();
                    if (c != '$') break block7;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append('\\');
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append(c);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        RuntimeCostAccounter.recordJump();
        if (this.first < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("No match available");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        int n = 0;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            block22: {
                char c;
                block23: {
                    int n2;
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    block21: {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        int n3 = string.length();
                                        RuntimeCostAccounter.recordJump();
                                        if (n >= n3) break;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                        c = string.charAt(n);
                                        RuntimeCostAccounter.recordJump();
                                        if (c != '\\') break block21;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        int n4 = string.length();
                                        RuntimeCostAccounter.recordJump();
                                        if (++n == n4) {
                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("character to be escaped is missing");
                                            RuntimeCostAccounter.recordThrow();
                                            throw illegalArgumentException;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                        c = string.charAt(n);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                        stringBuilder.append(c);
                                        ++n;
                                        RuntimeCostAccounter.recordJump();
                                        break block22;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (c != '$') break block23;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                    int n5 = string.length();
                                    RuntimeCostAccounter.recordJump();
                                    if (++n == n5) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal group reference: group index is missing");
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                    c = string.charAt(n);
                                    n2 = -1;
                                    RuntimeCostAccounter.recordJump();
                                    if (c != '{') break block24;
                                    ++n;
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    while (true) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        int n6 = string.length();
                                        RuntimeCostAccounter.recordJump();
                                        if (n >= n6) break;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                        c = string.charAt(n);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/ASCII.isLower:(I)Z");
                                        boolean bl = ASCII.isLower(c);
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/ASCII.isUpper:(I)Z");
                                            boolean bl2 = ASCII.isUpper(c);
                                            RuntimeCostAccounter.recordJump();
                                            if (!bl2) {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/ASCII.isDigit:(I)Z");
                                                boolean bl3 = ASCII.isDigit(c);
                                                RuntimeCostAccounter.recordJump();
                                                if (!bl3) break;
                                            }
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                        stringBuilder2.append(c);
                                        ++n;
                                        RuntimeCostAccounter.recordJump();
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                                    int n7 = stringBuilder2.length();
                                    RuntimeCostAccounter.recordJump();
                                    if (n7 == 0) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("named capturing group has 0 length name");
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (c != '}') {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("named capturing group is missing trailing '}'");
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                    String string2 = stringBuilder2.toString();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                    char c2 = string2.charAt(0);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/ASCII.isDigit:(I)Z");
                                    boolean bl = ASCII.isDigit(c2);
                                    RuntimeCostAccounter.recordJump();
                                    if (bl) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                        StringBuilder stringBuilder3 = new StringBuilder();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder4 = stringBuilder3.append("capturing group name {");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder6 = stringBuilder5.append("} starts with digit character");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                        String string3 = stringBuilder6.toString();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.namedGroups:()Ljava/util/Map;");
                                    Map<String, Integer> map = this.parentPattern.namedGroups();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                                    boolean bl4 = map.containsKey(string2);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl4) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                        StringBuilder stringBuilder7 = new StringBuilder();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder8 = stringBuilder7.append("No group with name {");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder9 = stringBuilder8.append(string2);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder10 = stringBuilder9.append("}");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                        String string4 = stringBuilder10.toString();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string4);
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.namedGroups:()Ljava/util/Map;");
                                    Map<String, Integer> map2 = this.parentPattern.namedGroups();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                                    n2 = map2.get(string2);
                                    ++n;
                                    RuntimeCostAccounter.recordJump();
                                    break block25;
                                }
                                n2 = c - 48;
                                RuntimeCostAccounter.recordJump();
                                if (n2 < 0) break block26;
                                RuntimeCostAccounter.recordJump();
                                if (n2 <= 9) break block27;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal group reference");
                            RuntimeCostAccounter.recordThrow();
                            throw illegalArgumentException;
                        }
                        ++n;
                        boolean bl = false;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                            int n8 = string.length();
                            RuntimeCostAccounter.recordJump();
                            if (n >= n8) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                            int n9 = string.charAt(n) - 48;
                            RuntimeCostAccounter.recordJump();
                            if (n9 < 0) break;
                            RuntimeCostAccounter.recordJump();
                            if (n9 > 9) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            int n10 = n2 * 10 + n9;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.groupCount:()I");
                            int n11 = this.groupCount();
                            RuntimeCostAccounter.recordJump();
                            if (n11 < n10) {
                                bl = true;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                n2 = n10;
                                ++n;
                            }
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:(I)I");
                    int n12 = this.start(n2);
                    RuntimeCostAccounter.recordJump();
                    if (n12 != -1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:(I)I");
                        int n13 = this.end(n2);
                        RuntimeCostAccounter.recordJump();
                        if (n13 != -1) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:(I)I");
                            int n14 = this.start(n2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:(I)I");
                            int n15 = this.end(n2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/CharSequence;II)Ljava/lang/StringBuilder;");
                            stringBuilder.append(this.text, n14, n15);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    break block22;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(c);
                ++n;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/CharSequence;II)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.text, this.lastAppendPosition, this.first);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/CharSequence;)Ljava/lang/StringBuffer;");
        stringBuffer.append((CharSequence)stringBuilder);
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getTextLength:()I");
        int n = this.getTextLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/CharSequence;II)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.text, this.lastAppendPosition, n);
        return stringBuffer;
    }

    public String replaceAll(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        this.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
        boolean bl = this.find();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
            StringBuffer stringBuffer = new StringBuffer();
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.appendReplacement:(Ljava/lang/StringBuffer;Ljava/lang/String;)Ljava/util/regex/Matcher;");
                this.appendReplacement(stringBuffer, string);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
                bl = this.find();
                RuntimeCostAccounter.recordJump();
            } while (bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.appendTail:(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;");
            this.appendTail(stringBuffer);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
            return stringBuffer.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        return this.text.toString();
    }

    public String replaceFirst(String string) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("replacement");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        this.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
        boolean bl = this.find();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            return this.text.toString();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        StringBuffer stringBuffer = new StringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.appendReplacement:(Ljava/lang/StringBuffer;Ljava/lang/String;)Ljava/util/regex/Matcher;");
        this.appendReplacement(stringBuffer, string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.appendTail:(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;");
        this.appendTail(stringBuffer);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer.toString();
    }

    public Matcher region(int n, int n2) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getTextLength:()I");
                        int n3 = this.getTextLength();
                        RuntimeCostAccounter.recordJump();
                        if (n <= n3) break block8;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("start");
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.getTextLength:()I");
                int n4 = this.getTextLength();
                RuntimeCostAccounter.recordJump();
                if (n2 <= n4) break block10;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("end");
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("start > end");
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:()Ljava/util/regex/Matcher;");
        this.reset();
        this.from = n;
        this.to = n2;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean bl) {
        this.transparentBounds = bl;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean bl) {
        this.anchoringBounds = bl;
        return this;
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append("java.util.regex.Matcher");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder2 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[pattern=");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.pattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.pattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(pattern);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(" region=");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder5 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.regionStart:()I");
        int n = this.regionStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(",");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.regionEnd:()I");
        int n2 = this.regionEnd();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder8.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(" lastmatch=");
        RuntimeCostAccounter.recordJump();
        if (this.first >= 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
            String string3 = this.group();
            RuntimeCostAccounter.recordJump();
            if (string3 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
                String string4 = this.group();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int n) {
        int n2;
        int n3;
        this.hitEnd = false;
        this.requireEnd = false;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n3 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = n;
        }
        this.first = n = n3;
        RuntimeCostAccounter.recordJump();
        if (this.oldLast < 0) {
            n2 = n;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = this.oldLast;
        }
        this.oldLast = n2;
        boolean bl = false;
        while (true) {
            boolean bl2 = this.groups.length;
            RuntimeCostAccounter.recordJump();
            if (bl >= bl2) break;
            this.groups[bl] = -1;
            bl += 1;
            RuntimeCostAccounter.recordJump();
        }
        this.acceptMode = 0;
        Pattern.Node node = this.parentPattern.root;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern$Node.match:(Ljava/util/regex/Matcher;ILjava/lang/CharSequence;)Z");
        bl = node.match(this, n, this.text);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    boolean match(int n, int n2) {
        int n3;
        int n4;
        this.hitEnd = false;
        this.requireEnd = false;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n4 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n4 = n;
        }
        this.first = n = n4;
        RuntimeCostAccounter.recordJump();
        if (this.oldLast < 0) {
            n3 = n;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = this.oldLast;
        }
        this.oldLast = n3;
        boolean bl = false;
        while (true) {
            boolean bl2 = this.groups.length;
            RuntimeCostAccounter.recordJump();
            if (bl >= bl2) break;
            this.groups[bl] = -1;
            bl += 1;
            RuntimeCostAccounter.recordJump();
        }
        this.acceptMode = n2;
        Pattern.Node node = this.parentPattern.matchRoot;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern$Node.match:(Ljava/util/regex/Matcher;ILjava/lang/CharSequence;)Z");
        bl = node.match(this, n, this.text);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    int getTextLength() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
        return this.text.length();
    }

    CharSequence getSubSequence(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
        return this.text.subSequence(n, n2);
    }

    char charAt(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
        return this.text.charAt(n);
    }

    int getMatchedGroupIndex(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "Group name");
        RuntimeCostAccounter.recordJump();
        if (this.first < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("No match found");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.namedGroups:()Ljava/util/Map;");
        Map<String, Integer> map = this.parentPattern.namedGroups();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl = map.containsKey(string);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("No group with name <");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(">");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.namedGroups:()Ljava/util/Map;");
        Map<String, Integer> map2 = this.parentPattern.namedGroups();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
        return map2.get(string);
    }
}

