/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.prefs;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.OutputStream;
import sandbox.java.security.AccessController;
import sandbox.java.security.AllPermission;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.Iterator;
import sandbox.java.util.ServiceConfigurationError;
import sandbox.java.util.ServiceLoader;
import sandbox.java.util.prefs.BackingStoreException;
import sandbox.java.util.prefs.InvalidPreferencesFormatException;
import sandbox.java.util.prefs.NodeChangeListener;
import sandbox.java.util.prefs.PreferenceChangeListener;
import sandbox.java.util.prefs.PreferencesFactory;
import sandbox.java.util.prefs.XmlSupport;

public abstract class Preferences {
    private static final PreferencesFactory factory;
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;
    public static final int MAX_NAME_LENGTH = 80;
    private static Permission prefsPerm;

    private static PreferencesFactory factory() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/Preferences$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences$1.<init>:()V");
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public String run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                return System.getProperty("java.util.prefs.PreferencesFactory");
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                Class<?> clazz = Class.forName(string, false, classLoader);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                return (PreferencesFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
                    SecurityManager securityManager = System.getSecurityManager();
                    RuntimeCostAccounter.recordJump();
                    if (securityManager != null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/security/AllPermission");
                        RuntimeCostAccounter.recordMethodCall((String)"java/security/AllPermission.<init>:()V");
                        AllPermission allPermission = new AllPermission();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                        securityManager.checkPermission((Permission)allPermission);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    Thread thread = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader = thread.getContextClassLoader();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                    Class<?> clazz = Class.forName(string, false, classLoader);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                    return (PreferencesFactory)clazz.newInstance();
                }
                catch (Exception exception2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Can't instantiate Preferences factory ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string2 = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
                    InternalError internalError = new InternalError(string2, exception2);
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/Preferences$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences$2.<init>:()V");
        PrivilegedAction<PreferencesFactory> privilegedAction2 = new PrivilegedAction<PreferencesFactory>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public PreferencesFactory run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.access$000:()Ljava/util/prefs/PreferencesFactory;");
                return Preferences.access$000();
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        return (PreferencesFactory)AccessController.doPrivileged((PrivilegedAction)privilegedAction2);
    }

    private static PreferencesFactory factory1() {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;Ljava/lang/ClassLoader;)Ljava/util/ServiceLoader;");
        ServiceLoader<PreferencesFactory> serviceLoader = ServiceLoader.load(PreferencesFactory.class, classLoader);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
        Iterator<PreferencesFactory> iterator = serviceLoader.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                return iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceConfigurationError.getCause:()Ljava/lang/Throwable;");
                boolean bl2 = serviceConfigurationError.getCause() instanceof SecurityException;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordThrow();
                throw serviceConfigurationError;
            }
            break;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = System.getProperty("os.name");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
        boolean bl = string2.startsWith("Windows");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "java.util.prefs.WindowsPreferencesFactory";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.contains:(Ljava/lang/CharSequence;)Z");
            boolean bl3 = string2.contains("OS X");
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                string = "java.util.prefs.MacOSXPreferencesFactory";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "java.util.prefs.FileSystemPreferencesFactory";
            }
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
            ClassLoader classLoader2 = Preferences.class.getClassLoader();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
            Class<?> clazz = Class.forName(string, false, classLoader2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
            return (PreferencesFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Can't instantiate platform default Preferences factory ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(string3, exception);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    public static Preferences userNodeForPackage(Class<?> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.userRoot:()Ljava/util/prefs/Preferences;");
        Preferences preferences = Preferences.userRoot();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.nodeName:(Ljava/lang/Class;)Ljava/lang/String;");
        String string = Preferences.nodeName(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.node:(Ljava/lang/String;)Ljava/util/prefs/Preferences;");
        return preferences.node(string);
    }

    public static Preferences systemNodeForPackage(Class<?> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.systemRoot:()Ljava/util/prefs/Preferences;");
        Preferences preferences = Preferences.systemRoot();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.nodeName:(Ljava/lang/Class;)Ljava/lang/String;");
        String string = Preferences.nodeName(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.node:(Ljava/lang/String;)Ljava/util/prefs/Preferences;");
        return preferences.node(string);
    }

    private static String nodeName(Class<?> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isArray:()Z");
        boolean bl = clazz.isArray();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Arrays have no associated preferences node.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = clazz.getName();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
        int n = string.lastIndexOf(46);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return "/<unnamed>";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        String string2 = string.substring(0, n);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("/");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(CC)Ljava/lang/String;");
        String string3 = string2.replace('.', '/');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    public static Preferences userRoot() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission(prefsPerm);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/PreferencesFactory.userRoot:()Ljava/util/prefs/Preferences;");
        return factory.userRoot();
    }

    public static Preferences systemRoot() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission(prefsPerm);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/PreferencesFactory.systemRoot:()Ljava/util/prefs/Preferences;");
        return factory.systemRoot();
    }

    protected Preferences() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public abstract void put(String var1, String var2);

    public abstract String get(String var1, String var2);

    public abstract void remove(String var1);

    public abstract void clear() throws BackingStoreException;

    public abstract void putInt(String var1, int var2);

    public abstract int getInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract long getLong(String var1, long var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void putFloat(String var1, float var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void putDouble(String var1, double var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract String[] keys() throws BackingStoreException;

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract Preferences parent();

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public abstract String name();

    public abstract String absolutePath();

    public abstract boolean isUserNode();

    public abstract String toString();

    public abstract void flush() throws BackingStoreException;

    public abstract void sync() throws BackingStoreException;

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void exportNode(OutputStream var1) throws IOException, BackingStoreException;

    public abstract void exportSubtree(OutputStream var1) throws IOException, BackingStoreException;

    public static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/XmlSupport.importPreferences:(Ljava/io/InputStream;)V");
        XmlSupport.importPreferences(inputStream);
    }

    static /* synthetic */ PreferencesFactory access$000() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.factory1:()Ljava/util/prefs/PreferencesFactory;");
        return Preferences.factory1();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.factory:()Ljava/util/prefs/PreferencesFactory;");
        factory = Preferences.factory();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
        prefsPerm = new RuntimePermission("preferences");
    }
}

