/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.OutputStream;
import sandbox.java.io.OutputStreamWriter;
import sandbox.java.io.UnsupportedEncodingException;
import sandbox.java.io.Writer;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Formatter;
import sandbox.java.util.logging.Handler;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogManager;
import sandbox.java.util.logging.LogRecord;
import sandbox.java.util.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream output;
    private boolean doneHeader;
    private volatile Writer writer;

    private void configure() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = clazz.getName();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(".level");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
        Level level = logManager.getLevelProperty(string2, Level.INFO);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(level);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder4 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(".filter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder6.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFilterProperty:(Ljava/lang/String;Ljava/util/logging/Filter;)Ljava/util/logging/Filter;");
        Filter filter = logManager.getFilterProperty(string3, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setFilter:(Ljava/util/logging/Filter;)V");
        this.setFilter(filter);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder7 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(".formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder9.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/SimpleFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/SimpleFormatter.<init>:()V");
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFormatterProperty:(Ljava/lang/String;Ljava/util/logging/Formatter;)Ljava/util/logging/Formatter;");
        Formatter formatter = logManager.getFormatterProperty(string4, simpleFormatter);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setFormatter:(Ljava/util/logging/Formatter;)V");
        this.setFormatter(formatter);
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder10 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder12 = stringBuilder11.append(".encoding");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string5 = stringBuilder12.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getStringProperty:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
            String string6 = logManager.getStringProperty(string5, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setEncoding:(Ljava/lang/String;)V");
            this.setEncoding(string6);
        }
        catch (Exception exception) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setEncoding:(Ljava/lang/String;)V");
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    public StreamHandler() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.<init>:()V");
        this.sealed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.configure:()V");
        this.configure();
        this.sealed = true;
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.<init>:()V");
        this.sealed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.configure:()V");
        this.configure();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setFormatter:(Ljava/util/logging/Formatter;)V");
        this.setFormatter(formatter);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.setOutputStream:(Ljava/io/OutputStream;)V");
        this.setOutputStream(outputStream);
        this.sealed = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void setOutputStream(OutputStream outputStream) throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (outputStream == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.flushAndClose:()V");
        this.flushAndClose();
        this.output = outputStream;
        this.doneHeader = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.getEncoding:()Ljava/lang/String;");
        String string = this.getEncoding();
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
            this.writer = new OutputStreamWriter(this.output);
            RuntimeCostAccounter.recordJump();
            return;
        }
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;Ljava/lang/String;)V");
            this.writer = new OutputStreamWriter(this.output, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unexpected exception ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(unsupportedEncodingException);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
            Error error = new Error(string2);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public synchronized void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.setEncoding:(Ljava/lang/String;)V");
        super.setEncoding(string);
        RuntimeCostAccounter.recordJump();
        if (this.output == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.flush:()V");
        this.flush();
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
            this.writer = new OutputStreamWriter(this.output);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;Ljava/lang/String;)V");
            this.writer = new OutputStreamWriter(this.output, string);
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        boolean bl = this.isLoggable(logRecord);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.getFormatter:()Ljava/util/logging/Formatter;");
            Formatter formatter = this.getFormatter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Formatter.format:(Ljava/util/logging/LogRecord;)Ljava/lang/String;");
            string = formatter.format(logRecord);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.reportError:(Ljava/lang/String;Ljava/lang/Exception;I)V");
            this.reportError(null, exception, 5);
            return;
        }
        RuntimeCostAccounter.recordJump();
        try {
            RuntimeCostAccounter.recordJump();
            if (!this.doneHeader) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.getFormatter:()Ljava/util/logging/Formatter;");
                Formatter formatter = this.getFormatter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Formatter.getHead:(Ljava/util/logging/Handler;)Ljava/lang/String;");
                String string2 = formatter.getHead(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;)V");
                this.writer.write(string2);
                this.doneHeader = true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;)V");
            this.writer.write(string);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.reportError:(Ljava/lang/String;Ljava/lang/Exception;I)V");
            this.reportError(null, exception, 1);
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (this.writer == null) break block2;
                RuntimeCostAccounter.recordJump();
                if (logRecord != null) break block3;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        return super.isLoggable(logRecord);
    }

    @Override
    public synchronized void flush() {
        RuntimeCostAccounter.recordJump();
        if (this.writer != null) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                this.writer.flush();
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.reportError:(Ljava/lang/String;Ljava/lang/Exception;I)V");
                this.reportError(null, exception, 2);
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        block3: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.checkPermission:()V");
            this.checkPermission();
            RuntimeCostAccounter.recordJump();
            if (this.writer == null) break block3;
            try {
                RuntimeCostAccounter.recordJump();
                if (!this.doneHeader) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.getFormatter:()Ljava/util/logging/Formatter;");
                    Formatter formatter = this.getFormatter();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Formatter.getHead:(Ljava/util/logging/Handler;)Ljava/lang/String;");
                    String string = formatter.getHead(this);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;)V");
                    this.writer.write(string);
                    this.doneHeader = true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.getFormatter:()Ljava/util/logging/Formatter;");
                Formatter formatter = this.getFormatter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Formatter.getTail:(Ljava/util/logging/Handler;)Ljava/lang/String;");
                String string = formatter.getTail(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;)V");
                this.writer.write(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                this.writer.flush();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                this.writer.close();
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.reportError:(Ljava/lang/String;Ljava/lang/Exception;I)V");
                this.reportError(null, exception, 3);
            }
            RuntimeCostAccounter.recordJump();
            this.writer = null;
            this.output = null;
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.flushAndClose:()V");
        this.flushAndClose();
    }
}

