/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import java.lang.ref.WeakReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Iterator;
import sandbox.java.util.Locale;
import sandbox.java.util.MissingResourceException;
import sandbox.java.util.ResourceBundle;
import sandbox.java.util.concurrent.CopyOnWriteArrayList;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Handler;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogManager;
import sandbox.java.util.logging.LogRecord;
import sandbox.sun.reflect.CallerSensitive;
import sandbox.sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers;
    private static final int offValue;
    static final String SYSTEM_LOGGER_RB_NAME = "sun.util.logging.resources.logging";
    private static final LoggerBundle SYSTEM_BUNDLE;
    private static final LoggerBundle NO_RESOURCE_BUNDLE;
    private volatile LogManager manager;
    private String name;
    private final CopyOnWriteArrayList<Handler> handlers;
    private volatile LoggerBundle loggerBundle;
    private volatile boolean useParentHandlers;
    private volatile Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static final Object treeLock;
    private volatile Logger parent;
    private ArrayList<LogManager.LoggerWeakRef> kids;
    private volatile Level levelObject;
    private volatile int levelValue;
    private WeakReference<ClassLoader> callersClassLoaderRef;
    private final boolean isSystemLogger;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Logger getGlobal() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager.getLogManager();
        return global;
    }

    protected Logger(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/util/logging/LogManager;Z)V");
        this(string, string2, null, logManager, false);
    }

    Logger(String string, String string2, Class<?> clazz, LogManager logManager, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CopyOnWriteArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.<init>:()V");
        this.handlers = new CopyOnWriteArrayList();
        this.loggerBundle = NO_RESOURCE_BUNDLE;
        this.useParentHandlers = true;
        this.manager = logManager;
        this.isSystemLogger = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setupResourceInfo:(Ljava/lang/String;Ljava/lang/Class;)V");
        this.setupResourceInfo(string2, clazz);
        this.name = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        this.levelValue = Level.INFO.intValue();
    }

    private void setCallersClassLoaderRef(Class<?> clazz) {
        ClassLoader classLoader;
        RuntimeCostAccounter.recordJump();
        if (clazz != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
            classLoader = clazz.getClassLoader();
            RuntimeCostAccounter.recordJump();
        } else {
            classLoader = null;
        }
        ClassLoader classLoader2 = classLoader;
        RuntimeCostAccounter.recordJump();
        if (classLoader2 != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/WeakReference");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;)V");
            this.callersClassLoaderRef = new WeakReference<ClassLoader>(classLoader2);
        }
    }

    private ClassLoader getCallersClassLoader() {
        ClassLoader classLoader;
        RuntimeCostAccounter.recordJump();
        if (this.callersClassLoaderRef != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.get:()Ljava/lang/Object;");
            classLoader = (ClassLoader)this.callersClassLoaderRef.get();
            RuntimeCostAccounter.recordJump();
        } else {
            classLoader = null;
        }
        return classLoader;
    }

    private Logger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CopyOnWriteArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.<init>:()V");
        this.handlers = new CopyOnWriteArrayList();
        this.loggerBundle = NO_RESOURCE_BUNDLE;
        this.useParentHandlers = true;
        this.name = string;
        this.isSystemLogger = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager logManager) {
        this.manager = logManager;
    }

    private void checkPermission() throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (!this.anonymous) {
            RuntimeCostAccounter.recordJump();
            if (this.manager == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
                this.manager = LogManager.getLogManager();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
            this.manager.checkPermission();
        }
    }

    private static Logger demandLogger(String string, String string2, Class<?> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordJump();
            if (!SystemLoggerHelper.disableCallerCheck) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = clazz.getClassLoader();
                RuntimeCostAccounter.recordJump();
                if (classLoader == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.demandSystemLogger:(Ljava/lang/String;Ljava/lang/String;)Ljava/util/logging/Logger;");
                    return logManager.demandSystemLogger(string, string2);
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.demandLogger:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/util/logging/Logger;");
        return logManager.demandLogger(string, string2, clazz);
    }

    @CallerSensitive
    public static Logger getLogger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/Reflection.getCallerClass:()Ljava/lang/Class;");
        Class clazz = Reflection.getCallerClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.demandLogger:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/util/logging/Logger;");
        return Logger.demandLogger(string, null, clazz);
    }

    @CallerSensitive
    public static Logger getLogger(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/Reflection.getCallerClass:()Ljava/lang/Class;");
        Class clazz = Reflection.getCallerClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.demandLogger:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/util/logging/Logger;");
        Logger logger = Logger.demandLogger(string, string2, clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setupResourceInfo:(Ljava/lang/String;Ljava/lang/Class;)V");
        logger.setupResourceInfo(string2, clazz);
        return logger;
    }

    static Logger getPlatformLogger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.demandSystemLogger:(Ljava/lang/String;Ljava/lang/String;)Ljava/util/logging/Logger;");
        Logger logger = logManager.demandSystemLogger(string, SYSTEM_LOGGER_RB_NAME);
        return logger;
    }

    public static Logger getAnonymousLogger() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getAnonymousLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
        return Logger.getAnonymousLogger(null);
    }

    @CallerSensitive
    public static Logger getAnonymousLogger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.drainLoggerRefQueueBounded:()V");
        logManager.drainLoggerRefQueueBounded();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger");
        RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/Reflection.getCallerClass:()Ljava/lang/Class;");
        Class clazz = Reflection.getCallerClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/util/logging/LogManager;Z)V");
        Logger logger = new Logger(null, string, clazz, logManager, false);
        logger.anonymous = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
        Logger logger2 = logManager.getLogger("");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doSetParent:(Ljava/util/logging/Logger;)V");
        logger.doSetParent(logger2);
        return logger;
    }

    public ResourceBundle getResourceBundle() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getResourceBundleName:()Ljava/lang/String;");
        String string = this.getResourceBundleName();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.findResourceBundle:(Ljava/lang/String;Z)Ljava/util/ResourceBundle;");
        return this.findResourceBundle(string, true);
    }

    public String getResourceBundleName() {
        return this.loggerBundle.resourceBundleName;
    }

    public void setFilter(Filter filter) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord logRecord) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.getLevel:()Ljava/util/logging/Level;");
        Level level = logRecord.getLevel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        Filter filter = this.filter;
        RuntimeCostAccounter.recordJump();
        if (filter != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Filter.isLoggable:(Ljava/util/logging/LogRecord;)Z");
            boolean bl2 = filter.isLoggable(logRecord);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                return;
            }
        }
        Logger logger = this;
        while (true) {
            Logger logger2;
            boolean bl3;
            Handler[] handlerArray;
            Handler[] handlerArray2;
            RuntimeCostAccounter.recordJump();
            if (logger == null) break;
            RuntimeCostAccounter.recordJump();
            if (this.isSystemLogger) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.accessCheckedHandlers:()[Ljava/util/logging/Handler;");
                handlerArray2 = logger.accessCheckedHandlers();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getHandlers:()[Ljava/util/logging/Handler;");
                handlerArray2 = logger.getHandlers();
            }
            Handler[] handlerArray3 = handlerArray = handlerArray2;
            int n = handlerArray3.length;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Handler handler = handlerArray3[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.publish:(Ljava/util/logging/LogRecord;)V");
                handler.publish(logRecord);
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.isSystemLogger) {
                bl3 = logger.useParentHandlers;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getUseParentHandlers:()Z");
                bl3 = logger.getUseParentHandlers();
            }
            boolean bl4 = bl3;
            RuntimeCostAccounter.recordJump();
            if (!bl4) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
            if (this.isSystemLogger) {
                logger2 = logger.parent;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getParent:()Ljava/util/logging/Logger;");
                logger2 = logger.getParent();
            }
            logger = logger2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void doLog(LogRecord logRecord) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setLoggerName:(Ljava/lang/String;)V");
        logRecord.setLoggerName(this.name);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getEffectiveLoggerBundle:()Ljava/util/logging/Logger$LoggerBundle;");
        LoggerBundle loggerBundle = this.getEffectiveLoggerBundle();
        ResourceBundle resourceBundle = loggerBundle.userBundle;
        String string = loggerBundle.resourceBundleName;
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordJump();
            if (resourceBundle != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundleName:(Ljava/lang/String;)V");
                logRecord.setResourceBundleName(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundle:(Ljava/util/ResourceBundle;)V");
                logRecord.setResourceBundle(resourceBundle);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/LogRecord;)V");
        this.log(logRecord);
    }

    public void log(Level level, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void log(Level level, Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, supplier.get());
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string);
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        Object[] objectArray = new Object[]{object};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object[] objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void log(Level level, Throwable throwable, Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, supplier.get());
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, supplier.get());
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        Object[] objectArray = new Object[]{object};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, Throwable throwable, Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, supplier.get());
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    private void doLog(LogRecord logRecord, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setLoggerName:(Ljava/lang/String;)V");
        logRecord.setLoggerName(this.name);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundleName:(Ljava/lang/String;)V");
            logRecord.setResourceBundleName(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.findResourceBundle:(Ljava/lang/String;Z)Ljava/util/ResourceBundle;");
            ResourceBundle resourceBundle = this.findResourceBundle(string, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundle:(Ljava/util/ResourceBundle;)V");
            logRecord.setResourceBundle(resourceBundle);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/LogRecord;)V");
        this.log(logRecord);
    }

    private void doLog(LogRecord logRecord, ResourceBundle resourceBundle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setLoggerName:(Ljava/lang/String;)V");
        logRecord.setLoggerName(this.name);
        RuntimeCostAccounter.recordJump();
        if (resourceBundle != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBaseBundleName:()Ljava/lang/String;");
            String string = resourceBundle.getBaseBundleName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundleName:(Ljava/lang/String;)V");
            logRecord.setResourceBundleName(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setResourceBundle:(Ljava/util/ResourceBundle;)V");
            logRecord.setResourceBundle(resourceBundle);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/LogRecord;)V");
        this.log(logRecord);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/lang/String;)V");
        this.doLog(logRecord, string3);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        Object[] objectArray = new Object[]{object};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/lang/String;)V");
        this.doLog(logRecord, string3);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
        logRecord.setParameters(objectArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/lang/String;)V");
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, ResourceBundle resourceBundle, String string3, Object ... objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordJump();
        if (objectArray != null) {
            int n = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setParameters:([Ljava/lang/Object;)V");
                logRecord.setParameters(objectArray);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/util/ResourceBundle;)V");
        this.doLog(logRecord, resourceBundle);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/lang/String;)V");
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, ResourceBundle resourceBundle, String string3, Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(level);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(level, string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;Ljava/util/ResourceBundle;)V");
        this.doLog(logRecord, resourceBundle);
    }

    public void entering(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        this.logp(Level.FINER, string, string2, "ENTRY");
    }

    public void entering(String string, String string2, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        this.logp(Level.FINER, string, string2, "ENTRY {0}", object);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        String string3 = "ENTRY";
        RuntimeCostAccounter.recordJump();
        if (objectArray == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
            this.logp(Level.FINER, string, string2, string3);
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(Level.FINER);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        int n = 0;
        while (true) {
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(" {");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("}");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string3 = stringBuilder5.toString();
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V");
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void exiting(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        this.logp(Level.FINER, string, string2, "RETURN");
    }

    public void exiting(String string, String string2, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.logp:(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
        this.logp(Level.FINER, string, string2, "RETURN {0}", object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLoggable:(Ljava/util/logging/Level;)Z");
        boolean bl = this.isLoggable(Level.FINER);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogRecord");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.<init>:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceClassName:(Ljava/lang/String;)V");
        logRecord.setSourceClassName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setSourceMethodName:(Ljava/lang/String;)V");
        logRecord.setSourceMethodName(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.setThrown:(Ljava/lang/Throwable;)V");
        logRecord.setThrown(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doLog:(Ljava/util/logging/LogRecord;)V");
        this.doLog(logRecord);
    }

    public void severe(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/lang/String;)V");
        this.log(Level.FINEST, string);
    }

    public void severe(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.SEVERE, supplier);
    }

    public void warning(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.WARNING, supplier);
    }

    public void info(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.INFO, supplier);
    }

    public void config(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.CONFIG, supplier);
    }

    public void fine(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.FINE, supplier);
    }

    public void finer(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.FINER, supplier);
    }

    public void finest(Supplier<String> supplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/Level;Ljava/util/function/Supplier;)V");
        this.log(Level.FINEST, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
        this.checkPermission();
        Object object = treeLock;
        try {
            this.levelObject = level;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.updateEffectiveLevel:()V");
            this.updateEffectiveLevel();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    final boolean isLevelInitialized() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.levelObject != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
                int n = level.intValue();
                RuntimeCostAccounter.recordJump();
                if (n < this.levelValue) break block2;
                RuntimeCostAccounter.recordJump();
                if (this.levelValue != offValue) break block3;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void addHandler(Handler handler) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        handler.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.add:(Ljava/lang/Object;)Z");
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordJump();
        if (handler == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.remove:(Ljava/lang/Object;)Z");
        this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.accessCheckedHandlers:()[Ljava/util/logging/Handler;");
        return this.accessCheckedHandlers();
    }

    Handler[] accessCheckedHandlers() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return this.handlers.toArray(emptyHandlers);
    }

    public void setUseParentHandlers(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
        this.checkPermission();
        this.useParentHandlers = bl;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private static ResourceBundle findSystemResourceBundle(final Locale locale) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$1.<init>:(Ljava/util/Locale;)V");
        PrivilegedAction<ResourceBundle> privilegedAction = new PrivilegedAction<ResourceBundle>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public ResourceBundle run() {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBundle:(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;)Ljava/util/ResourceBundle;");
                    return ResourceBundle.getBundle(Logger.SYSTEM_LOGGER_RB_NAME, locale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/MissingResourceException.toString:()Ljava/lang/String;");
                    String string = missingResourceException.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/String;)V");
                    InternalError internalError = new InternalError(string);
                    RuntimeCostAccounter.recordThrow();
                    throw internalError;
                }
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        return (ResourceBundle)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    private synchronized ResourceBundle findResourceBundle(String string, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        LoggerBundle loggerBundle = this.loggerBundle;
        ResourceBundle resourceBundle = loggerBundle.userBundle;
        RuntimeCostAccounter.recordJump();
        if (resourceBundle != null) {
            String string2 = loggerBundle.resourceBundleName;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = string.equals(string2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return loggerBundle.userBundle;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.catalog != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
            boolean bl3 = locale.equals(this.catalogLocale);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl4 = string.equals(this.catalogName);
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    return this.catalog;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl5 = string.equals(SYSTEM_LOGGER_RB_NAME);
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.findSystemResourceBundle:(Ljava/util/Locale;)Ljava/util/ResourceBundle;");
            this.catalog = Logger.findSystemResourceBundle(locale);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = thread.getContextClassLoader();
        RuntimeCostAccounter.recordJump();
        if (classLoader == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBundle:(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;)Ljava/util/ResourceBundle;");
            this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            block15: {
                ClassLoader classLoader2;
                block17: {
                    block16: {
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block15;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getCallersClassLoader:()Ljava/lang/ClassLoader;");
                        classLoader2 = this.getCallersClassLoader();
                        RuntimeCostAccounter.recordJump();
                        if (classLoader2 == null) break block16;
                        RuntimeCostAccounter.recordJump();
                        if (classLoader2 != classLoader) break block17;
                    }
                    return null;
                }
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBundle:(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;)Ljava/util/ResourceBundle;");
                    this.catalog = ResourceBundle.getBundle(string, locale, classLoader2);
                    this.catalogName = string;
                    this.catalogLocale = locale;
                    return this.catalog;
                }
                catch (MissingResourceException missingResourceException2) {
                    return null;
                }
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String string, Class<?> clazz) {
        LoggerBundle loggerBundle = this.loggerBundle;
        String string2 = loggerBundle.resourceBundleName;
        RuntimeCostAccounter.recordJump();
        if (string2 != null) {
            String string3 = loggerBundle.resourceBundleName;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string3.equals(string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = loggerBundle.resourceBundleName;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(" != ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string5 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string5);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setCallersClassLoaderRef:(Ljava/lang/Class;)V");
        this.setCallersClassLoaderRef(clazz);
        RuntimeCostAccounter.recordJump();
        if (this.isSystemLogger) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getCallersClassLoader:()Ljava/lang/ClassLoader;");
            ClassLoader classLoader = this.getCallersClassLoader();
            RuntimeCostAccounter.recordJump();
            if (classLoader != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
                this.checkPermission();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.findResourceBundle:(Ljava/lang/String;Z)Ljava/util/ResourceBundle;");
        ResourceBundle resourceBundle = this.findResourceBundle(string, true);
        RuntimeCostAccounter.recordJump();
        if (resourceBundle == null) {
            this.callersClassLoaderRef = null;
            RuntimeCostAccounter.recordAllocation((String)"java/util/MissingResourceException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append("Can't find ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(" bundle");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string6 = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/MissingResourceException.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
            MissingResourceException missingResourceException = new MissingResourceException(string6, string, "");
            RuntimeCostAccounter.recordThrow();
            throw missingResourceException;
        }
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            ResourceBundle resourceBundle2 = loggerBundle.userBundle;
            RuntimeCostAccounter.recordJump();
            if (resourceBundle2 != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.get:(Ljava/lang/String;Ljava/util/ResourceBundle;)Ljava/util/logging/Logger$LoggerBundle;");
        this.loggerBundle = LoggerBundle.get(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setResourceBundle(ResourceBundle var1_1) {
        block9: {
            block8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.checkPermission:()V");
                this.checkPermission();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBaseBundleName:()Ljava/lang/String;");
                var2_2 = var1_1.getBaseBundleName();
                RuntimeCostAccounter.recordJump();
                if (var2_2 == null) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.isEmpty:()Z");
                v0 = var2_2.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!v0) break block9;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            v1 = new IllegalArgumentException("resource bundle must have a name");
            RuntimeCostAccounter.recordThrow();
            throw v1;
        }
        var3_3 = this;
        try {
            var4_4 = this.loggerBundle;
            v2 = var4_4.resourceBundleName;
            RuntimeCostAccounter.recordJump();
            if (v2 == null) ** GOTO lbl-1000
            v3 = var4_4.resourceBundleName;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            v4 = v3.equals(var2_2);
            RuntimeCostAccounter.recordJump();
            if (v4) lbl-1000:
            // 2 sources

            {
                v5 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                v5 = false;
            }
            var5_5 = v5;
            RuntimeCostAccounter.recordJump();
            if (!var5_5) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v6 = new IllegalArgumentException("can't replace resource bundle");
                RuntimeCostAccounter.recordThrow();
                throw v6;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.get:(Ljava/lang/String;Ljava/util/ResourceBundle;)Ljava/util/logging/Logger$LoggerBundle;");
            this.loggerBundle = LoggerBundle.get(var2_2, var1_1);
        }
        catch (Throwable var6_6) {
            RuntimeCostAccounter.recordThrow();
            throw var6_6;
        }
        RuntimeCostAccounter.recordJump();
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger logger) {
        RuntimeCostAccounter.recordJump();
        if (logger == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.manager == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
            this.manager = LogManager.getLogManager();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.manager.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.doSetParent:(Ljava/util/logging/Logger;)V");
        this.doSetParent(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger logger) {
        Object object = treeLock;
        try {
            LogManager.LoggerWeakRef loggerWeakRef = null;
            RuntimeCostAccounter.recordJump();
            if (this.parent != null) {
                ArrayList<LogManager.LoggerWeakRef> arrayList = this.parent.kids;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.iterator:()Ljava/util/Iterator;");
                Iterator<LogManager.LoggerWeakRef> iterator = arrayList.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    loggerWeakRef = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
                    Logger logger2 = (Logger)loggerWeakRef.get();
                    RuntimeCostAccounter.recordJump();
                    if (logger2 == this) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                        iterator.remove();
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    loggerWeakRef = null;
                    RuntimeCostAccounter.recordJump();
                }
            }
            this.parent = logger;
            ArrayList<LogManager.LoggerWeakRef> arrayList = this.parent.kids;
            RuntimeCostAccounter.recordJump();
            if (arrayList == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
                this.parent.kids = new ArrayList(2);
            }
            RuntimeCostAccounter.recordJump();
            if (loggerWeakRef == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LoggerWeakRef");
                LogManager logManager = this.manager;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                logManager.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/Logger;)V");
                loggerWeakRef = new LogManager.LoggerWeakRef(logManager, this);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/WeakReference");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;)V");
            WeakReference<Logger> weakReference = new WeakReference<Logger>(this.parent);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.setParentRef:(Ljava/lang/ref/WeakReference;)V");
            loggerWeakRef.setParentRef(weakReference);
            ArrayList<LogManager.LoggerWeakRef> arrayList2 = this.parent.kids;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
            arrayList2.add(loggerWeakRef);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.updateEffectiveLevel:()V");
            this.updateEffectiveLevel();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildLogger(LogManager.LoggerWeakRef loggerWeakRef) {
        Object object = treeLock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.iterator:()Ljava/util/Iterator;");
            Iterator<LogManager.LoggerWeakRef> iterator = this.kids.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                LogManager.LoggerWeakRef loggerWeakRef2 = iterator.next();
                RuntimeCostAccounter.recordJump();
                if (loggerWeakRef2 == loggerWeakRef) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                    iterator.remove();
                    return;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    private void updateEffectiveLevel() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.levelObject != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
            n = this.levelObject.intValue();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (this.parent != null) {
                n = this.parent.levelValue;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
                n = Level.INFO.intValue();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.levelValue == n) {
            return;
        }
        this.levelValue = n;
        RuntimeCostAccounter.recordJump();
        if (this.kids != null) {
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
                int n3 = this.kids.size();
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.get:(I)Ljava/lang/Object;");
                LogManager.LoggerWeakRef loggerWeakRef = this.kids.get(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
                Logger logger = (Logger)loggerWeakRef.get();
                RuntimeCostAccounter.recordJump();
                if (logger != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.updateEffectiveLevel:()V");
                    logger.updateEffectiveLevel();
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    private LoggerBundle getEffectiveLoggerBundle() {
        LoggerBundle loggerBundle = this.loggerBundle;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.isSystemBundle:()Z");
        boolean bl = loggerBundle.isSystemBundle();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return SYSTEM_BUNDLE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getResourceBundle:()Ljava/util/ResourceBundle;");
        ResourceBundle resourceBundle = this.getResourceBundle();
        RuntimeCostAccounter.recordJump();
        if (resourceBundle != null) {
            ResourceBundle resourceBundle2 = loggerBundle.userBundle;
            RuntimeCostAccounter.recordJump();
            if (resourceBundle == resourceBundle2) {
                return loggerBundle;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (resourceBundle != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getResourceBundleName:()Ljava/lang/String;");
            String string = this.getResourceBundleName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.get:(Ljava/lang/String;Ljava/util/ResourceBundle;)Ljava/util/logging/Logger$LoggerBundle;");
            return LoggerBundle.get(string, resourceBundle);
        }
        Logger logger = this.parent;
        while (true) {
            Logger logger2;
            String string;
            RuntimeCostAccounter.recordJump();
            if (logger == null) break;
            LoggerBundle loggerBundle2 = logger.loggerBundle;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.isSystemBundle:()Z");
            boolean bl2 = loggerBundle2.isSystemBundle();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return SYSTEM_BUNDLE;
            }
            ResourceBundle resourceBundle3 = loggerBundle2.userBundle;
            RuntimeCostAccounter.recordJump();
            if (resourceBundle3 != null) {
                return loggerBundle2;
            }
            RuntimeCostAccounter.recordJump();
            if (this.isSystemLogger) {
                boolean bl3 = logger.isSystemLogger;
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    string = loggerBundle2.resourceBundleName;
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = null;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getResourceBundleName:()Ljava/lang/String;");
                string = logger.getResourceBundleName();
            }
            String string2 = string;
            RuntimeCostAccounter.recordJump();
            if (string2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.findResourceBundle:(Ljava/lang/String;Z)Ljava/util/ResourceBundle;");
                ResourceBundle resourceBundle4 = this.findResourceBundle(string2, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.get:(Ljava/lang/String;Ljava/util/ResourceBundle;)Ljava/util/logging/Logger$LoggerBundle;");
                return LoggerBundle.get(string2, resourceBundle4);
            }
            RuntimeCostAccounter.recordJump();
            if (this.isSystemLogger) {
                logger2 = logger.parent;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getParent:()Ljava/util/logging/Logger;");
                logger2 = logger.getParent();
            }
            logger = logger2;
            RuntimeCostAccounter.recordJump();
        }
        return NO_RESOURCE_BUNDLE;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = Logger.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        emptyHandlers = new Handler[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        offValue = Level.OFF.intValue();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger$LoggerBundle");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.<init>:(Ljava/lang/String;Ljava/util/ResourceBundle;Ljava/util/logging/Logger$1;)V");
        SYSTEM_BUNDLE = new LoggerBundle(SYSTEM_LOGGER_RB_NAME, null, null);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger$LoggerBundle");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.<init>:(Ljava/lang/String;Ljava/util/ResourceBundle;Ljava/util/logging/Logger$1;)V");
        NO_RESOURCE_BUNDLE = new LoggerBundle(null, null, null);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        treeLock = new Object();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;)V");
        global = new Logger(GLOBAL_LOGGER_NAME);
    }

    private static class SystemLoggerHelper {
        static boolean disableCallerCheck;

        private SystemLoggerHelper() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        private static boolean getBooleanProperty(final String string) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger$SystemLoggerHelper$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$SystemLoggerHelper$1.<init>:(Ljava/lang/String;)V");
            PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public String run() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                    return System.getProperty(string);
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            String string2 = (String)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Ljava/lang/String;)Ljava/lang/Boolean;");
            Boolean bl = Boolean.valueOf(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
            return bl;
        }

        static {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$SystemLoggerHelper.getBooleanProperty:(Ljava/lang/String;)Z");
            disableCallerCheck = SystemLoggerHelper.getBooleanProperty("sun.util.logging.disableCallerCheck");
        }
    }

    private static final class LoggerBundle {
        final String resourceBundleName;
        final ResourceBundle userBundle;

        private LoggerBundle(String string, ResourceBundle resourceBundle) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.resourceBundleName = string;
            this.userBundle = resourceBundle;
        }

        boolean isSystemBundle() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            return Logger.SYSTEM_LOGGER_RB_NAME.equals(this.resourceBundleName);
        }

        static LoggerBundle get(String string, ResourceBundle resourceBundle) {
            RuntimeCostAccounter.recordJump();
            if (string == null) {
                RuntimeCostAccounter.recordJump();
                if (resourceBundle == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.access$000:()Ljava/util/logging/Logger$LoggerBundle;");
                    return NO_RESOURCE_BUNDLE;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = Logger.SYSTEM_LOGGER_RB_NAME.equals(string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (resourceBundle == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.access$100:()Ljava/util/logging/Logger$LoggerBundle;");
                    return SYSTEM_BUNDLE;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger$LoggerBundle");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.<init>:(Ljava/lang/String;Ljava/util/ResourceBundle;)V");
            return new LoggerBundle(string, resourceBundle);
        }

        /* synthetic */ LoggerBundle(String string, ResourceBundle resourceBundle, 1 var3_3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger$LoggerBundle.<init>:(Ljava/lang/String;Ljava/util/ResourceBundle;)V");
            this(string, resourceBundle);
        }
    }
}

