/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.beans.PropertyChangeListener;
import sandbox.java.io.BufferedInputStream;
import sandbox.java.io.File;
import sandbox.java.io.FileInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.PrintStream;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.PrivilegedExceptionAction;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collection;
import sandbox.java.util.Enumeration;
import sandbox.java.util.HashMap;
import sandbox.java.util.Hashtable;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Properties;
import sandbox.java.util.Set;
import sandbox.java.util.WeakHashMap;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Formatter;
import sandbox.java.util.logging.Handler;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogRecord;
import sandbox.java.util.logging.Logger;
import sandbox.java.util.logging.Logging;
import sandbox.java.util.logging.LoggingMXBean;
import sandbox.java.util.logging.LoggingPermission;
import sandbox.sun.misc.JavaAWTAccess;
import sandbox.sun.misc.SharedSecrets;
import sandbox.sun.util.logging.PlatformLogger;

public class LogManager {
    private static final LogManager manager;
    private volatile Properties props;
    private static final Level defaultLevel;
    private final Map<Object, Integer> listenerMap;
    private final LoggerContext systemContext;
    private final LoggerContext userContext;
    private volatile Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers;
    private boolean deathImminent;
    private boolean initializedCalled;
    private volatile boolean initializationDone;
    private WeakHashMap<Object, LoggerContext> contextsMap;
    private final ReferenceQueue<Logger> loggerRefQueue;
    private static final int MAX_ITERATIONS = 400;
    private final Permission controlPermission;
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LogManager() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkSubclassPermissions:()Ljava/lang/Void;");
        Void void_ = LogManager.checkSubclassPermissions();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.<init>:(Ljava/lang/Void;)V");
        this(void_);
    }

    private LogManager(Void void_) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/Properties");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.<init>:()V");
        this.props = new Properties();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.listenerMap = new HashMap<Object, Integer>();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$SystemLoggerContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$SystemLoggerContext.<init>:(Ljava/util/logging/LogManager;)V");
        this.systemContext = new SystemLoggerContext();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LoggerContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager$1;)V");
        this.userContext = new LoggerContext(this, null);
        this.initializedGlobalHandlers = true;
        this.initializedCalled = false;
        this.initializationDone = false;
        this.contextsMap = null;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/ReferenceQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.<init>:()V");
        this.loggerRefQueue = new ReferenceQueue();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LoggingPermission");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LoggingPermission.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
        this.controlPermission = new LoggingPermission("control", null);
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
            Runtime runtime = Runtime.getRuntime();
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$Cleaner");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Cleaner.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager$1;)V");
            Cleaner cleaner = new Cleaner(this, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.addShutdownHook:(Ljava/lang/Thread;)V");
            runtime.addShutdownHook(cleaner);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
    }

    private static Void checkSubclassPermissions() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission = new RuntimePermission("shutdownHooks");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)runtimePermission);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission2 = new RuntimePermission("setContextClassLoader");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)runtimePermission2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureLogManagerInitialized() {
        LogManager logManager;
        block16: {
            block15: {
                logManager = this;
                RuntimeCostAccounter.recordJump();
                if (this.initializationDone) break block15;
                RuntimeCostAccounter.recordJump();
                if (logManager == manager) break block16;
            }
            return;
        }
        LogManager logManager2 = this;
        try {
            block18: {
                block17: {
                    boolean bl;
                    RuntimeCostAccounter.recordJump();
                    if (this.initializedCalled) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    boolean bl2 = bl;
                    RuntimeCostAccounter.recordJump();
                    if (!$assertionsDisabled) {
                        RuntimeCostAccounter.recordJump();
                        if (!this.initializedCalled) {
                            RuntimeCostAccounter.recordJump();
                            if (this.initializationDone) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                                AssertionError assertionError = new AssertionError((Object)"Initialization can't be done if initialized has not been called!");
                                RuntimeCostAccounter.recordThrow();
                                throw assertionError;
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block17;
                    RuntimeCostAccounter.recordJump();
                    if (!this.initializationDone) break block18;
                }
                return;
            }
            this.initializedCalled = true;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$2");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$2.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager;)V");
                PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
                    static final /* synthetic */ boolean $assertionsDisabled;
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    public Object run() {
                        block6: {
                            block7: {
                                RuntimeCostAccounter.recordJump();
                                if (!$assertionsDisabled) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                                    Logger logger = LogManager.this.rootLogger;
                                    RuntimeCostAccounter.recordJump();
                                    if (logger != null) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                                        AssertionError assertionError = new AssertionError();
                                        RuntimeCostAccounter.recordThrow();
                                        throw assertionError;
                                    }
                                }
                                RuntimeCostAccounter.recordJump();
                                if ($assertionsDisabled) break block6;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$600:(Ljava/util/logging/LogManager;)Z");
                                boolean bl = LogManager.this.initializedCalled;
                                RuntimeCostAccounter.recordJump();
                                if (!bl) break block7;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$700:(Ljava/util/logging/LogManager;)Z");
                                boolean bl2 = LogManager.this.initializationDone;
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) break block6;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                            AssertionError assertionError = new AssertionError();
                            RuntimeCostAccounter.recordThrow();
                            throw assertionError;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$800:(Ljava/util/logging/LogManager;)V");
                        LogManager.access$800(logManager);
                        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$RootLogger");
                        LogManager logManager2 = logManager;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                        logManager2.getClass();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$RootLogger.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager$1;)V");
                        RootLogger rootLogger = new RootLogger(logManager2, null);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$502:(Ljava/util/logging/LogManager;Ljava/util/logging/Logger;)Ljava/util/logging/Logger;");
                        logManager.rootLogger = rootLogger;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                        Logger logger = logManager.rootLogger;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.addLogger:(Ljava/util/logging/Logger;)Z");
                        logManager.addLogger(logger);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                        Logger logger2 = logManager.rootLogger;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLevelInitialized:()Z");
                        boolean bl = logger2.isLevelInitialized();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                            Logger logger3 = logManager.rootLogger;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1000:()Ljava/util/logging/Level;");
                            Level level = defaultLevel;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
                            logger3.setLevel(level);
                        }
                        Logger logger4 = Logger.global;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.addLogger:(Ljava/util/logging/Logger;)Z");
                        logManager.addLogger(logger4);
                        return null;
                    }

                    static {
                        boolean bl;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
                        boolean bl2 = LogManager.class.desiredAssertionStatus();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) {
                            bl = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            bl = false;
                        }
                        $assertionsDisabled = bl;
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
                AccessController.doPrivileged((PrivilegedAction)privilegedAction);
                this.initializationDone = true;
            }
            catch (Throwable throwable) {
                this.initializationDone = true;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public static LogManager getLogManager() {
        RuntimeCostAccounter.recordJump();
        if (manager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.ensureLogManagerInitialized:()V");
            manager.ensureLogManagerInitialized();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        RuntimeCostAccounter.recordJump();
        if (!this.readPrimordialConfiguration) {
            block6: {
                LogManager logManager = this;
                try {
                    RuntimeCostAccounter.recordJump();
                    if (this.readPrimordialConfiguration) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (System.out == null) {
                        return;
                    }
                    this.readPrimordialConfiguration = true;
                    try {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$3");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$3.<init>:(Ljava/util/logging/LogManager;)V");
                        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                            {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                            }

                            public Void run() throws Exception {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.readConfiguration:()V");
                                LogManager.this.readConfiguration();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.redirectPlatformLoggers:()V");
                                PlatformLogger.redirectPlatformLoggers();
                                return null;
                            }
                        };
                        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
                        AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
                    }
                    catch (Exception exception) {
                        RuntimeCostAccounter.recordJump();
                        if ($assertionsDisabled) break block6;
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Exception raised while reading logging configuration: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(exception);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                        AssertionError assertionError = new AssertionError((Object)string);
                        RuntimeCostAccounter.recordThrow();
                        throw assertionError;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        PropertyChangeListener propertyChangeListener2 = Objects.requireNonNull(propertyChangeListener);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
        Map<Object, Integer> map = this.listenerMap;
        try {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Integer n2 = this.listenerMap.get(propertyChangeListener2);
            RuntimeCostAccounter.recordJump();
            if (n2 == null) {
                n = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                n = n2 + 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            n2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.listenerMap.put(propertyChangeListener2, n2);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordJump();
        if (propertyChangeListener != null) {
            block6: {
                PropertyChangeListener propertyChangeListener2 = propertyChangeListener;
                Map<Object, Integer> map = this.listenerMap;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Integer n = this.listenerMap.get(propertyChangeListener2);
                    RuntimeCostAccounter.recordJump();
                    if (n == null) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n2 = n;
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                        this.listenerMap.remove(propertyChangeListener2);
                        RuntimeCostAccounter.recordJump();
                        break block6;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (!$assertionsDisabled) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 <= 1) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                            AssertionError assertionError = new AssertionError();
                            RuntimeCostAccounter.recordThrow();
                            throw assertionError;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                    Integer n3 = n2 - 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    this.listenerMap.put(propertyChangeListener2, n3);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getUserContext() {
        LoggerContext loggerContext;
        LoggerContext loggerContext2 = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.getJavaAWTAccess:()Lsun/misc/JavaAWTAccess;");
        JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordJump();
            if (javaAWTAccess != null) {
                block7: {
                    JavaAWTAccess javaAWTAccess2 = javaAWTAccess;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/JavaAWTAccess.getAppletContext:()Ljava/lang/Object;");
                        Object object = javaAWTAccess.getAppletContext();
                        RuntimeCostAccounter.recordJump();
                        if (object == null) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (this.contextsMap == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.<init>:()V");
                            this.contextsMap = new WeakHashMap();
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        loggerContext2 = this.contextsMap.get(object);
                        RuntimeCostAccounter.recordJump();
                        if (loggerContext2 != null) break block7;
                        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LoggerContext");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager$1;)V");
                        loggerContext2 = new LoggerContext(this, null);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.contextsMap.put(object, loggerContext2);
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (loggerContext2 != null) {
            loggerContext = loggerContext2;
            RuntimeCostAccounter.recordJump();
        } else {
            loggerContext = this.userContext;
        }
        return loggerContext;
    }

    final LoggerContext getSystemContext() {
        return this.systemContext;
    }

    private List<LoggerContext> contexts() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<LoggerContext> arrayList = new ArrayList<LoggerContext>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getSystemContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext = this.getSystemContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        arrayList.add(loggerContext);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getUserContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext2 = this.getUserContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        arrayList.add(loggerContext2);
        return arrayList;
    }

    Logger demandLogger(String string, String string2, Class<?> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
        Logger logger = this.getLogger(string);
        RuntimeCostAccounter.recordJump();
        if (logger == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/util/logging/LogManager;Z)V");
            Logger logger2 = new Logger(string, string2, clazz, this, false);
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.addLogger:(Ljava/util/logging/Logger;)Z");
                boolean bl = this.addLogger(logger2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return logger2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
                logger = this.getLogger(string);
                RuntimeCostAccounter.recordJump();
            } while (logger == null);
        }
        return logger;
    }

    Logger demandSystemLogger(String string, String string2) {
        Logger logger;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getSystemContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext = this.getSystemContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.demandLogger:(Ljava/lang/String;Ljava/lang/String;)Ljava/util/logging/Logger;");
        final Logger logger2 = loggerContext.demandLogger(string, string2);
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.addLogger:(Ljava/util/logging/Logger;)Z");
            boolean bl = this.addLogger(logger2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                logger = logger2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
                logger = this.getLogger(string);
            }
            RuntimeCostAccounter.recordJump();
        } while (logger == null);
        RuntimeCostAccounter.recordJump();
        if (logger != logger2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.accessCheckedHandlers:()[Ljava/util/logging/Handler;");
            int n = logger2.accessCheckedHandlers().length;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                final Logger logger3 = logger;
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$4");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$4.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/Logger;Ljava/util/logging/Logger;)V");
                PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    public Void run() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.accessCheckedHandlers:()[Ljava/util/logging/Handler;");
                        Handler[] handlerArray = logger3.accessCheckedHandlers();
                        int n = handlerArray.length;
                        int n2 = 0;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n2 >= n) break;
                            Handler handler = handlerArray[n2];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.addHandler:(Ljava/util/logging/Handler;)V");
                            logger2.addHandler(handler);
                            ++n2;
                            RuntimeCostAccounter.recordJump();
                        }
                        return null;
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
                AccessController.doPrivileged((PrivilegedAction)privilegedAction);
            }
        }
        return logger2;
    }

    private void loadLoggerHandlers(final Logger logger, String string, final String string2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$5");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$5.<init>:(Ljava/util/logging/LogManager;Ljava/lang/String;Ljava/util/logging/Logger;)V");
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Object run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1300:(Ljava/util/logging/LogManager;Ljava/lang/String;)[Ljava/lang/String;");
                String[] stringArray = LogManager.access$1300(LogManager.this, string2);
                int n = 0;
                while (true) {
                    int n2 = stringArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    String string = stringArray[n];
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                        Class<?> clazz = classLoader.loadClass(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                        Handler handler = (Handler)clazz.newInstance();
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(".level");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string22 = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string3 = LogManager.this.getProperty(string22);
                        RuntimeCostAccounter.recordJump();
                        if (string3 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.findLevel:(Ljava/lang/String;)Ljava/util/logging/Level;");
                            Level level = Level.findLevel(string3);
                            RuntimeCostAccounter.recordJump();
                            if (level != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.setLevel:(Ljava/util/logging/Level;)V");
                                handler.setLevel(level);
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                StringBuilder stringBuilder4 = new StringBuilder();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder5 = stringBuilder4.append("Can't set level for ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder6 = stringBuilder5.append(string);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                String string4 = stringBuilder6.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                                ((PrintStream)((Object)System.err)).println(string4);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.addHandler:(Ljava/util/logging/Handler;)V");
                        logger.addHandler(handler);
                    }
                    catch (Exception exception) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder7 = stringBuilder.append("Can't load log handler \"");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder8 = stringBuilder7.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder9 = stringBuilder8.append("\"");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string5 = stringBuilder9.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                        ((PrintStream)((Object)System.err)).println(string5);
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder10 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder11 = stringBuilder10.append("");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder12 = stringBuilder11.append(exception);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string6 = stringBuilder12.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                        ((PrintStream)((Object)System.err)).println(string6);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Exception.printStackTrace:()V");
                        exception.printStackTrace();
                    }
                    RuntimeCostAccounter.recordJump();
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    final void drainLoggerRefQueueBounded() {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= 400) break;
            RuntimeCostAccounter.recordJump();
            if (this.loggerRefQueue == null) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.poll:()Ljava/lang/ref/Reference;");
            LoggerWeakRef loggerWeakRef = (LoggerWeakRef)this.loggerRefQueue.poll();
            RuntimeCostAccounter.recordJump();
            if (loggerWeakRef == null) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.dispose:()V");
            loggerWeakRef.dispose();
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    public boolean addLogger(Logger logger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
        String string = logger.getName();
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.drainLoggerRefQueueBounded:()V");
        this.drainLoggerRefQueueBounded();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getUserContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext = this.getUserContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.addLocalLogger:(Ljava/util/logging/Logger;)Z");
        boolean bl = loggerContext.addLocalLogger(logger);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(".handlers");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.loadLoggerHandlers:(Ljava/util/logging/Logger;Ljava/lang/String;Ljava/lang/String;)V");
            this.loadLoggerHandlers(logger, string, string2);
            return true;
        }
        return false;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
            logger.setLevel(level);
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$6");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$6.<init>:(Ljava/util/logging/Logger;Ljava/util/logging/Level;)V");
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Object run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
                logger.setLevel(level);
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    private static void doSetParent(final Logger logger, final Logger logger2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setParent:(Ljava/util/logging/Logger;)V");
            logger.setParent(logger2);
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$7");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$7.<init>:(Ljava/util/logging/Logger;Ljava/util/logging/Logger;)V");
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Object run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setParent:(Ljava/util/logging/Logger;)V");
                logger.setParent(logger2);
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    public Logger getLogger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getUserContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext = this.getUserContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.findLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
        return loggerContext.findLogger(string);
    }

    public Enumeration<String> getLoggerNames() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getUserContext:()Ljava/util/logging/LogManager$LoggerContext;");
        LoggerContext loggerContext = this.getUserContext();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getLoggerNames:()Ljava/util/Enumeration;");
        return loggerContext.getLoggerNames();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readConfiguration() throws IOException, SecurityException {
        Object object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string = System.getProperty("java.util.logging.config.class");
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            try {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                    Class<?> clazz = classLoader.loadClass(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                    clazz.newInstance();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    Thread thread = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
                    ClassLoader classLoader = thread.getContextClassLoader();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                    Class<?> clazz = classLoader.loadClass(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                    clazz.newInstance();
                    return;
                }
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Logging configuration class \"");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("\" failed");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                ((PrintStream)((Object)System.err)).println(string2);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder5 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(exception);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                ((PrintStream)((Object)System.err)).println(string3);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string4 = System.getProperty("java.util.logging.config.file");
        RuntimeCostAccounter.recordJump();
        if (string4 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
            string4 = System.getProperty("java.home");
            RuntimeCostAccounter.recordJump();
            if (string4 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                Error error = new Error("Can't find java.home ??");
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
            object = new File(string4, "lib");
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
            object = new File((File)object, "logging.properties");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
            string4 = ((File)object).getCanonicalPath();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/lang/String;)V");
        object = new FileInputStream(string4);
        Throwable throwable = null;
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedInputStream");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.<init>:(Ljava/io/InputStream;)V");
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.readConfiguration:(Ljava/io/InputStream;)V");
            this.readConfiguration(bufferedInputStream);
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                RuntimeCostAccounter.recordThrow();
                throw throwable3;
            }
            catch (Throwable throwable4) {
                block16: {
                    block17: {
                        RuntimeCostAccounter.recordJump();
                        if (object == null) break block16;
                        RuntimeCostAccounter.recordJump();
                        if (throwable == null) break block17;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable5) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                            throwable.addSuppressed(throwable5);
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        break block16;
                        break block16;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                    ((InputStream)object).close();
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable4;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (object == null) return;
        RuntimeCostAccounter.recordJump();
        if (throwable != null) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                ((InputStream)object).close();
            }
            catch (Throwable throwable2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                throwable.addSuppressed(throwable2);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
        ((InputStream)object).close();
        RuntimeCostAccounter.recordJump();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
        Object object = this;
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Properties");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.<init>:()V");
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.contexts:()Ljava/util/List;");
        List<LoggerContext> list = this.contexts();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
        object = list.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = object.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            LoggerContext loggerContext = (LoggerContext)object.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getLoggerNames:()Ljava/util/Enumeration;");
            Enumeration<String> enumeration = loggerContext.getLoggerNames();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl2 = enumeration.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                String string = enumeration.nextElement();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.findLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
                Logger logger = loggerContext.findLogger(string);
                RuntimeCostAccounter.recordJump();
                if (logger != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.resetLogger:(Ljava/util/logging/Logger;)V");
                    this.resetLogger(logger);
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetLogger(Logger logger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getHandlers:()[Ljava/util/logging/Handler;");
        Handler[] handlerArray = logger.getHandlers();
        int n = 0;
        while (true) {
            block5: {
                int n2 = handlerArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Handler handler = handlerArray[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.removeHandler:(Ljava/util/logging/Handler;)V");
                logger.removeHandler(handler);
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.close:()V");
                    handler.close();
                }
                catch (Exception exception) {
                    // empty catch block
                    break block5;
                }
                RuntimeCostAccounter.recordJump();
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
        String string = logger.getName();
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string.equals("");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
                logger.setLevel(defaultLevel);
                RuntimeCostAccounter.recordJump();
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
        logger.setLevel(null);
    }

    private String[] parseClassNames(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = this.getProperty(string);
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
            return new String[0];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
        string2 = string2.trim();
        int n = 0;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n2 = string2.length();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            int n3 = n;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n4 = string2.length();
                RuntimeCostAccounter.recordJump();
                if (n3 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c = string2.charAt(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.isWhitespace:(C)Z");
                boolean bl = Character.isWhitespace(c);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c2 = string2.charAt(n3);
                RuntimeCostAccounter.recordJump();
                if (c2 == ',') {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string3 = string2.substring(n, n3);
            n = n3 + 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
            string3 = string3.trim();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n5 = string3.length();
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) {
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList.add(string3);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n6 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)8);
        String[] stringArray = new String[n6];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return arrayList.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        Object object;
        Object object2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.reset:()V");
        this.reset();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.load:(Ljava/io/InputStream;)V");
        this.props.load(inputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.parseClassNames:(Ljava/lang/String;)[Ljava/lang/String;");
        String[] stringArray = this.parseClassNames("config");
        int n = 0;
        while (true) {
            int n2 = stringArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            object2 = stringArray[n];
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                object = classLoader.loadClass((String)object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                ((Class)object).newInstance();
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Can't load config class \"");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append((String)object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("\"");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                ((PrintStream)((Object)System.err)).println(string);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder5 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(exception);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                ((PrintStream)((Object)System.err)).println(string2);
            }
            RuntimeCostAccounter.recordJump();
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.setLevelsOnExistingLoggers:()V");
        this.setLevelsOnExistingLoggers();
        HashMap<Object, Integer> hashMap = null;
        object2 = this.listenerMap;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            boolean bl = this.listenerMap.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(Ljava/util/Map;)V");
                hashMap = new HashMap<Object, Integer>(this.listenerMap);
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (hashMap != null) {
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.isBeansPresent:()Z");
                boolean bl = Beans.isBeansPresent();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.newPropertyChangeEvent:(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            object2 = Beans.newPropertyChangeEvent(LogManager.class, null, null, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
            Set set = hashMap.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            object = set.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = object.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry entry = (Map.Entry)object.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Integer n3 = (Integer)entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                int n4 = n3;
                int n5 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 >= n4) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.invokePropertyChange:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    Beans.invokePropertyChange(k, object2);
                    ++n5;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        object2 = this;
        try {
            this.initializedGlobalHandlers = false;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public String getProperty(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        return this.props.getProperty(string);
    }

    String getStringProperty(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string3 = this.getProperty(string);
        RuntimeCostAccounter.recordJump();
        if (string3 == null) {
            return string2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
        return string3.trim();
    }

    int getIntProperty(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = this.getProperty(string);
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            return n;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
            String string3 = string2.trim();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
            return Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return n;
        }
    }

    boolean getBooleanProperty(String string, boolean bl) {
        block10: {
            block9: {
                String string2;
                block8: {
                    block7: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        string2 = this.getProperty(string);
                        RuntimeCostAccounter.recordJump();
                        if (string2 == null) {
                            return bl;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toLowerCase:()Ljava/lang/String;");
                        string2 = string2.toLowerCase();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                        boolean bl2 = string2.equals("true");
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                        boolean bl3 = string2.equals("1");
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block8;
                    }
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl4 = string2.equals("false");
                RuntimeCostAccounter.recordJump();
                if (bl4) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl5 = string2.equals("0");
                RuntimeCostAccounter.recordJump();
                if (!bl5) break block10;
            }
            return false;
        }
        return bl;
    }

    Level getLevelProperty(String string, Level level) {
        Level level2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = this.getProperty(string);
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            return level;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
        String string3 = string2.trim();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.findLevel:(Ljava/lang/String;)Ljava/util/logging/Level;");
        Level level3 = Level.findLevel(string3);
        RuntimeCostAccounter.recordJump();
        if (level3 != null) {
            level2 = level3;
            RuntimeCostAccounter.recordJump();
        } else {
            level2 = level;
        }
        return level2;
    }

    Filter getFilterProperty(String string, Filter filter) {
        block2: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
            String string2 = this.getProperty(string);
            try {
                RuntimeCostAccounter.recordJump();
                if (string2 == null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                Class<?> clazz = classLoader.loadClass(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                return (Filter)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RuntimeCostAccounter.recordJump();
        return filter;
    }

    Formatter getFormatterProperty(String string, Formatter formatter) {
        block2: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
            String string2 = this.getProperty(string);
            try {
                RuntimeCostAccounter.recordJump();
                if (string2 == null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                Class<?> clazz = classLoader.loadClass(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                return (Formatter)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RuntimeCostAccounter.recordJump();
        return formatter;
    }

    private synchronized void initializeGlobalHandlers() {
        RuntimeCostAccounter.recordJump();
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        RuntimeCostAccounter.recordJump();
        if (this.deathImminent) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.loadLoggerHandlers:(Ljava/util/logging/Logger;Ljava/lang/String;Ljava/lang/String;)V");
        this.loadLoggerHandlers(this.rootLogger, null, "handlers");
    }

    void checkPermission() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission(this.controlPermission);
        }
    }

    public void checkAccess() throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        this.checkPermission();
    }

    private synchronized void setLevelsOnExistingLoggers() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.propertyNames:()Ljava/util/Enumeration;");
        Enumeration<?> enumeration = this.props.propertyNames();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
            boolean bl = enumeration.hasMoreElements();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
            String string = (String)enumeration.nextElement();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string.endsWith(".level");
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string.length() - 6;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string2 = string.substring(0, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
            Level level = this.getLevelProperty(string, null);
            RuntimeCostAccounter.recordJump();
            if (level == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Bad level value for property: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                ((PrintStream)((Object)System.err)).println(string3);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.contexts:()Ljava/util/List;");
            List<LoggerContext> list = this.contexts();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
            Iterator<LoggerContext> iterator = list.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl3 = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                LoggerContext loggerContext = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.findLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
                Logger logger = loggerContext.findLogger(string2);
                RuntimeCostAccounter.recordJump();
                if (logger == null) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLevel:(Ljava/util/logging/Level;)V");
                logger.setLevel(level);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        RuntimeCostAccounter.recordJump();
        if (loggingMXBean == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logging");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logging.<init>:()V");
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static /* synthetic */ void access$800(LogManager logManager) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.readPrimordialConfiguration:()V");
        logManager.readPrimordialConfiguration();
    }

    static /* synthetic */ void access$1100(Logger logger, Level level) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.doSetLevel:(Ljava/util/logging/Logger;Ljava/util/logging/Level;)V");
        LogManager.doSetLevel(logger, level);
    }

    static /* synthetic */ void access$1200(Logger logger, Logger logger2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.doSetParent:(Ljava/util/logging/Logger;Ljava/util/logging/Logger;)V");
        LogManager.doSetParent(logger, logger2);
    }

    static /* synthetic */ String[] access$1300(LogManager logManager, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.parseClassNames:(Ljava/lang/String;)[Ljava/lang/String;");
        return logManager.parseClassNames(string);
    }

    static /* synthetic */ void access$1500(LogManager logManager) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.initializeGlobalHandlers:()V");
        logManager.initializeGlobalHandlers();
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = LogManager.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        defaultLevel = Level.INFO;
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$1.<init>:()V");
        PrivilegedAction<LogManager> privilegedAction = new PrivilegedAction<LogManager>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public LogManager run() {
                LogManager logManager;
                block5: {
                    logManager = null;
                    String string = null;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        string = System.getProperty("java.util.logging.manager");
                        RuntimeCostAccounter.recordJump();
                        if (string == null) break block5;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                            Class<?> clazz = classLoader.loadClass(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                            logManager = (LogManager)clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                            Thread thread = Thread.currentThread();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
                            ClassLoader classLoader = thread.getContextClassLoader();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
                            Class<?> clazz = classLoader.loadClass(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                            logManager = (LogManager)clazz.newInstance();
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    catch (Exception exception) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Could not load Logmanager \"");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append("\"");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string2 = stringBuilder4.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
                        ((PrintStream)((Object)System.err)).println(string2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Exception.printStackTrace:()V");
                        exception.printStackTrace();
                    }
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (logManager == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.<init>:()V");
                    logManager = new LogManager();
                }
                return logManager;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        manager = (LogManager)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        loggingMXBean = null;
    }

    private static class Beans {
        private static final Class<?> propertyChangeListenerClass;
        private static final Class<?> propertyChangeEventClass;
        private static final Method propertyChangeMethod;
        private static final Constructor<?> propertyEventCtor;

        private Beans() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        private static Class<?> getClass(String string) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
                ClassLoader classLoader = Beans.class.getClassLoader();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                return Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
            try {
                Constructor<?> constructor;
                RuntimeCostAccounter.recordJump();
                if (clazz == null) {
                    constructor = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredConstructor:([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
                    constructor = clazz.getDeclaredConstructor(classArray);
                }
                return constructor;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)noSuchMethodException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                Method method;
                RuntimeCostAccounter.recordJump();
                if (clazz == null) {
                    method = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getMethod:(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                    method = clazz.getMethod(string, classArray);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)noSuchMethodException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean isBeansPresent() {
            RuntimeCostAccounter.recordJump();
            if (propertyChangeListenerClass == null) return false;
            RuntimeCostAccounter.recordJump();
            if (propertyChangeEventClass == null) return false;
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        static Object newPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
            try {
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
                Object[] objectArray = new Object[]{object, string, object2, object3};
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Constructor.newInstance:([Ljava/lang/Object;)Ljava/lang/Object;");
                return propertyEventCtor.newInstance(objectArray);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)reflectiveOperationException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
            catch (InvocationTargetException invocationTargetException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/InvocationTargetException.getCause:()Ljava/lang/Throwable;");
                Throwable throwable = invocationTargetException.getCause();
                boolean bl = throwable instanceof Error;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Error error = (Error)throwable;
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                boolean bl2 = throwable instanceof RuntimeException;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    RuntimeCostAccounter.recordThrow();
                    throw runtimeException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)invocationTargetException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }

        static void invokePropertyChange(Object object, Object object2) {
            try {
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Object[] objectArray = new Object[]{object2};
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Method.invoke:(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                propertyChangeMethod.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)illegalAccessException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
            catch (InvocationTargetException invocationTargetException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/InvocationTargetException.getCause:()Ljava/lang/Throwable;");
                Throwable throwable = invocationTargetException.getCause();
                boolean bl = throwable instanceof Error;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Error error = (Error)throwable;
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                boolean bl2 = throwable instanceof RuntimeException;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    RuntimeCostAccounter.recordThrow();
                    throw runtimeException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)invocationTargetException);
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
            RuntimeCostAccounter.recordJump();
        }

        static {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.getClass:(Ljava/lang/String;)Ljava/lang/Class;");
            propertyChangeListenerClass = Beans.getClass("java.beans.PropertyChangeListener");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.getClass:(Ljava/lang/String;)Ljava/lang/Class;");
            propertyChangeEventClass = Beans.getClass("java.beans.PropertyChangeEvent");
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Class[] classArray = new Class[]{propertyChangeEventClass};
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.getMethod:(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
            propertyChangeMethod = Beans.getMethod(propertyChangeListenerClass, "propertyChange", classArray);
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            Class[] classArray2 = new Class[]{Object.class, String.class, Object.class, Object.class};
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Beans.getConstructor:(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
            propertyEventCtor = Beans.getConstructor(propertyChangeEventClass, classArray2);
        }
    }

    private final class RootLogger
    extends Logger {
        final /* synthetic */ LogManager this$0;

        private RootLogger(LogManager logManager) {
            this.this$0 = logManager;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/util/logging/LogManager;Z)V");
            super("", null, null, logManager, true);
        }

        @Override
        public void log(LogRecord logRecord) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1500:(Ljava/util/logging/LogManager;)V");
            LogManager.access$1500(this.this$0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.log:(Ljava/util/logging/LogRecord;)V");
            super.log(logRecord);
        }

        @Override
        public void addHandler(Handler handler) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1500:(Ljava/util/logging/LogManager;)V");
            LogManager.access$1500(this.this$0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.addHandler:(Ljava/util/logging/Handler;)V");
            super.addHandler(handler);
        }

        @Override
        public void removeHandler(Handler handler) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1500:(Ljava/util/logging/LogManager;)V");
            LogManager.access$1500(this.this$0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.removeHandler:(Ljava/util/logging/Handler;)V");
            super.removeHandler(handler);
        }

        @Override
        Handler[] accessCheckedHandlers() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1500:(Ljava/util/logging/LogManager;)V");
            LogManager.access$1500(this.this$0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.accessCheckedHandlers:()[Ljava/util/logging/Handler;");
            return super.accessCheckedHandlers();
        }

        /* synthetic */ RootLogger(LogManager logManager, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$RootLogger.<init>:(Ljava/util/logging/LogManager;)V");
            this(logManager);
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;
        final LoggerContext context;

        LogNode(LogNode logNode, LoggerContext loggerContext) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.parent = logNode;
            this.context = loggerContext;
        }

        void walkAndSetParent(Logger logger) {
            RuntimeCostAccounter.recordJump();
            if (this.children == null) {
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.values:()Ljava/util/Collection;");
            Collection<LogNode> collection = this.children.values();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<LogNode> iterator = collection.iterator();
            while (true) {
                Logger logger2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                LogNode logNode = iterator.next();
                LoggerWeakRef loggerWeakRef = logNode.loggerRef;
                RuntimeCostAccounter.recordJump();
                if (loggerWeakRef == null) {
                    logger2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
                    logger2 = (Logger)loggerWeakRef.get();
                }
                Logger logger3 = logger2;
                RuntimeCostAccounter.recordJump();
                if (logger3 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LogNode.walkAndSetParent:(Ljava/util/logging/Logger;)V");
                    logNode.walkAndSetParent(logger);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1200:(Ljava/util/logging/Logger;Ljava/util/logging/Logger;)V");
                    LogManager.access$1200(logger3, logger);
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;
        private boolean disposed;

        LoggerWeakRef(Logger logger) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1400:(Ljava/util/logging/LogManager;)Ljava/lang/ref/ReferenceQueue;");
            ReferenceQueue referenceQueue = LogManager.this.loggerRefQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V");
            super(logger, referenceQueue);
            this.disposed = false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
            this.name = logger.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            Object object;
            Object object2 = this;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            object2 = this.node;
            RuntimeCostAccounter.recordJump();
            if (object2 != null) {
                object = ((LogNode)object2).context;
                try {
                    LoggerContext loggerContext = ((LogNode)object2).context;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.removeLoggerRef:(Ljava/lang/String;Ljava/util/logging/LogManager$LoggerWeakRef;)V");
                    loggerContext.removeLoggerRef(this.name, this);
                    this.name = null;
                    LoggerWeakRef loggerWeakRef = ((LogNode)object2).loggerRef;
                    RuntimeCostAccounter.recordJump();
                    if (loggerWeakRef == this) {
                        ((LogNode)object2).loggerRef = null;
                    }
                    this.node = null;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.parentRef != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.get:()Ljava/lang/Object;");
                object = (Logger)this.parentRef.get();
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.removeChildLogger:(Ljava/util/logging/LogManager$LoggerWeakRef;)V");
                    ((Logger)object).removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode logNode) {
            this.node = logNode;
        }

        void setParentRef(WeakReference<Logger> weakReference) {
            this.parentRef = weakReference;
        }
    }

    final class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/LogManager$1;)V");
            super(LogManager.this, null);
        }

        @Override
        Logger demandLogger(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$SystemLoggerContext.findLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
            Logger logger = this.findLogger(string);
            RuntimeCostAccounter.recordJump();
            if (logger == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Logger");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$SystemLoggerContext.getOwner:()Ljava/util/logging/LogManager;");
                LogManager logManager = this.getOwner();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/util/logging/LogManager;Z)V");
                Logger logger2 = new Logger(string, string2, null, logManager, true);
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$SystemLoggerContext.addLocalLogger:(Ljava/util/logging/Logger;)Z");
                    boolean bl = this.addLocalLogger(logger2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        logger = logger2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$SystemLoggerContext.findLogger:(Ljava/lang/String;)Ljava/util/logging/Logger;");
                        logger = this.findLogger(string);
                    }
                    RuntimeCostAccounter.recordJump();
                } while (logger == null);
            }
            return logger;
        }
    }

    class LoggerContext {
        private final Hashtable<String, LoggerWeakRef> namedLoggers;
        private final LogNode root;
        static final /* synthetic */ boolean $assertionsDisabled;
        final /* synthetic */ LogManager this$0;

        private LoggerContext(LogManager logManager) {
            this.this$0 = logManager;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:()V");
            this.namedLoggers = new Hashtable();
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LogNode");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LogNode.<init>:(Ljava/util/logging/LogManager$LogNode;Ljava/util/logging/LogManager$LoggerContext;)V");
            this.root = new LogNode(null, this);
        }

        final boolean requiresDefaultLoggers() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
            LogManager logManager = this.getOwner();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$100:()Ljava/util/logging/LogManager;");
            LogManager logManager2 = manager;
            RuntimeCostAccounter.recordJump();
            if (logManager == logManager2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            boolean bl2 = bl;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
                LogManager logManager3 = this.getOwner();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.ensureLogManagerInitialized:()V");
                logManager3.ensureLogManagerInitialized();
            }
            return bl2;
        }

        final LogManager getOwner() {
            return this.this$0;
        }

        final Logger getRootLogger() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
            LogManager logManager = this.getOwner();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
            return logManager.rootLogger;
        }

        final Logger getGlobalLogger() {
            Logger logger = Logger.global;
            return logger;
        }

        Logger demandLogger(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
            LogManager logManager = this.getOwner();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.demandLogger:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/util/logging/Logger;");
            return logManager.demandLogger(string, string2, null);
        }

        private void ensureInitialized() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.requiresDefaultLoggers:()Z");
            boolean bl = this.requiresDefaultLoggers();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getRootLogger:()Ljava/util/logging/Logger;");
                Logger logger = this.getRootLogger();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureDefaultLogger:(Ljava/util/logging/Logger;)V");
                this.ensureDefaultLogger(logger);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getGlobalLogger:()Ljava/util/logging/Logger;");
                Logger logger2 = this.getGlobalLogger();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureDefaultLogger:(Ljava/util/logging/Logger;)V");
                this.ensureDefaultLogger(logger2);
            }
        }

        synchronized Logger findLogger(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureInitialized:()V");
            this.ensureInitialized();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            LoggerWeakRef loggerWeakRef = this.namedLoggers.get(string);
            RuntimeCostAccounter.recordJump();
            if (loggerWeakRef == null) {
                return null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
            Logger logger = (Logger)loggerWeakRef.get();
            RuntimeCostAccounter.recordJump();
            if (logger == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.dispose:()V");
                loggerWeakRef.dispose();
            }
            return logger;
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.requiresDefaultLoggers:()Z");
            boolean bl = this.requiresDefaultLoggers();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
                String string = logger.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.isEmpty:()Z");
                boolean bl2 = string.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getRootLogger:()Ljava/util/logging/Logger;");
                    Logger logger2 = this.getRootLogger();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureDefaultLogger:(Ljava/util/logging/Logger;)V");
                    this.ensureDefaultLogger(logger2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = "global".equals(string);
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getGlobalLogger:()Ljava/util/logging/Logger;");
                        Logger logger3 = this.getGlobalLogger();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureDefaultLogger:(Ljava/util/logging/Logger;)V");
                        this.ensureDefaultLogger(logger3);
                    }
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            block7: {
                block6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.requiresDefaultLoggers:()Z");
                    boolean bl = this.requiresDefaultLoggers();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (logger == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (logger == Logger.global) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                    Logger logger2 = this.this$0.rootLogger;
                    RuntimeCostAccounter.recordJump();
                    if (logger == logger2) break block7;
                }
                RuntimeCostAccounter.recordJump();
                if (!$assertionsDisabled) {
                    RuntimeCostAccounter.recordJump();
                    if (logger != null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                        AssertionError assertionError = new AssertionError();
                        RuntimeCostAccounter.recordThrow();
                        throw assertionError;
                    }
                }
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
            String string = logger.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.containsKey:(Ljava/lang/Object;)Z");
            boolean bl = this.namedLoggers.containsKey(string);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.addLocalLogger:(Ljava/util/logging/Logger;Z)Z");
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.requiresDefaultLoggers:()Z");
            boolean bl = this.requiresDefaultLoggers();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.addLocalLogger:(Ljava/util/logging/Logger;Z)Z");
            return this.addLocalLogger(logger, bl);
        }

        synchronized boolean addLocalLogger(Logger logger, boolean bl) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureAllDefaultLoggers:(Ljava/util/logging/Logger;)V");
                this.ensureAllDefaultLoggers(logger);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.getName:()Ljava/lang/String;");
            String string = logger.getName();
            RuntimeCostAccounter.recordJump();
            if (string == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            LoggerWeakRef loggerWeakRef = this.namedLoggers.get(string);
            RuntimeCostAccounter.recordJump();
            if (loggerWeakRef != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
                Object t = loggerWeakRef.get();
                RuntimeCostAccounter.recordJump();
                if (t == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.dispose:()V");
                    loggerWeakRef.dispose();
                    RuntimeCostAccounter.recordJump();
                } else {
                    return false;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
            LogManager logManager = this.getOwner();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setLogManager:(Ljava/util/logging/LogManager;)V");
            logger.setLogManager(logManager);
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LoggerWeakRef");
            LogManager logManager2 = logManager;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            logManager2.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.<init>:(Ljava/util/logging/LogManager;Ljava/util/logging/Logger;)V");
            loggerWeakRef = logManager2.new LoggerWeakRef(logger);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.namedLoggers.put(string, loggerWeakRef);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(".level");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
            Level level = logManager.getLevelProperty(string2, null);
            RuntimeCostAccounter.recordJump();
            if (level != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.isLevelInitialized:()Z");
                boolean bl2 = logger.isLevelInitialized();
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1100:(Ljava/util/logging/Logger;Ljava/util/logging/Level;)V");
                    LogManager.access$1100(logger, level);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.processParentHandlers:(Ljava/util/logging/Logger;Ljava/lang/String;)V");
            this.processParentHandlers(logger, string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getNode:(Ljava/lang/String;)Ljava/util/logging/LogManager$LogNode;");
            LogNode logNode = this.getNode(string);
            logNode.loggerRef = loggerWeakRef;
            Logger logger2 = null;
            LogNode logNode2 = logNode.parent;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (logNode2 == null) break;
                LoggerWeakRef loggerWeakRef2 = logNode2.loggerRef;
                RuntimeCostAccounter.recordJump();
                if (loggerWeakRef2 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.get:()Ljava/lang/Object;");
                    logger2 = (Logger)loggerWeakRef2.get();
                    RuntimeCostAccounter.recordJump();
                    if (logger2 != null) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                }
                logNode2 = logNode2.parent;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (logger2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$1200:(Ljava/util/logging/Logger;Ljava/util/logging/Logger;)V");
                LogManager.access$1200(logger, logger2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LogNode.walkAndSetParent:(Ljava/util/logging/Logger;)V");
            logNode.walkAndSetParent(logger);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerWeakRef.setNode:(Ljava/util/logging/LogManager$LogNode;)V");
            loggerWeakRef.setNode(logNode);
            return true;
        }

        synchronized void removeLoggerRef(String string, LoggerWeakRef loggerWeakRef) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.namedLoggers.remove(string, loggerWeakRef);
        }

        synchronized Enumeration<String> getLoggerNames() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.ensureInitialized:()V");
            this.ensureInitialized();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.keys:()Ljava/util/Enumeration;");
            return this.namedLoggers.keys();
        }

        private void processParentHandlers(final Logger logger, final String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.getOwner:()Ljava/util/logging/LogManager;");
            final LogManager logManager = this.getOwner();
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LoggerContext$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext$1.<init>:(Ljava/util/logging/LogManager$LoggerContext;Ljava/util/logging/Logger;Ljava/util/logging/LogManager;Ljava/lang/String;)V");
            PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Void run() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$500:(Ljava/util/logging/LogManager;)Ljava/util/logging/Logger;");
                    Logger logger2 = logManager.rootLogger;
                    RuntimeCostAccounter.recordJump();
                    if (logger != logger2) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(".useParentHandlers");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string2 = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getBooleanProperty:(Ljava/lang/String;Z)Z");
                        boolean bl = logManager.getBooleanProperty(string2, true);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Logger.setUseParentHandlers:(Z)V");
                            logger.setUseParentHandlers(false);
                        }
                    }
                    return null;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            AccessController.doPrivileged((PrivilegedAction)privilegedAction);
            int n = 1;
            while (true) {
                int n2;
                block4: {
                    String string2;
                    block3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(Ljava/lang/String;I)I");
                        n2 = string.indexOf(".", n);
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 0) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                        string2 = string.substring(0, n2);
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(string2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(".level");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string3 = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string4 = logManager.getProperty(string3);
                        RuntimeCostAccounter.recordJump();
                        if (string4 != null) break block3;
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder4 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append(".handlers");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string5 = stringBuilder6.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string6 = logManager.getProperty(string5);
                        RuntimeCostAccounter.recordJump();
                        if (string6 == null) break block4;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.demandLogger:(Ljava/lang/String;Ljava/lang/String;)Ljava/util/logging/Logger;");
                    this.demandLogger(string2, null);
                }
                n = n2 + 1;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }

        LogNode getNode(String string) {
            block9: {
                block8: {
                    RuntimeCostAccounter.recordJump();
                    if (string == null) break block8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl = string.equals("");
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block9;
                }
                return this.root;
            }
            LogNode logNode = this.root;
            while (true) {
                String string2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n = string.length();
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(Ljava/lang/String;)I");
                int n2 = string.indexOf(".");
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                    string2 = string.substring(0, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                    string = string.substring(n2 + 1);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string2 = string;
                    string = "";
                }
                HashMap<String, LogNode> hashMap = logNode.children;
                RuntimeCostAccounter.recordJump();
                if (hashMap == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                    logNode.children = new HashMap();
                }
                HashMap<String, LogNode> hashMap2 = logNode.children;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                LogNode logNode2 = hashMap2.get(string2);
                RuntimeCostAccounter.recordJump();
                if (logNode2 == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/logging/LogManager$LogNode");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LogNode.<init>:(Ljava/util/logging/LogManager$LogNode;Ljava/util/logging/LogManager$LoggerContext;)V");
                    logNode2 = new LogNode(logNode, this);
                    HashMap<String, LogNode> hashMap3 = logNode.children;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    hashMap3.put(string2, logNode2);
                }
                logNode = logNode2;
                RuntimeCostAccounter.recordJump();
            }
            return logNode;
        }

        /* synthetic */ LoggerContext(LogManager logManager, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$LoggerContext.<init>:(Ljava/util/logging/LogManager;)V");
            this(logManager);
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = LogManager.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private class Cleaner
    extends Thread {
        final /* synthetic */ LogManager this$0;

        private Cleaner(LogManager logManager) {
            this.this$0 = logManager;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Cleaner.setContextClassLoader:(Ljava/lang/ClassLoader;)V");
            this.setContextClassLoader(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$100:()Ljava/util/logging/LogManager;");
            LogManager logManager = manager;
            LogManager logManager2 = this.this$0;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$202:(Ljava/util/logging/LogManager;Z)Z");
                this.this$0.deathImminent = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.access$302:(Ljava/util/logging/LogManager;Z)Z");
                this.this$0.initializedGlobalHandlers = true;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.reset:()V");
            this.this$0.reset();
        }

        /* synthetic */ Cleaner(LogManager logManager, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager$Cleaner.<init>:(Ljava/util/logging/LogManager;)V");
            this(logManager);
        }
    }
}

