/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.jar;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataOutputStream;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.OutputStream;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.Set;
import sandbox.java.util.jar.Attributes;

public class Manifest
implements Cloneable {
    private Attributes attr;
    private Map<String, Attributes> entries;

    public Manifest() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Attributes");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.<init>:()V");
        this.attr = new Attributes();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.entries = new HashMap<String, Attributes>();
    }

    public Manifest(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Attributes");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.<init>:()V");
        this.attr = new Attributes();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.entries = new HashMap<String, Attributes>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.read:(Ljava/io/InputStream;)V");
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Attributes");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.<init>:()V");
        this.attr = new Attributes();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.entries = new HashMap<String, Attributes>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getMainAttributes:()Ljava/util/jar/Attributes;");
        Attributes attributes = manifest.getMainAttributes();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.putAll:(Ljava/util/Map;)V");
        this.attr.putAll((Map<?, ?>)attributes);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getEntries:()Ljava/util/Map;");
        Map<String, Attributes> map = manifest.getEntries();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
        this.entries.putAll(map);
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getEntries:()Ljava/util/Map;");
        Map<String, Attributes> map = this.getEntries();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        return map.get(string);
    }

    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.clear:()V");
        this.attr.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
        this.entries.clear();
    }

    public void write(OutputStream outputStream) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/DataOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.<init>:(Ljava/io/OutputStream;)V");
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.writeMain:(Ljava/io/DataOutputStream;)V");
        this.attr.writeMain(dataOutputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<String, Attributes>> set = this.entries.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<String, Attributes>> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Map.Entry<String, Attributes> entry = iterator.next();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(Ljava/lang/String;)V");
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            String string = entry.getKey();
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getBytes:(Ljava/lang/String;)[B");
                byte[] byArray = string.getBytes("UTF8");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                int n = byArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIII)V");
                string = new String(byArray, 0, 0, n);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            stringBuffer.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            stringBuffer.append("\r\n");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.make72Safe:(Ljava/lang/StringBuffer;)V");
            Manifest.make72Safe(stringBuffer);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
            String string2 = stringBuffer.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeBytes:(Ljava/lang/String;)V");
            dataOutputStream.writeBytes(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.write:(Ljava/io/DataOutputStream;)V");
            entry.getValue().write(dataOutputStream);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.flush:()V");
        dataOutputStream.flush();
    }

    static void make72Safe(StringBuffer stringBuffer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.length:()I");
        int n = stringBuffer.length();
        RuntimeCostAccounter.recordJump();
        if (n > 72) {
            int n2 = 70;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n - 2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.insert:(ILjava/lang/String;)Ljava/lang/StringBuffer;");
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
                n += 3;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    public void read(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Manifest$FastInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.<init>:(Ljava/io/InputStream;)V");
        FastInputStream fastInputStream = new FastInputStream(inputStream);
        RuntimeCostAccounter.recordArrayAllocation((int)512, (int)1);
        byte[] byArray = new byte[512];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.read:(Ljava/util/jar/Manifest$FastInputStream;[B)V");
        this.attr.read(fastInputStream, byArray);
        int n = 0;
        int n2 = 0;
        int n3 = 2;
        String string = null;
        boolean bl = true;
        Object object = null;
        while (true) {
            Object object2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.readLine:([B)I");
            int n4 = fastInputStream.readLine(byArray);
            RuntimeCostAccounter.recordJump();
            if (n4 == -1) break;
            byte by = byArray[--n4];
            RuntimeCostAccounter.recordJump();
            if (by != 10) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("manifest line too long");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            RuntimeCostAccounter.recordJump();
            if (n4 > 0) {
                byte by2 = byArray[n4 - 1];
                RuntimeCostAccounter.recordJump();
                if (by2 == 13) {
                    --n4;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
            }
            bl = false;
            RuntimeCostAccounter.recordJump();
            if (string == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.parseName:([BI)Ljava/lang/String;");
                string = this.parseName(byArray, n4);
                RuntimeCostAccounter.recordJump();
                if (string == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("invalid manifest format");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.peek:()B");
                byte by3 = fastInputStream.peek();
                RuntimeCostAccounter.recordJump();
                if (by3 == 32) {
                    int n5 = n4 - 6;
                    RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)1);
                    object = new byte[n5];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(byArray, 6, object, 0, n4 - 6);
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
            } else {
                int n6 = (object).length + n4 - 1;
                RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)1);
                object2 = new byte[n6];
                int n7 = (object).length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(object, 0, object2, 0, n7);
                int n8 = ((byte[])object).length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(byArray, 1, object2, n8, n4 - 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.peek:()B");
                byte by4 = fastInputStream.peek();
                RuntimeCostAccounter.recordJump();
                if (by4 == 32) {
                    object = object2;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                int n9 = ((Object)object2).length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIILjava/lang/String;)V");
                string = new String((byte[])object2, 0, n9, "UTF8");
                object = null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getAttributes:(Ljava/lang/String;)Ljava/util/jar/Attributes;");
            object2 = this.getAttributes(string);
            RuntimeCostAccounter.recordJump();
            if (object2 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Attributes");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.<init>:(I)V");
                object2 = new Attributes(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.entries.put(string, (Attributes)object2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.read:(Ljava/util/jar/Manifest$FastInputStream;[B)V");
            ((Attributes)object2).read(fastInputStream, byArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.size:()I");
            int n10 = (n2 += ((Attributes)object2).size()) / ++n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
            n3 = Math.max(2, n10);
            string = null;
            bl = true;
            RuntimeCostAccounter.recordJump();
        }
    }

    private String parseName(byte[] byArray, int n) {
        byte by = byArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.toLower:(I)I");
        int n2 = this.toLower(by);
        RuntimeCostAccounter.recordJump();
        if (n2 == 110) {
            byte by2 = byArray[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.toLower:(I)I");
            int n3 = this.toLower(by2);
            RuntimeCostAccounter.recordJump();
            if (n3 == 97) {
                byte by3 = byArray[2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.toLower:(I)I");
                int n4 = this.toLower(by3);
                RuntimeCostAccounter.recordJump();
                if (n4 == 109) {
                    byte by4 = byArray[3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.toLower:(I)I");
                    int n5 = this.toLower(by4);
                    RuntimeCostAccounter.recordJump();
                    if (n5 == 101) {
                        byte by5 = byArray[4];
                        RuntimeCostAccounter.recordJump();
                        if (by5 == 58) {
                            byte by6 = byArray[5];
                            RuntimeCostAccounter.recordJump();
                            if (by6 == 32) {
                                try {
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIILjava/lang/String;)V");
                                    return new String(byArray, 6, n - 6, "UTF8");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int toLower(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n >= 65) {
            RuntimeCostAccounter.recordJump();
            if (n <= 90) {
                n2 = 97 + (n - 65);
                RuntimeCostAccounter.recordJump();
                return n2;
            }
        }
        n2 = n;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = object instanceof Manifest;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        Manifest manifest = (Manifest)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getMainAttributes:()Ljava/util/jar/Attributes;");
        Attributes attributes = manifest.getMainAttributes();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.attr.equals(attributes);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getEntries:()Ljava/util/Map;");
        Map<String, Attributes> map = manifest.getEntries();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.entries.equals(map);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Attributes.hashCode:()I");
        int n = this.attr.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.hashCode:()I");
        return n + this.entries.hashCode();
    }

    public Object clone() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Manifest");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.<init>:(Ljava/util/jar/Manifest;)V");
        return new Manifest(this);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count;
        private int pos;

        FastInputStream(InputStream inputStream) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.<init>:(Ljava/io/InputStream;I)V");
            this(inputStream, 8192);
        }

        FastInputStream(InputStream inputStream, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
            super(inputStream);
            this.count = 0;
            this.pos = 0;
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
            this.buf = new byte[n2];
        }

        @Override
        public int read() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos >= this.count) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.fill:()V");
                this.fill();
                RuntimeCostAccounter.recordJump();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            byte by = this.buf[this.pos++];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
            return Byte.toUnsignedInt(by);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.count - this.pos;
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) {
                int n4 = this.buf.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                    return this.in.read(byArray, n, n2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.fill:()V");
                this.fill();
                n3 = this.count - this.pos;
                RuntimeCostAccounter.recordJump();
                if (n3 <= 0) {
                    return -1;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n2 > n3) {
                n2 = n3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int readLine(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = this.buf;
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                int n4 = this.count - this.pos;
                RuntimeCostAccounter.recordJump();
                if (n4 <= 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.fill:()V");
                    this.fill();
                    n4 = this.count - this.pos;
                    RuntimeCostAccounter.recordJump();
                    if (n4 <= 0) {
                        return -1;
                    }
                }
                int n5 = n2 - n3;
                RuntimeCostAccounter.recordJump();
                if (n5 > n4) {
                    n5 = n4;
                }
                int n6 = this.pos;
                int n7 = n6 + n5;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n6 >= n7) break;
                    byte by = byArray2[n6++];
                    RuntimeCostAccounter.recordJump();
                    if (by == 10) break;
                    RuntimeCostAccounter.recordJump();
                }
                n5 = n6 - this.pos;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(byArray2, this.pos, byArray, n, n5);
                n += n5;
                n3 += n5;
                this.pos = n6;
                byte by = byArray2[n6 - 1];
                RuntimeCostAccounter.recordJump();
                if (by == 10) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
            }
            return n3;
        }

        public byte peek() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos == this.count) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.fill:()V");
                this.fill();
            }
            RuntimeCostAccounter.recordJump();
            if (this.pos == this.count) {
                return -1;
            }
            return this.buf[this.pos];
        }

        public int readLine(byte[] byArray) throws IOException {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest$FastInputStream.readLine:([BII)I");
            return this.readLine(byArray, 0, n);
        }

        @Override
        public long skip(long l) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.count - this.pos;
            RuntimeCostAccounter.recordJump();
            if (l2 <= 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.skip:(J)J");
                return this.in.skip(l);
            }
            RuntimeCostAccounter.recordJump();
            if (l > l2) {
                l = l2;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }

        @Override
        public int available() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
            return this.count - this.pos + this.in.available();
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.in != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.buf.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            int n2 = this.in.read(this.buf, 0, n);
            RuntimeCostAccounter.recordJump();
            if (n2 > 0) {
                this.count = n2;
            }
        }
    }
}

