/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.jar;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.ByteArrayOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.net.URL;
import sandbox.java.security.CodeSigner;
import sandbox.java.security.CodeSource;
import sandbox.java.security.NoSuchAlgorithmException;
import sandbox.java.security.SignatureException;
import sandbox.java.security.cert.CertPath;
import sandbox.java.security.cert.Certificate;
import sandbox.java.security.cert.CertificateException;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Enumeration;
import sandbox.java.util.HashMap;
import sandbox.java.util.HashSet;
import sandbox.java.util.Hashtable;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Set;
import sandbox.java.util.jar.JarEntry;
import sandbox.java.util.jar.JarFile;
import sandbox.java.util.jar.Manifest;
import sandbox.java.util.zip.ZipEntry;
import sandbox.sun.security.util.Debug;
import sandbox.sun.security.util.ManifestDigester;
import sandbox.sun.security.util.ManifestEntryVerifier;
import sandbox.sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug;
    private Hashtable<String, CodeSigner[]> verifiedSigners;
    private Hashtable<String, CodeSigner[]> sigFileSigners;
    private Hashtable<String, byte[]> sigFileData;
    private ArrayList<SignatureFileVerifier> pendingBlocks;
    private ArrayList<CodeSigner[]> signerCache;
    private boolean parsingBlockOrSF;
    private boolean parsingMeta;
    private boolean anyToVerify;
    private ByteArrayOutputStream baos;
    private volatile ManifestDigester manDig;
    byte[] manifestRawBytes;
    boolean eagerValidation;
    private Object csdomain;
    private List<Object> manifestDigests;
    private Map<URL, Map<CodeSigner[], CodeSource>> urlToCodeSourceMap;
    private Map<CodeSigner[], CodeSource> signerToCodeSource;
    private URL lastURL;
    private Map<CodeSigner[], CodeSource> lastURLMap;
    private CodeSigner[] emptySigner;
    private Map<String, CodeSigner[]> signerMap;
    private Enumeration<String> emptyEnumeration;
    private List<CodeSigner[]> jarCodeSigners;

    public JarVerifier(byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.parsingBlockOrSF = false;
        this.parsingMeta = true;
        this.anyToVerify = true;
        this.manifestRawBytes = null;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.csdomain = new Object();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.urlToCodeSourceMap = new HashMap<URL, Map<CodeSigner[], CodeSource>>();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.signerToCodeSource = new HashMap<CodeSigner[], CodeSource>();
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        this.emptySigner = new CodeSigner[0];
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$3");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$3.<init>:(Ljava/util/jar/JarVerifier;)V");
        this.emptyEnumeration = new Enumeration<String>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
        this.manifestRawBytes = byArray;
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:()V");
        this.sigFileSigners = new Hashtable();
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:()V");
        this.verifiedSigners = new Hashtable();
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:(I)V");
        this.sigFileData = new Hashtable(11);
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.pendingBlocks = new ArrayList();
        RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.<init>:()V");
        this.baos = new ByteArrayOutputStream();
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.manifestDigests = new ArrayList<Object>();
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        block19: {
            String string;
            block18: {
                block14: {
                    String string2;
                    block17: {
                        block16: {
                            block15: {
                                RuntimeCostAccounter.recordJump();
                                if (jarEntry == null) {
                                    return;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (debug != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                    StringBuilder stringBuilder = new StringBuilder();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder2 = stringBuilder.append("beginEntry ");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
                                    String string3 = jarEntry.getName();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder3 = stringBuilder2.append(string3);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                    String string4 = stringBuilder3.toString();
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                                    debug.println(string4);
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
                                string = jarEntry.getName();
                                RuntimeCostAccounter.recordJump();
                                if (!this.parsingMeta) break block14;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
                                string2 = string.toUpperCase(Locale.ENGLISH);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                                boolean bl = string2.startsWith("META-INF/");
                                RuntimeCostAccounter.recordJump();
                                if (bl) break block15;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                                boolean bl2 = string2.startsWith("/META-INF/");
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) break block14;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.isDirectory:()Z");
                            boolean bl = jarEntry.isDirectory();
                            RuntimeCostAccounter.recordJump();
                            if (bl) {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.setEntry:(Ljava/lang/String;Ljava/util/jar/JarEntry;)V");
                                manifestEntryVerifier.setEntry(null, jarEntry);
                                return;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                            boolean bl3 = string2.equals("META-INF/MANIFEST.MF");
                            RuntimeCostAccounter.recordJump();
                            if (bl3) break block16;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                            boolean bl4 = string2.equals("META-INF/INDEX.LIST");
                            RuntimeCostAccounter.recordJump();
                            if (!bl4) break block17;
                        }
                        return;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.isBlockOrSF:(Ljava/lang/String;)Z");
                    boolean bl = SignatureFileVerifier.isBlockOrSF((String)string2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        this.parsingBlockOrSF = true;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.reset:()V");
                        this.baos.reset();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.setEntry:(Ljava/lang/String;Ljava/util/jar/JarEntry;)V");
                        manifestEntryVerifier.setEntry(null, jarEntry);
                        return;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (this.parsingMeta) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.doneWithMeta:()V");
                    this.doneWithMeta();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.isDirectory:()Z");
                boolean bl = jarEntry.isDirectory();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.setEntry:(Ljava/lang/String;Ljava/util/jar/JarEntry;)V");
                    manifestEntryVerifier.setEntry(null, jarEntry);
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl5 = string.startsWith("./");
                RuntimeCostAccounter.recordJump();
                if (bl5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                    string = string.substring(2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl6 = string.startsWith("/");
                RuntimeCostAccounter.recordJump();
                if (bl6) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                    string = string.substring(1);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                CodeSigner[] codeSignerArray = this.sigFileSigners.get(string);
                RuntimeCostAccounter.recordJump();
                if (codeSignerArray != null) break block18;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                CodeSigner[] codeSignerArray2 = this.verifiedSigners.get(string);
                RuntimeCostAccounter.recordJump();
                if (codeSignerArray2 == null) break block19;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.setEntry:(Ljava/lang/String;Ljava/util/jar/JarEntry;)V");
            manifestEntryVerifier.setEntry(string, jarEntry);
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.setEntry:(Ljava/lang/String;Ljava/util/jar/JarEntry;)V");
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            RuntimeCostAccounter.recordJump();
            if (this.parsingBlockOrSF) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.write:(I)V");
                this.baos.write(n);
                RuntimeCostAccounter.recordJump();
            } else {
                byte by = (byte)n;
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.update:(B)V");
                manifestEntryVerifier.update(by);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.processEntry:(Lsun/security/util/ManifestEntryVerifier;)V");
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n, byte[] byArray, int n2, int n3, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            RuntimeCostAccounter.recordJump();
            if (this.parsingBlockOrSF) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.write:([BII)V");
                this.baos.write(byArray, n2, n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.update:([BII)V");
                manifestEntryVerifier.update(byArray, n2, n);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.processEntry:(Lsun/security/util/ManifestEntryVerifier;)V");
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntry(ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        block23: {
            block24: {
                RuntimeCostAccounter.recordJump();
                if (this.parsingBlockOrSF) break block24;
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.getEntry:()Ljava/util/jar/JarEntry;");
                JarEntry jarEntry = manifestEntryVerifier.getEntry();
                RuntimeCostAccounter.recordJump();
                if (jarEntry != null) {
                    CodeSigner[] codeSignerArray = jarEntry.signers;
                    RuntimeCostAccounter.recordJump();
                    if (codeSignerArray == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.verify:(Ljava/util/Hashtable;Ljava/util/Hashtable;)[Ljava/security/CodeSigner;");
                        CodeSigner[] codeSignerArray2 = jarEntry.signers = manifestEntryVerifier.verify(this.verifiedSigners, this.sigFileSigners);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCertArray:([Ljava/security/CodeSigner;)[Ljava/security/cert/Certificate;");
                        jarEntry.certs = JarVerifier.mapSignersToCertArray(codeSignerArray2);
                    }
                }
                RuntimeCostAccounter.recordJump();
                break block23;
            }
            try {
                Object object;
                this.parsingBlockOrSF = false;
                RuntimeCostAccounter.recordJump();
                if (debug != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    debug.println("processEntry: processing block");
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.getEntry:()Ljava/util/jar/JarEntry;");
                JarEntry jarEntry = manifestEntryVerifier.getEntry();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
                String string = jarEntry.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
                String string2 = string.toUpperCase(Locale.ENGLISH);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                boolean bl = string2.endsWith(".SF");
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n = string2.length() - 3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                    String string3 = string2.substring(0, n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.toByteArray:()[B");
                    byte[] byArray = this.baos.toByteArray();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    this.sigFileData.put(string3, byArray);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.iterator:()Ljava/util/Iterator;");
                    Iterator<SignatureFileVerifier> iterator = this.pendingBlocks.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl2 = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        SignatureFileVerifier signatureFileVerifier = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.needSignatureFile:(Ljava/lang/String;)Z");
                        boolean bl3 = signatureFileVerifier.needSignatureFile(string3);
                        RuntimeCostAccounter.recordJump();
                        if (bl3) {
                            RuntimeCostAccounter.recordJump();
                            if (debug != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                                debug.println("processEntry: processing pending block");
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.setSignatureFile:([B)V");
                            signatureFileVerifier.setSignatureFile(byArray);
                            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.process:(Ljava/util/Hashtable;Ljava/util/List;)V");
                            signatureFileVerifier.process(this.sigFileSigners, this.manifestDigests);
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(Ljava/lang/String;)I");
                int n = string2.lastIndexOf(".");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                String string4 = string2.substring(0, n);
                RuntimeCostAccounter.recordJump();
                if (this.signerCache == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                    this.signerCache = new ArrayList();
                }
                RuntimeCostAccounter.recordJump();
                if (this.manDig == null) {
                    block22: {
                        object = this.manifestRawBytes;
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (this.manDig != null) break block22;
                            RuntimeCostAccounter.recordAllocation((String)"sun/security/util/ManifestDigester");
                            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestDigester.<init>:([B)V");
                            this.manDig = new ManifestDigester(this.manifestRawBytes);
                            this.manifestRawBytes = null;
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordAllocation((String)"sun/security/util/SignatureFileVerifier");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.toByteArray:()[B");
                byte[] byArray = this.baos.toByteArray();
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.<init>:(Ljava/util/ArrayList;Lsun/security/util/ManifestDigester;Ljava/lang/String;[B)V");
                object = new SignatureFileVerifier(this.signerCache, this.manDig, string2, byArray);
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.needSignatureFileBytes:()Z");
                boolean bl4 = object.needSignatureFileBytes();
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    byte[] byArray2 = this.sigFileData.get(string4);
                    RuntimeCostAccounter.recordJump();
                    if (byArray2 == null) {
                        RuntimeCostAccounter.recordJump();
                        if (debug != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                            debug.println("adding pending block");
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                        this.pendingBlocks.add((SignatureFileVerifier)object);
                        return;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.setSignatureFile:([B)V");
                    object.setSignatureFile(byArray2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.process:(Ljava/util/Hashtable;Ljava/util/List;)V");
                object.process(this.sigFileSigners, this.manifestDigests);
            }
            catch (IOException iOException) {
                RuntimeCostAccounter.recordJump();
                if (debug != null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("processEntry caught: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(iOException);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    debug.println(string);
                }
                RuntimeCostAccounter.recordJump();
            }
            catch (SignatureException signatureException) {
                RuntimeCostAccounter.recordJump();
                if (debug != null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder.append("processEntry caught: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append((Object)signatureException);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder5.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    debug.println(string);
                }
                RuntimeCostAccounter.recordJump();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                RuntimeCostAccounter.recordJump();
                if (debug != null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder.append("processEntry caught: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append((Object)noSuchAlgorithmException);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder7.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    debug.println(string);
                }
                RuntimeCostAccounter.recordJump();
            }
            catch (CertificateException certificateException) {
                RuntimeCostAccounter.recordJump();
                if (debug == null) break block23;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder.append("processEntry caught: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append((Object)certificateException);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder9.toString();
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                debug.println(string);
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Deprecated
    public Certificate[] getCerts(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSigners:(Ljava/lang/String;)[Ljava/security/CodeSigner;");
        CodeSigner[] codeSignerArray = this.getCodeSigners(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCertArray:([Ljava/security/CodeSigner;)[Ljava/security/cert/Certificate;");
        return JarVerifier.mapSignersToCertArray(codeSignerArray);
    }

    public Certificate[] getCerts(JarFile jarFile, JarEntry jarEntry) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSigners:(Ljava/util/jar/JarFile;Ljava/util/jar/JarEntry;)[Ljava/security/CodeSigner;");
        CodeSigner[] codeSignerArray = this.getCodeSigners(jarFile, jarEntry);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCertArray:([Ljava/security/CodeSigner;)[Ljava/security/cert/Certificate;");
        return JarVerifier.mapSignersToCertArray(codeSignerArray);
    }

    public CodeSigner[] getCodeSigners(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.verifiedSigners.get(string);
    }

    public CodeSigner[] getCodeSigners(JarFile jarFile, JarEntry jarEntry) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
        String string = jarEntry.getName();
        RuntimeCostAccounter.recordJump();
        if (this.eagerValidation) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            CodeSigner[] codeSignerArray = this.sigFileSigners.get(string);
            RuntimeCostAccounter.recordJump();
            if (codeSignerArray != null) {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    RuntimeCostAccounter.recordArrayAllocation((int)1024, (int)1);
                    byte[] byArray = new byte[1024];
                    int n = byArray.length;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n == -1) break;
                        int n2 = byArray.length;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                        n = inputStream.read(byArray, 0, n2);
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSigners:(Ljava/lang/String;)[Ljava/security/CodeSigner;");
        return this.getCodeSigners(string);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] codeSignerArray) {
        RuntimeCostAccounter.recordJump();
        if (codeSignerArray != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (true) {
                int n2 = codeSignerArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                CodeSigner codeSigner = codeSignerArray[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSigner.getSignerCertPath:()Ljava/security/cert/CertPath;");
                CertPath certPath = codeSigner.getSignerCertPath();
                RuntimeCostAccounter.recordMethodCall((String)"java/security/cert/CertPath.getCertificates:()Ljava/util/List;");
                List list = certPath.getCertificates();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.addAll:(Ljava/util/Collection;)Z");
                arrayList.addAll(list);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            int n3 = arrayList.size();
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            Certificate[] certificateArray = new Certificate[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return arrayList.toArray(certificateArray);
        }
        return null;
    }

    boolean nothingToVerify() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (!this.anyToVerify) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    void doneWithMeta() {
        boolean bl;
        this.parsingMeta = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.isEmpty:()Z");
        boolean bl2 = this.sigFileSigners.isEmpty();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        this.anyToVerify = bl;
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.containsKey:(Ljava/lang/Object;)Z");
        boolean bl3 = this.sigFileSigners.containsKey("META-INF/MANIFEST.MF");
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            CodeSigner[] codeSignerArray = this.sigFileSigners.remove("META-INF/MANIFEST.MF");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.verifiedSigners.put("META-INF/MANIFEST.MF", codeSignerArray);
        }
    }

    private synchronized CodeSource mapSignersToCodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        Map<CodeSigner[], CodeSource> map;
        RuntimeCostAccounter.recordJump();
        if (uRL == this.lastURL) {
            map = this.lastURLMap;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            map = this.urlToCodeSourceMap.get(uRL);
            RuntimeCostAccounter.recordJump();
            if (map == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                map = new HashMap<CodeSigner[], CodeSource>();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.urlToCodeSourceMap.put(uRL, map);
            }
            this.lastURLMap = map;
            this.lastURL = uRL;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        CodeSource codeSource = map.get(codeSignerArray);
        RuntimeCostAccounter.recordJump();
        if (codeSource == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$VerifierCodeSource");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.<init>:(Ljava/lang/Object;Ljava/net/URL;[Ljava/security/CodeSigner;)V");
            codeSource = new VerifierCodeSource(this.csdomain, uRL, codeSignerArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.signerToCodeSource.put(codeSignerArray, codeSource);
        }
        return codeSource;
    }

    private CodeSource[] mapSignersToCodeSources(URL uRL, List<CodeSigner[]> list, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n2 = list.size();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSource:(Ljava/net/URL;[Ljava/security/CodeSigner;)Ljava/security/CodeSource;");
            CodeSource codeSource = this.mapSignersToCodeSource(uRL, list.get(n));
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList.add(codeSource);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSource:(Ljava/net/URL;[Ljava/security/CodeSigner;)Ljava/security/CodeSource;");
            CodeSource codeSource = this.mapSignersToCodeSource(uRL, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList.add(codeSource);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n3 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        CodeSource[] codeSourceArray = new CodeSource[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return arrayList.toArray(codeSourceArray);
    }

    private CodeSigner[] findMatchingSigners(CodeSource codeSource) {
        CodeSource[] codeSourceArray;
        boolean bl = codeSource instanceof VerifierCodeSource;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            codeSourceArray = (CodeSource[])codeSource;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.isSameDomain:(Ljava/lang/Object;)Z");
            boolean bl2 = codeSourceArray.isSameDomain(this.csdomain);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                VerifierCodeSource verifierCodeSource = (VerifierCodeSource)codeSource;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.access$000:(Ljava/util/jar/JarVerifier$VerifierCodeSource;)[Ljava/security/CodeSigner;");
                return VerifierCodeSource.access$000(verifierCodeSource);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSource.getLocation:()Ljava/net/URL;");
        URL uRL = codeSource.getLocation();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getJarCodeSigners:()Ljava/util/List;");
        List<CodeSigner[]> list = this.getJarCodeSigners();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSources:(Ljava/net/URL;Ljava/util/List;Z)[Ljava/security/CodeSource;");
        codeSourceArray = this.mapSignersToCodeSources(uRL, list, true);
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        int n = 0;
        while (true) {
            int n2 = codeSourceArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            CodeSource codeSource2 = codeSourceArray[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList.add(codeSource2);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.indexOf:(Ljava/lang/Object;)I");
        n = arrayList.indexOf(codeSource);
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            VerifierCodeSource verifierCodeSource = (VerifierCodeSource)((Object)arrayList.get(n));
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.access$000:(Ljava/util/jar/JarVerifier$VerifierCodeSource;)[Ljava/security/CodeSigner;");
            CodeSigner[] codeSignerArray = VerifierCodeSource.access$000(verifierCodeSource);
            RuntimeCostAccounter.recordJump();
            if (codeSignerArray == null) {
                codeSignerArray = this.emptySigner;
            }
            return codeSignerArray;
        }
        return null;
    }

    private synchronized Map<String, CodeSigner[]> signerMap() {
        RuntimeCostAccounter.recordJump();
        if (this.signerMap == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.size:()I");
            int n = this.verifiedSigners.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.size:()I");
            int n2 = n + this.sigFileSigners.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(I)V");
            this.signerMap = new HashMap<String, CodeSigner[]>(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
            this.signerMap.putAll(this.verifiedSigners);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
            this.signerMap.putAll(this.sigFileSigners);
        }
        return this.signerMap;
    }

    public synchronized Enumeration<String> entryNames(JarFile jarFile, CodeSource[] codeSourceArray) {
        Enumeration<String> enumeration;
        Object object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.signerMap:()Ljava/util/Map;");
        Map<String, CodeSigner[]> map = this.signerMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<String, CodeSigner[]>> set = map.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        final Iterator<Map.Entry<String, CodeSigner[]>> iterator = set.iterator();
        boolean bl = false;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        int n = codeSourceArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
        ArrayList<CodeSigner[]> arrayList = new ArrayList<CodeSigner[]>(n);
        int n2 = 0;
        while (true) {
            int n3 = codeSourceArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            CodeSource codeSource = codeSourceArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.findMatchingSigners:(Ljava/security/CodeSource;)[Ljava/security/CodeSigner;");
            object = this.findMatchingSigners(codeSource);
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                int n4 = ((CodeSigner[])object).length;
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add((CodeSigner[])object);
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                bl = true;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        final ArrayList<CodeSigner[]> arrayList2 = arrayList;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.unsignedEntryNames:(Ljava/util/jar/JarFile;)Ljava/util/Enumeration;");
            enumeration = this.unsignedEntryNames(jarFile);
            RuntimeCostAccounter.recordJump();
        } else {
            enumeration = this.emptyEnumeration;
        }
        object = enumeration;
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$1.<init>:(Ljava/util/jar/JarVerifier;Ljava/util/Iterator;Ljava/util/List;Ljava/util/Enumeration;)V");
        return new Enumeration<String>((Enumeration)object){
            String name;
            final /* synthetic */ Enumeration val$enum2;
            {
                this.val$enum2 = enumeration;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                RuntimeCostAccounter.recordJump();
                if (this.name != null) {
                    return true;
                }
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry entry = (Map.Entry)iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Object v = entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.contains:(Ljava/lang/Object;)Z");
                    boolean bl2 = arrayList2.contains(v);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        this.name = (String)entry.getKey();
                        return true;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl = this.val$enum2.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                    this.name = (String)this.val$enum2.nextElement();
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$1.hasMoreElements:()Z");
                boolean bl = this.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    public Enumeration<JarEntry> entries2(final JarFile jarFile, Enumeration<? extends ZipEntry> enumeration) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        final HashMap<String, CodeSigner[]> hashMap = new HashMap<String, CodeSigner[]>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.signerMap:()Ljava/util/Map;");
        Map<String, CodeSigner[]> map = this.signerMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
        hashMap.putAll(map);
        final Enumeration<? extends ZipEntry> enumeration2 = enumeration;
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$2.<init>:(Ljava/util/jar/JarVerifier;Ljava/util/Enumeration;Ljava/util/jar/JarFile;Ljava/util/Map;)V");
        return new Enumeration<JarEntry>(){
            Enumeration<String> signers;
            JarEntry entry;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.signers = null;
            }

            @Override
            public boolean hasMoreElements() {
                Object object;
                block4: {
                    RuntimeCostAccounter.recordJump();
                    if (this.entry != null) {
                        return true;
                    }
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                        boolean bl = enumeration2.hasMoreElements();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                        object = (ZipEntry)enumeration2.nextElement();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
                        String string = ((ZipEntry)object).getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.isSigningRelated:(Ljava/lang/String;)Z");
                        boolean bl2 = JarVerifier.isSigningRelated(string);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.newEntry:(Ljava/util/zip/ZipEntry;)Ljava/util/jar/JarEntry;");
                    this.entry = jarFile.newEntry((ZipEntry)object);
                    return true;
                }
                RuntimeCostAccounter.recordJump();
                if (this.signers == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
                    Set set = hashMap.keySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.enumeration:(Ljava/util/Collection;)Ljava/util/Enumeration;");
                    this.signers = Collections.enumeration(set);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl = this.signers.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                    object = this.signers.nextElement();
                    RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.<init>:(Ljava/lang/String;)V");
                    ZipEntry zipEntry = new ZipEntry((String)object);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.newEntry:(Ljava/util/zip/ZipEntry;)Ljava/util/jar/JarEntry;");
                    this.entry = jarFile.newEntry(zipEntry);
                    return true;
                }
                return false;
            }

            @Override
            public JarEntry nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$2.hasMoreElements:()Z");
                boolean bl = this.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    JarEntry jarEntry = this.entry;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
                    String string = jarEntry.getName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                    hashMap.remove(string);
                    this.entry = null;
                    return jarEntry;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    static boolean isSigningRelated(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.isSigningRelated:(Ljava/lang/String;)Z");
        return SignatureFileVerifier.isSigningRelated((String)string);
    }

    private Enumeration<String> unsignedEntryNames(JarFile jarFile) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.signerMap:()Ljava/util/Map;");
        final Map<String, CodeSigner[]> map = this.signerMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.entries:()Ljava/util/Enumeration;");
        final Enumeration<JarEntry> enumeration = jarFile.entries();
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$4");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$4.<init>:(Ljava/util/jar/JarVerifier;Ljava/util/Enumeration;Ljava/util/Map;)V");
        return new Enumeration<String>(){
            String name;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                RuntimeCostAccounter.recordJump();
                if (this.name != null) {
                    return true;
                }
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                    boolean bl = enumeration.hasMoreElements();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
                    String string = zipEntry.getName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.isDirectory:()Z");
                    boolean bl2 = zipEntry.isDirectory();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) continue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.isSigningRelated:(Ljava/lang/String;)Z");
                    boolean bl3 = JarVerifier.isSigningRelated(string);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object v = map.get(string);
                    RuntimeCostAccounter.recordJump();
                    if (v == null) {
                        this.name = string;
                        return true;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                return false;
            }

            @Override
            public String nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$4.hasMoreElements:()Z");
                boolean bl = this.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    private synchronized List<CodeSigner[]> getJarCodeSigners() {
        RuntimeCostAccounter.recordJump();
        if (this.jarCodeSigners == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:()V");
            HashSet<CodeSigner[]> hashSet = new HashSet<CodeSigner[]>();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.signerMap:()Ljava/util/Map;");
            Map<String, CodeSigner[]> map = this.signerMap();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
            Collection<CodeSigner[]> collection = map.values();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.addAll:(Ljava/util/Collection;)Z");
            hashSet.addAll(collection);
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            this.jarCodeSigners = new ArrayList<CodeSigner[]>();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(Ljava/util/Collection;)Z");
            this.jarCodeSigners.addAll(hashSet);
        }
        return this.jarCodeSigners;
    }

    public synchronized CodeSource[] getCodeSources(JarFile jarFile, URL uRL) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.unsignedEntryNames:(Ljava/util/jar/JarFile;)Ljava/util/Enumeration;");
        Enumeration<String> enumeration = this.unsignedEntryNames(jarFile);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
        boolean bl = enumeration.hasMoreElements();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getJarCodeSigners:()Ljava/util/List;");
        List<CodeSigner[]> list = this.getJarCodeSigners();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSources:(Ljava/net/URL;Ljava/util/List;Z)[Ljava/security/CodeSource;");
        return this.mapSignersToCodeSources(uRL, list, bl);
    }

    public CodeSource getCodeSource(URL uRL, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.signerMap:()Ljava/util/Map;");
        Map<String, CodeSigner[]> map = this.signerMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        CodeSigner[] codeSignerArray = map.get(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSource:(Ljava/net/URL;[Ljava/security/CodeSigner;)Ljava/security/CodeSource;");
        return this.mapSignersToCodeSource(uRL, codeSignerArray);
    }

    public CodeSource getCodeSource(URL uRL, JarFile jarFile, JarEntry jarEntry) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSigners:(Ljava/util/jar/JarFile;Ljava/util/jar/JarEntry;)[Ljava/security/CodeSigner;");
        CodeSigner[] codeSignerArray = this.getCodeSigners(jarFile, jarEntry);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.mapSignersToCodeSource:(Ljava/net/URL;[Ljava/security/CodeSigner;)Ljava/security/CodeSource;");
        return this.mapSignersToCodeSource(uRL, codeSignerArray);
    }

    public void setEagerValidation(boolean bl) {
        this.eagerValidation = bl;
    }

    public synchronized List<Object> getManifestDigests() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
        return Collections.unmodifiableList(this.manifestDigests);
    }

    static CodeSource getUnsignedCS(URL uRL) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$VerifierCodeSource");
        Certificate[] certificateArray = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.<init>:(Ljava/lang/Object;Ljava/net/URL;[Ljava/security/cert/Certificate;)V");
        return new VerifierCodeSource(null, uRL, certificateArray);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.getInstance:(Ljava/lang/String;)Lsun/security/util/Debug;");
        debug = Debug.getInstance((String)"jar");
    }

    private static class VerifierCodeSource
    extends CodeSource {
        private static final long serialVersionUID = -9047366145967768825L;
        URL vlocation;
        CodeSigner[] vsigners;
        Certificate[] vcerts;
        Object csdomain;

        VerifierCodeSource(Object object, URL uRL, CodeSigner[] codeSignerArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSource.<init>:(Ljava/net/URL;[Ljava/security/CodeSigner;)V");
            super(uRL, codeSignerArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vsigners = codeSignerArray;
        }

        VerifierCodeSource(Object object, URL uRL, Certificate[] certificateArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSource.<init>:(Ljava/net/URL;[Ljava/security/cert/Certificate;)V");
            super(uRL, certificateArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vcerts = certificateArray;
        }

        public boolean equals(Object object) {
            block6: {
                VerifierCodeSource verifierCodeSource;
                block8: {
                    block7: {
                        RuntimeCostAccounter.recordJump();
                        if (object == this) {
                            return true;
                        }
                        boolean bl = object instanceof VerifierCodeSource;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block6;
                        verifierCodeSource = (VerifierCodeSource)((Object)object);
                        Object object2 = verifierCodeSource.csdomain;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.isSameDomain:(Ljava/lang/Object;)Z");
                        boolean bl2 = this.isSameDomain(object2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block6;
                        CodeSigner[] codeSignerArray = verifierCodeSource.vsigners;
                        RuntimeCostAccounter.recordJump();
                        if (codeSignerArray != this.vsigners) break block7;
                        Certificate[] certificateArray = verifierCodeSource.vcerts;
                        RuntimeCostAccounter.recordJump();
                        if (certificateArray == this.vcerts) break block8;
                    }
                    return false;
                }
                URL uRL = verifierCodeSource.vlocation;
                RuntimeCostAccounter.recordJump();
                if (uRL != null) {
                    URL uRL2 = verifierCodeSource.vlocation;
                    RuntimeCostAccounter.recordMethodCall((String)"java/net/URL.equals:(Ljava/lang/Object;)Z");
                    return uRL2.equals((Object)this.vlocation);
                }
                RuntimeCostAccounter.recordJump();
                if (this.vlocation != null) {
                    URL uRL3 = verifierCodeSource.vlocation;
                    RuntimeCostAccounter.recordMethodCall((String)"java/net/URL.equals:(Ljava/lang/Object;)Z");
                    return this.vlocation.equals((Object)uRL3);
                }
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSource.equals:(Ljava/lang/Object;)Z");
            return super.equals(object);
        }

        boolean isSameDomain(Object object) {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.csdomain == object) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        private CodeSigner[] getPrivateSigners() {
            return this.vsigners;
        }

        private Certificate[] getPrivateCertificates() {
            return this.vcerts;
        }

        static /* synthetic */ CodeSigner[] access$000(VerifierCodeSource verifierCodeSource) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierCodeSource.getPrivateSigners:()[Ljava/security/CodeSigner;");
            return verifierCodeSource.getPrivateSigners();
        }
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
            this.is = inputStream;
            this.jv = jarVerifier;
            RuntimeCostAccounter.recordAllocation((String)"sun/security/util/ManifestEntryVerifier");
            RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.<init>:(Ljava/util/jar/Manifest;)V");
            this.mev = new ManifestEntryVerifier(manifest);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.beginEntry:(Ljava/util/jar/JarEntry;Lsun/security/util/ManifestEntryVerifier;)V");
            this.jv.beginEntry(jarEntry, this.mev);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getSize:()J");
            this.numLeft = jarEntry.getSize();
            RuntimeCostAccounter.recordJump();
            if (this.numLeft == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(ILsun/security/util/ManifestEntryVerifier;)V");
                this.jv.update(-1, this.mev);
            }
        }

        @Override
        public int read() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.numLeft > 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
                int n = this.is.read();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(ILsun/security/util/ManifestEntryVerifier;)V");
                this.jv.update(n, this.mev);
                --this.numLeft;
                RuntimeCostAccounter.recordJump();
                if (this.numLeft == 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(ILsun/security/util/ManifestEntryVerifier;)V");
                    this.jv.update(-1, this.mev);
                }
                return n;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.numLeft > 0L) {
                long l = this.numLeft - (long)n2;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 < 0) {
                    n2 = (int)this.numLeft;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (this.numLeft > 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                int n3 = this.is.read(byArray, n, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(I[BIILsun/security/util/ManifestEntryVerifier;)V");
                this.jv.update(n3, byArray, n, n2, this.mev);
                this.numLeft -= (long)n3;
                RuntimeCostAccounter.recordJump();
                if (this.numLeft == 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(I[BIILsun/security/util/ManifestEntryVerifier;)V");
                    this.jv.update(-1, byArray, n, n2, this.mev);
                }
                return n3;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.is != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        @Override
        public int available() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
            return this.is.available();
        }
    }
}

