/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.locks;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.Lock;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.java.util.concurrent.locks.ReadWriteLock;
import sandbox.sun.misc.Unsafe;

public class StampedLock
implements Serializable {
    private static final long serialVersionUID = -6001602636862214147L;
    private static final int NCPU;
    private static final int SPINS;
    private static final int HEAD_SPINS;
    private static final int MAX_HEAD_SPINS;
    private static final int OVERFLOW_YIELD_RATE = 7;
    private static final int LG_READERS = 7;
    private static final long RUNIT = 1L;
    private static final long WBIT = 128L;
    private static final long RBITS = 127L;
    private static final long RFULL = 126L;
    private static final long ABITS = 255L;
    private static final long SBITS = -128L;
    private static final long ORIGIN = 256L;
    private static final long INTERRUPTED = 1L;
    private static final int WAITING = -1;
    private static final int CANCELLED = 1;
    private static final int RMODE = 0;
    private static final int WMODE = 1;
    private volatile transient WNode whead;
    private volatile transient WNode wtail;
    transient ReadLockView readLockView;
    transient WriteLockView writeLockView;
    transient ReadWriteLockView readWriteLockView;
    private volatile transient long state;
    private transient int readerOverflow;
    private static final Unsafe U;
    private static final long STATE;
    private static final long WHEAD;
    private static final long WTAIL;
    private static final long WNEXT;
    private static final long WSTATUS;
    private static final long WCOWAIT;
    private static final long PARKBLOCKER;

    public StampedLock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.state = 256L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long writeLock() {
        long l;
        long l2 = this.state;
        RuntimeCostAccounter.recordJump();
        if ((l2 & 0xFFL) == 0L) {
            long l3 = l2 + 128L;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl = U.compareAndSwapLong((Object)this, STATE, l2, l3);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                l = l3;
                RuntimeCostAccounter.recordJump();
                return l;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireWrite:(ZJ)J");
        l = this.acquireWrite(false, 0L);
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long tryWriteLock() {
        long l = this.state;
        RuntimeCostAccounter.recordJump();
        if ((l & 0xFFL) != 0L) return 0L;
        long l2 = l + 128L;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
        boolean bl = U.compareAndSwapLong((Object)this, STATE, l, l2);
        RuntimeCostAccounter.recordJump();
        if (!bl) return 0L;
        long l3 = l2;
        RuntimeCostAccounter.recordJump();
        return l3;
    }

    public long tryWriteLock(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryWriteLock:()J");
            long l3 = this.tryWriteLock();
            RuntimeCostAccounter.recordJump();
            if (l3 != 0L) {
                return l3;
            }
            RuntimeCostAccounter.recordJump();
            if (l2 <= 0L) {
                return 0L;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            long l4 = System.nanoTime() + l2;
            RuntimeCostAccounter.recordJump();
            if (l4 == 0L) {
                l4 = 1L;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireWrite:(ZJ)J");
            l3 = this.acquireWrite(true, l4);
            RuntimeCostAccounter.recordJump();
            if (l3 != 1L) {
                return l3;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    public long writeLockInterruptibly() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireWrite:(ZJ)J");
            long l = this.acquireWrite(true, 0L);
            RuntimeCostAccounter.recordJump();
            if (l != 1L) {
                return l;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long readLock() {
        long l;
        long l2 = this.state;
        RuntimeCostAccounter.recordJump();
        if (this.whead == this.wtail) {
            RuntimeCostAccounter.recordJump();
            if ((l2 & 0xFFL) < 126L) {
                long l3 = l2 + 1L;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, STATE, l2, l3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    l = l3;
                    RuntimeCostAccounter.recordJump();
                    return l;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireRead:(ZJ)J");
        l = this.acquireRead(false, 0L);
        return l;
    }

    public long tryReadLock() {
        while (true) {
            long l;
            long l2 = this.state;
            long l3 = l2 & 0xFFL;
            RuntimeCostAccounter.recordJump();
            if (l3 == 128L) {
                return 0L;
            }
            RuntimeCostAccounter.recordJump();
            if (l3 < 126L) {
                l = l2 + 1L;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, STATE, l2, l);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return l;
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                l = this.tryIncReaderOverflow(l2);
                RuntimeCostAccounter.recordJump();
                if (l != 0L) {
                    return l;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public long tryReadLock(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            long l3;
            long l4 = this.state;
            long l5 = l4 & 0xFFL;
            RuntimeCostAccounter.recordJump();
            if (l5 != 128L) {
                RuntimeCostAccounter.recordJump();
                if (l5 < 126L) {
                    l3 = l4 + 1L;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl2 = U.compareAndSwapLong((Object)this, STATE, l4, l3);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        return l3;
                    }
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                    l3 = this.tryIncReaderOverflow(l4);
                    RuntimeCostAccounter.recordJump();
                    if (l3 != 0L) {
                        return l3;
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (l2 <= 0L) {
                return 0L;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            long l6 = System.nanoTime() + l2;
            RuntimeCostAccounter.recordJump();
            if (l6 == 0L) {
                l6 = 1L;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireRead:(ZJ)J");
            l3 = this.acquireRead(true, l6);
            RuntimeCostAccounter.recordJump();
            if (l3 != 1L) {
                return l3;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    public long readLockInterruptibly() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.acquireRead:(ZJ)J");
            long l = this.acquireRead(true, 0L);
            RuntimeCostAccounter.recordJump();
            if (l != 1L) {
                return l;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    public long tryOptimisticRead() {
        long l;
        long l2 = this.state;
        RuntimeCostAccounter.recordJump();
        if ((l2 & 0x80L) == 0L) {
            l = l2 & 0xFFFFFFFFFFFFFF80L;
            RuntimeCostAccounter.recordJump();
        } else {
            l = 0L;
        }
        return l;
    }

    public boolean validate(long l) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.loadFence:()V");
        U.loadFence();
        RuntimeCostAccounter.recordJump();
        if ((l & 0xFFFFFFFFFFFFFF80L) == (this.state & 0xFFFFFFFFFFFFFF80L)) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public void unlockWrite(long l) {
        long l2;
        block8: {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (this.state != l) break block7;
                RuntimeCostAccounter.recordJump();
                if ((l & 0x80L) != 0L) break block8;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
            IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalMonitorStateException;
        }
        RuntimeCostAccounter.recordJump();
        if ((l += 128L) == 0L) {
            l2 = 256L;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = l;
        }
        this.state = l2;
        WNode wNode = this.whead;
        RuntimeCostAccounter.recordJump();
        if (wNode != null) {
            int n = wNode.status;
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                this.release(wNode);
            }
        }
    }

    public void unlockRead(long l) {
        block11: {
            while (true) {
                long l2;
                long l3;
                block13: {
                    block12: {
                        l3 = this.state;
                        RuntimeCostAccounter.recordJump();
                        if ((l3 & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L)) break block12;
                        RuntimeCostAccounter.recordJump();
                        if ((l & 0xFFL) == 0L) break block12;
                        l2 = l3 & 0xFFL;
                        RuntimeCostAccounter.recordJump();
                        if (l2 == 0L) break block12;
                        RuntimeCostAccounter.recordJump();
                        if (l2 != 128L) break block13;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                    IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalMonitorStateException;
                }
                RuntimeCostAccounter.recordJump();
                if (l2 < 126L) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l3, l3 - 1L);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    RuntimeCostAccounter.recordJump();
                    if (l2 != 1L) break block11;
                    WNode wNode = this.whead;
                    RuntimeCostAccounter.recordJump();
                    if (wNode != null) {
                        int n = wNode.status;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                            this.release(wNode);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryDecReaderOverflow:(J)J");
                long l4 = this.tryDecReaderOverflow(l3) - 0L;
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l5 != false) break;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public void unlock(long l) {
        block13: {
            long l2 = l & 0xFFL;
            while (true) {
                long l3 = this.state;
                RuntimeCostAccounter.recordJump();
                if ((l3 & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L)) break block13;
                long l4 = l3 & 0xFFL;
                RuntimeCostAccounter.recordJump();
                if (l4 == 0L) {
                    RuntimeCostAccounter.recordJump();
                    break block13;
                }
                RuntimeCostAccounter.recordJump();
                if (l4 == 128L) {
                    long l5;
                    RuntimeCostAccounter.recordJump();
                    if (l2 != l4) {
                        RuntimeCostAccounter.recordJump();
                        break block13;
                    }
                    RuntimeCostAccounter.recordJump();
                    if ((l3 += 128L) == 0L) {
                        l5 = 256L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l5 = l3;
                    }
                    this.state = l5;
                    WNode wNode = this.whead;
                    RuntimeCostAccounter.recordJump();
                    if (wNode != null) {
                        int n = wNode.status;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                            this.release(wNode);
                        }
                    }
                    return;
                }
                RuntimeCostAccounter.recordJump();
                if (l2 == 0L) break block13;
                RuntimeCostAccounter.recordJump();
                if (l2 >= 128L) {
                    RuntimeCostAccounter.recordJump();
                    break block13;
                }
                RuntimeCostAccounter.recordJump();
                if (l4 < 126L) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l3, l3 - 1L);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    RuntimeCostAccounter.recordJump();
                    if (l4 == 1L) {
                        WNode wNode = this.whead;
                        RuntimeCostAccounter.recordJump();
                        if (wNode != null) {
                            int n = wNode.status;
                            RuntimeCostAccounter.recordJump();
                            if (n != 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                                this.release(wNode);
                            }
                        }
                    }
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryDecReaderOverflow:(J)J");
                long l6 = this.tryDecReaderOverflow(l3) - 0L;
                long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l7 != false) break;
            }
            return;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
        IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
        RuntimeCostAccounter.recordThrow();
        throw illegalMonitorStateException;
    }

    public long tryConvertToWriteLock(long l) {
        block5: {
            long l2;
            long l3 = l & 0xFFL;
            while (true) {
                long l4 = this.state;
                RuntimeCostAccounter.recordJump();
                if ((l4 & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L)) break block5;
                long l5 = l4 & 0xFFL;
                RuntimeCostAccounter.recordJump();
                if (l5 == 0L) {
                    RuntimeCostAccounter.recordJump();
                    if (l3 != 0L) {
                        RuntimeCostAccounter.recordJump();
                        break block5;
                    }
                    l2 = l4 + 128L;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l4, l2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    return l2;
                }
                RuntimeCostAccounter.recordJump();
                if (l5 == 128L) {
                    RuntimeCostAccounter.recordJump();
                    if (l3 != l5) {
                        RuntimeCostAccounter.recordJump();
                        break block5;
                    }
                    return l;
                }
                RuntimeCostAccounter.recordJump();
                if (l5 != 1L) break block5;
                RuntimeCostAccounter.recordJump();
                if (l3 == 0L) break block5;
                l2 = l4 - 1L + 128L;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, STATE, l4, l2);
                RuntimeCostAccounter.recordJump();
                if (bl) break;
            }
            return l2;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long tryConvertToReadLock(long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        block5: {
            l5 = l & 0xFFL;
            while (true) {
                l4 = this.state;
                RuntimeCostAccounter.recordJump();
                if ((l4 & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L)) return 0L;
                l3 = l4 & 0xFFL;
                RuntimeCostAccounter.recordJump();
                if (l3 != 0L) break block5;
                RuntimeCostAccounter.recordJump();
                if (l5 != 0L) {
                    RuntimeCostAccounter.recordJump();
                    return 0L;
                }
                RuntimeCostAccounter.recordJump();
                if (l3 < 126L) {
                    l2 = l4 + 1L;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l4, l2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    return l2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                l2 = this.tryIncReaderOverflow(l4);
                RuntimeCostAccounter.recordJump();
                if (l2 != 0L) break;
            }
            return l2;
        }
        RuntimeCostAccounter.recordJump();
        if (l3 != 128L) {
            RuntimeCostAccounter.recordJump();
            if (l5 == 0L) return 0L;
            RuntimeCostAccounter.recordJump();
            if (l5 >= 128L) return 0L;
            return l;
        }
        RuntimeCostAccounter.recordJump();
        if (l5 != l3) {
            RuntimeCostAccounter.recordJump();
            return 0L;
        }
        this.state = l2 = l4 + 129L;
        WNode wNode = this.whead;
        RuntimeCostAccounter.recordJump();
        if (wNode == null) return l2;
        int n = wNode.status;
        RuntimeCostAccounter.recordJump();
        if (n == 0) return l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
        this.release(wNode);
        return l2;
    }

    public long tryConvertToOptimisticRead(long l) {
        block15: {
            long l2;
            long l3 = l & 0xFFL;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.loadFence:()V");
            U.loadFence();
            while (true) {
                long l4 = this.state;
                RuntimeCostAccounter.recordJump();
                if ((l4 & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L)) {
                    RuntimeCostAccounter.recordJump();
                    break block15;
                }
                long l5 = l4 & 0xFFL;
                RuntimeCostAccounter.recordJump();
                if (l5 == 0L) {
                    RuntimeCostAccounter.recordJump();
                    if (l3 != 0L) {
                        RuntimeCostAccounter.recordJump();
                        break block15;
                    }
                    return l4;
                }
                RuntimeCostAccounter.recordJump();
                if (l5 == 128L) {
                    long l6;
                    RuntimeCostAccounter.recordJump();
                    if (l3 != l5) {
                        RuntimeCostAccounter.recordJump();
                        break block15;
                    }
                    RuntimeCostAccounter.recordJump();
                    if ((l4 += 128L) == 0L) {
                        l6 = 256L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l6 = l4;
                    }
                    l2 = l6;
                    this.state = l6;
                    WNode wNode = this.whead;
                    RuntimeCostAccounter.recordJump();
                    if (wNode != null) {
                        int n = wNode.status;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                            this.release(wNode);
                        }
                    }
                    return l2;
                }
                RuntimeCostAccounter.recordJump();
                if (l3 == 0L) break block15;
                RuntimeCostAccounter.recordJump();
                if (l3 >= 128L) {
                    RuntimeCostAccounter.recordJump();
                    break block15;
                }
                RuntimeCostAccounter.recordJump();
                if (l5 < 126L) {
                    l2 = l4 - 1L;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l4, l2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    RuntimeCostAccounter.recordJump();
                    if (l5 == 1L) {
                        WNode wNode = this.whead;
                        RuntimeCostAccounter.recordJump();
                        if (wNode != null) {
                            int n = wNode.status;
                            RuntimeCostAccounter.recordJump();
                            if (n != 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                                this.release(wNode);
                            }
                        }
                    }
                    return l2 & 0xFFFFFFFFFFFFFF80L;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryDecReaderOverflow:(J)J");
                l2 = this.tryDecReaderOverflow(l4);
                RuntimeCostAccounter.recordJump();
                if (l2 != 0L) break;
            }
            return l2 & 0xFFFFFFFFFFFFFF80L;
        }
        return 0L;
    }

    public boolean tryUnlockWrite() {
        long l = this.state;
        RuntimeCostAccounter.recordJump();
        if ((l & 0x80L) != 0L) {
            long l2;
            RuntimeCostAccounter.recordJump();
            if ((l += 128L) == 0L) {
                l2 = 256L;
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = l;
            }
            this.state = l2;
            WNode wNode = this.whead;
            RuntimeCostAccounter.recordJump();
            if (wNode != null) {
                int n = wNode.status;
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                    this.release(wNode);
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryUnlockRead() {
        block5: {
            while (true) {
                long l = this.state;
                long l2 = l & 0xFFL;
                RuntimeCostAccounter.recordJump();
                if (l2 == 0L) break block5;
                RuntimeCostAccounter.recordJump();
                if (l2 >= 128L) break block5;
                RuntimeCostAccounter.recordJump();
                if (l2 < 126L) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = U.compareAndSwapLong((Object)this, STATE, l, l - 1L);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) continue;
                    RuntimeCostAccounter.recordJump();
                    if (l2 == 1L) {
                        WNode wNode = this.whead;
                        RuntimeCostAccounter.recordJump();
                        if (wNode != null) {
                            int n = wNode.status;
                            RuntimeCostAccounter.recordJump();
                            if (n != 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                                this.release(wNode);
                            }
                        }
                    }
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryDecReaderOverflow:(J)J");
                long l3 = this.tryDecReaderOverflow(l) - 0L;
                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l4 != false) break;
            }
            return true;
        }
        return false;
    }

    private int getReadLockCount(long l) {
        long l2 = l & 0x7FL;
        RuntimeCostAccounter.recordJump();
        if (l2 >= 126L) {
            l2 = 126L + (long)this.readerOverflow;
        }
        return (int)l2;
    }

    public boolean isWriteLocked() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if ((this.state & 0x80L) != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isReadLocked() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if ((this.state & 0x7FL) != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public int getReadLockCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.getReadLockCount:(J)I");
        return this.getReadLockCount(this.state);
    }

    public String toString() {
        String string;
        long l = this.state;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string2 = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordJump();
        if ((l & 0xFFL) == 0L) {
            string = "[Unlocked]";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if ((l & 0x80L) != 0L) {
                string = "[Write-locked]";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder3 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("[Read-locks:");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.getReadLockCount:(J)I");
                int n = this.getReadLockCount(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("]");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder6.toString();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    public Lock asReadLock() {
        ReadLockView readLockView;
        ReadLockView readLockView2 = this.readLockView;
        RuntimeCostAccounter.recordJump();
        if (readLockView2 != null) {
            readLockView = readLockView2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$ReadLockView");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$ReadLockView.<init>:(Ljava/util/concurrent/locks/StampedLock;)V");
            readLockView = this.readLockView = new ReadLockView();
        }
        return readLockView;
    }

    public Lock asWriteLock() {
        WriteLockView writeLockView;
        WriteLockView writeLockView2 = this.writeLockView;
        RuntimeCostAccounter.recordJump();
        if (writeLockView2 != null) {
            writeLockView = writeLockView2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$WriteLockView");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$WriteLockView.<init>:(Ljava/util/concurrent/locks/StampedLock;)V");
            writeLockView = this.writeLockView = new WriteLockView();
        }
        return writeLockView;
    }

    public ReadWriteLock asReadWriteLock() {
        ReadWriteLockView readWriteLockView;
        ReadWriteLockView readWriteLockView2 = this.readWriteLockView;
        RuntimeCostAccounter.recordJump();
        if (readWriteLockView2 != null) {
            readWriteLockView = readWriteLockView2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$ReadWriteLockView");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$ReadWriteLockView.<init>:(Ljava/util/concurrent/locks/StampedLock;)V");
            readWriteLockView = this.readWriteLockView = new ReadWriteLockView();
        }
        return readWriteLockView;
    }

    final void unstampedUnlockWrite() {
        long l;
        long l2 = this.state;
        RuntimeCostAccounter.recordJump();
        if ((l2 & 0x80L) == 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
            IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalMonitorStateException;
        }
        RuntimeCostAccounter.recordJump();
        if ((l2 += 128L) == 0L) {
            l = 256L;
            RuntimeCostAccounter.recordJump();
        } else {
            l = l2;
        }
        this.state = l;
        WNode wNode = this.whead;
        RuntimeCostAccounter.recordJump();
        if (wNode != null) {
            int n = wNode.status;
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                this.release(wNode);
            }
        }
    }

    final void unstampedUnlockRead() {
        while (true) {
            long l;
            long l2;
            block10: {
                block9: {
                    l2 = this.state;
                    l = l2 & 0xFFL;
                    RuntimeCostAccounter.recordJump();
                    if (l == 0L) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (l < 128L) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            RuntimeCostAccounter.recordJump();
            if (l < 126L) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = U.compareAndSwapLong((Object)this, STATE, l2, l2 - 1L);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordJump();
                    if (l != 1L) break;
                    WNode wNode = this.whead;
                    RuntimeCostAccounter.recordJump();
                    if (wNode == null) break;
                    int n = wNode.status;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                    this.release(wNode);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryDecReaderOverflow:(J)J");
                long l3 = this.tryDecReaderOverflow(l2) - 0L;
                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l4 != false) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        this.state = 256L;
    }

    private long tryIncReaderOverflow(long l) {
        RuntimeCostAccounter.recordJump();
        if ((l & 0xFFL) == 126L) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl = U.compareAndSwapLong((Object)this, STATE, l, l | 0x7FL);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ++this.readerOverflow;
                this.state = l;
                return l;
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
            int n = LockSupport.nextSecondarySeed() & 7;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                Thread.yield();
            }
        }
        return 0L;
    }

    private long tryDecReaderOverflow(long l) {
        RuntimeCostAccounter.recordJump();
        if ((l & 0xFFL) == 126L) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl = U.compareAndSwapLong((Object)this, STATE, l, l | 0x7FL);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                long l2;
                int n = this.readerOverflow;
                RuntimeCostAccounter.recordJump();
                if (n > 0) {
                    this.readerOverflow = n - 1;
                    l2 = l;
                    RuntimeCostAccounter.recordJump();
                } else {
                    l2 = l - 1L;
                }
                this.state = l2;
                return l2;
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
            int n = LockSupport.nextSecondarySeed() & 7;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                Thread.yield();
            }
        }
        return 0L;
    }

    private void release(WNode wNode) {
        block7: {
            WNode wNode2;
            block9: {
                block8: {
                    RuntimeCostAccounter.recordJump();
                    if (wNode == null) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    U.compareAndSwapInt((Object)wNode, WSTATUS, -1, 0);
                    wNode2 = wNode.next;
                    RuntimeCostAccounter.recordJump();
                    if (wNode2 == null) break block8;
                    int n = wNode2.status;
                    RuntimeCostAccounter.recordJump();
                    if (n != 1) break block9;
                }
                WNode wNode3 = this.wtail;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (wNode3 == null) break;
                    RuntimeCostAccounter.recordJump();
                    if (wNode3 == wNode) break;
                    int n = wNode3.status;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) {
                        wNode2 = wNode3;
                    }
                    wNode3 = wNode3.prev;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordJump();
            if (wNode2 != null) {
                Thread thread = wNode2.thread;
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                    U.unpark((Object)thread);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private long acquireWrite(boolean var1_1, long var2_2) {
        var4_3 = null;
        var5_4 = -1;
        while (true) {
            block41: {
                block42: {
                    block40: {
                        var6_5 = this.state;
                        var8_6 = var6_5 & 255L;
                        RuntimeCostAccounter.recordJump();
                        if (var8_6 != 0L) break block40;
                        var10_7 = var6_5 + 128L;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                        v0 = StampedLock.U.compareAndSwapLong((Object)this, StampedLock.STATE, var6_5, var10_7);
                        RuntimeCostAccounter.recordJump();
                        if (v0) {
                            return var10_7;
                        }
                        break block41;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var5_4 >= 0) break block42;
                    RuntimeCostAccounter.recordJump();
                    if (var8_6 != 128L) ** GOTO lbl-1000
                    RuntimeCostAccounter.recordJump();
                    if (this.wtail == this.whead) {
                        v1 = StampedLock.SPINS;
                        RuntimeCostAccounter.recordJump();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = 0;
                    }
                    var5_4 = v1;
                    RuntimeCostAccounter.recordJump();
                    break block41;
                }
                RuntimeCostAccounter.recordJump();
                if (var5_4 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
                    v2 = LockSupport.nextSecondarySeed();
                    RuntimeCostAccounter.recordJump();
                    if (v2 >= 0) {
                        --var5_4;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    var12_8 = this.wtail;
                    RuntimeCostAccounter.recordJump();
                    if (var12_8 == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$WNode");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$WNode.<init>:(ILjava/util/concurrent/locks/StampedLock$WNode;)V");
                        var13_9 = new WNode(1, null);
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        v3 = StampedLock.U.compareAndSwapObject((Object)this, StampedLock.WHEAD, null, var13_9);
                        RuntimeCostAccounter.recordJump();
                        if (v3) {
                            this.wtail = var13_9;
                        }
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (var4_3 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$WNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$WNode.<init>:(ILjava/util/concurrent/locks/StampedLock$WNode;)V");
                            var4_3 = new WNode(1, var12_8);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v4 = var4_3.prev;
                            RuntimeCostAccounter.recordJump();
                            if (v4 != var12_8) {
                                var4_3.prev = var12_8;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                v5 = StampedLock.U.compareAndSwapObject((Object)this, StampedLock.WTAIL, (Object)var12_8, (Object)var4_3);
                                RuntimeCostAccounter.recordJump();
                                if (v5) break;
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        var12_8.next = var4_3;
        RuntimeCostAccounter.recordJump();
        var5_4 = -1;
        while (true) {
            block43: {
                block47: {
                    block48: {
                        block46: {
                            block45: {
                                block44: {
                                    var14_10 = this.whead;
                                    RuntimeCostAccounter.recordJump();
                                    if (var14_10 == var12_8) {
                                        RuntimeCostAccounter.recordJump();
                                        if (var5_4 < 0) {
                                            var5_4 = StampedLock.HEAD_SPINS;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            RuntimeCostAccounter.recordJump();
                                            if (var5_4 < StampedLock.MAX_HEAD_SPINS) {
                                                var5_4 <<= 1;
                                            }
                                        }
                                        var15_11 = var5_4;
                                        while (true) {
                                            var16_13 = this.state;
                                            RuntimeCostAccounter.recordJump();
                                            if ((var16_13 & 255L) == 0L) {
                                                var18_14 = var16_13 + 128L;
                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                                v6 = StampedLock.U.compareAndSwapLong((Object)this, StampedLock.STATE, var16_13, var18_14);
                                                RuntimeCostAccounter.recordJump();
                                                if (v6) {
                                                    this.whead = var4_3;
                                                    var4_3.prev = null;
                                                    return var18_14;
                                                }
                                            } else {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
                                                v7 = LockSupport.nextSecondarySeed();
                                                RuntimeCostAccounter.recordJump();
                                                if (v7 >= 0) {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (--var15_11 <= 0) break;
                                                }
                                            }
                                            RuntimeCostAccounter.recordJump();
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordJump();
                                        if (var14_10 != null) {
                                            while (true) {
                                                var15_12 = var14_10.cowait;
                                                RuntimeCostAccounter.recordJump();
                                                if (var15_12 == null) break;
                                                v8 = var15_12.cowait;
                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                                v9 = StampedLock.U.compareAndSwapObject((Object)var14_10, StampedLock.WCOWAIT, (Object)var15_12, (Object)v8);
                                                RuntimeCostAccounter.recordJump();
                                                if (!v9) continue;
                                                var20_15 = var15_12.thread;
                                                RuntimeCostAccounter.recordJump();
                                                if (var20_15 == null) continue;
                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                                StampedLock.U.unpark((Object)var20_15);
                                                RuntimeCostAccounter.recordJump();
                                            }
                                        }
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (this.whead != var14_10) break block43;
                                    var21_16 = var4_3.prev;
                                    RuntimeCostAccounter.recordJump();
                                    if (var21_16 == var12_8) break block44;
                                    RuntimeCostAccounter.recordJump();
                                    if (var21_16 != null) {
                                        var12_8 = var21_16;
                                        var21_16.next = var4_3;
                                        RuntimeCostAccounter.recordJump();
                                    }
                                    break block43;
                                }
                                var22_17 = var12_8.status;
                                RuntimeCostAccounter.recordJump();
                                if (var22_17 != 0) break block45;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                StampedLock.U.compareAndSwapInt((Object)var12_8, StampedLock.WSTATUS, 0, -1);
                                RuntimeCostAccounter.recordJump();
                                break block43;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (var22_17 != 1) break block46;
                            var23_18 = var12_8.prev;
                            RuntimeCostAccounter.recordJump();
                            if (var23_18 != null) {
                                var4_3.prev = var23_18;
                                var23_18.next = var4_3;
                                RuntimeCostAccounter.recordJump();
                            }
                            break block43;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var2_2 == 0L) {
                            var10_7 = 0L;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                            var10_7 = var2_2 - System.nanoTime();
                            RuntimeCostAccounter.recordJump();
                            if (var10_7 <= 0L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                                return this.cancelWaiter(var4_3, var4_3, false);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        var13_9 = Thread.currentThread();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                        StampedLock.U.putObject(var13_9, StampedLock.PARKBLOCKER, (Object)this);
                        var4_3.thread = var13_9;
                        v10 = var12_8.status;
                        RuntimeCostAccounter.recordJump();
                        if (v10 >= 0) break block47;
                        RuntimeCostAccounter.recordJump();
                        if (var12_8 != var14_10) break block48;
                        RuntimeCostAccounter.recordJump();
                        if ((this.state & 255L) == 0L) break block47;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.whead == var14_10) {
                        v11 = var4_3.prev;
                        RuntimeCostAccounter.recordJump();
                        if (v11 == var12_8) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
                            StampedLock.U.park(false, var10_7);
                        }
                    }
                }
                var4_3.thread = null;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                StampedLock.U.putObject(var13_9, StampedLock.PARKBLOCKER, null);
                RuntimeCostAccounter.recordJump();
                if (var1_1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                    v12 = Thread.interrupted();
                    RuntimeCostAccounter.recordJump();
                    if (v12) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                        return this.cancelWaiter(var4_3, var4_3, true);
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private long acquireRead(boolean bl, long l) {
        Thread thread;
        long l2;
        WNode wNode;
        WNode wNode2;
        long l3;
        WNode wNode3;
        WNode wNode4;
        WNode wNode5 = null;
        int n = -1;
        while (true) {
            block71: {
                block75: {
                    block74: {
                        block73: {
                            block72: {
                                block70: {
                                    block66: {
                                        wNode4 = this.whead;
                                        wNode3 = this.wtail;
                                        RuntimeCostAccounter.recordJump();
                                        if (wNode4 != wNode3) break block66;
                                        while (true) {
                                            long l4;
                                            block68: {
                                                block69: {
                                                    long l5;
                                                    block67: {
                                                        l5 = this.state;
                                                        l4 = l5 & 0xFFL;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (l4 >= 126L) break block67;
                                                        l3 = l5 + 1L;
                                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                                        boolean bl2 = U.compareAndSwapLong((Object)this, STATE, l5, l3);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (!bl2) break block68;
                                                        RuntimeCostAccounter.recordJump();
                                                        break block69;
                                                    }
                                                    RuntimeCostAccounter.recordJump();
                                                    if (l4 >= 128L) break block68;
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                                                    l3 = this.tryIncReaderOverflow(l5);
                                                    RuntimeCostAccounter.recordJump();
                                                    if (l3 == 0L) break block68;
                                                }
                                                return l3;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (l4 < 128L) continue;
                                            RuntimeCostAccounter.recordJump();
                                            if (n > 0) {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
                                                int n2 = LockSupport.nextSecondarySeed();
                                                RuntimeCostAccounter.recordJump();
                                                if (n2 < 0) continue;
                                                --n;
                                                RuntimeCostAccounter.recordJump();
                                                continue;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (n == 0) {
                                                WNode wNode6 = this.whead;
                                                WNode wNode7 = this.wtail;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode6 == wNode4) {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (wNode7 == wNode3) break;
                                                }
                                                wNode4 = wNode6;
                                                wNode3 = wNode7;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode4 != wNode3) {
                                                    RuntimeCostAccounter.recordJump();
                                                    break;
                                                }
                                            }
                                            n = SPINS;
                                            RuntimeCostAccounter.recordJump();
                                        }
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (wNode3 != null) break block70;
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$WNode");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$WNode.<init>:(ILjava/util/concurrent/locks/StampedLock$WNode;)V");
                                    wNode2 = new WNode(1, null);
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl3 = U.compareAndSwapObject((Object)this, WHEAD, null, (Object)wNode2);
                                    RuntimeCostAccounter.recordJump();
                                    if (bl3) {
                                        this.wtail = wNode2;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    break block71;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (wNode5 != null) break block72;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/StampedLock$WNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock$WNode.<init>:(ILjava/util/concurrent/locks/StampedLock$WNode;)V");
                                wNode5 = new WNode(0, wNode3);
                                RuntimeCostAccounter.recordJump();
                                break block71;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (wNode4 == wNode3) break block73;
                            int n3 = wNode3.mode;
                            RuntimeCostAccounter.recordJump();
                            if (n3 == 0) break block74;
                        }
                        WNode wNode8 = wNode5.prev;
                        RuntimeCostAccounter.recordJump();
                        if (wNode8 != wNode3) {
                            wNode5.prev = wNode3;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl4 = U.compareAndSwapObject((Object)this, WTAIL, (Object)wNode3, (Object)wNode5);
                            RuntimeCostAccounter.recordJump();
                            if (bl4) {
                                break;
                            }
                        }
                        break block71;
                    }
                    wNode5.cowait = wNode3.cowait;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl5 = U.compareAndSwapObject((Object)wNode3, WCOWAIT, (Object)wNode5.cowait, (Object)wNode5);
                    RuntimeCostAccounter.recordJump();
                    if (bl5) break block75;
                    wNode5.cowait = null;
                    RuntimeCostAccounter.recordJump();
                    break block71;
                }
                while (true) {
                    block81: {
                        block85: {
                            block84: {
                                block83: {
                                    block82: {
                                        block77: {
                                            block76: {
                                                wNode4 = this.whead;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode4 != null) {
                                                    wNode = wNode4.cowait;
                                                    RuntimeCostAccounter.recordJump();
                                                    if (wNode != null) {
                                                        WNode wNode9 = wNode.cowait;
                                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                                        boolean bl6 = U.compareAndSwapObject((Object)wNode4, WCOWAIT, (Object)wNode, (Object)wNode9);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (bl6) {
                                                            Thread thread2 = wNode.thread;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (thread2 != null) {
                                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                                                U.unpark((Object)thread2);
                                                            }
                                                        }
                                                    }
                                                }
                                                wNode2 = wNode3.prev;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode4 == wNode2) break block76;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode4 == wNode3) break block76;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode2 != null) break block77;
                                            }
                                            do {
                                                block79: {
                                                    long l6;
                                                    block80: {
                                                        long l7;
                                                        block78: {
                                                            l7 = this.state;
                                                            l2 = l7 & 0xFFL;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (l2 >= 126L) break block78;
                                                            l6 = l7 + 1L;
                                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                                            boolean bl7 = U.compareAndSwapLong((Object)this, STATE, l7, l6);
                                                            RuntimeCostAccounter.recordJump();
                                                            if (!bl7) break block79;
                                                            RuntimeCostAccounter.recordJump();
                                                            break block80;
                                                        }
                                                        RuntimeCostAccounter.recordJump();
                                                        if (l2 >= 128L) break block79;
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                                                        l6 = this.tryIncReaderOverflow(l7);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (l6 == 0L) break block79;
                                                    }
                                                    return l6;
                                                }
                                                RuntimeCostAccounter.recordJump();
                                            } while (l2 < 128L);
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (this.whead != wNode4) break block81;
                                        WNode wNode10 = wNode3.prev;
                                        RuntimeCostAccounter.recordJump();
                                        if (wNode10 != wNode2) break block81;
                                        RuntimeCostAccounter.recordJump();
                                        if (wNode2 == null) break block82;
                                        RuntimeCostAccounter.recordJump();
                                        if (wNode4 == wNode3) break block82;
                                        int n4 = wNode3.status;
                                        RuntimeCostAccounter.recordJump();
                                        if (n4 <= 0) break block83;
                                    }
                                    wNode5 = null;
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (l == 0L) {
                                    l2 = 0L;
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                                    l2 = l - System.nanoTime();
                                    RuntimeCostAccounter.recordJump();
                                    if (l2 <= 0L) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                                        return this.cancelWaiter(wNode5, wNode3, false);
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                                thread = Thread.currentThread();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                                U.putObject((Object)thread, PARKBLOCKER, (Object)this);
                                wNode5.thread = thread;
                                RuntimeCostAccounter.recordJump();
                                if (wNode4 != wNode2) break block84;
                                RuntimeCostAccounter.recordJump();
                                if ((this.state & 0xFFL) != 128L) break block85;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.whead == wNode4) {
                                WNode wNode11 = wNode3.prev;
                                RuntimeCostAccounter.recordJump();
                                if (wNode11 == wNode2) {
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
                                    U.park(false, l2);
                                }
                            }
                        }
                        wNode5.thread = null;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                        U.putObject((Object)thread, PARKBLOCKER, null);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                            boolean bl8 = Thread.interrupted();
                            RuntimeCostAccounter.recordJump();
                            if (bl8) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                                return this.cancelWaiter(wNode5, wNode3, true);
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        wNode3.next = wNode5;
        RuntimeCostAccounter.recordJump();
        n = -1;
        while (true) {
            block91: {
                block95: {
                    block96: {
                        block94: {
                            int n5;
                            block93: {
                                block92: {
                                    block90: {
                                        block86: {
                                            wNode4 = this.whead;
                                            RuntimeCostAccounter.recordJump();
                                            if (wNode4 != wNode3) break block86;
                                            RuntimeCostAccounter.recordJump();
                                            if (n < 0) {
                                                n = HEAD_SPINS;
                                                RuntimeCostAccounter.recordJump();
                                            } else {
                                                RuntimeCostAccounter.recordJump();
                                                if (n < MAX_HEAD_SPINS) {
                                                    n <<= 1;
                                                }
                                            }
                                            int n6 = n;
                                            while (true) {
                                                block88: {
                                                    long l8;
                                                    block89: {
                                                        long l9;
                                                        block87: {
                                                            l9 = this.state;
                                                            l3 = l9 & 0xFFL;
                                                            RuntimeCostAccounter.recordJump();
                                                            if (l3 >= 126L) break block87;
                                                            l8 = l9 + 1L;
                                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                                                            boolean bl9 = U.compareAndSwapLong((Object)this, STATE, l9, l8);
                                                            RuntimeCostAccounter.recordJump();
                                                            if (!bl9) break block88;
                                                            RuntimeCostAccounter.recordJump();
                                                            break block89;
                                                        }
                                                        RuntimeCostAccounter.recordJump();
                                                        if (l3 >= 128L) break block88;
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryIncReaderOverflow:(J)J");
                                                        l8 = this.tryIncReaderOverflow(l9);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (l8 == 0L) break block88;
                                                    }
                                                    this.whead = wNode5;
                                                    wNode5.prev = null;
                                                    while (true) {
                                                        WNode wNode12 = wNode5.cowait;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (wNode12 == null) break;
                                                        WNode wNode13 = wNode12.cowait;
                                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                                        boolean bl10 = U.compareAndSwapObject((Object)wNode5, WCOWAIT, (Object)wNode12, (Object)wNode13);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (!bl10) continue;
                                                        Thread thread3 = wNode12.thread;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (thread3 == null) continue;
                                                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                                        U.unpark((Object)thread3);
                                                        RuntimeCostAccounter.recordJump();
                                                    }
                                                    return l8;
                                                }
                                                RuntimeCostAccounter.recordJump();
                                                if (l3 >= 128L) {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.nextSecondarySeed:()I");
                                                    int n7 = LockSupport.nextSecondarySeed();
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n7 >= 0) {
                                                        RuntimeCostAccounter.recordJump();
                                                        if (--n6 <= 0) break;
                                                    }
                                                }
                                                RuntimeCostAccounter.recordJump();
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            RuntimeCostAccounter.recordJump();
                                            break block90;
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (wNode4 != null) {
                                            while (true) {
                                                WNode wNode14 = wNode4.cowait;
                                                RuntimeCostAccounter.recordJump();
                                                if (wNode14 == null) break;
                                                WNode wNode15 = wNode14.cowait;
                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                                boolean bl11 = U.compareAndSwapObject((Object)wNode4, WCOWAIT, (Object)wNode14, (Object)wNode15);
                                                RuntimeCostAccounter.recordJump();
                                                if (!bl11) continue;
                                                Thread thread4 = wNode14.thread;
                                                RuntimeCostAccounter.recordJump();
                                                if (thread4 == null) continue;
                                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                                                U.unpark((Object)thread4);
                                                RuntimeCostAccounter.recordJump();
                                            }
                                        }
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (this.whead != wNode4) break block91;
                                    wNode2 = wNode5.prev;
                                    RuntimeCostAccounter.recordJump();
                                    if (wNode2 == wNode3) break block92;
                                    RuntimeCostAccounter.recordJump();
                                    if (wNode2 != null) {
                                        wNode3 = wNode2;
                                        wNode2.next = wNode5;
                                        RuntimeCostAccounter.recordJump();
                                    }
                                    break block91;
                                }
                                n5 = wNode3.status;
                                RuntimeCostAccounter.recordJump();
                                if (n5 != 0) break block93;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                                U.compareAndSwapInt((Object)wNode3, WSTATUS, 0, -1);
                                RuntimeCostAccounter.recordJump();
                                break block91;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n5 != 1) break block94;
                            wNode = wNode3.prev;
                            RuntimeCostAccounter.recordJump();
                            if (wNode != null) {
                                wNode5.prev = wNode;
                                wNode.next = wNode5;
                                RuntimeCostAccounter.recordJump();
                            }
                            break block91;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (l == 0L) {
                            l2 = 0L;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                            l2 = l - System.nanoTime();
                            RuntimeCostAccounter.recordJump();
                            if (l2 <= 0L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                                return this.cancelWaiter(wNode5, wNode5, false);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        thread = Thread.currentThread();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                        U.putObject((Object)thread, PARKBLOCKER, (Object)this);
                        wNode5.thread = thread;
                        int n8 = wNode3.status;
                        RuntimeCostAccounter.recordJump();
                        if (n8 >= 0) break block95;
                        RuntimeCostAccounter.recordJump();
                        if (wNode3 != wNode4) break block96;
                        RuntimeCostAccounter.recordJump();
                        if ((this.state & 0xFFL) != 128L) break block95;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.whead == wNode4) {
                        WNode wNode16 = wNode5.prev;
                        RuntimeCostAccounter.recordJump();
                        if (wNode16 == wNode3) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
                            U.park(false, l2);
                        }
                    }
                }
                wNode5.thread = null;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
                U.putObject((Object)thread, PARKBLOCKER, null);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                    boolean bl12 = Thread.interrupted();
                    RuntimeCostAccounter.recordJump();
                    if (bl12) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.cancelWaiter:(Ljava/util/concurrent/locks/StampedLock$WNode;Ljava/util/concurrent/locks/StampedLock$WNode;Z)J");
                        return this.cancelWaiter(wNode5, wNode5, true);
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long cancelWaiter(WNode wNode, WNode wNode2, boolean bl) {
        WNode wNode3;
        WNode wNode4;
        Object object;
        block25: {
            WNode wNode5;
            RuntimeCostAccounter.recordJump();
            if (wNode == null) break block25;
            RuntimeCostAccounter.recordJump();
            if (wNode2 == null) break block25;
            wNode.status = 1;
            WNode wNode6 = wNode2;
            while (true) {
                wNode5 = wNode6.cowait;
                RuntimeCostAccounter.recordJump();
                if (wNode5 == null) break;
                int n = wNode5.status;
                RuntimeCostAccounter.recordJump();
                if (n == 1) {
                    WNode wNode7 = wNode5.cowait;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    U.compareAndSwapObject((Object)wNode6, WCOWAIT, (Object)wNode5, (Object)wNode7);
                    wNode6 = wNode2;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                wNode6 = wNode5;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (wNode2 != wNode) break block25;
            wNode6 = wNode2.cowait;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (wNode6 == null) break;
                object = wNode6.thread;
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                    U.unpark(object);
                }
                wNode6 = wNode6.cowait;
                RuntimeCostAccounter.recordJump();
            }
            wNode6 = wNode.prev;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (wNode6 == null) break;
                while (true) {
                    block27: {
                        block26: {
                            wNode5 = wNode.next;
                            RuntimeCostAccounter.recordJump();
                            if (wNode5 != null) {
                                int n = wNode5.status;
                                RuntimeCostAccounter.recordJump();
                                if (n != 1) break;
                            }
                            wNode4 = null;
                            WNode wNode8 = this.wtail;
                            while (true) {
                                RuntimeCostAccounter.recordJump();
                                if (wNode8 == null) break;
                                RuntimeCostAccounter.recordJump();
                                if (wNode8 == wNode) break;
                                int n = wNode8.status;
                                RuntimeCostAccounter.recordJump();
                                if (n != 1) {
                                    wNode4 = wNode8;
                                }
                                wNode8 = wNode8.prev;
                                RuntimeCostAccounter.recordJump();
                            }
                            RuntimeCostAccounter.recordJump();
                            if (wNode5 == wNode4) break block26;
                            WNode wNode9 = wNode5;
                            wNode5 = wNode4;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl2 = U.compareAndSwapObject((Object)wNode, WNEXT, (Object)wNode9, (Object)wNode5);
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break block27;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (wNode5 != null) break;
                        RuntimeCostAccounter.recordJump();
                        if (wNode != this.wtail) break;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        U.compareAndSwapObject((Object)this, WTAIL, (Object)wNode, (Object)wNode6);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                WNode wNode10 = wNode6.next;
                RuntimeCostAccounter.recordJump();
                if (wNode10 == wNode) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    U.compareAndSwapObject((Object)wNode6, WNEXT, (Object)wNode, (Object)wNode5);
                }
                RuntimeCostAccounter.recordJump();
                if (wNode5 != null) {
                    object = wNode5.thread;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        wNode5.thread = null;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
                        U.unpark(object);
                    }
                }
                int n = wNode6.status;
                RuntimeCostAccounter.recordJump();
                if (n != 1) break;
                wNode3 = wNode6.prev;
                RuntimeCostAccounter.recordJump();
                if (wNode3 == null) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                wNode.prev = wNode3;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                U.compareAndSwapObject((Object)wNode3, WNEXT, (Object)wNode6, (Object)wNode5);
                wNode6 = wNode3;
                RuntimeCostAccounter.recordJump();
            }
        }
        while (true) {
            block29: {
                block28: {
                    object = this.whead;
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break;
                    wNode3 = ((WNode)object).next;
                    RuntimeCostAccounter.recordJump();
                    if (wNode3 == null) break block28;
                    int n = wNode3.status;
                    RuntimeCostAccounter.recordJump();
                    if (n != 1) break block29;
                }
                wNode4 = this.wtail;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (wNode4 == null) break;
                    RuntimeCostAccounter.recordJump();
                    if (wNode4 == object) break;
                    int n = wNode4.status;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) {
                        wNode3 = wNode4;
                    }
                    wNode4 = wNode4.prev;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordJump();
            if (object == this.whead) {
                RuntimeCostAccounter.recordJump();
                if (wNode3 == null) break;
                int n = ((WNode)object).status;
                RuntimeCostAccounter.recordJump();
                if (n != 0) break;
                long l = this.state;
                RuntimeCostAccounter.recordJump();
                if ((l & 0xFFL) == 128L) break;
                RuntimeCostAccounter.recordJump();
                if (l != 0L) {
                    int n2 = wNode3.mode;
                    RuntimeCostAccounter.recordJump();
                    if (n2 != 0) break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.release:(Ljava/util/concurrent/locks/StampedLock$WNode;)V");
                this.release((WNode)object);
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl3 = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (!bl3) return 0L;
        }
        long l = 1L;
        RuntimeCostAccounter.recordJump();
        return l;
    }

    static {
        int n;
        int n2;
        int n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        NCPU = runtime.availableProcessors();
        RuntimeCostAccounter.recordJump();
        if (NCPU > 1) {
            n3 = 64;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = 0;
        }
        SPINS = n3;
        RuntimeCostAccounter.recordJump();
        if (NCPU > 1) {
            n2 = 1024;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        HEAD_SPINS = n2;
        RuntimeCostAccounter.recordJump();
        if (NCPU > 1) {
            n = 65536;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        MAX_HEAD_SPINS = n;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            U = Unsafe.getUnsafe();
            Class<StampedLock> clazz = StampedLock.class;
            Class<WNode> clazz2 = WNode.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("state");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            STATE = U.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("whead");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WHEAD = U.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("wtail");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WTAIL = U.objectFieldOffset(field3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field4 = clazz2.getDeclaredField("status");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WSTATUS = U.objectFieldOffset(field4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field5 = clazz2.getDeclaredField("next");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WNEXT = U.objectFieldOffset(field5);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field6 = clazz2.getDeclaredField("cowait");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WCOWAIT = U.objectFieldOffset(field6);
            Class<Thread> clazz3 = Thread.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field7 = clazz3.getDeclaredField("parkBlocker");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PARKBLOCKER = U.objectFieldOffset(field7);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    final class ReadWriteLockView
    implements ReadWriteLock {
        ReadWriteLockView() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public Lock readLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.asReadLock:()Ljava/util/concurrent/locks/Lock;");
            return StampedLock.this.asReadLock();
        }

        @Override
        public Lock writeLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.asWriteLock:()Ljava/util/concurrent/locks/Lock;");
            return StampedLock.this.asWriteLock();
        }
    }

    final class WriteLockView
    implements Lock {
        WriteLockView() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.writeLock:()J");
            StampedLock.this.writeLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.writeLockInterruptibly:()J");
            StampedLock.this.writeLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryWriteLock:()J");
            long l = StampedLock.this.tryWriteLock() - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryWriteLock:(JLjava/util/concurrent/TimeUnit;)J");
            long l2 = StampedLock.this.tryWriteLock(l, timeUnit) - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void unlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.unstampedUnlockWrite:()V");
            StampedLock.this.unstampedUnlockWrite();
        }

        @Override
        public Condition newCondition() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
    }

    final class ReadLockView
    implements Lock {
        ReadLockView() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.readLock:()J");
            StampedLock.this.readLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.readLockInterruptibly:()J");
            StampedLock.this.readLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryReadLock:()J");
            long l = StampedLock.this.tryReadLock() - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.tryReadLock:(JLjava/util/concurrent/TimeUnit;)J");
            long l2 = StampedLock.this.tryReadLock(l, timeUnit) - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 != false) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void unlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/StampedLock.unstampedUnlockRead:()V");
            StampedLock.this.unstampedUnlockRead();
        }

        @Override
        public Condition newCondition() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
    }

    static final class WNode {
        volatile WNode prev;
        volatile WNode next;
        volatile WNode cowait;
        volatile Thread thread;
        volatile int status;
        final int mode;

        WNode(int n, WNode wNode) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.mode = n;
            this.prev = wNode;
        }
    }
}

