/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.locks;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.Collection;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.AbstractQueuedSynchronizer;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.Lock;

public class ReentrantLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public ReentrantLock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.<init>:()V");
        this.sync = new NonfairSync();
    }

    public ReentrantLock(boolean bl) {
        Sync sync;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock$FairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.<init>:()V");
            sync = new FairSync();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.<init>:()V");
            sync = new NonfairSync();
        }
        this.sync = sync;
    }

    @Override
    public void lock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.lock:()V");
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.acquireInterruptibly:(I)V");
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.nonfairTryAcquire:(I)Z");
        return this.sync.nonfairTryAcquire(1);
    }

    @Override
    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.tryAcquireNanos:(IJ)Z");
        return this.sync.tryAcquireNanos(1, l2);
    }

    @Override
    public void unlock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.release:(I)Z");
        this.sync.release(1);
    }

    @Override
    public Condition newCondition() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.newCondition:()Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;");
        return this.sync.newCondition();
    }

    public int getHoldCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getHoldCount:()I");
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.isHeldExclusively:()Z");
        return this.sync.isHeldExclusively();
    }

    public boolean isLocked() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.isLocked:()Z");
        return this.sync.isLocked();
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getOwner:()Ljava/lang/Thread;");
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.hasQueuedThreads:()Z");
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.isQueued:(Ljava/lang/Thread;)Z");
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getQueueLength:()I");
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getQueuedThreads:()Ljava/util/Collection;");
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.hasWaiters:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)Z");
        return this.sync.hasWaiters(conditionObject);
    }

    public int getWaitQueueLength(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getWaitQueueLength:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)I");
        return this.sync.getWaitQueueLength(conditionObject);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getWaitingThreads:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)Ljava/util/Collection;");
        return this.sync.getWaitingThreads(conditionObject);
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getOwner:()Ljava/lang/Thread;");
        Thread thread = this.sync.getOwner();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string2 = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordJump();
        if (thread == null) {
            string = "[Unlocked]";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder3 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("[Locked by thread ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getName:()Ljava/lang/String;");
            String string3 = thread.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string = stringBuilder6.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -3000897897090466540L;

        FairSync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.<init>:()V");
        }

        @Override
        final void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.acquire:(I)V");
            this.acquire(1);
        }

        @Override
        protected final boolean tryAcquire(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.getState:()I");
            int n2 = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.hasQueuedPredecessors:()Z");
                boolean bl = this.hasQueuedPredecessors();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.compareAndSetState:(II)Z");
                    boolean bl2 = this.compareAndSetState(0, n);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                        this.setExclusiveOwnerThread(thread);
                        return true;
                    }
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                Thread thread2 = this.getExclusiveOwnerThread();
                RuntimeCostAccounter.recordJump();
                if (thread == thread2) {
                    int n3 = n2 + n;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                        Error error = new Error("Maximum lock count exceeded");
                        RuntimeCostAccounter.recordThrow();
                        throw error;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$FairSync.setState:(I)V");
                    this.setState(n3);
                    return true;
                }
            }
            return false;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        NonfairSync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.<init>:()V");
        }

        @Override
        final void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.compareAndSetState:(II)Z");
            boolean bl = this.compareAndSetState(0, 1);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                this.setExclusiveOwnerThread(thread);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.acquire:(I)V");
                this.acquire(1);
            }
        }

        @Override
        protected final boolean tryAcquire(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$NonfairSync.nonfairTryAcquire:(I)Z");
            return this.nonfairTryAcquire(n);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -5179523762034025860L;

        Sync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer.<init>:()V");
        }

        abstract void lock();

        final boolean nonfairTryAcquire(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getState:()I");
            int n2 = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.compareAndSetState:(II)Z");
                boolean bl = this.compareAndSetState(0, n);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                    this.setExclusiveOwnerThread(thread);
                    return true;
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                Thread thread2 = this.getExclusiveOwnerThread();
                RuntimeCostAccounter.recordJump();
                if (thread == thread2) {
                    int n3 = n2 + n;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                        Error error = new Error("Maximum lock count exceeded");
                        RuntimeCostAccounter.recordThrow();
                        throw error;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.setState:(I)V");
                    this.setState(n3);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected final boolean tryRelease(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getState:()I");
            int n2 = this.getState() - n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
            Thread thread2 = this.getExclusiveOwnerThread();
            RuntimeCostAccounter.recordJump();
            if (thread != thread2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            boolean bl = false;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                bl = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                this.setExclusiveOwnerThread(null);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.setState:(I)V");
            this.setState(n2);
            return bl;
        }

        @Override
        protected final boolean isHeldExclusively() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
            Thread thread = this.getExclusiveOwnerThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread2 = Thread.currentThread();
            RuntimeCostAccounter.recordJump();
            if (thread == thread2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject.<init>:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer;)V");
            return new AbstractQueuedSynchronizer.ConditionObject();
        }

        final Thread getOwner() {
            Thread thread;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                thread = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                thread = this.getExclusiveOwnerThread();
            }
            return thread;
        }

        final int getHoldCount() {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.isHeldExclusively:()Z");
            boolean bl = this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getState:()I");
                n = this.getState();
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n;
        }

        final boolean isLocked() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
            objectInputStream.defaultReadObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock$Sync.setState:(I)V");
            this.setState(0);
        }
    }
}

