/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.security.Permission;
import sandbox.java.util.ArrayList;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.HashSet;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.concurrent.AbstractExecutorService;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.Executors;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.RejectedExecutionException;
import sandbox.java.util.concurrent.RejectedExecutionHandler;
import sandbox.java.util.concurrent.ThreadFactory;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.locks.AbstractQueuedSynchronizer;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl;
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock;
    private final HashSet<Worker> workers;
    private final Condition termination;
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler;
    private static final RuntimePermission shutdownPerm;
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int n) {
        return n & 0xE0000000;
    }

    private static int workerCountOf(int n) {
        return n & 0x1FFFFFFF;
    }

    private static int ctlOf(int n, int n2) {
        return n | n2;
    }

    private static boolean runStateLessThan(int n, int n2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private static boolean runStateAtLeast(int n, int n2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private static boolean isRunning(int n) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean compareAndIncrementWorkerCount(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
        return this.ctl.compareAndSet(n, n + 1);
    }

    private boolean compareAndDecrementWorkerCount(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
        return this.ctl.compareAndSet(n, n - 1);
    }

    private void decrementWorkerCount() {
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n = this.ctl.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.compareAndDecrementWorkerCount:(I)Z");
            bl = this.compareAndDecrementWorkerCount(n);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
    }

    private void advanceRunState(int n) {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n2 = this.ctl.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
            boolean bl = ThreadPoolExecutor.runStateAtLeast(n2, n);
            RuntimeCostAccounter.recordJump();
            if (bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
            int n3 = ThreadPoolExecutor.workerCountOf(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.ctlOf:(II)I");
            int n4 = ThreadPoolExecutor.ctlOf(n, n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
            boolean bl2 = this.ctl.compareAndSet(n2, n4);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        while (true) {
            ReentrantLock reentrantLock;
            block9: {
                int n;
                block12: {
                    block11: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                        n = this.ctl.get();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isRunning:(I)Z");
                        boolean bl = ThreadPoolExecutor.isRunning(n);
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block11;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
                        boolean bl2 = ThreadPoolExecutor.runStateAtLeast(n, 0x40000000);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block11;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
                        int n2 = ThreadPoolExecutor.runStateOf(n);
                        RuntimeCostAccounter.recordJump();
                        if (n2 != 0) break block12;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                        boolean bl3 = this.workQueue.isEmpty();
                        RuntimeCostAccounter.recordJump();
                        if (bl3) break block12;
                    }
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                int n3 = ThreadPoolExecutor.workerCountOf(n);
                RuntimeCostAccounter.recordJump();
                if (n3 != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:(Z)V");
                    this.interruptIdleWorkers(true);
                    return;
                }
                reentrantLock = this.mainLock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.ctlOf:(II)I");
                    int n4 = ThreadPoolExecutor.ctlOf(0x40000000, 0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
                    boolean bl = this.ctl.compareAndSet(n, n4);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block9;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.terminated:()V");
                        this.terminated();
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.ctlOf:(II)I");
                        int n5 = ThreadPoolExecutor.ctlOf(0x60000000, 0);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.set:(I)V");
                        this.ctl.set(n5);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signalAll:()V");
                        this.termination.signalAll();
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.ctlOf:(II)I");
                    int n6 = ThreadPoolExecutor.ctlOf(0x60000000, 0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.set:(I)V");
                    this.ctl.set(n6);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signalAll:()V");
                    this.termination.signalAll();
                    RuntimeCostAccounter.recordJump();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkShutdownAccess() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager == null) return;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
        securityManager.checkPermission((Permission)shutdownPerm);
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Worker worker = iterator.next();
                    Thread thread = worker.thread;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkAccess:(Ljava/lang/Thread;)V");
                    securityManager.checkAccess(thread);
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void interruptWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Worker worker = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.interruptIfStarted:()V");
                    worker.interruptIfStarted();
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void interruptIdleWorkers(boolean bl) {
        ReentrantLock reentrantLock;
        block10: {
            reentrantLock = this.mainLock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
                Iterator<Worker> iterator = this.workers.iterator();
                while (true) {
                    block11: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl2 = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        Worker worker = iterator.next();
                        Thread thread = worker.thread;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                        boolean bl3 = thread.isInterrupted();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.tryLock:()Z");
                            boolean bl4 = worker.tryLock();
                            RuntimeCostAccounter.recordJump();
                            if (bl4) {
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                                    thread.interrupt();
                                }
                                catch (SecurityException securityException) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
                                    worker.unlock();
                                    RuntimeCostAccounter.recordJump();
                                    break block11;
                                    catch (Throwable throwable) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
                                        worker.unlock();
                                        RuntimeCostAccounter.recordThrow();
                                        throw throwable;
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
                                worker.unlock();
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private void interruptIdleWorkers() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:(Z)V");
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RejectedExecutionHandler.rejectedExecution:(Ljava/lang/Runnable;Ljava/util/concurrent/ThreadPoolExecutor;)V");
        this.handler.rejectedExecution(runnable, this);
    }

    void onShutdown() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean isRunningOrShutdown(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
        int n2 = ThreadPoolExecutor.runStateOf(n);
        RuntimeCostAccounter.recordJump();
        if (n2 != -536870912) {
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) return false;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
        }
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    private List<Runnable> drainQueue() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.drainTo:(Ljava/util/Collection;)I");
        blockingQueue.drainTo(arrayList);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
        boolean bl = blockingQueue.isEmpty();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
            Runnable[] runnableArray = new Runnable[]{};
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            Runnable[] runnableArray2 = blockingQueue.toArray(runnableArray);
            int n = runnableArray2.length;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Runnable runnable = runnableArray2[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.remove:(Ljava/lang/Object;)Z");
                boolean bl2 = blockingQueue.remove(runnable);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                    arrayList.add(runnable);
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable runnable, boolean bl) {
        boolean bl2;
        Worker worker;
        block25: {
            int n;
            block4: while (true) {
                int bl22;
                block27: {
                    block28: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                        bl22 = this.ctl.get();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
                        n = ThreadPoolExecutor.runStateOf(bl22);
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block27;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) break block28;
                        RuntimeCostAccounter.recordJump();
                        if (runnable != null) break block28;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                        boolean bl3 = this.workQueue.isEmpty();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block27;
                    }
                    return false;
                }
                while (true) {
                    block30: {
                        block29: {
                            int n2;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                            int n3 = ThreadPoolExecutor.workerCountOf(bl22);
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= 0x1FFFFFFF) break block29;
                            RuntimeCostAccounter.recordJump();
                            if (bl) {
                                n2 = this.corePoolSize;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                n2 = this.maximumPoolSize;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n3 < n2) break block30;
                        }
                        return false;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.compareAndIncrementWorkerCount:(I)Z");
                    boolean bl4 = this.compareAndIncrementWorkerCount(bl22);
                    RuntimeCostAccounter.recordJump();
                    if (bl4) break block4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                    bl22 = this.ctl.get();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
                    int n4 = ThreadPoolExecutor.runStateOf(bl22);
                    RuntimeCostAccounter.recordJump();
                    if (n4 != n) {
                        RuntimeCostAccounter.recordJump();
                        continue block4;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
            RuntimeCostAccounter.recordJump();
            boolean bl5 = false;
            n = 0;
            worker = null;
            try {
                ReentrantLock reentrantLock;
                Thread thread;
                block26: {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor$Worker");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.<init>:(Ljava/util/concurrent/ThreadPoolExecutor;Ljava/lang/Runnable;)V");
                    worker = new Worker(runnable);
                    thread = worker.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread == null) break block25;
                    reentrantLock = this.mainLock;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                    reentrantLock.lock();
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                        int n5 = this.ctl.get();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
                        int n6 = ThreadPoolExecutor.runStateOf(n5);
                        RuntimeCostAccounter.recordJump();
                        if (n6 >= 0) {
                            RuntimeCostAccounter.recordJump();
                            if (n6 != 0) break block26;
                            RuntimeCostAccounter.recordJump();
                            if (runnable != null) break block26;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
                        boolean bl6 = thread.isAlive();
                        RuntimeCostAccounter.recordJump();
                        if (bl6) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalThreadStateException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalThreadStateException.<init>:()V");
                            IllegalThreadStateException illegalThreadStateException = new IllegalThreadStateException();
                            RuntimeCostAccounter.recordThrow();
                            throw illegalThreadStateException;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.add:(Ljava/lang/Object;)Z");
                        this.workers.add(worker);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.size:()I");
                        int n7 = this.workers.size();
                        RuntimeCostAccounter.recordJump();
                        if (n7 > this.largestPoolSize) {
                            this.largestPoolSize = n7;
                        }
                        n = 1;
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                        reentrantLock.unlock();
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (n == 0) break block25;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.start:()V");
                thread.start();
                bl2 = true;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordJump();
                if (!bl5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorkerFailed:(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V");
                    this.addWorkerFailed(worker);
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorkerFailed:(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V");
            this.addWorkerFailed(worker);
            RuntimeCostAccounter.recordJump();
        }
        return bl2;
    }

    private void addWorkerFailed(Worker worker) {
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordJump();
            if (worker != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.remove:(Ljava/lang/Object;)Z");
                this.workers.remove(worker);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.decrementWorkerCount:()V");
            this.decrementWorkerCount();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
            this.tryTerminate();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker worker, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.decrementWorkerCount:()V");
            this.decrementWorkerCount();
        }
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.remove:(Ljava/lang/Object;)Z");
            this.workers.remove(worker);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateLessThan:(II)Z");
        boolean bl2 = ThreadPoolExecutor.runStateLessThan(n, 0x20000000);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                int n2;
                RuntimeCostAccounter.recordJump();
                if (this.allowCoreThreadTimeOut) {
                    n2 = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n2 = this.corePoolSize;
                }
                int n3 = n2;
                RuntimeCostAccounter.recordJump();
                if (n3 == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                    boolean bl3 = this.workQueue.isEmpty();
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) {
                        n3 = 1;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                int n4 = ThreadPoolExecutor.workerCountOf(n);
                RuntimeCostAccounter.recordJump();
                if (n4 >= n3) {
                    return;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
            this.addWorker(null, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Runnable getTask() {
        var1_1 = false;
        while (true) {
            block17: {
                block18: {
                    block16: {
                        block14: {
                            block15: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                                var2_2 = this.ctl.get();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateOf:(I)I");
                                var3_3 = ThreadPoolExecutor.runStateOf(var2_2);
                                RuntimeCostAccounter.recordJump();
                                if (var3_3 < 0) break block14;
                                RuntimeCostAccounter.recordJump();
                                if (var3_3 >= 0x20000000) break block15;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                                v0 = this.workQueue.isEmpty();
                                RuntimeCostAccounter.recordJump();
                                if (!v0) break block14;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.decrementWorkerCount:()V");
                            this.decrementWorkerCount();
                            return null;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                        var4_4 = ThreadPoolExecutor.workerCountOf(var2_2);
                        RuntimeCostAccounter.recordJump();
                        if (this.allowCoreThreadTimeOut) ** GOTO lbl-1000
                        RuntimeCostAccounter.recordJump();
                        if (var4_4 > this.corePoolSize) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v1 = false;
                        }
                        var5_5 = v1;
                        RuntimeCostAccounter.recordJump();
                        if (var4_4 > this.maximumPoolSize) break block16;
                        RuntimeCostAccounter.recordJump();
                        if (!var5_5) break block17;
                        RuntimeCostAccounter.recordJump();
                        if (!var1_1) break block17;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 > 1) break block18;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                    v2 = this.workQueue.isEmpty();
                    RuntimeCostAccounter.recordJump();
                    if (!v2) break block17;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.compareAndDecrementWorkerCount:(I)Z");
                v3 = this.compareAndDecrementWorkerCount(var2_2);
                RuntimeCostAccounter.recordJump();
                if (!v3) continue;
                return null;
            }
            try {
                RuntimeCostAccounter.recordJump();
                if (var5_5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.poll:(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;");
                    v4 = this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.take:()Ljava/lang/Object;");
                    v4 = this.workQueue.take();
                }
                var6_6 = v4;
                RuntimeCostAccounter.recordJump();
                if (var6_6 != null) {
                    return var6_6;
                }
                var1_1 = true;
            }
            catch (InterruptedException var6_7) {
                var1_1 = false;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void runWorker(Worker worker) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        Runnable runnable = worker.firstTask;
        worker.firstTask = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
        worker.unlock();
        boolean bl = true;
        try {
            while (true) {
                block17: {
                    block16: {
                        RuntimeCostAccounter.recordJump();
                        if (runnable == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getTask:()Ljava/lang/Runnable;");
                            runnable = this.getTask();
                            RuntimeCostAccounter.recordJump();
                            if (runnable == null) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.lock:()V");
                        worker.lock();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                        int n = this.ctl.get();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
                        boolean bl2 = ThreadPoolExecutor.runStateAtLeast(n, 0x20000000);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block16;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                        boolean bl3 = Thread.interrupted();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block17;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                        int n2 = this.ctl.get();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
                        boolean bl4 = ThreadPoolExecutor.runStateAtLeast(n2, 0x20000000);
                        RuntimeCostAccounter.recordJump();
                        if (!bl4) break block17;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                    boolean bl5 = thread.isInterrupted();
                    RuntimeCostAccounter.recordJump();
                    if (!bl5) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                        thread.interrupt();
                    }
                }
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.beforeExecute:(Ljava/lang/Thread;Ljava/lang/Runnable;)V");
                    this.beforeExecute(thread, runnable);
                    Throwable throwable = null;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                        runnable.run();
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            throwable = runtimeException;
                            RuntimeCostAccounter.recordThrow();
                            throw runtimeException;
                            catch (Error error) {
                                throwable = error;
                                RuntimeCostAccounter.recordThrow();
                                throw error;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                                Error error = new Error(throwable2);
                                RuntimeCostAccounter.recordThrow();
                                throw error;
                            }
                        }
                        catch (Throwable throwable3) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.afterExecute:(Ljava/lang/Runnable;Ljava/lang/Throwable;)V");
                            this.afterExecute(runnable, throwable);
                            RuntimeCostAccounter.recordThrow();
                            throw throwable3;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.afterExecute:(Ljava/lang/Runnable;Ljava/lang/Throwable;)V");
                    this.afterExecute(runnable, throwable);
                    RuntimeCostAccounter.recordJump();
                    runnable = null;
                    ++worker.completedTasks;
                }
                catch (Throwable throwable) {
                    runnable = null;
                    ++worker.completedTasks;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
                    worker.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.unlock:()V");
                worker.unlock();
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
            }
            bl = false;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.processWorkerExit:(Ljava/util/concurrent/ThreadPoolExecutor$Worker;Z)V");
            this.processWorkerExit(worker, bl);
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.processWorkerExit:(Ljava/util/concurrent/ThreadPoolExecutor$Worker;Z)V");
        this.processWorkerExit(worker, bl);
        RuntimeCostAccounter.recordJump();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors.defaultThreadFactory:()Ljava/util/concurrent/ThreadFactory;");
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V");
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V");
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors.defaultThreadFactory:()Ljava/util/concurrent/ThreadFactory;");
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V");
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/AbstractExecutorService.<init>:()V");
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.ctlOf:(II)I");
                        int n3 = ThreadPoolExecutor.ctlOf(-536870912, 0);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:(I)V");
                        this.ctl = new AtomicInteger(n3);
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
                        this.mainLock = new ReentrantLock();
                        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:()V");
                        this.workers = new HashSet();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
                        this.termination = this.mainLock.newCondition();
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block4;
                        RuntimeCostAccounter.recordJump();
                        if (n2 <= 0) break block4;
                        RuntimeCostAccounter.recordJump();
                        if (n2 < n) break block4;
                        RuntimeCostAccounter.recordJump();
                        if (l >= 0L) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordJump();
                if (blockingQueue == null) break block6;
                RuntimeCostAccounter.recordJump();
                if (threadFactory == null) break block6;
                RuntimeCostAccounter.recordJump();
                if (rejectedExecutionHandler != null) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(Runnable var1_1) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (var1_1 == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    v0 = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw v0;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                var2_2 = this.ctl.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                v1 = ThreadPoolExecutor.workerCountOf(var2_2);
                RuntimeCostAccounter.recordJump();
                if (v1 < this.corePoolSize) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
                    v2 = this.addWorker(var1_1, true);
                    RuntimeCostAccounter.recordJump();
                    if (v2) {
                        return;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                    var2_2 = this.ctl.get();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isRunning:(I)Z");
                v3 = ThreadPoolExecutor.isRunning(var2_2);
                RuntimeCostAccounter.recordJump();
                if (!v3) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.offer:(Ljava/lang/Object;)Z");
                v4 = this.workQueue.offer(var1_1);
                RuntimeCostAccounter.recordJump();
                if (!v4) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                var3_3 = this.ctl.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isRunning:(I)Z");
                v5 = ThreadPoolExecutor.isRunning(var3_3);
                RuntimeCostAccounter.recordJump();
                if (v5) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.remove:(Ljava/lang/Runnable;)Z");
                v6 = this.remove(var1_1);
                RuntimeCostAccounter.recordJump();
                if (v6) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.reject:(Ljava/lang/Runnable;)V");
                    this.reject(var1_1);
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                    v7 = ThreadPoolExecutor.workerCountOf(var3_3);
                    RuntimeCostAccounter.recordJump();
                    if (v7 == 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
                        this.addWorker(null, false);
                    }
                }
                RuntimeCostAccounter.recordJump();
                break block8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
            v8 = this.addWorker(var1_1, false);
            RuntimeCostAccounter.recordJump();
            if (!v8) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.reject:(Ljava/lang/Runnable;)V");
                this.reject(var1_1);
            }
        }
    }

    @Override
    public void shutdown() {
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.checkShutdownAccess:()V");
            this.checkShutdownAccess();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.advanceRunState:(I)V");
            this.advanceRunState(0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:()V");
            this.interruptIdleWorkers();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.onShutdown:()V");
            this.onShutdown();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.checkShutdownAccess:()V");
            this.checkShutdownAccess();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.advanceRunState:(I)V");
            this.advanceRunState(0x20000000);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptWorkers:()V");
            this.interruptWorkers();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.drainQueue:()Ljava/util/List;");
            list = this.drainQueue();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
        return list;
    }

    @Override
    public boolean isShutdown() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isRunning:(I)Z");
        boolean bl2 = ThreadPoolExecutor.isRunning(n);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminating() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isRunning:(I)Z");
        boolean bl = ThreadPoolExecutor.isRunning(n);
        RuntimeCostAccounter.recordJump();
        if (bl) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateLessThan:(II)Z");
        boolean bl2 = ThreadPoolExecutor.runStateLessThan(n, 0x60000000);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public boolean isTerminated() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
        return ThreadPoolExecutor.runStateAtLeast(n, 0x60000000);
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n = this.ctl.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
            boolean bl2 = ThreadPoolExecutor.runStateAtLeast(n, 0x60000000);
            RuntimeCostAccounter.recordJump();
            if (!bl2) break block5;
            bl = true;
            break;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block6: {
                block5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    return bl;
                }
                RuntimeCostAccounter.recordJump();
                if (l2 > 0L) break block6;
                boolean bl3 = false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return bl3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
            l2 = this.termination.awaitNanos(l2);
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    protected void finalize() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.shutdown:()V");
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordJump();
        if (threadFactory == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        RuntimeCostAccounter.recordJump();
        if (rejectedExecutionHandler == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int n) {
        block2: {
            boolean bl;
            int n2;
            block3: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                n2 = n - this.corePoolSize;
                this.corePoolSize = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                int n3 = this.ctl.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
                int n4 = ThreadPoolExecutor.workerCountOf(n3);
                RuntimeCostAccounter.recordJump();
                if (n4 <= n) break block3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:()V");
                this.interruptIdleWorkers();
                RuntimeCostAccounter.recordJump();
                break block2;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break block2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.size:()I");
            int n5 = this.workQueue.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n6 = Math.min(n2, n5);
            do {
                int n7 = n6--;
                RuntimeCostAccounter.recordJump();
                if (n7 <= 0) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
                boolean bl2 = this.addWorker(null, true);
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.isEmpty:()Z");
                bl = this.workQueue.isEmpty();
                RuntimeCostAccounter.recordJump();
            } while (!bl);
            RuntimeCostAccounter.recordJump();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prestartCoreThread() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
        int n2 = ThreadPoolExecutor.workerCountOf(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.corePoolSize) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
        boolean bl = this.addWorker(null, true);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    void ensurePrestart() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
        int n2 = ThreadPoolExecutor.workerCountOf(n);
        RuntimeCostAccounter.recordJump();
        if (n2 < this.corePoolSize) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
            this.addWorker(null, true);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
                this.addWorker(null, false);
            }
        }
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.addWorker:(Ljava/lang/Runnable;Z)Z");
            boolean bl = this.addWorker(null, true);
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (this.keepAliveTime <= 0L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Core threads must have nonzero keep alive times");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (bl != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = bl;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:()V");
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break block4;
                RuntimeCostAccounter.recordJump();
                if (n >= this.corePoolSize) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.maximumPoolSize = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n2 = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.workerCountOf:(I)I");
        int n3 = ThreadPoolExecutor.workerCountOf(n2);
        RuntimeCostAccounter.recordJump();
        if (n3 > n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:()V");
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.allowsCoreThreadTimeOut:()Z");
            boolean bl = this.allowsCoreThreadTimeOut();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Core threads must have nonzero keep alive times");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        long l3 = l2 - this.keepAliveTime;
        this.keepAliveTime = l2;
        RuntimeCostAccounter.recordJump();
        if (l3 < 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.interruptIdleWorkers:()V");
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.convert:(JLjava/util/concurrent/TimeUnit;)J");
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.remove:(Ljava/lang/Object;)Z");
        boolean bl = this.workQueue.remove(runnable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
        return bl;
    }

    public void purge() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.iterator:()Ljava/util/Iterator;");
            Iterator iterator = blockingQueue.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Runnable runnable = (Runnable)iterator.next();
                boolean bl2 = runnable instanceof Future;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    Future future = (Future)((Object)runnable);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Future.isCancelled:()Z");
                    boolean bl3 = future.isCancelled();
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                        iterator.remove();
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.toArray:()[Ljava/lang/Object;");
            Object[] objectArray = blockingQueue.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Object object = objectArray[n2];
                boolean bl = object instanceof Future;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Future future = (Future)object;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Future.isCancelled:()Z");
                    boolean bl4 = future.isCancelled();
                    RuntimeCostAccounter.recordJump();
                    if (bl4) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.remove:(Ljava/lang/Object;)Z");
                        blockingQueue.remove(object);
                    }
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
    }

    public int getPoolSize() {
        int n;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n3 = this.ctl.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
            boolean bl = ThreadPoolExecutor.runStateAtLeast(n3, 0x40000000);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.size:()I");
                n2 = this.workers.size();
            }
            n = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        int n;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n2 = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Worker worker = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.isLocked:()Z");
                boolean bl2 = worker.isLocked();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    ++n2;
                }
                RuntimeCostAccounter.recordJump();
            }
            n = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    public int getLargestPoolSize() {
        int n;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.largestPoolSize;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        long l;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            long l2 = this.completedTaskCount;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Worker worker = iterator.next();
                l2 += worker.completedTasks;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.isLocked:()Z");
                boolean bl2 = worker.isLocked();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    ++l2;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.size:()I");
            l = l2 + (long)this.workQueue.size();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        long l;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            long l2 = this.completedTaskCount;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Worker worker = iterator.next();
                l2 += worker.completedTasks;
                RuntimeCostAccounter.recordJump();
            }
            l = l2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        String string;
        Object object;
        int n;
        int n2;
        long l;
        ReentrantLock reentrantLock = this.mainLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            l = this.completedTaskCount;
            n2 = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.size:()I");
            n = this.workers.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.iterator:()Ljava/util/Iterator;");
            Iterator<Worker> iterator = this.workers.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    object = iterator.next();
                    l += ((Worker)object).completedTasks;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.isLocked:()Z");
                    boolean bl2 = ((Worker)object).isLocked();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        ++n2;
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n3 = this.ctl.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateLessThan:(II)Z");
        boolean bl = ThreadPoolExecutor.runStateLessThan(n3, 0);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "Running";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runStateAtLeast:(II)Z");
            boolean bl3 = ThreadPoolExecutor.runStateAtLeast(n3, 0x60000000);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                string = "Terminated";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "Shutting down";
            }
        }
        object = string;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string2 = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(", pool size = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(", active threads = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(", queued tasks = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.size:()I");
        int n4 = this.workQueue.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append(", completed tasks = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder13.toString();
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor$AbortPolicy");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$AbortPolicy.<init>:()V");
        defaultHandler = new AbortPolicy();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
        shutdownPerm = new RuntimePermission("modifyThread");
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public DiscardOldestPolicy() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isShutdown:()Z");
            boolean bl = threadPoolExecutor.isShutdown();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
                BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.poll:()Ljava/lang/Object;");
                blockingQueue.poll();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.execute:(Ljava/lang/Runnable;)V");
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public DiscardPolicy() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public AbortPolicy() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/RejectedExecutionException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Task ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            String string = runnable.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" rejected from ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.toString:()Ljava/lang/String;");
            String string2 = threadPoolExecutor.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RejectedExecutionException.<init>:(Ljava/lang/String;)V");
            RejectedExecutionException rejectedExecutionException = new RejectedExecutionException(string3);
            RuntimeCostAccounter.recordThrow();
            throw rejectedExecutionException;
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public CallerRunsPolicy() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.isShutdown:()Z");
            boolean bl = threadPoolExecutor.isShutdown();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                runnable.run();
            }
        }
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.setState:(I)V");
            this.setState(-1);
            this.firstTask = runnable;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getThreadFactory:()Ljava/util/concurrent/ThreadFactory;");
            ThreadFactory threadFactory = ThreadPoolExecutor.this.getThreadFactory();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadFactory.newThread:(Ljava/lang/Runnable;)Ljava/lang/Thread;");
            this.thread = threadFactory.newThread(this);
        }

        @Override
        public void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.runWorker:(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V");
            ThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected boolean tryAcquire(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.compareAndSetState:(II)Z");
            boolean bl = this.compareAndSetState(0, 1);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                this.setExclusiveOwnerThread(thread);
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
            this.setExclusiveOwnerThread(null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.setState:(I)V");
            this.setState(0);
            return true;
        }

        public void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.acquire:(I)V");
            this.acquire(1);
        }

        public boolean tryLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.tryAcquire:(I)Z");
            return this.tryAcquire(1);
        }

        public void unlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.release:(I)Z");
            this.release(1);
        }

        public boolean isLocked() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.isHeldExclusively:()Z");
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor$Worker.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                Thread thread = this.thread;
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                    boolean bl = thread.isInterrupted();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                            thread.interrupt();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
    }
}

