/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.Collection;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Semaphore$NonfairSync");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$NonfairSync.<init>:(I)V");
        this.sync = new NonfairSync(n);
    }

    public Semaphore(int n, boolean bl) {
        Sync sync;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Semaphore$FairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$FairSync.<init>:(I)V");
            sync = new FairSync(n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Semaphore$NonfairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$NonfairSync.<init>:(I)V");
            sync = new NonfairSync(n);
        }
        this.sync = sync;
    }

    public void acquire() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.acquireSharedInterruptibly:(I)V");
        this.sync.acquireSharedInterruptibly(1);
    }

    public void acquireUninterruptibly() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.acquireShared:(I)V");
        this.sync.acquireShared(1);
    }

    public boolean tryAcquire() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.nonfairTryAcquireShared:(I)I");
        int n = this.sync.nonfairTryAcquireShared(1);
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.tryAcquireSharedNanos:(IJ)Z");
        return this.sync.tryAcquireSharedNanos(1, l2);
    }

    public void release() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.releaseShared:(I)Z");
        this.sync.releaseShared(1);
    }

    public void acquire(int n) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.acquireSharedInterruptibly:(I)V");
        this.sync.acquireSharedInterruptibly(n);
    }

    public void acquireUninterruptibly(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.acquireShared:(I)V");
        this.sync.acquireShared(n);
    }

    public boolean tryAcquire(int n) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.nonfairTryAcquireShared:(I)I");
        int n2 = this.sync.nonfairTryAcquireShared(n);
        RuntimeCostAccounter.recordJump();
        if (n2 >= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean tryAcquire(int n, long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.tryAcquireSharedNanos:(IJ)Z");
        return this.sync.tryAcquireSharedNanos(n, l2);
    }

    public void release(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.releaseShared:(I)Z");
        this.sync.releaseShared(n);
    }

    public int availablePermits() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getPermits:()I");
        return this.sync.getPermits();
    }

    public int drainPermits() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.drainPermits:()I");
        return this.sync.drainPermits();
    }

    protected void reducePermits(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.reducePermits:(I)V");
        this.sync.reducePermits(n);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.hasQueuedThreads:()Z");
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getQueueLength:()I");
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getQueuedThreads:()Ljava/util/Collection;");
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[Permits = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getPermits:()I");
        int n = this.sync.getPermits();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = 2014338818796000944L;

        FairSync(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.<init>:(I)V");
            super(n);
        }

        @Override
        protected int tryAcquireShared(int n) {
            while (true) {
                block6: {
                    int n2;
                    block5: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$FairSync.hasQueuedPredecessors:()Z");
                        boolean bl = this.hasQueuedPredecessors();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            return -1;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$FairSync.getState:()I");
                        int n3 = this.getState();
                        n2 = n3 - n;
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 0) break block5;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$FairSync.compareAndSetState:(II)Z");
                        boolean bl2 = this.compareAndSetState(n3, n2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block6;
                    }
                    return n2;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        NonfairSync(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.<init>:(I)V");
            super(n);
        }

        @Override
        protected int tryAcquireShared(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$NonfairSync.nonfairTryAcquireShared:(I)I");
            return this.nonfairTryAcquireShared(n);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1192457210091910933L;

        Sync(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.setState:(I)V");
            this.setState(n);
        }

        final int getPermits() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getState:()I");
            return this.getState();
        }

        final int nonfairTryAcquireShared(int n) {
            while (true) {
                block4: {
                    int n2;
                    block3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getState:()I");
                        int n3 = this.getState();
                        n2 = n3 - n;
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 0) break block3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.compareAndSetState:(II)Z");
                        boolean bl = this.compareAndSetState(n3, n2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block4;
                    }
                    return n2;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        protected final boolean tryReleaseShared(int n) {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getState:()I");
                int n2 = this.getState();
                int n3 = n2 + n;
                RuntimeCostAccounter.recordJump();
                if (n3 < n2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                    Error error = new Error("Maximum permit count exceeded");
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.compareAndSetState:(II)Z");
                boolean bl = this.compareAndSetState(n2, n3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        final void reducePermits(int n) {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getState:()I");
                int n2 = this.getState();
                int n3 = n2 - n;
                RuntimeCostAccounter.recordJump();
                if (n3 > n2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                    Error error = new Error("Permit count underflow");
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.compareAndSetState:(II)Z");
                boolean bl = this.compareAndSetState(n2, n3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        final int drainPermits() {
            while (true) {
                block4: {
                    int n;
                    block3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.getState:()I");
                        n = this.getState();
                        RuntimeCostAccounter.recordJump();
                        if (n == 0) break block3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Semaphore$Sync.compareAndSetState:(II)Z");
                        boolean bl = this.compareAndSetState(n, 0);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block4;
                    }
                    return n;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }
}

