/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.ForkJoinPool;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.atomic.AtomicReference;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int MAX_PARTIES = 65535;
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private static final int PARTIES_SHIFT = 16;
    private static final int PHASE_SHIFT = 32;
    private static final int UNARRIVED_MASK = 65535;
    private static final long PARTIES_MASK = 0xFFFF0000L;
    private static final long COUNTS_MASK = 0xFFFFFFFFL;
    private static final long TERMINATION_BIT = Long.MIN_VALUE;
    private static final int ONE_ARRIVAL = 1;
    private static final int ONE_PARTY = 65536;
    private static final int ONE_DEREGISTER = 65537;
    private static final int EMPTY = 1;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ;
    private final AtomicReference<QNode> oddQ;
    private static final int NCPU;
    static final int SPINS_PER_ARRIVAL;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;

    private static int unarrivedOf(long l) {
        int n;
        int n2 = (int)l;
        RuntimeCostAccounter.recordJump();
        if (n2 == 1) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = n2 & 0xFFFF;
        }
        return n;
    }

    private static int partiesOf(long l) {
        return (int)l >>> 16;
    }

    private static int phaseOf(long l) {
        return (int)(l >>> 32);
    }

    private static int arrivedOf(long l) {
        int n;
        int n2 = (int)l;
        RuntimeCostAccounter.recordJump();
        if (n2 == 1) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = (n2 >>> 16) - (n2 & 0xFFFF);
        }
        return n;
    }

    private AtomicReference<QNode> queueFor(int n) {
        AtomicReference<QNode> atomicReference;
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 0) {
            atomicReference = this.evenQ;
            RuntimeCostAccounter.recordJump();
        } else {
            atomicReference = this.oddQ;
        }
        return atomicReference;
    }

    private String badArrive(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Attempted arrival of unregistered party for ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.stateToString:(J)Ljava/lang/String;");
        String string = this.stateToString(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    private String badRegister(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Attempt to register more than 65535 parties for ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.stateToString:(J)Ljava/lang/String;");
        String string = this.stateToString(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    private int doArrive(int n) {
        Phaser phaser = this.root;
        while (true) {
            int n2;
            long l;
            RuntimeCostAccounter.recordJump();
            if (phaser == this) {
                l = this.state;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
                l = this.reconcileState();
            }
            long l2 = l;
            int n3 = (int)(l2 >>> 32);
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) {
                return n3;
            }
            int n4 = (int)l2;
            RuntimeCostAccounter.recordJump();
            if (n4 == 1) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n4 & 0xFFFF;
            }
            int n5 = n2;
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.badArrive:(J)Ljava/lang/String;");
                String string = this.badArrive(l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l2 -= (long)n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (n5 == 1) {
                    long l3 = l2 & 0xFFFF0000L;
                    int n6 = (int)l3 >>> 16;
                    RuntimeCostAccounter.recordJump();
                    if (phaser == this) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.onAdvance:(II)Z");
                        boolean bl2 = this.onAdvance(n3, n6);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            l3 |= Long.MIN_VALUE;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordJump();
                            if (n6 == 0) {
                                l3 |= 1L;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                l3 |= (long)n6;
                            }
                        }
                        int n7 = n3 + 1 & Integer.MAX_VALUE;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                        UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l3 |= (long)n7 << 32);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
                        this.releaseWaiters(n3);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n6 == 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doArrive:(I)I");
                            n3 = this.parent.doArrive(65537);
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l2 | 1L);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doArrive:(I)I");
                            n3 = this.parent.doArrive(1);
                        }
                    }
                }
                return n3;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int doRegister(int n) {
        int n2;
        long l = (long)n << 16 | (long)n;
        Phaser phaser = this.parent;
        while (true) {
            block22: {
                long l2;
                block20: {
                    int n3;
                    block21: {
                        long l3;
                        RuntimeCostAccounter.recordJump();
                        if (phaser == null) {
                            l3 = this.state;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
                            l3 = this.reconcileState();
                        }
                        l2 = l3;
                        int n4 = (int)l2;
                        int n5 = n4 >>> 16;
                        n3 = n4 & 0xFFFF;
                        RuntimeCostAccounter.recordJump();
                        if (n > 65535 - n5) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.badRegister:(J)Ljava/lang/String;");
                            String string = this.badRegister(l2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                            IllegalStateException illegalStateException = new IllegalStateException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw illegalStateException;
                        }
                        n2 = (int)(l2 >>> 32);
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 0) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n4 == 1) break block20;
                        RuntimeCostAccounter.recordJump();
                        if (phaser == null) break block21;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
                        long l4 = this.reconcileState() - l2;
                        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l5 != false) break block22;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n3 == 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.internalAwaitAdvance:(ILjava/util/concurrent/Phaser$QNode;)I");
                        this.root.internalAwaitAdvance(n2, null);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                        boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l2 + l);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                    }
                    break block22;
                }
                RuntimeCostAccounter.recordJump();
                if (phaser == null) {
                    long l6 = (long)n2 << 32 | l;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                    boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l6);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    block18: {
                        block19: {
                            RuntimeCostAccounter.recordJump();
                            if (this.state != l2) break block18;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doRegister:(I)I");
                            n2 = phaser.doRegister(1);
                            RuntimeCostAccounter.recordJump();
                            if (n2 >= 0) break block19;
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        while (true) {
                            long l7 = (long)n2 << 32 | l;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                            boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l7);
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                            l2 = this.state;
                            n2 = (int)(this.root.state >>> 32);
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                break block22;
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    private long reconcileState() {
        Phaser phaser = this.root;
        long l = this.state;
        RuntimeCostAccounter.recordJump();
        if (phaser != this) {
            while (true) {
                long l2;
                int n = (int)(phaser.state >>> 32);
                int n2 = (int)(l >>> 32);
                RuntimeCostAccounter.recordJump();
                if (n == n2) break;
                long l3 = l;
                long l4 = (long)n << 32;
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    l2 = l & 0xFFFFFFFFL;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n3 = (int)l >>> 16;
                    RuntimeCostAccounter.recordJump();
                    if (n3 == 0) {
                        l2 = 1L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l2 = l & 0xFFFF0000L | (long)n3;
                    }
                }
                l = l4 | l2;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l3, l);
                RuntimeCostAccounter.recordJump();
                if (bl) break;
                l = this.state;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l;
    }

    public Phaser() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.<init>:(Ljava/util/concurrent/Phaser;I)V");
        this(null, 0);
    }

    public Phaser(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.<init>:(Ljava/util/concurrent/Phaser;I)V");
        this(null, n);
    }

    public Phaser(Phaser phaser) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.<init>:(Ljava/util/concurrent/Phaser;I)V");
        this(phaser, 0);
    }

    public Phaser(Phaser phaser, int n) {
        long l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n >>> 16 != 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal number of parties");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = 0;
        this.parent = phaser;
        RuntimeCostAccounter.recordJump();
        if (phaser != null) {
            Phaser phaser2;
            this.root = phaser2 = phaser.root;
            this.evenQ = phaser2.evenQ;
            this.oddQ = phaser2.oddQ;
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doRegister:(I)I");
                n2 = phaser.doRegister(1);
            }
            RuntimeCostAccounter.recordJump();
        } else {
            this.root = this;
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicReference");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.<init>:()V");
            this.evenQ = new AtomicReference();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicReference");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.<init>:()V");
            this.oddQ = new AtomicReference();
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            l = 1L;
            RuntimeCostAccounter.recordJump();
        } else {
            l = (long)n2 << 32 | (long)n << 16 | (long)n;
        }
        this.state = l;
    }

    public int register() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doRegister:(I)I");
        return this.doRegister(1);
    }

    public int bulkRegister(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.getPhase:()I");
            return this.getPhase();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doRegister:(I)I");
        return this.doRegister(n);
    }

    public int arrive() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doArrive:(I)I");
        return this.doArrive(1);
    }

    public int arriveAndDeregister() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.doArrive:(I)I");
        return this.doArrive(65537);
    }

    public int arriveAndAwaitAdvance() {
        Phaser phaser = this.root;
        while (true) {
            int n;
            long l;
            RuntimeCostAccounter.recordJump();
            if (phaser == this) {
                l = this.state;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
                l = this.reconcileState();
            }
            long l2 = l;
            int n2 = (int)(l2 >>> 32);
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                return n2;
            }
            int n3 = (int)l2;
            RuntimeCostAccounter.recordJump();
            if (n3 == 1) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = n3 & 0xFFFF;
            }
            int n4 = n;
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.badArrive:(J)Ljava/lang/String;");
                String string = this.badArrive(l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            long l3 = l2--;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
            boolean bl = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l3, l2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (n4 > 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.internalAwaitAdvance:(ILjava/util/concurrent/Phaser$QNode;)I");
                    return phaser.internalAwaitAdvance(n2, null);
                }
                RuntimeCostAccounter.recordJump();
                if (phaser != this) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.arriveAndAwaitAdvance:()I");
                    return this.parent.arriveAndAwaitAdvance();
                }
                long l4 = l2 & 0xFFFF0000L;
                int n5 = (int)l4 >>> 16;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.onAdvance:(II)Z");
                boolean bl2 = this.onAdvance(n2, n5);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    l4 |= Long.MIN_VALUE;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n5 == 0) {
                        l4 |= 1L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l4 |= (long)n5;
                    }
                }
                int n6 = n2 + 1 & Integer.MAX_VALUE;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                boolean bl3 = UNSAFE.compareAndSwapLong((Object)this, stateOffset, l2, l4 |= (long)n6 << 32);
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    return (int)(this.state >>> 32);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
                this.releaseWaiters(n2);
                return n6;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public int awaitAdvance(int n) {
        long l;
        Phaser phaser = this.root;
        RuntimeCostAccounter.recordJump();
        if (phaser == this) {
            l = this.state;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
            l = this.reconcileState();
        }
        long l2 = l;
        int n2 = (int)(l2 >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return n;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.internalAwaitAdvance:(ILjava/util/concurrent/Phaser$QNode;)I");
            return phaser.internalAwaitAdvance(n, null);
        }
        return n2;
    }

    public int awaitAdvanceInterruptibly(int n) throws InterruptedException {
        long l;
        Phaser phaser = this.root;
        RuntimeCostAccounter.recordJump();
        if (phaser == this) {
            l = this.state;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
            l = this.reconcileState();
        }
        long l2 = l;
        int n2 = (int)(l2 >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return n;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Phaser$QNode");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.<init>:(Ljava/util/concurrent/Phaser;IZZJ)V");
            QNode qNode = new QNode(this, n, true, false, 0L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.internalAwaitAdvance:(ILjava/util/concurrent/Phaser$QNode;)I");
            n2 = phaser.internalAwaitAdvance(n, qNode);
            boolean bl = qNode.wasInterrupted;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
        }
        return n2;
    }

    public int awaitAdvanceInterruptibly(int n, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l3 = timeUnit.toNanos(l);
        Phaser phaser = this.root;
        RuntimeCostAccounter.recordJump();
        if (phaser == this) {
            l2 = this.state;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
            l2 = this.reconcileState();
        }
        long l4 = l2;
        int n2 = (int)(l4 >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return n;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Phaser$QNode");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.<init>:(Ljava/util/concurrent/Phaser;IZZJ)V");
            QNode qNode = new QNode(this, n, true, true, l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.internalAwaitAdvance:(ILjava/util/concurrent/Phaser$QNode;)I");
            n2 = phaser.internalAwaitAdvance(n, qNode);
            boolean bl = qNode.wasInterrupted;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/TimeoutException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeoutException.<init>:()V");
                TimeoutException timeoutException = new TimeoutException();
                RuntimeCostAccounter.recordThrow();
                throw timeoutException;
            }
        }
        return n2;
    }

    public void forceTermination() {
        block1: {
            boolean bl;
            Phaser phaser = this.root;
            do {
                long l = phaser.state;
                RuntimeCostAccounter.recordJump();
                if (l < 0L) break block1;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
                bl = UNSAFE.compareAndSwapLong((Object)phaser, stateOffset, l, l | Long.MIN_VALUE);
                RuntimeCostAccounter.recordJump();
            } while (!bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
            this.releaseWaiters(0);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
            this.releaseWaiters(1);
            return;
        }
    }

    public final int getPhase() {
        return (int)(this.root.state >>> 32);
    }

    public int getRegisteredParties() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.partiesOf:(J)I");
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
        long l = this.reconcileState();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.arrivedOf:(J)I");
        return Phaser.arrivedOf(l);
    }

    public int getUnarrivedParties() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
        long l = this.reconcileState();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.unarrivedOf:(J)I");
        return Phaser.unarrivedOf(l);
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        boolean bl;
        long l = this.root.state - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean onAdvance(int n, int n2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.reconcileState:()J");
        long l = this.reconcileState();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.stateToString:(J)Ljava/lang/String;");
        return this.stateToString(l);
    }

    private String stateToString(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[phase = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.phaseOf:(J)I");
        int n = Phaser.phaseOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(" parties = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.partiesOf:(J)I");
        int n2 = Phaser.partiesOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(" arrived = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.arrivedOf:(J)I");
        int n3 = Phaser.arrivedOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder9.toString();
    }

    private void releaseWaiters(int n) {
        AtomicReference<QNode> atomicReference;
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 0) {
            atomicReference = this.evenQ;
            RuntimeCostAccounter.recordJump();
        } else {
            atomicReference = this.oddQ;
        }
        AtomicReference<QNode> atomicReference2 = atomicReference;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
            QNode qNode = atomicReference2.get();
            RuntimeCostAccounter.recordJump();
            if (qNode == null) break;
            int n2 = qNode.phase;
            int n3 = (int)(this.root.state >>> 32);
            RuntimeCostAccounter.recordJump();
            if (n2 == n3) break;
            QNode qNode2 = qNode.next;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = atomicReference2.compareAndSet(qNode, qNode2);
            RuntimeCostAccounter.recordJump();
            if (!bl) continue;
            Thread thread = qNode.thread;
            RuntimeCostAccounter.recordJump();
            if (thread == null) continue;
            qNode.thread = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
            LockSupport.unpark(thread);
            RuntimeCostAccounter.recordJump();
        }
    }

    private int abortWait(int n) {
        AtomicReference<QNode> atomicReference;
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 0) {
            atomicReference = this.evenQ;
            RuntimeCostAccounter.recordJump();
        } else {
            atomicReference = this.oddQ;
        }
        AtomicReference<QNode> atomicReference2 = atomicReference;
        while (true) {
            Thread thread;
            QNode qNode;
            block9: {
                int n2;
                block8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
                    qNode = atomicReference2.get();
                    n2 = (int)(this.root.state >>> 32);
                    RuntimeCostAccounter.recordJump();
                    if (qNode == null) break block8;
                    thread = qNode.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread == null) break block9;
                    int n3 = qNode.phase;
                    RuntimeCostAccounter.recordJump();
                    if (n3 != n2) break block9;
                }
                return n2;
            }
            QNode qNode2 = qNode.next;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = atomicReference2.compareAndSet(qNode, qNode2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    qNode.thread = null;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
                    LockSupport.unpark(thread);
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private int internalAwaitAdvance(int n, QNode qNode) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
        this.releaseWaiters(n - 1);
        boolean bl = false;
        int n3 = 0;
        int n4 = SPINS_PER_ARRIVAL;
        while (true) {
            block24: {
                block26: {
                    QNode qNode2;
                    AtomicReference<QNode> atomicReference;
                    block25: {
                        AtomicReference<QNode> atomicReference2;
                        block21: {
                            block23: {
                                boolean bl2;
                                block22: {
                                    long l = this.state;
                                    n2 = (int)(l >>> 32);
                                    RuntimeCostAccounter.recordJump();
                                    if (n2 != n) break;
                                    RuntimeCostAccounter.recordJump();
                                    if (qNode != null) break block21;
                                    int n5 = (int)l & 0xFFFF;
                                    RuntimeCostAccounter.recordJump();
                                    if (n5 != n3) {
                                        n3 = n5;
                                        RuntimeCostAccounter.recordJump();
                                        if (n3 < NCPU) {
                                            n4 += SPINS_PER_ARRIVAL;
                                        }
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                                    bl2 = Thread.interrupted();
                                    RuntimeCostAccounter.recordJump();
                                    if (bl2) break block22;
                                    RuntimeCostAccounter.recordJump();
                                    if (--n4 >= 0) break block23;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Phaser$QNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.<init>:(Ljava/util/concurrent/Phaser;IZZJ)V");
                                qNode = new QNode(this, n, false, false, 0L);
                                qNode.wasInterrupted = bl2;
                            }
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.isReleasable:()Z");
                        boolean bl3 = qNode.isReleasable();
                        RuntimeCostAccounter.recordJump();
                        if (bl3) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block24;
                        RuntimeCostAccounter.recordJump();
                        if ((n & 1) == 0) {
                            atomicReference2 = this.evenQ;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            atomicReference2 = this.oddQ;
                        }
                        atomicReference = atomicReference2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
                        qNode2 = qNode.next = atomicReference.get();
                        RuntimeCostAccounter.recordJump();
                        if (qNode2 == null) break block25;
                        int n6 = qNode2.phase;
                        RuntimeCostAccounter.recordJump();
                        if (n6 != n) break block26;
                    }
                    int n7 = (int)(this.state >>> 32);
                    RuntimeCostAccounter.recordJump();
                    if (n7 == n) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                        bl = atomicReference.compareAndSet(qNode2, qNode);
                    }
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.managedBlock:(Ljava/util/concurrent/ForkJoinPool$ManagedBlocker;)V");
                ForkJoinPool.managedBlock(qNode);
            }
            catch (InterruptedException interruptedException) {
                qNode.wasInterrupted = true;
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            continue;
            break;
        }
        RuntimeCostAccounter.recordJump();
        if (qNode != null) {
            Thread thread = qNode.thread;
            RuntimeCostAccounter.recordJump();
            if (thread != null) {
                qNode.thread = null;
            }
            boolean bl4 = qNode.wasInterrupted;
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                boolean bl5 = qNode.interruptible;
                RuntimeCostAccounter.recordJump();
                if (!bl5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                    Thread thread2 = Thread.currentThread();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                    thread2.interrupt();
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                n2 = (int)(this.state >>> 32);
                RuntimeCostAccounter.recordJump();
                if (n2 == n) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.abortWait:(I)I");
                    return this.abortWait(n);
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.releaseWaiters:(I)V");
        this.releaseWaiters(n);
        return n2;
    }

    static {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        NCPU = runtime.availableProcessors();
        RuntimeCostAccounter.recordJump();
        if (NCPU < 2) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 256;
        }
        SPINS_PER_ARRIVAL = n;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<Phaser> clazz = Phaser.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("state");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            stateOffset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final boolean interruptible;
        final boolean timed;
        boolean wasInterrupted;
        long nanos;
        final long deadline;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int n, boolean bl, boolean bl2, long l) {
            long l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.phaser = phaser;
            this.phase = n;
            this.interruptible = bl;
            this.nanos = l;
            this.timed = bl2;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = System.nanoTime() + l;
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = 0L;
            }
            this.deadline = l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            RuntimeCostAccounter.recordJump();
            if (this.thread == null) {
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser.getPhase:()I");
            int n = this.phaser.getPhase();
            RuntimeCostAccounter.recordJump();
            if (n != this.phase) {
                this.thread = null;
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.wasInterrupted = true;
            }
            RuntimeCostAccounter.recordJump();
            if (this.wasInterrupted) {
                RuntimeCostAccounter.recordJump();
                if (this.interruptible) {
                    this.thread = null;
                    return true;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (this.timed) {
                RuntimeCostAccounter.recordJump();
                if (this.nanos > 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                    this.nanos = this.deadline - System.nanoTime();
                }
                RuntimeCostAccounter.recordJump();
                if (this.nanos <= 0L) {
                    this.thread = null;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean block() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.isReleasable:()Z");
            boolean bl = this.isReleasable();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            RuntimeCostAccounter.recordJump();
            if (!this.timed) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                LockSupport.park(this);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.nanos > 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, this.nanos);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Phaser$QNode.isReleasable:()Z");
            return this.isReleasable();
        }
    }
}

