/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.BrokenBarrierException;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock;
    private final Condition trip;
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation;
    private int count;

    private void nextGeneration() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signalAll:()V");
        this.trip.signalAll();
        this.count = this.parties;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CyclicBarrier$Generation");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier$Generation.<init>:(Ljava/util/concurrent/CyclicBarrier$1;)V");
        this.generation = new Generation(null);
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signalAll:()V");
        this.trip.signalAll();
    }

    /*
     * Exception decompiling
     */
    private int dowait(boolean var1_1, long var2_2) throws InterruptedException, BrokenBarrierException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CyclicBarrier(int n, Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.lock = new ReentrantLock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.trip = this.lock.newCondition();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CyclicBarrier$Generation");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier$Generation.<init>:(Ljava/util/concurrent/CyclicBarrier$1;)V");
        this.generation = new Generation(null);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.parties = n;
        this.count = n;
        this.barrierCommand = runnable;
    }

    public CyclicBarrier(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier.<init>:(ILjava/lang/Runnable;)V");
        this(n, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier.dowait:(ZJ)I");
            return this.dowait(false, 0L);
        }
        catch (TimeoutException timeoutException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(timeoutException);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
    }

    public int await(long l, TimeUnit timeUnit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier.dowait:(ZJ)I");
        return this.dowait(true, l2);
    }

    public boolean isBroken() {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            bl = this.generation.broken;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    public void reset() {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier.breakBarrier:()V");
            this.breakBarrier();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier.nextGeneration:()V");
            this.nextGeneration();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    public int getNumberWaiting() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.parties - this.count;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    private static class Generation {
        boolean broken;

        private Generation() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.broken = false;
        }

        /* synthetic */ Generation(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CyclicBarrier$Generation.<init>:()V");
            this();
        }
    }
}

