/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Function;

public interface ConcurrentMap<K, V>
extends Map<K, V> {
    @Override
    default public V getOrDefault(Object object, V v) {
        Object v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object v3 = this.get(object);
        RuntimeCostAccounter.recordJump();
        if (v3 != null) {
            v2 = v3;
            RuntimeCostAccounter.recordJump();
        } else {
            v2 = v;
        }
        return v2;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.entrySet:()Ljava/util/Set;");
        Set set = this.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator iterator = set.iterator();
        while (true) {
            Object v;
            Object k;
            block3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry entry = iterator.next();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    k = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    v = entry.getValue();
                }
                catch (IllegalStateException illegalStateException) {
                    RuntimeCostAccounter.recordJump();
                }
                break block3;
                continue;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept(k, v);
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public V putIfAbsent(K var1, V var2);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public V replace(K var1, V var2);

    @Override
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        BiConsumer<Object, Object> biConsumer = (object, object2) -> {
            block1: {
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    Object r = biFunction.apply((K)object, (V)object2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = this.replace(object, object2, r);
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    object2 = this.get(object);
                    RuntimeCostAccounter.recordJump();
                } while (object2 != null);
                RuntimeCostAccounter.recordJump();
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.forEach:(Ljava/util/function/BiConsumer;)V");
        this.forEach(biConsumer);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        Object v;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object v2 = this.get(k);
        RuntimeCostAccounter.recordJump();
        if (v2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            V v3 = function.apply(k);
            RuntimeCostAccounter.recordJump();
            if (v3 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                v2 = this.putIfAbsent(k, v3);
                RuntimeCostAccounter.recordJump();
                if (v2 == null) {
                    v = v3;
                    RuntimeCostAccounter.recordJump();
                    return v;
                }
            }
        }
        v = v2;
        return v;
    }

    @Override
    default public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object v;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            v = this.get(k);
            RuntimeCostAccounter.recordJump();
            if (v == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            V v2 = biFunction.apply(k, v);
            RuntimeCostAccounter.recordJump();
            if (v2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = this.replace(k, v, v2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return v2;
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = this.remove(k, v);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return null;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object v = this.get(k);
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            V v2 = biFunction.apply(k, v);
            RuntimeCostAccounter.recordJump();
            if (v2 == null) {
                RuntimeCostAccounter.recordJump();
                if (v == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl = this.containsKey(k);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) return null;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = this.remove(k, v);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return null;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                v = this.get(k);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (v != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = this.replace(k, v, v2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return v2;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    v = this.get(k);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    v = this.putIfAbsent(k, v2);
                    RuntimeCostAccounter.recordJump();
                    if (v == null) {
                        return v2;
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    default public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object v2 = this.get(k);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (v2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                V v3 = biFunction.apply(v2, v);
                RuntimeCostAccounter.recordJump();
                if (v3 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = this.replace(k, v2, v3);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return v3;
                    }
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = this.remove(k, v2);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return null;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                v2 = this.get(k);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            v2 = this.putIfAbsent(k, v);
            RuntimeCostAccounter.recordJump();
            if (v2 == null) break;
        }
        return v;
    }
}

