/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.io.Serializable;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Comparator;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.NavigableMap;
import sandbox.java.util.NavigableSet;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.SortedMap;
import sandbox.java.util.SortedSet;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Consumer;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
sandbox.java.io.Serializable {
    private final Comparator<? super K> comparator;
    private transient Entry<K, V> root;
    private transient int size;
    private transient int modCount;
    private transient EntrySet entrySet;
    private transient KeySet<K> navigableKeySet;
    private transient NavigableMap<K, V> descendingMap;
    private static final Object UNBOUNDED;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        this.comparator = null;
    }

    public TreeMap(Comparator<? super K> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        this.comparator = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.putAll:(Ljava/util/Map;)V");
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.comparator:()Ljava/util/Comparator;");
        this.comparator = sortedMap.comparator();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.size:()I");
            int n = sortedMap.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.entrySet:()Ljava/util/Set;");
            Set<Map.Entry<K, V>> set = sortedMap.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<Map.Entry<K, ? extends V>> iterator = set.iterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
            this.buildFromSorted(n, iterator, null, null);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordJump();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getEntry(object);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            Object v = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = TreeMap.valEquals(object, v);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            entry = TreeMap.successor(entry);
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public V get(Object object) {
        V v;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getEntry(object);
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            v = null;
            RuntimeCostAccounter.recordJump();
        } else {
            v = entry.value;
        }
        return v;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.key:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.key(entry);
    }

    @Override
    public K lastKey() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLastEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.key:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.key(entry);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        block3: {
            int n;
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
                n = map.size();
                RuntimeCostAccounter.recordJump();
                if (this.size != 0) break block3;
                RuntimeCostAccounter.recordJump();
                if (n == 0) break block3;
                boolean bl = map instanceof SortedMap;
                RuntimeCostAccounter.recordJump();
                if (!bl) break block3;
                SortedMap sortedMap = (SortedMap)map;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.comparator:()Ljava/util/Comparator;");
                Comparator comparator = sortedMap.comparator();
                RuntimeCostAccounter.recordJump();
                if (comparator == this.comparator) break block4;
                RuntimeCostAccounter.recordJump();
                if (comparator == null) break block3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = comparator.equals(this.comparator);
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block3;
            }
            ++this.modCount;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set<Map.Entry<K, V>> set = map.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Iterator<Map.Entry<? extends K, ? extends V>> iterator = set.iterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
                this.buildFromSorted(n, iterator, null, null);
            }
            catch (IOException iOException) {
                RuntimeCostAccounter.recordJump();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.putAll:(Ljava/util/Map;)V");
        super.putAll(map);
    }

    final Entry<K, V> getEntry(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this.comparator != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntryUsingComparator:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.getEntryUsingComparator(object);
        }
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        Comparable comparable = (Comparable)object;
        Entry<K, V> entry = this.root;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            Object k = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n = comparable.compareTo(k);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                entry = entry.left;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n > 0) {
                    entry = entry.right;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return entry;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    final Entry<K, V> getEntryUsingComparator(Object object) {
        Object object2 = object;
        Comparator<K> comparator = this.comparator;
        RuntimeCostAccounter.recordJump();
        if (comparator != null) {
            Entry<K, V> entry = this.root;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Object k = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                int n = comparator.compare(object2, k);
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    entry = entry.left;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n > 0) {
                        entry = entry.right;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        return entry;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Entry<K, V> getCeilingEntry(K k) {
        Entry<K, V> entry = this.root;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) return null;
            Object k2 = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = this.compare(k, k2);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                Entry entry2 = entry.left;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) return entry;
                entry = entry.left;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n <= 0) return entry;
                Entry entry3 = entry.right;
                RuntimeCostAccounter.recordJump();
                if (entry3 != null) {
                    entry = entry.right;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Entry entry4 = entry.parent;
                    Entry<K, V> entry5 = entry;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (entry4 == null) return entry4;
                        Entry entry6 = entry4.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry5 != entry6) return entry4;
                        entry5 = entry4;
                        entry4 = entry4.parent;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Entry<K, V> getFloorEntry(K k) {
        Entry<K, V> entry = this.root;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) return null;
            Object k2 = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = this.compare(k, k2);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                Entry entry2 = entry.right;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) return entry;
                entry = entry.right;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n >= 0) return entry;
                Entry entry3 = entry.left;
                RuntimeCostAccounter.recordJump();
                if (entry3 != null) {
                    entry = entry.left;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Entry entry4 = entry.parent;
                    Entry<K, V> entry5 = entry;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (entry4 == null) return entry4;
                        Entry entry6 = entry4.left;
                        RuntimeCostAccounter.recordJump();
                        if (entry5 != entry6) return entry4;
                        entry5 = entry4;
                        entry4 = entry4.parent;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Entry<K, V> getHigherEntry(K k) {
        Entry<K, V> entry = this.root;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) return null;
            Object k2 = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = this.compare(k, k2);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                Entry entry2 = entry.left;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) return entry;
                entry = entry.left;
                RuntimeCostAccounter.recordJump();
            } else {
                Entry entry3 = entry.right;
                RuntimeCostAccounter.recordJump();
                if (entry3 != null) {
                    entry = entry.right;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Entry entry4 = entry.parent;
                    Entry<K, V> entry5 = entry;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (entry4 == null) return entry4;
                        Entry entry6 = entry4.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry5 != entry6) return entry4;
                        entry5 = entry4;
                        entry4 = entry4.parent;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Entry<K, V> getLowerEntry(K k) {
        Entry<K, V> entry = this.root;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) return null;
            Object k2 = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = this.compare(k, k2);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                Entry entry2 = entry.right;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) return entry;
                entry = entry.right;
                RuntimeCostAccounter.recordJump();
            } else {
                Entry entry3 = entry.left;
                RuntimeCostAccounter.recordJump();
                if (entry3 != null) {
                    entry = entry.left;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Entry entry4 = entry.parent;
                    Entry<K, V> entry5 = entry;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (entry4 == null) return entry4;
                        Entry entry6 = entry4.left;
                        RuntimeCostAccounter.recordJump();
                        if (entry5 != entry6) return entry4;
                        entry5 = entry4;
                        entry4 = entry4.parent;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public V put(K k, V v) {
        Object object;
        int n;
        Entry<K, V> entry;
        Entry<K, V> entry2 = this.root;
        RuntimeCostAccounter.recordJump();
        if (entry2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            this.compare(k, k);
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$Entry");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/TreeMap$Entry;)V");
            this.root = new Entry<K, V>(k, v, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> comparator = this.comparator;
        RuntimeCostAccounter.recordJump();
        if (comparator != null) {
            do {
                entry = entry2;
                Object k2 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                n = comparator.compare(k, k2);
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    entry2 = entry2.left;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n > 0) {
                        entry2 = entry2.right;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.setValue:(Ljava/lang/Object;)Ljava/lang/Object;");
                        return entry2.setValue(v);
                    }
                }
                RuntimeCostAccounter.recordJump();
            } while (entry2 != null);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (k == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            object = (Comparable)k;
            do {
                entry = entry2;
                Object k3 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                n = object.compareTo(k3);
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    entry2 = entry2.left;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n > 0) {
                        entry2 = entry2.right;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.setValue:(Ljava/lang/Object;)Ljava/lang/Object;");
                        return entry2.setValue(v);
                    }
                }
                RuntimeCostAccounter.recordJump();
            } while (entry2 != null);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$Entry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/TreeMap$Entry;)V");
        object = new Entry<K, V>(k, v, entry);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            entry.left = object;
            RuntimeCostAccounter.recordJump();
        } else {
            entry.right = object;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.fixAfterInsertion:(Ljava/util/TreeMap$Entry;)V");
        this.fixAfterInsertion((Entry<K, V>)object);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public V remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getEntry(object);
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            return null;
        }
        Object v = entry.value;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.deleteEntry:(Ljava/util/TreeMap$Entry;)V");
        this.deleteEntry(entry);
        return v;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        TreeMap treeMap;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.clone:()Ljava/lang/Object;");
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        RuntimeCostAccounter.recordJump();
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        treeMap.navigableKeySet = null;
        treeMap.descendingMap = null;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.entrySet:()Ljava/util/Set;");
            Set<Map.Entry<K, V>> set = this.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<Map.Entry<K, V>> iterator = set.iterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
            treeMap.buildFromSorted(this.size, iterator, null, null);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordJump();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
        return treeMap;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLastEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.deleteEntry:(Ljava/util/TreeMap$Entry;)V");
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLastEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.deleteEntry:(Ljava/util/TreeMap$Entry;)V");
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLowerEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLowerEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public K lowerKey(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLowerEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLowerEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFloorEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFloorEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public K floorKey(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFloorEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFloorEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getCeilingEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getCeilingEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public K ceilingKey(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getCeilingEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getCeilingEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getHigherEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getHigherEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
        return TreeMap.exportEntry(entry);
    }

    @Override
    public K higherKey(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getHigherEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getHigherEntry(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Set<K> keySet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.navigableKeySet:()Ljava/util/NavigableSet;");
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<Object> keySet;
        KeySet<K> keySet2 = this.navigableKeySet;
        RuntimeCostAccounter.recordJump();
        if (keySet2 != null) {
            keySet = keySet2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
            keySet = this.navigableKeySet = new KeySet(this);
        }
        return keySet;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.descendingMap:()Ljava/util/NavigableMap;");
        NavigableMap<K, V> navigableMap = this.descendingMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
        return navigableMap.navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = this.values;
        RuntimeCostAccounter.recordJump();
        if (collection2 != null) {
            collection = collection2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$Values");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Values.<init>:(Ljava/util/TreeMap;)V");
            collection = this.values = new Values();
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = this.entrySet;
        RuntimeCostAccounter.recordJump();
        if (entrySet2 != null) {
            entrySet = entrySet2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$EntrySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySet.<init>:(Ljava/util/TreeMap;)V");
            entrySet = this.entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> navigableMap;
        NavigableMap<K, V> navigableMap2 = this.descendingMap;
        RuntimeCostAccounter.recordJump();
        if (navigableMap2 != null) {
            navigableMap = navigableMap2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            navigableMap = this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true);
        }
        return navigableMap;
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
        return new AscendingSubMap(this, false, k, bl, false, k2, bl2);
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
        return new AscendingSubMap(this, true, null, true, false, k, bl);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
        return new AscendingSubMap(this, false, k, bl, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
        return this.subMap(k, true, k2, false);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
        return this.headMap(k, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
        return this.tailMap(k, true);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getEntry(k);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            Object v3 = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = Objects.equals(v, v3);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                entry.value = v2;
                return true;
            }
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getEntry(k);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            Object v2 = entry.value;
            entry.value = v;
            return v2;
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            Object k = entry.key;
            Object v = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept(k, v);
            RuntimeCostAccounter.recordJump();
            if (n != this.modCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            entry = TreeMap.successor(entry);
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            Object k = entry.key;
            Object v = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            entry.value = biFunction.apply(k, v);
            RuntimeCostAccounter.recordJump();
            if (n != this.modCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            entry = TreeMap.successor(entry);
            RuntimeCostAccounter.recordJump();
        }
    }

    Iterator<K> keyIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeyIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getFirstEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeyIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
        return new KeyIterator(entry);
    }

    Iterator<K> descendingKeyIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingKeyIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
        Entry<K, V> entry = this.getLastEntry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeyIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
        return new DescendingKeyIterator(entry);
    }

    final int compare(Object object, Object object2) {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.comparator == null) {
            Comparable comparable = (Comparable)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            n = comparable.compareTo(object2);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            n = this.comparator.compare(object, object2);
        }
        return n;
    }

    static final boolean valEquals(Object object, Object object2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordJump();
            if (object2 == null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(object2);
        }
        return bl;
    }

    static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> entry) {
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            simpleImmutableEntry = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/util/Map$Entry;)V");
            simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<K, V>(entry);
        }
        return simpleImmutableEntry;
    }

    static <K, V> K keyOrNull(Entry<K, V> entry) {
        K k;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            k = null;
            RuntimeCostAccounter.recordJump();
        } else {
            k = entry.key;
        }
        return k;
    }

    static <K> K key(Entry<K, ?> entry) {
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return entry.key;
    }

    final Entry<K, V> getFirstEntry() {
        Entry<K, V> entry = this.root;
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            while (true) {
                Entry entry2 = entry.left;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) break;
                entry = entry.left;
                RuntimeCostAccounter.recordJump();
            }
        }
        return entry;
    }

    final Entry<K, V> getLastEntry() {
        Entry<K, V> entry = this.root;
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            while (true) {
                Entry entry2 = entry.right;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) break;
                entry = entry.right;
                RuntimeCostAccounter.recordJump();
            }
        }
        return entry;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry.right;
        RuntimeCostAccounter.recordJump();
        if (entry2 != null) {
            Entry entry3 = entry.right;
            while (true) {
                Entry entry4 = entry3.left;
                RuntimeCostAccounter.recordJump();
                if (entry4 == null) break;
                entry3 = entry3.left;
                RuntimeCostAccounter.recordJump();
            }
            return entry3;
        }
        Entry entry5 = entry.parent;
        Entry<K, V> entry6 = entry;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry5 == null) break;
            Entry entry7 = entry5.right;
            RuntimeCostAccounter.recordJump();
            if (entry6 != entry7) break;
            entry6 = entry5;
            entry5 = entry5.parent;
            RuntimeCostAccounter.recordJump();
        }
        return entry5;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry.left;
        RuntimeCostAccounter.recordJump();
        if (entry2 != null) {
            Entry entry3 = entry.left;
            while (true) {
                Entry entry4 = entry3.right;
                RuntimeCostAccounter.recordJump();
                if (entry4 == null) break;
                entry3 = entry3.right;
                RuntimeCostAccounter.recordJump();
            }
            return entry3;
        }
        Entry entry5 = entry.parent;
        Entry<K, V> entry6 = entry;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry5 == null) break;
            Entry entry7 = entry5.left;
            RuntimeCostAccounter.recordJump();
            if (entry6 != entry7) break;
            entry6 = entry5;
            entry5 = entry5.parent;
            RuntimeCostAccounter.recordJump();
        }
        return entry5;
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = entry.color;
        }
        return bl;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        Entry entry2;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            entry2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            entry2 = entry.parent;
        }
        return entry2;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        Entry entry2;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            entry2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            entry2 = entry.left;
        }
        return entry2;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        Entry entry2;
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            entry2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            entry2 = entry.right;
        }
        return entry2;
    }

    private void rotateLeft(Entry<K, V> entry) {
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            Entry entry2 = entry.right;
            entry.right = entry2.left;
            Entry entry3 = entry2.left;
            RuntimeCostAccounter.recordJump();
            if (entry3 != null) {
                entry2.left.parent = entry;
            }
            entry2.parent = entry.parent;
            Entry entry4 = entry.parent;
            RuntimeCostAccounter.recordJump();
            if (entry4 == null) {
                this.root = entry2;
                RuntimeCostAccounter.recordJump();
            } else {
                Entry entry5 = entry.parent.left;
                RuntimeCostAccounter.recordJump();
                if (entry5 == entry) {
                    entry.parent.left = entry2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    entry.parent.right = entry2;
                }
            }
            entry2.left = entry;
            entry.parent = entry2;
        }
    }

    private void rotateRight(Entry<K, V> entry) {
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            Entry entry2 = entry.left;
            entry.left = entry2.right;
            Entry entry3 = entry2.right;
            RuntimeCostAccounter.recordJump();
            if (entry3 != null) {
                entry2.right.parent = entry;
            }
            entry2.parent = entry.parent;
            Entry entry4 = entry.parent;
            RuntimeCostAccounter.recordJump();
            if (entry4 == null) {
                this.root = entry2;
                RuntimeCostAccounter.recordJump();
            } else {
                Entry entry5 = entry.parent.right;
                RuntimeCostAccounter.recordJump();
                if (entry5 == entry) {
                    entry.parent.right = entry2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    entry.parent.left = entry2;
                }
            }
            entry2.right = entry;
            entry.parent = entry2;
        }
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (true) {
            Entry<K, V> entry2;
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            RuntimeCostAccounter.recordJump();
            if (entry == this.root) break;
            boolean bl = entry.parent.color;
            RuntimeCostAccounter.recordJump();
            if (bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry3 = TreeMap.parentOf(entry);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry4 = TreeMap.parentOf(entry);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry5 = TreeMap.parentOf(entry4);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry6 = TreeMap.leftOf(entry5);
            RuntimeCostAccounter.recordJump();
            if (entry3 == entry6) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry7 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry8 = TreeMap.parentOf(entry7);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                entry2 = TreeMap.rightOf(entry8);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                boolean bl2 = TreeMap.colorOf(entry2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry9 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(entry9, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(entry2, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry10 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry11 = TreeMap.parentOf(entry10);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(entry11, false);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry12 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    entry = TreeMap.parentOf(entry12);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry13 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry14 = TreeMap.rightOf(entry13);
                    RuntimeCostAccounter.recordJump();
                    if (entry == entry14) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                        entry = TreeMap.parentOf(entry);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateLeft:(Ljava/util/TreeMap$Entry;)V");
                        this.rotateLeft(entry);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry15 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(entry15, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry16 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry17 = TreeMap.parentOf(entry16);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(entry17, false);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry18 = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    Entry<K, V> entry19 = TreeMap.parentOf(entry18);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateRight:(Ljava/util/TreeMap$Entry;)V");
                    this.rotateRight(entry19);
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry20 = TreeMap.parentOf(entry);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry21 = TreeMap.parentOf(entry20);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            entry2 = TreeMap.leftOf(entry21);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
            boolean bl3 = TreeMap.colorOf(entry2);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry22 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(entry22, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(entry2, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry23 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry24 = TreeMap.parentOf(entry23);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(entry24, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry25 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                entry = TreeMap.parentOf(entry25);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry26 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry27 = TreeMap.leftOf(entry26);
                RuntimeCostAccounter.recordJump();
                if (entry == entry27) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    entry = TreeMap.parentOf(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateRight:(Ljava/util/TreeMap$Entry;)V");
                    this.rotateRight(entry);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry28 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(entry28, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry29 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry30 = TreeMap.parentOf(entry29);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(entry30, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry31 = TreeMap.parentOf(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                Entry<K, V> entry32 = TreeMap.parentOf(entry31);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateLeft:(Ljava/util/TreeMap$Entry;)V");
                this.rotateLeft(entry32);
            }
            RuntimeCostAccounter.recordJump();
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry entry2;
        Entry entry3;
        ++this.modCount;
        --this.size;
        Entry entry4 = entry.left;
        RuntimeCostAccounter.recordJump();
        if (entry4 != null) {
            Entry entry5 = entry.right;
            RuntimeCostAccounter.recordJump();
            if (entry5 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                entry3 = TreeMap.successor(entry);
                entry.key = entry3.key;
                entry.value = entry3.value;
                entry = entry3;
            }
        }
        Entry entry6 = entry.left;
        RuntimeCostAccounter.recordJump();
        if (entry6 != null) {
            entry2 = entry.left;
            RuntimeCostAccounter.recordJump();
        } else {
            entry2 = entry.right;
        }
        entry3 = entry2;
        RuntimeCostAccounter.recordJump();
        if (entry3 != null) {
            entry3.parent = entry.parent;
            Entry entry7 = entry.parent;
            RuntimeCostAccounter.recordJump();
            if (entry7 == null) {
                this.root = entry3;
                RuntimeCostAccounter.recordJump();
            } else {
                Entry entry8 = entry.parent.left;
                RuntimeCostAccounter.recordJump();
                if (entry == entry8) {
                    entry.parent.left = entry3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    entry.parent.right = entry3;
                }
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            boolean bl = entry.color;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.fixAfterDeletion:(Ljava/util/TreeMap$Entry;)V");
                this.fixAfterDeletion(entry3);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            Entry entry9 = entry.parent;
            RuntimeCostAccounter.recordJump();
            if (entry9 == null) {
                this.root = null;
                RuntimeCostAccounter.recordJump();
            } else {
                boolean bl = entry.color;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.fixAfterDeletion:(Ljava/util/TreeMap$Entry;)V");
                    this.fixAfterDeletion(entry);
                }
                Entry entry10 = entry.parent;
                RuntimeCostAccounter.recordJump();
                if (entry10 != null) {
                    Entry entry11 = entry.parent.left;
                    RuntimeCostAccounter.recordJump();
                    if (entry == entry11) {
                        entry.parent.left = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        Entry entry12 = entry.parent.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry == entry12) {
                            entry.parent.right = null;
                        }
                    }
                    entry.parent = null;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fixAfterDeletion(Entry<K, V> var1_1) {
        while (true) {
            block9: {
                RuntimeCostAccounter.recordJump();
                if (var1_1 == this.root) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v0 = TreeMap.colorOf(var1_1);
                RuntimeCostAccounter.recordJump();
                if (!v0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v1 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v2 = TreeMap.leftOf(v1);
                RuntimeCostAccounter.recordJump();
                if (var1_1 != v2) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v3 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                var2_2 = TreeMap.rightOf(v3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v4 = TreeMap.colorOf(var2_2);
                RuntimeCostAccounter.recordJump();
                if (!v4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(var2_2, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v5 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(v5, false);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v6 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateLeft:(Ljava/util/TreeMap$Entry;)V");
                    this.rotateLeft(v6);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v7 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    var2_2 = TreeMap.rightOf(v7);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v8 = TreeMap.leftOf(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v9 = TreeMap.colorOf(v8);
                RuntimeCostAccounter.recordJump();
                if (!v9) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v10 = TreeMap.rightOf(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v11 = TreeMap.colorOf(v10);
                RuntimeCostAccounter.recordJump();
                if (v11) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(var2_2, false);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    var1_1 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v12 = TreeMap.rightOf(var2_2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                    v13 = TreeMap.colorOf(v12);
                    RuntimeCostAccounter.recordJump();
                    if (v13) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                        v14 = TreeMap.leftOf(var2_2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                        TreeMap.setColor(v14, true);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                        TreeMap.setColor(var2_2, false);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateRight:(Ljava/util/TreeMap$Entry;)V");
                        this.rotateRight(var2_2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                        v15 = TreeMap.parentOf(var1_1);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                        var2_2 = TreeMap.rightOf(v15);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v16 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                    v17 = TreeMap.colorOf(v16);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(var2_2, v17);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v18 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(v18, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v19 = TreeMap.rightOf(var2_2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(v19, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v20 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateLeft:(Ljava/util/TreeMap$Entry;)V");
                    this.rotateLeft(v20);
                    var1_1 = this.root;
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            v21 = TreeMap.parentOf(var1_1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            var2_2 = TreeMap.leftOf(v21);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
            v22 = TreeMap.colorOf(var2_2);
            RuntimeCostAccounter.recordJump();
            if (!v22) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(var2_2, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v23 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(v23, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v24 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateRight:(Ljava/util/TreeMap$Entry;)V");
                this.rotateRight(v24);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v25 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                var2_2 = TreeMap.leftOf(v25);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            v26 = TreeMap.rightOf(var2_2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
            v27 = TreeMap.colorOf(v26);
            RuntimeCostAccounter.recordJump();
            if (!v27) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            v28 = TreeMap.leftOf(var2_2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
            v29 = TreeMap.colorOf(v28);
            RuntimeCostAccounter.recordJump();
            if (v29) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(var2_2, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                var1_1 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v30 = TreeMap.leftOf(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v31 = TreeMap.colorOf(v30);
                RuntimeCostAccounter.recordJump();
                if (v31) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rightOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v32 = TreeMap.rightOf(var2_2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(v32, true);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                    TreeMap.setColor(var2_2, false);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateLeft:(Ljava/util/TreeMap$Entry;)V");
                    this.rotateLeft(var2_2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    v33 = TreeMap.parentOf(var1_1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                    var2_2 = TreeMap.leftOf(v33);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v34 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.colorOf:(Ljava/util/TreeMap$Entry;)Z");
                v35 = TreeMap.colorOf(v34);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(var2_2, v35);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v36 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(v36, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.leftOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v37 = TreeMap.leftOf(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
                TreeMap.setColor(v37, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.parentOf:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                v38 = TreeMap.parentOf(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.rotateRight:(Ljava/util/TreeMap$Entry;)V");
                this.rotateRight(v38);
                var1_1 = this.root;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.setColor:(Ljava/util/TreeMap$Entry;Z)V");
        TreeMap.setColor(var1_1, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(this.size);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<K, V>> set = this.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<K, V>> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Map.Entry<K, V> entry = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            K k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            V v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(v);
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n = objectInputStream.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
        this.buildFromSorted(n, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.size:()I");
            int n = sortedSet.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.iterator:()Ljava/util/Iterator;");
            Iterator iterator = sortedSet.iterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(ILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
            this.buildFromSorted(n, iterator, null, v);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordJump();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
    }

    private void buildFromSorted(int n, Iterator<?> iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.size = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.computeRedLevel:(I)I");
        int n2 = TreeMap.computeRedLevel(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(IIIILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
        this.root = this.buildFromSorted(0, 0, n - 1, n2, iterator, objectInputStream, v);
    }

    private final Entry<K, V> buildFromSorted(int n, int n2, int n3, int n4, Iterator<?> iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        V v2;
        Object object;
        Entry<Object, V> entry;
        RuntimeCostAccounter.recordJump();
        if (n3 < n2) {
            return null;
        }
        int n5 = n2 + n3 >>> 1;
        Entry<K, V> entry2 = null;
        RuntimeCostAccounter.recordJump();
        if (n2 < n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(IIIILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            entry2 = this.buildFromSorted(n + 1, n2, n5 - 1, n4, iterator, objectInputStream, v);
        }
        RuntimeCostAccounter.recordJump();
        if (iterator != null) {
            RuntimeCostAccounter.recordJump();
            if (v == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                entry = (Entry<Object, V>)iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                object = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                v2 = entry.getValue();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                object = iterator.next();
                v2 = v;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            Object object2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            object = objectInputStream.readObject();
            RuntimeCostAccounter.recordJump();
            if (v != null) {
                object2 = v;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
                object2 = objectInputStream.readObject();
            }
            v2 = object2;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$Entry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/TreeMap$Entry;)V");
        entry = new Entry<Object, V>(object, v2, null);
        RuntimeCostAccounter.recordJump();
        if (n == n4) {
            entry.color = false;
        }
        RuntimeCostAccounter.recordJump();
        if (entry2 != null) {
            entry.left = entry2;
            entry2.parent = entry;
        }
        RuntimeCostAccounter.recordJump();
        if (n5 < n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.buildFromSorted:(IIIILjava/util/Iterator;Ljava/io/ObjectInputStream;Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry3 = this.buildFromSorted(n + 1, n5 + 1, n3, n4, iterator, objectInputStream, v);
            entry.right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) break;
            ++n2;
            n3 = n3 / 2 - 1;
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    static <K> Spliterator<K> keySpliteratorFor(NavigableMap<K, ?> navigableMap) {
        NavigableSubMap navigableSubMap;
        boolean bl = navigableMap instanceof TreeMap;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            TreeMap treeMap = (TreeMap)navigableMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keySpliterator:()Ljava/util/Spliterator;");
            return treeMap.keySpliterator();
        }
        boolean bl2 = navigableMap instanceof DescendingSubMap;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            navigableSubMap = (DescendingSubMap)navigableMap;
            TreeMap treeMap = ((DescendingSubMap)navigableSubMap).m;
            NavigableMap navigableMap2 = treeMap.descendingMap;
            RuntimeCostAccounter.recordJump();
            if (navigableSubMap == navigableMap2) {
                TreeMap treeMap2 = treeMap;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.descendingKeySpliterator:()Ljava/util/Spliterator;");
                return treeMap2.descendingKeySpliterator();
            }
        }
        navigableSubMap = (NavigableSubMap)navigableMap;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.keySpliterator:()Ljava/util/Spliterator;");
        return navigableSubMap.keySpliterator();
    }

    final Spliterator<K> keySpliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
        return new KeySpliterator(this, null, null, 0, -1, 0);
    }

    final Spliterator<K> descendingKeySpliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingKeySpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
        return new DescendingKeySpliterator(this, null, null, 0, -2, 0);
    }

    static /* synthetic */ void access$000(TreeMap treeMap, Entry entry) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.deleteEntry:(Ljava/util/TreeMap$Entry;)V");
        treeMap.deleteEntry(entry);
    }

    static /* synthetic */ Entry access$500(TreeMap treeMap) {
        return treeMap.root;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        UNBOUNDED = new Object();
    }

    static final class EntrySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(TreeMap<K, V> treeMap, Entry<K, V> entry, Entry<K, V> entry2, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$TreeMapSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            super(treeMap, entry, entry2, n, n2, n3);
        }

        /*
         * Unable to fully structure code
         */
        public EntrySpliterator<K, V> trySplit() {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            block7: {
                                RuntimeCostAccounter.recordJump();
                                if (this.est < 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySpliterator.getEstimate:()I");
                                    this.getEstimate();
                                }
                                var1_1 = this.side;
                                var2_2 = this.current;
                                var3_3 = this.fence;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 == null) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != var3_3) break block8;
                            }
                            v0 = null;
                            RuntimeCostAccounter.recordJump();
                            break block9;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 != 0) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$500:(Ljava/util/TreeMap;)Ljava/util/TreeMap$Entry;");
                        v0 = TreeMap.access$500(this.tree);
                        RuntimeCostAccounter.recordJump();
                        break block9;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 <= 0) break block11;
                    v0 = var2_2.right;
                    RuntimeCostAccounter.recordJump();
                    break block9;
                }
                RuntimeCostAccounter.recordJump();
                if (var1_1 >= 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (var3_3 != null) {
                    v0 = var3_3.left;
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            var4_4 = v0;
            RuntimeCostAccounter.recordJump();
            if (var4_4 != null) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 != var2_2) {
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 != var3_3) {
                        v1 = var2_2.key;
                        v2 = var4_4.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                        v3 = this.tree.compare(v1, v2);
                        RuntimeCostAccounter.recordJump();
                        if (v3 < 0) {
                            this.side = 1;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$EntrySpliterator");
                            this.current = var4_4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
                            return new EntrySpliterator<K, V>(this.tree, var2_2, this.current, -1, this.est >>>= 1, this.expectedModCount);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.est < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySpliterator.getEstimate:()I");
                this.getEstimate();
            }
            Entry entry = this.fence;
            Entry entry2 = this.current;
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                RuntimeCostAccounter.recordJump();
                if (entry2 != entry) {
                    this.current = entry;
                    do {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(entry2);
                        Entry entry3 = entry2.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry3 != null) {
                            while (true) {
                                Entry entry4 = entry3.left;
                                RuntimeCostAccounter.recordJump();
                                if (entry4 != null) {
                                    entry3 = entry4;
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                break;
                            }
                        } else {
                            while (true) {
                                entry3 = entry2.parent;
                                RuntimeCostAccounter.recordJump();
                                if (entry3 == null) break;
                                Entry entry5 = entry3.right;
                                RuntimeCostAccounter.recordJump();
                                if (entry2 != entry5) break;
                                entry2 = entry3;
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        entry2 = entry3;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (entry2 != entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    int n = this.tree.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            Entry entry;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.est < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySpliterator.getEstimate:()I");
                        this.getEstimate();
                    }
                    entry = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (entry != this.fence) break block7;
                }
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.current = TreeMap.successor(entry);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(entry);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = this.tree.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            return true;
        }

        @Override
        public int characteristics() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.side == 0) {
                n = 64;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n | 1 | 4 | 0x10;
        }

        @Override
        public Comparator<Map.Entry<K, V>> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$300:(Ljava/util/TreeMap;)Ljava/util/Comparator;");
            Comparator comparator = this.tree.comparator;
            RuntimeCostAccounter.recordJump();
            if (comparator != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$300:(Ljava/util/TreeMap;)Ljava/util/Comparator;");
                Comparator comparator2 = this.tree.comparator;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.comparingByKey:(Ljava/util/Comparator;)Ljava/util/Comparator;");
                return Map.Entry.comparingByKey(comparator2);
            }
            return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(entry, entry2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Comparable comparable = (Comparable)entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry2.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                return comparable.compareTo(k);
            }));
        }
    }

    static final class ValueSpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(TreeMap<K, V> treeMap, Entry<K, V> entry, Entry<K, V> entry2, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$TreeMapSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            super(treeMap, entry, entry2, n, n2, n3);
        }

        /*
         * Unable to fully structure code
         */
        public ValueSpliterator<K, V> trySplit() {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            block7: {
                                RuntimeCostAccounter.recordJump();
                                if (this.est < 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueSpliterator.getEstimate:()I");
                                    this.getEstimate();
                                }
                                var1_1 = this.side;
                                var2_2 = this.current;
                                var3_3 = this.fence;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 == null) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != var3_3) break block8;
                            }
                            v0 = null;
                            RuntimeCostAccounter.recordJump();
                            break block9;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 != 0) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$500:(Ljava/util/TreeMap;)Ljava/util/TreeMap$Entry;");
                        v0 = TreeMap.access$500(this.tree);
                        RuntimeCostAccounter.recordJump();
                        break block9;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 <= 0) break block11;
                    v0 = var2_2.right;
                    RuntimeCostAccounter.recordJump();
                    break block9;
                }
                RuntimeCostAccounter.recordJump();
                if (var1_1 >= 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (var3_3 != null) {
                    v0 = var3_3.left;
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            var4_4 = v0;
            RuntimeCostAccounter.recordJump();
            if (var4_4 != null) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 != var2_2) {
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 != var3_3) {
                        v1 = var2_2.key;
                        v2 = var4_4.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                        v3 = this.tree.compare(v1, v2);
                        RuntimeCostAccounter.recordJump();
                        if (v3 < 0) {
                            this.side = 1;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$ValueSpliterator");
                            this.current = var4_4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
                            return new ValueSpliterator<K, V>(this.tree, var2_2, this.current, -1, this.est >>>= 1, this.expectedModCount);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.est < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueSpliterator.getEstimate:()I");
                this.getEstimate();
            }
            Entry entry = this.fence;
            Entry entry2 = this.current;
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                RuntimeCostAccounter.recordJump();
                if (entry2 != entry) {
                    this.current = entry;
                    do {
                        Object v = entry2.value;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(v);
                        Entry entry3 = entry2.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry3 != null) {
                            while (true) {
                                Entry entry4 = entry3.left;
                                RuntimeCostAccounter.recordJump();
                                if (entry4 != null) {
                                    entry3 = entry4;
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                break;
                            }
                        } else {
                            while (true) {
                                entry3 = entry2.parent;
                                RuntimeCostAccounter.recordJump();
                                if (entry3 == null) break;
                                Entry entry5 = entry3.right;
                                RuntimeCostAccounter.recordJump();
                                if (entry2 != entry5) break;
                                entry2 = entry3;
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        entry2 = entry3;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (entry2 != entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    int n = this.tree.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            Entry entry;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.est < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueSpliterator.getEstimate:()I");
                        this.getEstimate();
                    }
                    entry = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (entry != this.fence) break block7;
                }
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.current = TreeMap.successor(entry);
            Object v = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = this.tree.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            return true;
        }

        @Override
        public int characteristics() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.side == 0) {
                n = 64;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n | 0x10;
        }
    }

    static final class DescendingKeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        DescendingKeySpliterator(TreeMap<K, V> treeMap, Entry<K, V> entry, Entry<K, V> entry2, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$TreeMapSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            super(treeMap, entry, entry2, n, n2, n3);
        }

        /*
         * Unable to fully structure code
         */
        public DescendingKeySpliterator<K, V> trySplit() {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            block7: {
                                RuntimeCostAccounter.recordJump();
                                if (this.est < 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeySpliterator.getEstimate:()I");
                                    this.getEstimate();
                                }
                                var1_1 = this.side;
                                var2_2 = this.current;
                                var3_3 = this.fence;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 == null) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != var3_3) break block8;
                            }
                            v0 = null;
                            RuntimeCostAccounter.recordJump();
                            break block9;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 != 0) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$500:(Ljava/util/TreeMap;)Ljava/util/TreeMap$Entry;");
                        v0 = TreeMap.access$500(this.tree);
                        RuntimeCostAccounter.recordJump();
                        break block9;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 >= 0) break block11;
                    v0 = var2_2.left;
                    RuntimeCostAccounter.recordJump();
                    break block9;
                }
                RuntimeCostAccounter.recordJump();
                if (var1_1 <= 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (var3_3 != null) {
                    v0 = var3_3.right;
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            var4_4 = v0;
            RuntimeCostAccounter.recordJump();
            if (var4_4 != null) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 != var2_2) {
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 != var3_3) {
                        v1 = var2_2.key;
                        v2 = var4_4.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                        v3 = this.tree.compare(v1, v2);
                        RuntimeCostAccounter.recordJump();
                        if (v3 > 0) {
                            this.side = 1;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingKeySpliterator");
                            this.current = var4_4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
                            return new DescendingKeySpliterator<K, V>(this.tree, var2_2, this.current, -1, this.est >>>= 1, this.expectedModCount);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.est < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeySpliterator.getEstimate:()I");
                this.getEstimate();
            }
            Entry entry = this.fence;
            Entry entry2 = this.current;
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                RuntimeCostAccounter.recordJump();
                if (entry2 != entry) {
                    this.current = entry;
                    do {
                        Object k = entry2.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(k);
                        Entry entry3 = entry2.left;
                        RuntimeCostAccounter.recordJump();
                        if (entry3 != null) {
                            while (true) {
                                Entry entry4 = entry3.right;
                                RuntimeCostAccounter.recordJump();
                                if (entry4 != null) {
                                    entry3 = entry4;
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                break;
                            }
                        } else {
                            while (true) {
                                entry3 = entry2.parent;
                                RuntimeCostAccounter.recordJump();
                                if (entry3 == null) break;
                                Entry entry5 = entry3.left;
                                RuntimeCostAccounter.recordJump();
                                if (entry2 != entry5) break;
                                entry2 = entry3;
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        entry2 = entry3;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (entry2 != entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    int n = this.tree.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            Entry entry;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.est < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeySpliterator.getEstimate:()I");
                        this.getEstimate();
                    }
                    entry = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (entry != this.fence) break block7;
                }
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.predecessor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.current = TreeMap.predecessor(entry);
            Object k = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = this.tree.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            return true;
        }

        @Override
        public int characteristics() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.side == 0) {
                n = 64;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n | 1 | 0x10;
        }
    }

    static final class KeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(TreeMap<K, V> treeMap, Entry<K, V> entry, Entry<K, V> entry2, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$TreeMapSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            super(treeMap, entry, entry2, n, n2, n3);
        }

        /*
         * Unable to fully structure code
         */
        public KeySpliterator<K, V> trySplit() {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            block7: {
                                RuntimeCostAccounter.recordJump();
                                if (this.est < 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySpliterator.getEstimate:()I");
                                    this.getEstimate();
                                }
                                var1_1 = this.side;
                                var2_2 = this.current;
                                var3_3 = this.fence;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 == null) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != var3_3) break block8;
                            }
                            v0 = null;
                            RuntimeCostAccounter.recordJump();
                            break block9;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 != 0) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$500:(Ljava/util/TreeMap;)Ljava/util/TreeMap$Entry;");
                        v0 = TreeMap.access$500(this.tree);
                        RuntimeCostAccounter.recordJump();
                        break block9;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 <= 0) break block11;
                    v0 = var2_2.right;
                    RuntimeCostAccounter.recordJump();
                    break block9;
                }
                RuntimeCostAccounter.recordJump();
                if (var1_1 >= 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (var3_3 != null) {
                    v0 = var3_3.left;
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            var4_4 = v0;
            RuntimeCostAccounter.recordJump();
            if (var4_4 != null) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 != var2_2) {
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 != var3_3) {
                        v1 = var2_2.key;
                        v2 = var4_4.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                        v3 = this.tree.compare(v1, v2);
                        RuntimeCostAccounter.recordJump();
                        if (v3 < 0) {
                            this.side = 1;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySpliterator");
                            this.current = var4_4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
                            return new KeySpliterator<K, V>(this.tree, var2_2, this.current, -1, this.est >>>= 1, this.expectedModCount);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.est < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySpliterator.getEstimate:()I");
                this.getEstimate();
            }
            Entry entry = this.fence;
            Entry entry2 = this.current;
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                RuntimeCostAccounter.recordJump();
                if (entry2 != entry) {
                    this.current = entry;
                    do {
                        Object k = entry2.key;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(k);
                        Entry entry3 = entry2.right;
                        RuntimeCostAccounter.recordJump();
                        if (entry3 != null) {
                            while (true) {
                                Entry entry4 = entry3.left;
                                RuntimeCostAccounter.recordJump();
                                if (entry4 != null) {
                                    entry3 = entry4;
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                break;
                            }
                        } else {
                            while (true) {
                                entry3 = entry2.parent;
                                RuntimeCostAccounter.recordJump();
                                if (entry3 == null) break;
                                Entry entry5 = entry3.right;
                                RuntimeCostAccounter.recordJump();
                                if (entry2 != entry5) break;
                                entry2 = entry3;
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        entry2 = entry3;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (entry2 != entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    int n = this.tree.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            Entry entry;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.est < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySpliterator.getEstimate:()I");
                        this.getEstimate();
                    }
                    entry = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (entry != this.fence) break block7;
                }
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.current = TreeMap.successor(entry);
            Object k = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = this.tree.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            return true;
        }

        @Override
        public int characteristics() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.side == 0) {
                n = 64;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n | 1 | 4 | 0x10;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$300:(Ljava/util/TreeMap;)Ljava/util/Comparator;");
            return this.tree.comparator;
        }
    }

    static class TreeMapSpliterator<K, V> {
        final TreeMap<K, V> tree;
        Entry<K, V> current;
        Entry<K, V> fence;
        int side;
        int est;
        int expectedModCount;

        TreeMapSpliterator(TreeMap<K, V> treeMap, Entry<K, V> entry, Entry<K, V> entry2, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.tree = treeMap;
            this.current = entry;
            this.fence = entry2;
            this.side = n;
            this.est = n2;
            this.expectedModCount = n3;
        }

        final int getEstimate() {
            int n = this.est;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                TreeMap<K, V> treeMap = this.tree;
                RuntimeCostAccounter.recordJump();
                if (treeMap != null) {
                    Entry<K, V> entry;
                    RuntimeCostAccounter.recordJump();
                    if (n == -1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
                        entry = treeMap.getFirstEntry();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
                        entry = treeMap.getLastEntry();
                    }
                    this.current = entry;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$400:(Ljava/util/TreeMap;)I");
                    n = this.est = ((TreeMap)treeMap).size;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    this.expectedModCount = ((TreeMap)treeMap).modCount;
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.est = 0;
                    n = 0;
                }
            }
            return n;
        }

        public final long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$TreeMapSpliterator.getEstimate:()I");
            return this.getEstimate();
        }
    }

    static final class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> left;
        Entry<K, V> right;
        Entry<K, V> parent;
        boolean color;

        Entry(K k, V v, Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.color = true;
            this.key = k;
            this.value = v;
            this.parent = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl2 = TreeMap.valEquals(this.key, k);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            Object v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl3 = TreeMap.valEquals(this.value, v);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }

        @Override
        public int hashCode() {
            int n;
            int n2;
            RuntimeCostAccounter.recordJump();
            if (this.key == null) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
                n2 = this.key.hashCode();
            }
            int n3 = n2;
            RuntimeCostAccounter.recordJump();
            if (this.value == null) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
                n = this.value.hashCode();
            }
            int n4 = n;
            return n3 ^ n4;
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(this.key);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("=");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(this.value);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    sandbox.java.io.Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart;
        private boolean toEnd;
        private K fromKey;
        private K toKey;

        private SubMap() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
            this.fromStart = false;
            this.toEnd = false;
        }

        private Object readResolve() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new AscendingSubMap(TreeMap.this, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public K lastKey() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public K firstKey() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }

        @Override
        public Comparator<? super K> comparator() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$300:(Ljava/util/TreeMap;)Ljava/util/Comparator;");
            Comparator comparator = this.m.comparator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverseOrder:(Ljava/util/Comparator;)Ljava/util/Comparator;");
            this.reverseComparator = Collections.reverseOrder(comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl3 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("fromKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl4 = this.inRange(k2, bl2);
            RuntimeCostAccounter.recordJump();
            if (!bl4) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("toKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new DescendingSubMap<K, V>(this.m, false, k2, bl2, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl2 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("toKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new DescendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl2 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("fromKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap ascendingSubMap;
            AscendingSubMap ascendingSubMap2 = this.descendingMapView;
            RuntimeCostAccounter.recordJump();
            if (ascendingSubMap2 != null) {
                ascendingSubMap = ascendingSubMap2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
                ascendingSubMap = this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive);
            }
            return ascendingSubMap;
        }

        @Override
        Iterator<K> keyIterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLowFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absLowFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.DescendingSubMapKeyIterator(entry, entry2);
        }

        @Override
        Spliterator<K> keySpliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLowFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absLowFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.DescendingSubMapKeyIterator(entry, entry2);
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHighFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absHighFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.SubMapKeyIterator(entry, entry2);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView;
            NavigableSubMap.EntrySetView entrySetView2 = this.entrySetView;
            RuntimeCostAccounter.recordJump();
            if (entrySetView2 != null) {
                entrySetView = entrySetView2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap$DescendingEntrySetView");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap$DescendingEntrySetView.<init>:(Ljava/util/TreeMap$DescendingSubMap;)V");
                entrySetView = this.entrySetView = new DescendingEntrySetView();
            }
            return entrySetView;
        }

        @Override
        Entry<K, V> subLowest() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
            return this.absHighest();
        }

        @Override
        Entry<K, V> subHighest() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
            return this.absLowest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absFloor:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLower:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absLower(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absCeiling:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHigher:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absHigher(k);
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$EntrySetView.<init>:(Ljava/util/TreeMap$NavigableSubMap;)V");
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapEntryIterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
                Entry entry = DescendingSubMap.this.absHighest();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.absLowFence:()Ljava/util/TreeMap$Entry;");
                Entry entry2 = DescendingSubMap.this.absLowFence();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapEntryIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                return new NavigableSubMap.DescendingSubMapEntryIterator(entry, entry2);
            }
        }
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
        }

        @Override
        public Comparator<? super K> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.comparator:()Ljava/util/Comparator;");
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl3 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("fromKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl4 = this.inRange(k2, bl2);
            RuntimeCostAccounter.recordJump();
            if (!bl4) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("toKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new AscendingSubMap<K, V>(this.m, false, k, bl, false, k2, bl2);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl2 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("toKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.inRange:(Ljava/lang/Object;Z)Z");
            boolean bl2 = this.inRange(k, bl);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("fromKey out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
            return new AscendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap descendingSubMap;
            DescendingSubMap descendingSubMap2 = this.descendingMapView;
            RuntimeCostAccounter.recordJump();
            if (descendingSubMap2 != null) {
                descendingSubMap = descendingSubMap2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$DescendingSubMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingSubMap.<init>:(Ljava/util/TreeMap;ZLjava/lang/Object;ZZLjava/lang/Object;Z)V");
                descendingSubMap = this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive);
            }
            return descendingSubMap;
        }

        @Override
        Iterator<K> keyIterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHighFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absHighFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.SubMapKeyIterator(entry, entry2);
        }

        @Override
        Spliterator<K> keySpliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHighFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absHighFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.SubMapKeyIterator(entry, entry2);
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
            Entry entry = this.absHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLowFence:()Ljava/util/TreeMap$Entry;");
            Entry entry2 = this.absLowFence();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
            return new NavigableSubMap.DescendingSubMapKeyIterator(entry, entry2);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView;
            NavigableSubMap.EntrySetView entrySetView2 = this.entrySetView;
            RuntimeCostAccounter.recordJump();
            if (entrySetView2 != null) {
                entrySetView = entrySetView2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$AscendingSubMap$AscendingEntrySetView");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap$AscendingEntrySetView.<init>:(Ljava/util/TreeMap$AscendingSubMap;)V");
                entrySetView = this.entrySetView = new AscendingEntrySetView();
            }
            return entrySetView;
        }

        @Override
        Entry<K, V> subLowest() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
            return this.absLowest();
        }

        @Override
        Entry<K, V> subHighest() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
            return this.absHighest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absCeiling:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHigher:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absHigher(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absFloor:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLower:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            return this.absLower(k);
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$EntrySetView.<init>:(Ljava/util/TreeMap$NavigableSubMap;)V");
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$NavigableSubMap$SubMapEntryIterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
                Entry entry = AscendingSubMap.this.absLowest();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$AscendingSubMap.absHighFence:()Ljava/util/TreeMap$Entry;");
                Entry entry2 = AscendingSubMap.this.absHighFence();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapEntryIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                return new NavigableSubMap.SubMapEntryIterator(entry, entry2);
            }
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    sandbox.java.io.Serializable {
        private static final long serialVersionUID = -2102997345730753016L;
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView;
        transient EntrySetView entrySetView;
        transient KeySet<K> navigableKeySetView;

        /*
         * Unable to fully structure code
         */
        NavigableSubMap(TreeMap<K, V> var1_1, boolean var2_2, K var3_3, boolean var4_4, boolean var5_5, K var6_6, boolean var7_7) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
            super();
            RuntimeCostAccounter.recordJump();
            if (var2_2) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (!var5_5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                v0 = var1_1.compare(var3_3, var6_6);
                RuntimeCostAccounter.recordJump();
                if (v0 > 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    v1 = new IllegalArgumentException("fromKey > toKey");
                    RuntimeCostAccounter.recordThrow();
                    throw v1;
                }
            } else lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordJump();
                if (!var2_2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                    var1_1.compare(var3_3, var3_3);
                }
                RuntimeCostAccounter.recordJump();
                if (!var5_5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                    var1_1.compare(var6_6, var6_6);
                }
            }
            this.m = var1_1;
            this.fromStart = var2_2;
            this.lo = var3_3;
            this.loInclusive = var4_4;
            this.toEnd = var5_5;
            this.hi = var6_6;
            this.hiInclusive = var7_7;
        }

        final boolean tooLow(Object object) {
            block2: {
                block3: {
                    RuntimeCostAccounter.recordJump();
                    if (this.fromStart) break block2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                    int n = this.m.compare(object, this.lo);
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (n != 0) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (this.loInclusive) break block2;
                }
                return true;
            }
            return false;
        }

        final boolean tooHigh(Object object) {
            block2: {
                block3: {
                    RuntimeCostAccounter.recordJump();
                    if (this.toEnd) break block2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                    int n = this.m.compare(object, this.hi);
                    RuntimeCostAccounter.recordJump();
                    if (n > 0) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (n != 0) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (this.hiInclusive) break block2;
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean inRange(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
            boolean bl = this.tooLow(object);
            RuntimeCostAccounter.recordJump();
            if (bl) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
            boolean bl2 = this.tooHigh(object);
            RuntimeCostAccounter.recordJump();
            if (bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean inClosedRange(Object object) {
            RuntimeCostAccounter.recordJump();
            if (!this.fromStart) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                int n = this.m.compare(object, this.lo);
                RuntimeCostAccounter.recordJump();
                if (n < 0) return false;
            }
            RuntimeCostAccounter.recordJump();
            if (!this.toEnd) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                int n = this.m.compare(this.hi, object);
                RuntimeCostAccounter.recordJump();
                if (n < 0) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        final boolean inRange(Object object, boolean bl) {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
                bl2 = this.inRange(object);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inClosedRange:(Ljava/lang/Object;)Z");
                bl2 = this.inClosedRange(object);
            }
            return bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absLowest() {
            Entry<K, V> entry;
            Entry<K, V> entry2;
            RuntimeCostAccounter.recordJump();
            if (this.fromStart) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
                entry2 = this.m.getFirstEntry();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.loInclusive) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getCeilingEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry2 = this.m.getCeilingEntry(this.lo);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getHigherEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry2 = this.m.getHigherEntry(this.lo);
                }
            }
            Entry<K, V> entry3 = entry2;
            RuntimeCostAccounter.recordJump();
            if (entry3 != null) {
                Object k = entry3.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
                boolean bl = this.tooHigh(k);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    entry = entry3;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absHighest() {
            Entry<K, V> entry;
            Entry<K, V> entry2;
            RuntimeCostAccounter.recordJump();
            if (this.toEnd) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLastEntry:()Ljava/util/TreeMap$Entry;");
                entry2 = this.m.getLastEntry();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.hiInclusive) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFloorEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry2 = this.m.getFloorEntry(this.hi);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLowerEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry2 = this.m.getLowerEntry(this.hi);
                }
            }
            Entry<K, V> entry3 = entry2;
            RuntimeCostAccounter.recordJump();
            if (entry3 != null) {
                Object k = entry3.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
                boolean bl = this.tooLow(k);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    entry = entry3;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absCeiling(K k) {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
            boolean bl = this.tooLow(k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
                return this.absLowest();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getCeilingEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry2 = this.m.getCeilingEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                Object k2 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
                boolean bl2 = this.tooHigh(k2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    entry = entry2;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absHigher(K k) {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
            boolean bl = this.tooLow(k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
                return this.absLowest();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getHigherEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry2 = this.m.getHigherEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                Object k2 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
                boolean bl2 = this.tooHigh(k2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    entry = entry2;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absFloor(K k) {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
            boolean bl = this.tooHigh(k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
                return this.absHighest();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFloorEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry2 = this.m.getFloorEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                Object k2 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
                boolean bl2 = this.tooLow(k2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    entry = entry2;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        /*
         * Enabled aggressive block sorting
         */
        final Entry<K, V> absLower(K k) {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
            boolean bl = this.tooHigh(k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.absHighest:()Ljava/util/TreeMap$Entry;");
                return this.absHighest();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLowerEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry2 = this.m.getLowerEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                Object k2 = entry2.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooLow:(Ljava/lang/Object;)Z");
                boolean bl2 = this.tooLow(k2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    entry = entry2;
                    return entry;
                }
            }
            entry = null;
            RuntimeCostAccounter.recordJump();
            return entry;
        }

        final Entry<K, V> absHighFence() {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordJump();
            if (this.toEnd) {
                entry = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.hiInclusive) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getHigherEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry = this.m.getHigherEntry(this.hi);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getCeilingEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry = this.m.getCeilingEntry(this.hi);
                }
            }
            return entry;
        }

        final Entry<K, V> absLowFence() {
            Entry<K, V> entry;
            RuntimeCostAccounter.recordJump();
            if (this.fromStart) {
                entry = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.loInclusive) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getLowerEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry = this.m.getLowerEntry(this.lo);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFloorEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                    entry = this.m.getFloorEntry(this.lo);
                }
            }
            return entry;
        }

        abstract Entry<K, V> subLowest();

        abstract Entry<K, V> subHighest();

        abstract Entry<K, V> subCeiling(K var1);

        abstract Entry<K, V> subHigher(K var1);

        abstract Entry<K, V> subFloor(K var1);

        abstract Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Spliterator<K> keySpliterator();

        abstract Iterator<K> descendingKeyIterator();

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isEmpty() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.fromStart) {
                RuntimeCostAccounter.recordJump();
                if (this.toEnd) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.isEmpty:()Z");
                    bl = this.m.isEmpty();
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.entrySet:()Ljava/util/Set;");
            Set set = this.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.isEmpty:()Z");
            bl = set.isEmpty();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int size() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.fromStart) {
                RuntimeCostAccounter.recordJump();
                if (this.toEnd) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.size:()I");
                    n = this.m.size();
                    RuntimeCostAccounter.recordJump();
                    return n;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.entrySet:()Ljava/util/Set;");
            Set set = this.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
            n = set.size();
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean containsKey(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
            boolean bl = this.inRange(object);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.containsKey:(Ljava/lang/Object;)Z");
            boolean bl2 = this.m.containsKey(object);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public final V put(K k, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
            boolean bl = this.inRange(k);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("key out of range");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.put(k, v);
        }

        @Override
        public final V get(Object object) {
            V v;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
            boolean bl = this.inRange(object);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                v = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                v = this.m.get(object);
            }
            return v;
        }

        @Override
        public final V remove(Object object) {
            V v;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
            boolean bl = this.inRange(object);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                v = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                v = this.m.remove(object);
            }
            return v;
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subCeiling:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subCeiling(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final K ceilingKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subCeiling:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subCeiling(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.keyOrNull(entry);
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subHigher:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subHigher(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final K higherKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subHigher:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subHigher(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.keyOrNull(entry);
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subFloor:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subFloor(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final K floorKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subFloor:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subFloor(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.keyOrNull(entry);
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subLower:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subLower(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final K lowerKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subLower:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subLower(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyOrNull:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.keyOrNull(entry);
        }

        @Override
        public final K firstKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subLowest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.key:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.key(entry);
        }

        @Override
        public final K lastKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subHighest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.key:(Ljava/util/TreeMap$Entry;)Ljava/lang/Object;");
            return TreeMap.key(entry);
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subLowest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subHighest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            return TreeMap.exportEntry(entry);
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subLowest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subLowest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            RuntimeCostAccounter.recordJump();
            if (entry != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                TreeMap.access$000(this.m, entry);
            }
            return entry2;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subHighest:()Ljava/util/TreeMap$Entry;");
            Entry<K, V> entry = this.subHighest();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.exportEntry:(Ljava/util/TreeMap$Entry;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            RuntimeCostAccounter.recordJump();
            if (entry != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                TreeMap.access$000(this.m, entry);
            }
            return entry2;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<Object> keySet;
            KeySet<K> keySet2 = this.navigableKeySetView;
            RuntimeCostAccounter.recordJump();
            if (keySet2 != null) {
                keySet = keySet2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
                keySet = this.navigableKeySetView = new KeySet(this);
            }
            return keySet;
        }

        @Override
        public final Set<K> keySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.navigableKeySet:()Ljava/util/NavigableSet;");
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.descendingMap:()Ljava/util/NavigableMap;");
            NavigableMap navigableMap = this.descendingMap();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
            return navigableMap.navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K k, K k2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
            return this.subMap(k, true, k2, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            return this.headMap(k, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            return this.tailMap(k, true);
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            DescendingSubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                super(entry, entry2);
            }

            @Override
            public K next() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.prevEntry:()Ljava/util/TreeMap$Entry;");
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.removeDescending:()V");
                this.removeDescending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> consumer) {
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.next:()Ljava/lang/Object;");
                    Object k = this.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(k);
                    RuntimeCostAccounter.recordJump();
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapKeyIterator.next:()Ljava/lang/Object;");
                    Object k = this.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(k);
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 17;
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            SubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                super(entry, entry2);
            }

            @Override
            public K next() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.nextEntry:()Ljava/util/TreeMap$Entry;");
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.removeAscending:()V");
                this.removeAscending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> consumer) {
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.hasNext:()Z");
                    boolean bl = this.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.next:()Ljava/lang/Object;");
                    Object k = this.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(k);
                    RuntimeCostAccounter.recordJump();
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapKeyIterator.next:()Ljava/lang/Object;");
                    Object k = this.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(k);
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 21;
            }

            @Override
            public final Comparator<? super K> getComparator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.comparator:()Ljava/util/Comparator;");
                return NavigableSubMap.this.comparator();
            }
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapEntryIterator.prevEntry:()Ljava/util/TreeMap$Entry;");
                return this.prevEntry();
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$DescendingSubMapEntryIterator.removeDescending:()V");
                this.removeDescending();
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapIterator.<init>:(Ljava/util/TreeMap$NavigableSubMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;)V");
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapEntryIterator.nextEntry:()Ljava/util/TreeMap$Entry;");
                return this.nextEntry();
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$SubMapEntryIterator.removeAscending:()V");
                this.removeAscending();
            }
        }

        abstract class SubMapIterator<T>
        implements Iterator<T> {
            Entry<K, V> lastReturned;
            Entry<K, V> next;
            final Object fenceKey;
            int expectedModCount;

            SubMapIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                Object object;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                this.expectedModCount = treeMap.modCount;
                this.lastReturned = null;
                this.next = entry;
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$200:()Ljava/lang/Object;");
                    object = UNBOUNDED;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = entry2.key;
                }
                this.fenceKey = object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (this.next == null) return false;
                Object k = this.next.key;
                RuntimeCostAccounter.recordJump();
                if (k == this.fenceKey) return false;
                boolean bl = true;
                RuntimeCostAccounter.recordJump();
                return bl;
            }

            final Entry<K, V> nextEntry() {
                Entry entry;
                block5: {
                    block4: {
                        entry = this.next;
                        RuntimeCostAccounter.recordJump();
                        if (entry == null) break block4;
                        Object k = entry.key;
                        RuntimeCostAccounter.recordJump();
                        if (k != this.fenceKey) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                int n = treeMap.modCount;
                RuntimeCostAccounter.recordJump();
                if (n != this.expectedModCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                this.next = TreeMap.successor(entry);
                this.lastReturned = entry;
                return entry;
            }

            final Entry<K, V> prevEntry() {
                Entry entry;
                block5: {
                    block4: {
                        entry = this.next;
                        RuntimeCostAccounter.recordJump();
                        if (entry == null) break block4;
                        Object k = entry.key;
                        RuntimeCostAccounter.recordJump();
                        if (k != this.fenceKey) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                int n = treeMap.modCount;
                RuntimeCostAccounter.recordJump();
                if (n != this.expectedModCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.predecessor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                this.next = TreeMap.predecessor(entry);
                this.lastReturned = entry;
                return entry;
            }

            final void removeAscending() {
                RuntimeCostAccounter.recordJump();
                if (this.lastReturned == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                    IllegalStateException illegalStateException = new IllegalStateException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                int n = treeMap.modCount;
                RuntimeCostAccounter.recordJump();
                if (n != this.expectedModCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                Entry entry = this.lastReturned.left;
                RuntimeCostAccounter.recordJump();
                if (entry != null) {
                    Entry entry2 = this.lastReturned.right;
                    RuntimeCostAccounter.recordJump();
                    if (entry2 != null) {
                        this.next = this.lastReturned;
                    }
                }
                TreeMap treeMap2 = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                TreeMap.access$000(treeMap2, this.lastReturned);
                this.lastReturned = null;
                TreeMap treeMap3 = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                this.expectedModCount = treeMap3.modCount;
            }

            final void removeDescending() {
                RuntimeCostAccounter.recordJump();
                if (this.lastReturned == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                    IllegalStateException illegalStateException = new IllegalStateException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                int n = treeMap.modCount;
                RuntimeCostAccounter.recordJump();
                if (n != this.expectedModCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                TreeMap treeMap2 = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                TreeMap.access$000(treeMap2, this.lastReturned);
                this.lastReturned = null;
                TreeMap treeMap3 = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                this.expectedModCount = treeMap3.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size;
            private transient int sizeModCount;

            EntrySetView() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
                this.size = -1;
            }

            @Override
            public int size() {
                block7: {
                    block6: {
                        boolean bl = NavigableSubMap.this.fromStart;
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            boolean bl2 = NavigableSubMap.this.toEnd;
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                TreeMap treeMap = NavigableSubMap.this.m;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.size:()I");
                                return treeMap.size();
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.size == -1) break block6;
                        TreeMap treeMap = NavigableSubMap.this.m;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                        int n = treeMap.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (this.sizeModCount == n) break block7;
                    }
                    TreeMap treeMap = NavigableSubMap.this.m;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
                    this.sizeModCount = treeMap.modCount;
                    this.size = 0;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap$EntrySetView.iterator:()Ljava/util/Iterator;");
                    Iterator iterator = this.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        ++this.size;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        iterator.next();
                        RuntimeCostAccounter.recordJump();
                    }
                }
                return this.size;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isEmpty() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.absLowest:()Ljava/util/TreeMap$Entry;");
                Entry entry = NavigableSubMap.this.absLowest();
                RuntimeCostAccounter.recordJump();
                if (entry != null) {
                    Object k = entry.key;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.tooHigh:(Ljava/lang/Object;)Z");
                    boolean bl = NavigableSubMap.this.tooHigh(k);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) return false;
                }
                boolean bl = true;
                RuntimeCostAccounter.recordJump();
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean contains(Object object) {
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
                boolean bl2 = NavigableSubMap.this.inRange(k);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    return false;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                Entry entry2 = treeMap.getEntry(k);
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry2.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v2 = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl3 = TreeMap.valEquals(v, v2);
                RuntimeCostAccounter.recordJump();
                if (!bl3) return false;
                boolean bl4 = true;
                RuntimeCostAccounter.recordJump();
                return bl4;
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.inRange:(Ljava/lang/Object;)Z");
                boolean bl2 = NavigableSubMap.this.inRange(k);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    return false;
                }
                TreeMap treeMap = NavigableSubMap.this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
                Entry entry2 = treeMap.getEntry(k);
                RuntimeCostAccounter.recordJump();
                if (entry2 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.getValue:()Ljava/lang/Object;");
                    Object v = entry2.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Object v2 = entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl3 = TreeMap.valEquals(v, v2);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        TreeMap treeMap2 = NavigableSubMap.this.m;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                        TreeMap.access$000(treeMap2, entry2);
                        return true;
                    }
                }
                return false;
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$PrivateEntryIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            super(entry);
        }

        @Override
        public K next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$DescendingKeyIterator.prevEntry:()Ljava/util/TreeMap$Entry;");
            return this.prevEntry().key;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = TreeMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            TreeMap.access$000(TreeMap.this, this.lastReturned);
            this.lastReturned = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            this.expectedModCount = TreeMap.this.modCount;
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$PrivateEntryIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            super(entry);
        }

        @Override
        public K next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeyIterator.nextEntry:()Ljava/util/TreeMap$Entry;");
            return this.nextEntry().key;
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$PrivateEntryIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            super(entry);
        }

        @Override
        public V next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueIterator.nextEntry:()Ljava/util/TreeMap$Entry;");
            return this.nextEntry().value;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$PrivateEntryIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            super(entry);
        }

        @Override
        public Map.Entry<K, V> next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntryIterator.nextEntry:()Ljava/util/TreeMap$Entry;");
            return this.nextEntry();
        }
    }

    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        Entry<K, V> next;
        Entry<K, V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        @Override
        public final boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.next != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final Entry<K, V> nextEntry() {
            Entry entry = this.next;
            RuntimeCostAccounter.recordJump();
            if (entry == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = TreeMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.next = TreeMap.successor(entry);
            this.lastReturned = entry;
            return entry;
        }

        final Entry<K, V> prevEntry() {
            Entry entry = this.next;
            RuntimeCostAccounter.recordJump();
            if (entry == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = TreeMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.predecessor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
            this.next = TreeMap.predecessor(entry);
            this.lastReturned = entry;
            return entry;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            int n = TreeMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            Entry entry = this.lastReturned.left;
            RuntimeCostAccounter.recordJump();
            if (entry != null) {
                Entry entry2 = this.lastReturned.right;
                RuntimeCostAccounter.recordJump();
                if (entry2 != null) {
                    this.next = this.lastReturned;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            TreeMap.access$000(TreeMap.this, this.lastReturned);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$100:(Ljava/util/TreeMap;)I");
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, ?> m;

        KeySet(NavigableMap<E, ?> navigableMap) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
            this.m = navigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            boolean bl = this.m instanceof TreeMap;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                TreeMap treeMap = (TreeMap)this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keyIterator:()Ljava/util/Iterator;");
                return treeMap.keyIterator();
            }
            NavigableSubMap navigableSubMap = (NavigableSubMap)this.m;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.keyIterator:()Ljava/util/Iterator;");
            return navigableSubMap.keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            boolean bl = this.m instanceof TreeMap;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                TreeMap treeMap = (TreeMap)this.m;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.descendingKeyIterator:()Ljava/util/Iterator;");
                return treeMap.descendingKeyIterator();
            }
            NavigableSubMap navigableSubMap = (NavigableSubMap)this.m;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$NavigableSubMap.descendingKeyIterator:()Ljava/util/Iterator;");
            return navigableSubMap.descendingKeyIterator();
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.size:()I");
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.isEmpty:()Z");
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.containsKey:(Ljava/lang/Object;)Z");
            return this.m.containsKey(object);
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.clear:()V");
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.firstKey:()Ljava/lang/Object;");
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lastKey:()Ljava/lang/Object;");
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.comparator:()Ljava/util/Comparator;");
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            E e;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollFirstEntry:()Ljava/util/Map$Entry;");
            Map.Entry<E, ?> entry = this.m.pollFirstEntry();
            RuntimeCostAccounter.recordJump();
            if (entry == null) {
                e = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                e = entry.getKey();
            }
            return e;
        }

        @Override
        public E pollLast() {
            E e;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollLastEntry:()Ljava/util/Map$Entry;");
            Map.Entry<E, ?> entry = this.m.pollLastEntry();
            RuntimeCostAccounter.recordJump();
            if (entry == null) {
                e = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                e = entry.getKey();
            }
            return e;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.size:()I");
            int n = this.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.m.remove(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.size:()I");
            int n2 = this.size();
            RuntimeCostAccounter.recordJump();
            if (n2 != n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<E, ?> navigableMap = this.m.subMap(e, bl, e2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
            return new KeySet<E>(navigableMap);
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<E, ?> navigableMap = this.m.headMap(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
            return new KeySet<E>(navigableMap);
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<E, ?> navigableMap = this.m.tailMap(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
            return new KeySet<E>(navigableMap);
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
            return this.subSet(e, true, e2, false);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            return this.headSet(e, false);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            return this.tailSet(e, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingMap:()Ljava/util/NavigableMap;");
            NavigableMap<E, ?> navigableMap = this.m.descendingMap();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$KeySet.<init>:(Ljava/util/NavigableMap;)V");
            return new KeySet<E>(navigableMap);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.keySpliteratorFor:(Ljava/util/NavigableMap;)Ljava/util/Spliterator;");
            return TreeMap.keySpliteratorFor(this.m);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$EntryIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
            Entry entry = TreeMap.this.getFirstEntry();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntryIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            return new EntryIterator(entry);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            Object v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry entry2 = TreeMap.this.getEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 == null) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.getValue:()Ljava/lang/Object;");
            Object v2 = entry2.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl2 = TreeMap.valEquals(v2, v);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            Object v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getEntry:(Ljava/lang/Object;)Ljava/util/TreeMap$Entry;");
            Entry entry2 = TreeMap.this.getEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.getValue:()Ljava/lang/Object;");
                Object v2 = entry2.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl2 = TreeMap.valEquals(v2, v);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                    TreeMap.access$000(TreeMap.this, entry2);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.size:()I");
            return TreeMap.this.size();
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.clear:()V");
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$EntrySpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$EntrySpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            return new EntrySpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        }

        @Override
        public Iterator<V> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$ValueIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
            Entry entry = TreeMap.this.getFirstEntry();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueIterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
            return new ValueIterator(entry);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.size:()I");
            return TreeMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.containsValue:(Ljava/lang/Object;)Z");
            return TreeMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.getFirstEntry:()Ljava/util/TreeMap$Entry;");
            Entry entry = TreeMap.this.getFirstEntry();
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.valEquals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = TreeMap.valEquals(v, object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.access$000:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;)V");
                    TreeMap.access$000(TreeMap.this, entry);
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.successor:(Ljava/util/TreeMap$Entry;)Ljava/util/TreeMap$Entry;");
                entry = TreeMap.successor(entry);
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.clear:()V");
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap$ValueSpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap$ValueSpliterator.<init>:(Ljava/util/TreeMap;Ljava/util/TreeMap$Entry;Ljava/util/TreeMap$Entry;III)V");
            return new ValueSpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }
}

