/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractSequentialList;
import sandbox.java.util.Collection;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Deque;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.ListIterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.Consumer;

public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size;
    transient Node<E> first;
    transient Node<E> last;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSequentialList.<init>:()V");
        this.size = 0;
    }

    public LinkedList(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.<init>:()V");
        this();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.addAll:(Ljava/util/Collection;)Z");
        this.addAll(collection);
    }

    private void linkFirst(E e) {
        Node<E> node = this.first;
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$Node.<init>:(Ljava/util/LinkedList$Node;Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
        Node<E> node2 = new Node<E>(null, e, node);
        this.first = node2;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            this.last = node2;
            RuntimeCostAccounter.recordJump();
        } else {
            node.prev = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkLast(E e) {
        Node<E> node = this.last;
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$Node.<init>:(Ljava/util/LinkedList$Node;Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
        Node<E> node2 = new Node<E>(node, e, null);
        this.last = node2;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            this.first = node2;
            RuntimeCostAccounter.recordJump();
        } else {
            node.next = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkBefore(E e, Node<E> node) {
        Node node2 = node.prev;
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$Node.<init>:(Ljava/util/LinkedList$Node;Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
        Node node3 = new Node(node2, e, node);
        node.prev = node3;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.first = node3;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.next = node3;
        }
        ++this.size;
        ++this.modCount;
    }

    private E unlinkFirst(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        node.item = null;
        node.next = null;
        this.first = node2;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.last = null;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.prev = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    private E unlinkLast(Node<E> node) {
        Object e = node.item;
        Node node2 = node.prev;
        node.item = null;
        node.prev = null;
        this.last = node2;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.first = null;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.next = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    E unlink(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        Node node3 = node.prev;
        RuntimeCostAccounter.recordJump();
        if (node3 == null) {
            this.first = node2;
            RuntimeCostAccounter.recordJump();
        } else {
            node3.next = node2;
            node.prev = null;
        }
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.last = node3;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.prev = node3;
            node.next = null;
        }
        node.item = null;
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    public E getFirst() {
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return node.item;
    }

    @Override
    public E getLast() {
        Node<E> node = this.last;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return node.item;
    }

    @Override
    public E removeFirst() {
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlinkFirst:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
        return this.unlinkFirst(node);
    }

    @Override
    public E removeLast() {
        Node<E> node = this.last;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlinkLast:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
        return this.unlinkLast(node);
    }

    @Override
    public void addFirst(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkFirst:(Ljava/lang/Object;)V");
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkLast:(Ljava/lang/Object;)V");
        this.linkLast(e);
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.indexOf:(Ljava/lang/Object;)I");
        int n = this.indexOf(object);
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkLast:(Ljava/lang/Object;)V");
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
                    this.unlink(node);
                    return true;
                }
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(e);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
                    this.unlink(node);
                    return true;
                }
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.addAll:(ILjava/util/Collection;)Z");
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Node<Object> node;
        Node<E> node2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkPositionIndex:(I)V");
        this.checkPositionIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (n == this.size) {
            node2 = null;
            node = this.last;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
            node2 = this.node(n);
            node = node2.prev;
        }
        Object[] objectArray2 = objectArray;
        int n3 = objectArray2.length;
        int n4 = 0;
        while (true) {
            Object object;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n3) break;
            Object object2 = object = objectArray2[n4];
            RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$Node");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$Node.<init>:(Ljava/util/LinkedList$Node;Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
            Node<Object> node3 = new Node<Object>(node, object2, null);
            RuntimeCostAccounter.recordJump();
            if (node == null) {
                this.first = node3;
                RuntimeCostAccounter.recordJump();
            } else {
                node.next = node3;
            }
            node = node3;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.last = node;
            RuntimeCostAccounter.recordJump();
        } else {
            node.next = node2;
            node2.prev = node;
        }
        this.size += n2;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        Node<E> node = this.first;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Node node2 = node.next;
            node.item = null;
            node.next = null;
            node.prev = null;
            node = node2;
            RuntimeCostAccounter.recordJump();
        }
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkElementIndex:(I)V");
        this.checkElementIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
        return this.node((int)n).item;
    }

    @Override
    public E set(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkElementIndex:(I)V");
        this.checkElementIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
        Node<E> node = this.node(n);
        Object e2 = node.item;
        node.item = e;
        return e2;
    }

    @Override
    public void add(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkPositionIndex:(I)V");
        this.checkPositionIndex(n);
        RuntimeCostAccounter.recordJump();
        if (n == this.size) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkLast:(Ljava/lang/Object;)V");
            this.linkLast(e);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
            Node<E> node = this.node(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkBefore:(Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
            this.linkBefore(e, node);
        }
    }

    @Override
    public E remove(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkElementIndex:(I)V");
        this.checkElementIndex(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
        Node<E> node = this.node(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
        return this.unlink(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isElementIndex(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) return false;
        RuntimeCostAccounter.recordJump();
        if (n >= this.size) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPositionIndex(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) return false;
        RuntimeCostAccounter.recordJump();
        if (n > this.size) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    private String outOfBoundsMsg(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(", Size: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.size);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    private void checkElementIndex(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.isElementIndex:(I)Z");
        boolean bl = this.isElementIndex(n);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.outOfBoundsMsg:(I)Ljava/lang/String;");
            String string = this.outOfBoundsMsg(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    private void checkPositionIndex(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.isPositionIndex:(I)Z");
        boolean bl = this.isPositionIndex(n);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.outOfBoundsMsg:(I)Ljava/lang/String;");
            String string = this.outOfBoundsMsg(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
    }

    Node<E> node(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < this.size >> 1) {
            Node<E> node = this.first;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                node = node.next;
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            return node;
        }
        Node<E> node = this.last;
        int n3 = this.size - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= n) break;
            node = node.prev;
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        return node;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    return n;
                }
                ++n;
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(e);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                ++n;
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            Node<E> node = this.last;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                --n;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    return n;
                }
                node = node.prev;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            Node<E> node = this.last;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                --n;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(e);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                node = node.prev;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    @Override
    public E peek() {
        E e;
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            e = node.item;
        }
        return e;
    }

    @Override
    public E element() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.getFirst:()Ljava/lang/Object;");
        return this.getFirst();
    }

    @Override
    public E poll() {
        E e;
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlinkFirst:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
            e = this.unlinkFirst(node);
        }
        return e;
    }

    @Override
    public E remove() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.add:(Ljava/lang/Object;)Z");
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.addFirst:(Ljava/lang/Object;)V");
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.addLast:(Ljava/lang/Object;)V");
        this.addLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        E e;
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            e = node.item;
        }
        return e;
    }

    @Override
    public E peekLast() {
        E e;
        Node<E> node = this.last;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            e = node.item;
        }
        return e;
    }

    @Override
    public E pollFirst() {
        E e;
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlinkFirst:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
            e = this.unlinkFirst(node);
        }
        return e;
    }

    @Override
    public E pollLast() {
        E e;
        Node<E> node = this.last;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlinkLast:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
            e = this.unlinkLast(node);
        }
        return e;
    }

    @Override
    public void push(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.addFirst:(Ljava/lang/Object;)V");
        this.addFirst(e);
    }

    @Override
    public E pop() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.remove:(Ljava/lang/Object;)Z");
        return this.remove(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            Node<E> node = this.last;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            Node<E> node = this.last;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(e);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
                RuntimeCostAccounter.recordJump();
            }
        }
        return false;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.checkPositionIndex:(I)V");
        this.checkPositionIndex(n);
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$ListItr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.<init>:(Ljava/util/LinkedList;I)V");
        return new ListItr(n);
    }

    @Override
    public Iterator<E> descendingIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$DescendingIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$DescendingIterator.<init>:(Ljava/util/LinkedList;Ljava/util/LinkedList$1;)V");
        return new DescendingIterator(this, null);
    }

    private LinkedList<E> superClone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            return (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    public Object clone() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.superClone:()Ljava/util/LinkedList;");
        LinkedList linkedList = this.superClone();
        linkedList.last = null;
        linkedList.first = null;
        linkedList.size = 0;
        linkedList.modCount = 0;
        Node<E> node = this.first;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Object e = node.item;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.add:(Ljava/lang/Object;)Z");
            linkedList.add(e);
            node = node.next;
            RuntimeCostAccounter.recordJump();
        }
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        int n = this.size;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        Object[] objectArray = new Object[n];
        int n2 = 0;
        Node<E> node = this.first;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            objectArray[n2++] = node.item;
            node = node.next;
            RuntimeCostAccounter.recordJump();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n < this.size) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = objectArray.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getComponentType();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
            objectArray = (Object[])Array.newInstance(clazz2, this.size);
        }
        int n2 = 0;
        T[] TArray = objectArray;
        Node<E> node = this.first;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            TArray[n2++] = node.item;
            node = node.next;
            RuntimeCostAccounter.recordJump();
        }
        int n3 = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(this.size);
        Node<E> node = this.first;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Object e = node.item;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(e);
            node = node.next;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object = objectInputStream.readObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkLast:(Ljava/lang/Object;)V");
            this.linkLast(object);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$LLSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$LLSpliterator.<init>:(Ljava/util/LinkedList;II)V");
        return new LLSpliterator(this, -1, 0);
    }

    static final class LLSpliterator<E>
    implements Spliterator<E> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        final LinkedList<E> list;
        Node<E> current;
        int est;
        int expectedModCount;
        int batch;

        LLSpliterator(LinkedList<E> linkedList, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.list = linkedList;
            this.est = n;
            this.expectedModCount = n2;
        }

        final int getEst() {
            int n = this.est;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                LinkedList<E> linkedList = this.list;
                RuntimeCostAccounter.recordJump();
                if (linkedList == null) {
                    this.est = 0;
                    n = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.expectedModCount = linkedList.modCount;
                    this.current = linkedList.first;
                    n = this.est = linkedList.size;
                }
            }
            return n;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$LLSpliterator.getEst:()I");
            return this.getEst();
        }

        @Override
        public Spliterator<E> trySplit() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$LLSpliterator.getEst:()I");
            int n = this.getEst();
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                Node<E> node = this.current;
                RuntimeCostAccounter.recordJump();
                if (node != null) {
                    int n2 = this.batch + 1024;
                    RuntimeCostAccounter.recordJump();
                    if (n2 > n) {
                        n2 = n;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n2 > 0x2000000) {
                        n2 = 0x2000000;
                    }
                    int n3 = n2;
                    RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
                    Object[] objectArray = new Object[n3];
                    int n4 = 0;
                    do {
                        objectArray[n4++] = node.item;
                        node = node.next;
                        RuntimeCostAccounter.recordJump();
                        if (node == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (n4 < n2);
                    this.current = node;
                    this.batch = n4;
                    this.est = n - n4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:([Ljava/lang/Object;III)Ljava/util/Spliterator;");
                    return Spliterators.spliterator(objectArray, 0, n4, 16);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$LLSpliterator.getEst:()I");
            int n = this.getEst();
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                Node<E> node = this.current;
                RuntimeCostAccounter.recordJump();
                if (node != null) {
                    this.current = null;
                    this.est = 0;
                    do {
                        Object e = node.item;
                        node = node.next;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(e);
                        RuntimeCostAccounter.recordJump();
                        if (node == null) break;
                        RuntimeCostAccounter.recordJump();
                    } while (--n > 0);
                }
            }
            int n2 = this.list.modCount;
            RuntimeCostAccounter.recordJump();
            if (n2 != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$LLSpliterator.getEst:()I");
            int n = this.getEst();
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                Node<E> node = this.current;
                RuntimeCostAccounter.recordJump();
                if (node != null) {
                    --this.est;
                    Object e = node.item;
                    this.current = node.next;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(e);
                    int n2 = this.list.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n2 != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;
        final /* synthetic */ LinkedList this$0;

        private DescendingIterator(LinkedList linkedList) {
            this.this$0 = linkedList;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedList$ListItr");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.size:()I");
            int n = this.this$0.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.<init>:(Ljava/util/LinkedList;I)V");
            this.itr = this.this$0.new ListItr(n);
        }

        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.hasPrevious:()Z");
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.previous:()Ljava/lang/Object;");
            return this.itr.previous();
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.remove:()V");
            this.itr.remove();
        }

        /* synthetic */ DescendingIterator(LinkedList linkedList, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$DescendingIterator.<init>:(Ljava/util/LinkedList;)V");
            this(linkedList);
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> node, E e, Node<E> node2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.item = e;
            this.next = node2;
            this.prev = node;
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n) {
            Node node;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.expectedModCount = LinkedList.this.modCount;
            int n2 = LinkedList.this.size;
            RuntimeCostAccounter.recordJump();
            if (n == n2) {
                node = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.node:(I)Ljava/util/LinkedList$Node;");
                node = LinkedList.this.node(n);
            }
            this.next = node;
            this.nextIndex = n;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            int n = LinkedList.this.size;
            RuntimeCostAccounter.recordJump();
            if (this.nextIndex < n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.hasNext:()Z");
            boolean bl = this.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.nextIndex > 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E previous() {
            Node node;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.hasPrevious:()Z");
            boolean bl = this.hasPrevious();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.next == null) {
                node = LinkedList.this.last;
                RuntimeCostAccounter.recordJump();
            } else {
                node = this.next.prev;
            }
            this.next = node;
            this.lastReturned = node;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            Node node = this.lastReturned.next;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.unlink:(Ljava/util/LinkedList$Node;)Ljava/lang/Object;");
            LinkedList.this.unlink(this.lastReturned);
            RuntimeCostAccounter.recordJump();
            if (this.next == this.lastReturned) {
                this.next = node;
                RuntimeCostAccounter.recordJump();
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
            this.lastReturned = null;
            RuntimeCostAccounter.recordJump();
            if (this.next == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkLast:(Ljava/lang/Object;)V");
                LinkedList.this.linkLast(e);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList.linkBefore:(Ljava/lang/Object;Ljava/util/LinkedList$Node;)V");
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
            while (true) {
                int n = LinkedList.this.modCount;
                RuntimeCostAccounter.recordJump();
                if (n != this.expectedModCount) break;
                int n2 = LinkedList.this.size;
                RuntimeCostAccounter.recordJump();
                if (this.nextIndex >= n2) break;
                Object e = this.next.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(e);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedList$ListItr.checkForComodification:()V");
            this.checkForComodification();
        }

        final void checkForComodification() {
            int n = LinkedList.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }
    }
}

