/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.function.IntConsumer;

public class IntSummaryStatistics
implements IntConsumer {
    private long count;
    private long sum;
    private int min;
    private int max;

    public IntSummaryStatistics() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    @Override
    public void accept(int n) {
        ++this.count;
        this.sum += (long)n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        this.min = Math.min(this.min, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.max = Math.max(this.max, n);
    }

    public void combine(IntSummaryStatistics intSummaryStatistics) {
        this.count += intSummaryStatistics.count;
        this.sum += intSummaryStatistics.sum;
        int n = intSummaryStatistics.min;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        this.min = Math.min(this.min, n);
        int n2 = intSummaryStatistics.max;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.max = Math.max(this.max, n2);
    }

    public final long getCount() {
        return this.count;
    }

    public final long getSum() {
        return this.sum;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final double getAverage() {
        double d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getCount:()J");
        long l = this.getCount() - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getSum:()J");
            double d2 = this.getSum();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getCount:()J");
            d = d2 / (double)this.getCount();
            RuntimeCostAccounter.recordJump();
        } else {
            d = 0.0;
        }
        return d;
    }

    public String toString() {
        RuntimeCostAccounter.recordArrayAllocation((int)6, (int)8);
        Object[] objectArray = new Object[6];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
        objectArray[0] = clazz.getSimpleName();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getCount:()J");
        long l = this.getCount();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[1] = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getSum:()J");
        long l2 = this.getSum();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[2] = l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getMin:()I");
        int n = this.getMin();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
        objectArray[3] = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getAverage:()D");
        double d = this.getAverage();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[4] = d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.getMax:()I");
        int n2 = this.getMax();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
        objectArray[5] = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
        return String.format("%s{count=%d, sum=%d, min=%d, average=%f, max=%d}", objectArray);
    }
}

