/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Dictionary;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Function;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry<?, ?>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static final long serialVersionUID = 1421746759512286392L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Collection<V> values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public Hashtable(int n, float f) {
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Dictionary.<init>:()V");
                this.modCount = 0;
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Illegal Capacity: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordJump();
                if (f <= 0.0f) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.isNaN:(F)Z");
                boolean bl = Float.isNaN(f);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Illegal Load: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(F)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(f);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.table = new Entry[n2];
        float f2 = (float)n * f;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(FF)F");
        this.threshold = (int)Math.min(f2, 2.1474836E9f);
    }

    public Hashtable(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:(IF)V");
        this(n, 0.75f);
    }

    public Hashtable() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:(IF)V");
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = 2 * map.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n2 = Math.max(n, 11);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.<init>:(IF)V");
        this(n2, 0.75f);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.putAll:(Ljava/util/Map;)V");
        this.putAll(map);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.getEnumeration:(I)Ljava/util/Enumeration;");
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.getEnumeration:(I)Ljava/util/Enumeration;");
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = entryArray.length;
        while (true) {
            int n2 = n--;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            Entry<Object, Object> entry = entryArray[n];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Object v = entry.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = v.equals(object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.contains:(Ljava/lang/Object;)Z");
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k.equals(object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k.equals(object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return entry.value;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<?, ?>[] entryArray = this.table;
        int n2 = (n << 1) + 1;
        RuntimeCostAccounter.recordJump();
        if (n2 - 0x7FFFFFF7 > 0) {
            RuntimeCostAccounter.recordJump();
            if (n == 0x7FFFFFF7) {
                return;
            }
            n2 = 0x7FFFFFF7;
        }
        int n3 = n2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        Entry[] entryArray2 = new Entry[n3];
        ++this.modCount;
        float f = (float)n2 * this.loadFactor;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(FF)F");
        this.threshold = (int)Math.min(f, 2.1474836E9f);
        this.table = entryArray2;
        int n4 = n;
        while (true) {
            int n5 = n4--;
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) break;
            Entry<Object, Object> entry = entryArray[n4];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Entry<?, ?> entry2 = entry;
                entry = entry.next;
                int n6 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n6];
                entryArray2[n6] = entry2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private void addEntry(int n, K k, V v, int n2) {
        ++this.modCount;
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordJump();
        if (this.count >= this.threshold) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.rehash:()V");
            this.rehash();
            entryArray = this.table;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
            n = k.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        Entry<?, ?> entry = entryArray[n2];
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Entry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.<init>:(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/Hashtable$Entry;)V");
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    @Override
    public synchronized V put(K k, V v) {
        RuntimeCostAccounter.recordJump();
        if (v == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v2 = entry.value;
                    entry.value = v;
                    return v2;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.addEntry:(ILjava/lang/Object;Ljava/lang/Object;I)V");
        this.addEntry(n, k, v, n2);
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k.equals(object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    ++this.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (entry2 != null) {
                        entry2.next = entry.next;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object v = entry.value;
                    entry.value = null;
                    return v;
                }
            }
            entry2 = entry;
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<K, V>> set = map.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<K, V>> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Map.Entry<K, V> entry = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            K k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            V v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.put(k, v);
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public synchronized void clear() {
        Entry<?, ?>[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (--n < 0) break;
            entryArray[n] = null;
            RuntimeCostAccounter.recordJump();
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            Hashtable hashtable = (Hashtable)super.clone();
            int n = this.table.length;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            hashtable.table = new Entry[n];
            int n2 = this.table.length;
            while (true) {
                Entry entry;
                int n3 = n2--;
                RuntimeCostAccounter.recordJump();
                if (n3 <= 0) break;
                Entry<?, ?>[] entryArray = hashtable.table;
                Entry<?, ?> entry2 = this.table[n2];
                RuntimeCostAccounter.recordJump();
                if (entry2 != null) {
                    Entry<?, ?> entry3 = this.table[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.clone:()Ljava/lang/Object;");
                    entry = (Entry)entry3.clone();
                    RuntimeCostAccounter.recordJump();
                } else {
                    entry = null;
                }
                entryArray[n2] = entry;
                RuntimeCostAccounter.recordJump();
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    public synchronized String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.size:()I");
        int n = this.size() - 1;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return "{}";
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<K, V>> set = this.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<K, V>> iterator = set.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('{');
        int n2 = 0;
        while (true) {
            String string;
            String string2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Map.Entry<K, V> entry = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            K k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            V v = entry.getValue();
            RuntimeCostAccounter.recordJump();
            if (k == this) {
                string2 = "(this Map)";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                string2 = k.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('=');
            RuntimeCostAccounter.recordJump();
            if (v == this) {
                string = "(this Map)";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                string = v.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string);
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append('}');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder2.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(", ");
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private <T> Enumeration<T> getEnumeration(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyEnumeration:()Ljava/util/Enumeration;");
            return Collections.emptyEnumeration();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Enumerator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Enumerator.<init>:(Ljava/util/Hashtable;IZ)V");
        return new Enumerator(n, false);
    }

    private <T> Iterator<T> getIterator(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyIterator:()Ljava/util/Iterator;");
            return Collections.emptyIterator();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Enumerator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Enumerator.<init>:(Ljava/util/Hashtable;IZ)V");
        return new Enumerator(n, true);
    }

    @Override
    public Set<K> keySet() {
        RuntimeCostAccounter.recordJump();
        if (this.keySet == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$KeySet.<init>:(Ljava/util/Hashtable;Ljava/util/Hashtable$1;)V");
            KeySet keySet = new KeySet(this, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.synchronizedSet:(Ljava/util/Set;Ljava/lang/Object;)Ljava/util/Set;");
            this.keySet = Collections.synchronizedSet(keySet, this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        RuntimeCostAccounter.recordJump();
        if (this.entrySet == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$EntrySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$EntrySet.<init>:(Ljava/util/Hashtable;Ljava/util/Hashtable$1;)V");
            EntrySet entrySet = new EntrySet(this, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.synchronizedSet:(Ljava/util/Set;Ljava/lang/Object;)Ljava/util/Set;");
            this.entrySet = Collections.synchronizedSet(entrySet, this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        RuntimeCostAccounter.recordJump();
        if (this.values == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$ValueCollection");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$ValueCollection.<init>:(Ljava/util/Hashtable;Ljava/util/Hashtable$1;)V");
            ValueCollection valueCollection = new ValueCollection(this, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.synchronizedCollection:(Ljava/util/Collection;Ljava/lang/Object;)Ljava/util/Collection;");
            this.values = Collections.synchronizedCollection(valueCollection, this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof Map;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        Map map = (Map)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = map.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.size:()I");
        int n2 = this.size();
        RuntimeCostAccounter.recordJump();
        if (n != n2) {
            return false;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.entrySet:()Ljava/util/Set;");
            Set<Map.Entry<K, V>> set = this.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<Map.Entry<K, V>> iterator = set.iterator();
            while (true) {
                block12: {
                    V v;
                    K k;
                    block10: {
                        block11: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                            boolean bl2 = iterator.hasNext();
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                            Map.Entry<K, V> entry = iterator.next();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                            k = entry.getKey();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                            v = entry.getValue();
                            RuntimeCostAccounter.recordJump();
                            if (v != null) break block10;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                            Object v2 = map.get(k);
                            RuntimeCostAccounter.recordJump();
                            if (v2 != null) break block11;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                            boolean bl3 = map.containsKey(k);
                            RuntimeCostAccounter.recordJump();
                            if (bl3) break block12;
                        }
                        return false;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object v3 = map.get(k);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl4 = v.equals(v3);
                    RuntimeCostAccounter.recordJump();
                    if (!bl4) {
                        return false;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        return true;
    }

    @Override
    public synchronized int hashCode() {
        Entry<?, ?>[] entryArray;
        int n;
        block5: {
            block4: {
                n = 0;
                RuntimeCostAccounter.recordJump();
                if (this.count == 0) break block4;
                RuntimeCostAccounter.recordJump();
                if (!(this.loadFactor < 0.0f)) break block5;
            }
            return n;
        }
        this.loadFactor = -this.loadFactor;
        Entry<?, ?>[] entryArray2 = entryArray = this.table;
        int n2 = entryArray2.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            Entry<Object, Object> entry = entryArray2[n3];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.hashCode:()I");
                n += entry.hashCode();
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        this.loadFactor = -this.loadFactor;
        return n;
    }

    @Override
    public synchronized V getOrDefault(Object object, V v) {
        V v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v3 = this.get(object);
        RuntimeCostAccounter.recordJump();
        if (null == v3) {
            v2 = v;
            RuntimeCostAccounter.recordJump();
        } else {
            v2 = v3;
        }
        return v2;
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Entry<?, ?>[] entryArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        Entry<?, ?>[] entryArray2 = entryArray = this.table;
        int n2 = entryArray2.length;
        int n3 = 0;
        while (true) {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                Entry<Object, Object> entry = entryArray2[n3];
                do {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block2;
                    Object k = entry.key;
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    biConsumer.accept(k, v);
                    entry = entry.next;
                    RuntimeCostAccounter.recordJump();
                } while (n == this.modCount);
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Entry<?, ?>[] entryArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        Entry<?, ?>[] entryArray2 = entryArray = this.table;
        int n2 = entryArray2.length;
        int n3 = 0;
        while (true) {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                Entry<Object, Object> entry = entryArray2[n3];
                do {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block2;
                    Object k = entry.key;
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    V v2 = biFunction.apply(k, v);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    entry.value = Objects.requireNonNull(v2);
                    entry = entry.next;
                    RuntimeCostAccounter.recordJump();
                } while (n == this.modCount);
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v2 = entry.value;
                    RuntimeCostAccounter.recordJump();
                    if (v2 == null) {
                        entry.value = v;
                    }
                    return v2;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.addEntry:(ILjava/lang/Object;Ljava/lang/Object;I)V");
        this.addEntry(n, k, v, n2);
        return null;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(object2);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k.equals(object);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl2 = v.equals(object2);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        ++this.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 != null) {
                            entry2.next = entry.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entryArray[n2] = entry.next;
                        }
                        --this.count;
                        entry.value = null;
                        return true;
                    }
                }
            }
            entry2 = entry;
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v2);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v3 = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl2 = v3.equals(v);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        entry.value = v2;
                        return true;
                    }
                    return false;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v2 = entry.value;
                    entry.value = v;
                    return v2;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    @Override
    public synchronized V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return entry.value;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v = function.apply(k);
        RuntimeCostAccounter.recordJump();
        if (v != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.addEntry:(ILjava/lang/Object;Ljava/lang/Object;I)V");
            this.addEntry(n, k, v, n2);
        }
        return v;
    }

    @Override
    public synchronized V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    V v2 = biFunction.apply(k, v);
                    RuntimeCostAccounter.recordJump();
                    if (v2 == null) {
                        ++this.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 != null) {
                            entry2.next = entry.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entryArray[n2] = entry.next;
                        }
                        --this.count;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entry.value = v2;
                    }
                    return v2;
                }
            }
            entry2 = entry;
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    @Override
    public synchronized V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<Object, Object> entry2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = Objects.equals(k2, k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    V v2 = biFunction.apply(k, v);
                    RuntimeCostAccounter.recordJump();
                    if (v2 == null) {
                        ++this.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 != null) {
                            entry2.next = entry.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entryArray[n2] = entry.next;
                        }
                        --this.count;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entry.value = v2;
                    }
                    return v2;
                }
            }
            entry2 = entry;
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        entry2 = biFunction.apply(k, null);
        RuntimeCostAccounter.recordJump();
        if (entry2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.addEntry:(ILjava/lang/Object;Ljava/lang/Object;I)V");
            this.addEntry(n, k, entry2, n2);
        }
        return (V)entry2;
    }

    @Override
    public synchronized V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        Entry<?, ?>[] entryArray = this.table;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v2 = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    V v3 = biFunction.apply(v2, v);
                    RuntimeCostAccounter.recordJump();
                    if (v3 == null) {
                        ++this.modCount;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 != null) {
                            entry2.next = entry.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entryArray[n2] = entry.next;
                        }
                        --this.count;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entry.value = v3;
                    }
                    return v3;
                }
            }
            entry2 = entry;
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (v != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.addEntry:(ILjava/lang/Object;Ljava/lang/Object;I)V");
            this.addEntry(n, k, v, n2);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Entry entry = null;
        Hashtable hashtable = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
            objectOutputStream.defaultWriteObject();
            int n = this.table.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
            objectOutputStream.writeInt(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
            objectOutputStream.writeInt(this.count);
            int n2 = 0;
            while (true) {
                int n3 = this.table.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                Entry<Object, Object> entry2 = this.table[n2];
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry2 == null) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Entry");
                    Object k = entry2.key;
                    Object v = entry2.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.<init>:(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/Hashtable$Entry;)V");
                    entry = new Entry(0, k, v, entry);
                    entry2 = entry2.next;
                    RuntimeCostAccounter.recordJump();
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            Object k = entry.key;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(k);
            Object v = entry.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(v);
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n = objectInputStream.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        RuntimeCostAccounter.recordJump();
        if (n3 > n2) {
            RuntimeCostAccounter.recordJump();
            if ((n3 & 1) == 0) {
                --n3;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordJump();
            if (n3 > n) {
                n3 = n;
            }
        }
        int n4 = n3;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
        this.table = new Entry[n4];
        float f = (float)n3 * this.loadFactor;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(FF)F");
        this.threshold = (int)Math.min(f, 2.1474836E9f);
        this.count = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object = objectInputStream.readObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object2 = objectInputStream.readObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.reconstitutionPut:([Ljava/util/Hashtable$Entry;Ljava/lang/Object;Ljava/lang/Object;)V");
            this.reconstitutionPut(this.table, object, object2);
            --n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void reconstitutionPut(Entry<?, ?>[] entryArray, K k, V v) throws StreamCorruptedException {
        RuntimeCostAccounter.recordJump();
        if (v == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:()V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException();
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n3 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                Object k2 = entry.key;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = k2.equals(k);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:()V");
                    StreamCorruptedException streamCorruptedException = new StreamCorruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw streamCorruptedException;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        entry = entryArray[n2];
        RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Entry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.<init>:(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/Hashtable$Entry;)V");
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    static /* synthetic */ Iterator access$100(Hashtable hashtable, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.getIterator:(I)Ljava/util/Iterator;");
        return hashtable.getIterator(n);
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        Entry<?, ?>[] table;
        int index;
        Entry<?, ?> entry;
        Entry<?, ?> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$400:(Ljava/util/Hashtable;)[Ljava/util/Hashtable$Entry;");
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$500:(Ljava/util/Hashtable;)I");
            this.expectedModCount = Hashtable.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        @Override
        public boolean hasMoreElements() {
            boolean bl;
            Entry<?, ?> entry = this.entry;
            int n = this.index;
            Entry<?, ?>[] entryArray = this.table;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry != null) break;
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break;
                entry = entryArray[--n];
                RuntimeCostAccounter.recordJump();
            }
            this.entry = entry;
            this.index = n;
            RuntimeCostAccounter.recordJump();
            if (entry != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public T nextElement() {
            Entry<?, ?> entry = this.entry;
            int n = this.index;
            Entry<?, ?>[] entryArray = this.table;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry != null) break;
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break;
                entry = entryArray[--n];
                RuntimeCostAccounter.recordJump();
            }
            this.entry = entry;
            this.index = n;
            RuntimeCostAccounter.recordJump();
            if (entry != null) {
                Object object;
                this.lastReturned = this.entry;
                Entry<?, ?> entry2 = this.lastReturned;
                this.entry = entry2.next;
                RuntimeCostAccounter.recordJump();
                if (this.type == 0) {
                    object = entry2.key;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.type == 1) {
                        object = entry2.value;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        object = entry2;
                    }
                }
                return (T)object;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("Hashtable Enumerator");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }

        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Enumerator.hasMoreElements:()Z");
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$500:(Ljava/util/Hashtable;)I");
            int n = Hashtable.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Enumerator.nextElement:()Ljava/lang/Object;");
            return this.nextElement();
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (!this.iterator) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                RuntimeCostAccounter.recordThrow();
                throw unsupportedOperationException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException("Hashtable Enumerator");
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$500:(Ljava/util/Hashtable;)I");
            int n = Hashtable.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            Hashtable hashtable = Hashtable.this;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$400:(Ljava/util/Hashtable;)[Ljava/util/Hashtable$Entry;");
                Entry[] entryArray = Hashtable.this.table;
                int n2 = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n2];
                Entry entry2 = null;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break;
                    RuntimeCostAccounter.recordJump();
                    if (entry == this.lastReturned) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$508:(Ljava/util/Hashtable;)I");
                        Hashtable.this.modCount++;
                        ++this.expectedModCount;
                        RuntimeCostAccounter.recordJump();
                        if (entry2 == null) {
                            entryArray[n2] = entry.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entry2.next = entry.next;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$210:(Ljava/util/Hashtable;)I");
                        Hashtable.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int n, K k, V v, Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = entry;
        }

        protected Object clone() {
            Entry entry;
            RuntimeCostAccounter.recordAllocation((String)"java/util/Hashtable$Entry");
            RuntimeCostAccounter.recordJump();
            if (this.next == null) {
                entry = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.clone:()Ljava/lang/Object;");
                entry = (Entry)this.next.clone();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.<init>:(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/Hashtable$Entry;)V");
            return new Entry<K, V>(this.hash, this.key, this.value, entry);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            RuntimeCostAccounter.recordJump();
            if (v == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordJump();
            if (this.key == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordJump();
                if (k != null) return false;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = this.key.equals(k);
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
            }
            RuntimeCostAccounter.recordJump();
            if (this.value == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordJump();
                if (v != null) return false;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = this.value.equals(v);
                RuntimeCostAccounter.recordJump();
                if (!bl3) return false;
            }
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.hashCode:(Ljava/lang/Object;)I");
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            String string = this.key.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("=");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            String string2 = this.value.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        final /* synthetic */ Hashtable this$0;

        private ValueCollection(Hashtable hashtable) {
            this.this$0 = hashtable;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        }

        @Override
        public Iterator<V> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$100:(Ljava/util/Hashtable;I)Ljava/util/Iterator;");
            return Hashtable.access$100(this.this$0, 1);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$200:(Ljava/util/Hashtable;)I");
            return this.this$0.count;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.containsValue:(Ljava/lang/Object;)Z");
            return this.this$0.containsValue(object);
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.clear:()V");
            this.this$0.clear();
        }

        /* synthetic */ ValueCollection(Hashtable hashtable, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$ValueCollection.<init>:(Ljava/util/Hashtable;)V");
            this(hashtable);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ Hashtable this$0;

        private EntrySet(Hashtable hashtable) {
            this.this$0 = hashtable;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$100:(Ljava/util/Hashtable;I)Ljava/util/Iterator;");
            return Hashtable.access$100(this.this$0, 2);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.add:(Ljava/lang/Object;)Z");
            return super.add(entry);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$400:(Ljava/util/Hashtable;)[Ljava/util/Hashtable$Entry;");
            Entry[] entryArray = this.this$0.table;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) break;
                int n3 = entry2.hash;
                RuntimeCostAccounter.recordJump();
                if (n3 == n) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.equals:(Ljava/lang/Object;)Z");
                    boolean bl2 = entry2.equals(entry);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        return true;
                    }
                }
                entry2 = entry2.next;
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$400:(Ljava/util/Hashtable;)[Ljava/util/Hashtable$Entry;");
            Entry[] entryArray = this.this$0.table;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            Entry entry3 = null;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry2 == null) break;
                int n3 = entry2.hash;
                RuntimeCostAccounter.recordJump();
                if (n3 == n) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$Entry.equals:(Ljava/lang/Object;)Z");
                    boolean bl2 = entry2.equals(entry);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$508:(Ljava/util/Hashtable;)I");
                        this.this$0.modCount++;
                        RuntimeCostAccounter.recordJump();
                        if (entry3 != null) {
                            entry3.next = entry2.next;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entryArray[n2] = entry2.next;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$210:(Ljava/util/Hashtable;)I");
                        this.this$0.count--;
                        entry2.value = null;
                        return true;
                    }
                }
                entry3 = entry2;
                entry2 = entry2.next;
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$200:(Ljava/util/Hashtable;)I");
            return this.this$0.count;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.clear:()V");
            this.this$0.clear();
        }

        /* synthetic */ EntrySet(Hashtable hashtable, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$EntrySet.<init>:(Ljava/util/Hashtable;)V");
            this(hashtable);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ Hashtable this$0;

        private KeySet(Hashtable hashtable) {
            this.this$0 = hashtable;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<K> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$100:(Ljava/util/Hashtable;I)Ljava/util/Iterator;");
            return Hashtable.access$100(this.this$0, 0);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.access$200:(Ljava/util/Hashtable;)I");
            return this.this$0.count;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.containsKey:(Ljava/lang/Object;)Z");
            return this.this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object v = this.this$0.remove(object);
            RuntimeCostAccounter.recordJump();
            if (v != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable.clear:()V");
            this.this$0.clear();
        }

        /* synthetic */ KeySet(Hashtable hashtable, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Hashtable$KeySet.<init>:(Ljava/util/Hashtable;)V");
            this(hashtable);
        }
    }
}

